/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import org.w3c.dom.Attr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrivateResourceDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create("PrivateResource", "Looks for references to private resources", "Private resources should not be referenced; the may not be present everywhere, and even where they are they may disappear without notice.\n\nTo fix this, copy the resource into your own project. You can find the platform resources under $ANDROID_SK/platforms/android-$VERSION/data/res/.", Category.CORRECTNESS, 3, Severity.FATAL, PrivateResourceDetector.class, Scope.RESOURCE_FILE_SCOPE);

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    @Override
    public void visitAttribute(XmlContext xmlContext, Attr attr) {
        String string = attr.getNodeValue();
        if (string.startsWith("@*android:")) {
            xmlContext.report(ISSUE, attr, xmlContext.getLocation(attr), "Illegal resource reference: @*android resources are private and not always present", null);
        }
    }
}

