/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Identifier;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.StrictListAccessor;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityDetector
extends Detector
implements Detector.XmlScanner,
Detector.JavaScanner {
    public static final Issue EXPORTED_SERVICE = Issue.create("ExportedService", "Checks for exported services that do not require permissions", "Exported services (services which either set exported=true or contain an intent-filter and do not specify exported=false) should define a permission that an entity must have in order to launch the service or bind to it. Without this, any application can use this service.", Category.SECURITY, 5, Severity.WARNING, SecurityDetector.class, EnumSet.of(Scope.MANIFEST));
    public static final Issue OPEN_PROVIDER = Issue.create("GrantAllUris", "Checks for <grant-uri-permission> elements where everything is shared", "The <grant-uri-permission> element allows specific paths to be shared. This detector checks for a path URL of just '/' (everything), which is probably not what you want; you should limit access to a subset.", Category.SECURITY, 7, Severity.WARNING, SecurityDetector.class, EnumSet.of(Scope.MANIFEST));
    public static final Issue WORLD_WRITEABLE = Issue.create("WorldWriteableFiles", "Checks for openFileOutput() calls passing MODE_WORLD_WRITEABLE", "There are cases where it is appropriate for an application to write world writeable files, but these should be reviewed carefully to ensure that they contain no private data, and that if the file is modified by a malicious application it does not trick or compromise your application.", Category.SECURITY, 4, Severity.WARNING, SecurityDetector.class, Scope.JAVA_FILE_SCOPE);

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public boolean appliesTo(Context context, File file) {
        return file.getName().equals("AndroidManifest.xml");
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("service", "grant-uri-permission");
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        String string = element.getTagName();
        if (string.equals("service")) {
            this.checkService(xmlContext, element);
        } else if (string.equals("grant-uri-permission")) {
            this.checkGrantPermission(xmlContext, element);
        }
    }

    private void checkService(XmlContext xmlContext, Element element) {
        String string;
        Element element2;
        Object object;
        boolean bl;
        String string2 = element.getAttributeNS("http://schemas.android.com/apk/res/android", "exported");
        if (string2 != null && string2.length() > 0) {
            bl = Boolean.valueOf(string2);
        } else {
            boolean bl2 = false;
            object = LintUtils.getChildren(element).iterator();
            while (object.hasNext()) {
                element2 = object.next();
                if (!element2.getTagName().equals("intent-filter")) continue;
                bl2 = true;
                break;
            }
            bl = bl2;
        }
        if (bl && ((string = element.getAttributeNS("http://schemas.android.com/apk/res/android", "permission")) == null || string.length() == 0) && (object = element.getParentNode()).getNodeType() == 1 && object.getNodeName().equals("application") && ((string = (element2 = (Element)object).getAttributeNS("http://schemas.android.com/apk/res/android", "permission")) == null || string.length() == 0)) {
            xmlContext.report(EXPORTED_SERVICE, element, xmlContext.getLocation(element), "Exported service does not require permission", null);
        }
    }

    private void checkGrantPermission(XmlContext xmlContext, Element element) {
        Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "path");
        Attr attr2 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "pathPrefix");
        Attr attr3 = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "pathPattern");
        String string = "Content provider shares everything; this is potentially dangerous.";
        if (attr != null && attr.getValue().equals("/")) {
            xmlContext.report(OPEN_PROVIDER, attr, xmlContext.getLocation(attr), string, null);
        }
        if (attr2 != null && attr2.getValue().equals("/")) {
            xmlContext.report(OPEN_PROVIDER, attr2, xmlContext.getLocation(attr2), string, null);
        }
        if (attr3 != null && attr3.getValue().equals("/")) {
            xmlContext.report(OPEN_PROVIDER, attr3, xmlContext.getLocation(attr3), string, null);
        }
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("openFileOutput");
    }

    @Override
    public void visitMethod(JavaContext javaContext, AstVisitor astVisitor, MethodInvocation methodInvocation) {
        StrictListAccessor strictListAccessor = methodInvocation.astArguments();
        Iterator iterator = strictListAccessor.iterator();
        while (iterator.hasNext()) {
            ((Expression)iterator.next()).accept(astVisitor);
        }
    }

    @Override
    public AstVisitor createJavaVisitor(JavaContext javaContext) {
        return new IdentifierVisitor(javaContext);
    }

    private static class IdentifierVisitor
    extends ForwardingAstVisitor {
        private final JavaContext mContext;

        public IdentifierVisitor(JavaContext javaContext) {
            this.mContext = javaContext;
        }

        public boolean visitIdentifier(Identifier identifier) {
            if ("MODE_WORLD_WRITEABLE".equals(identifier.getDescription())) {
                Location location = this.mContext.getLocation((Node)identifier);
                this.mContext.report(WORLD_WRITEABLE, (Node)identifier, location, "Using MODE_WORLD_WRITEABLE with openFileOutput can be risky, review carefully", null);
            }
            return false;
        }
    }
}

