/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class StateListDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create("StateListReachable", "Looks for unreachable states in a <selector>", "In a selector, only the last child in the state list should omit a state qualifier. If not, all subsequent items in the list will be ignored since the given item will match all.", Category.CORRECTNESS, 5, Severity.WARNING, StateListDetector.class, Scope.RESOURCE_FILE_SCOPE);

    public boolean appliesTo(ResourceFolderType resourceFolderType) {
        return resourceFolderType == ResourceFolderType.DRAWABLE;
    }

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void visitDocument(XmlContext xmlContext, Document document) {
        Element element = document.getDocumentElement();
        if (element != null && element.getTagName().equals("selector")) {
            List<Element> list = LintUtils.getChildren(element);
            for (int i = 0; i < list.size() - 1; ++i) {
                Element element2 = list.get(i);
                boolean bl = false;
                NamedNodeMap namedNodeMap = element2.getAttributes();
                for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                    Attr attr = (Attr)namedNodeMap.item(j);
                    if (attr.getLocalName() == null) continue;
                    if (attr.getLocalName().startsWith("state_")) {
                        bl = true;
                        break;
                    }
                    String string = attr.getNamespaceURI();
                    if (string == null || string.length() <= 0 || "http://schemas.android.com/apk/res/android".equals(string)) continue;
                    bl = true;
                }
                if (bl) continue;
                xmlContext.report(ISSUE, element2, xmlContext.getLocation(element2), String.format("No android:state_ attribute found on <item> %1$d, later states not reachable", i), null);
            }
        }
    }
}

