/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.client.api.IJavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.util.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.ast.AstVisitor;
import lombok.ast.CharLiteral;
import lombok.ast.Expression;
import lombok.ast.FloatingPointLiteral;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.IntegralLiteral;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.NullLiteral;
import lombok.ast.Select;
import lombok.ast.StrictListAccessor;
import lombok.ast.StringLiteral;
import lombok.ast.VariableDefinition;
import lombok.ast.VariableDefinitionEntry;
import lombok.ast.VariableReference;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringFormatDetector
extends ResourceXmlDetector
implements Detector.JavaScanner {
    private static final String FORMAT_METHOD = "format";
    public static final Issue INVALID = Issue.create("StringFormatInvalid", "Checks that format strings are valid", "If a string contains a '%' character, then the string may be a formatting string which will be passed to String.format from Java code to replace each '%' occurrence with specific values.\n\nThis lint warning checks for two related problems:\n(1) Formatting strings that are invalid, meaning that String.format will throw exceptions at runtime when attempting to use the format string.\n(2) Strings containing '%' that are not formatting strings getting passed to a String.format call. In this case the '%' will need to be escaped as '%%'.\n\nNOTE: Not all Strings which look like formatting strings are intended for use by String.format; for example, they may contain date formats intended for android.text.format.Time#format(). Lint cannot always figure out that a String is a date format, so you may get false warnings in those scenarios. See the suppress help topic for information on how to suppress errors in that case.", Category.MESSAGES, 9, Severity.ERROR, StringFormatDetector.class, Scope.ALL_RESOURCES_SCOPE);
    public static final Issue ARG_COUNT = Issue.create("StringFormatCount", "Ensures that all format strings are used and that the same number is defined across translations", "When a formatted string takes arguments, it usually needs to reference the same arguments in all translations. There are cases where this is not the case, so this issue is a warning rather than an error by default. However, this usually happens when a language is not translated or updated correctly.", Category.MESSAGES, 5, Severity.WARNING, StringFormatDetector.class, Scope.ALL_RESOURCES_SCOPE);
    public static final Issue ARG_TYPES = Issue.create("StringFormatMatches", "Ensures that the format used in <string> definitions is compatible with the String.format call", "This lint check ensures the following:\n(1) If there are multiple translations of the format string, then all translations use the same type for the same numbered arguments\n(2) The usage of the format string in Java is consistent with the format string, meaning that the parameter types passed to String.format matches those in the format string.", Category.MESSAGES, 9, Severity.ERROR, StringFormatDetector.class, EnumSet.of(Scope.ALL_RESOURCE_FILES, Scope.JAVA_FILE));
    private Map<String, List<Pair<Location.Handle, String>>> mFormatStrings;
    private Map<String, Location.Handle> mNotFormatStrings = new HashMap<String, Location.Handle>();
    private static final int CONVERSION_CLASS_UNKNOWN = 0;
    private static final int CONVERSION_CLASS_STRING = 1;
    private static final int CONVERSION_CLASS_CHARACTER = 2;
    private static final int CONVERSION_CLASS_INTEGER = 3;
    private static final int CONVERSION_CLASS_FLOAT = 4;
    private static final int CONVERSION_CLASS_BOOLEAN = 5;
    private static final int CONVERSION_CLASS_HASHCODE = 6;
    private static final int CONVERSION_CLASS_PERCENT = 7;
    private static final int CONVERSION_CLASS_NEWLINE = 8;
    private static final int CONVERSION_CLASS_DATETIME = 9;
    private static final Pattern FORMAT = Pattern.compile("%(\\d+\\$)?([-+#, 0(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");

    @Override
    public boolean appliesTo(ResourceFolderType resourceFolderType) {
        return resourceFolderType == ResourceFolderType.VALUES;
    }

    @Override
    public boolean appliesTo(Context context, File file) {
        if (LintUtils.endsWith(file.getName(), ".java")) {
            return this.mFormatStrings != null;
        }
        return super.appliesTo(context, file);
    }

    @Override
    public Speed getSpeed() {
        return Speed.NORMAL;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("string");
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        org.w3c.dom.Node node;
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() > 0 && nodeList.getLength() == 1 && (node = nodeList.item(0)).getNodeType() == 3) {
            this.checkTextNode(xmlContext, element, StringFormatDetector.strip(node.getNodeValue()));
        }
    }

    private static String strip(String string) {
        char c;
        if (string.length() < 2) {
            return string;
        }
        char c2 = string.charAt(0);
        if (c2 == (c = string.charAt(string.length() - 1)) && (c2 == '\'' || c2 == '\"')) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    private void checkTextNode(XmlContext xmlContext, Element element, String string) {
        String string2 = null;
        boolean bl = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            String string3;
            char c = string.charAt(i);
            if (c == '\\') {
                ++i;
            }
            if (c != '%') continue;
            if (string2 == null) {
                string2 = element.getAttribute("name");
            }
            if ((string3 = element.getAttribute("formatted")).length() > 0 && !Boolean.parseBoolean(string3)) {
                if (!this.mNotFormatStrings.containsKey(string2)) {
                    object2 = xmlContext.parser.createLocationHandle(xmlContext, element);
                    object2.setClientData(element);
                    this.mNotFormatStrings.put(string2, (Location.Handle)object2);
                }
                return;
            }
            object2 = FORMAT.matcher(string);
            if (!((Matcher)object2).find(i)) {
                if (!this.mNotFormatStrings.containsKey(string2)) {
                    object = xmlContext.parser.createLocationHandle(xmlContext, element);
                    object.setClientData(element);
                    this.mNotFormatStrings.put(string2, (Location.Handle)object);
                }
                return;
            }
            object = ((Matcher)object2).group(6);
            int n2 = StringFormatDetector.getConversionClass(((String)object).charAt(0));
            if (n2 == 0 || ((Matcher)object2).group(5) != null) {
                if (!this.mNotFormatStrings.containsKey(string2)) {
                    Location.Handle handle = xmlContext.parser.createLocationHandle(xmlContext, element);
                    handle.setClientData(element);
                    this.mNotFormatStrings.put(string2, handle);
                }
                return;
            }
            bl = true;
        }
        if (bl && string2 != null) {
            List<Pair<Location.Handle, String>> list;
            if (this.mFormatStrings == null) {
                this.mFormatStrings = new HashMap<String, List<Pair<Location.Handle, String>>>();
            }
            if ((list = this.mFormatStrings.get(string2)) == null) {
                list = new ArrayList<Pair<Location.Handle, String>>();
                this.mFormatStrings.put(string2, list);
            }
            Location.Handle handle = xmlContext.parser.createLocationHandle(xmlContext, element);
            handle.setClientData(element);
            list.add(Pair.of(handle, string));
        }
    }

    @Override
    public void afterCheckProject(Context context) {
        if (this.mFormatStrings != null) {
            Formatter formatter = new Formatter();
            boolean bl = context.isEnabled(ARG_COUNT);
            boolean bl2 = context.isEnabled(INVALID);
            boolean bl3 = context.isEnabled(ARG_TYPES);
            for (Map.Entry<String, List<Pair<Location.Handle, String>>> entry : this.mFormatStrings.entrySet()) {
                String string = entry.getKey();
                List<Pair<Location.Handle, String>> list = entry.getValue();
                if (bl) {
                    this.checkArity(context, string, list);
                }
                if (!bl2 && !bl3) continue;
                this.checkTypes(context, formatter, bl2, bl3, string, list);
            }
        }
    }

    private void checkTypes(Context context, Formatter formatter, boolean bl, boolean bl2, String string, List<Pair<Location.Handle, String>> list) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        HashMap<Integer, Location.Handle> hashMap2 = new HashMap<Integer, Location.Handle>();
        block0: for (Pair<Location.Handle, String> pair : list) {
            Location.Handle handle = pair.getFirst();
            String string2 = pair.getSecond();
            Matcher matcher = FORMAT.matcher(string2);
            int n = 0;
            int n2 = 0;
            int n3 = 1;
            while (matcher.find(n)) {
                String string3;
                Object object;
                Object object2;
                int n4;
                int n5 = matcher.start();
                while (n2 < n5) {
                    char c = string2.charAt(n2);
                    if (c == '\\') {
                        ++n2;
                    }
                    ++n2;
                }
                if (n2 > n5) {
                    n = n2;
                    continue;
                }
                n = matcher.end();
                String string4 = string2.substring(n5, matcher.end());
                if (bl && string4.length() > 2 && string4.charAt(string4.length() - 2) == ' ' && (n4 = (int)string4.charAt(string4.length() - 1)) != 100 && n4 != 111 && n4 != 120 && n4 != 88) {
                    object2 = handle.getClientData();
                    if (object2 instanceof org.w3c.dom.Node && context.getDriver().isSuppressed(INVALID, (org.w3c.dom.Node)object2)) {
                        return;
                    }
                    object = handle.resolve();
                    string3 = String.format("Incorrect formatting string %1$s; missing conversion character in '%2$s' ?", string, string4);
                    context.report(INVALID, (Location)object, string3, null);
                    continue;
                }
                if (!bl2) continue;
                object2 = matcher.group(1);
                if (object2 != null) {
                    object2 = ((String)object2).substring(0, ((String)object2).length() - 1);
                    n4 = Integer.parseInt((String)object2);
                    n3 = n4 + 1;
                } else {
                    n4 = n3++;
                }
                object = matcher.group(6);
                string3 = (String)hashMap.get(n4);
                if (string3 == null) {
                    hashMap.put(n4, (String)object);
                    hashMap2.put(n4, handle);
                    continue;
                }
                if (string3.equals(object) || !this.isIncompatible(string3.charAt(0), ((String)object).charAt(0))) continue;
                Object object3 = handle.getClientData();
                if (object3 instanceof org.w3c.dom.Node && context.getDriver().isSuppressed(ARG_TYPES, (org.w3c.dom.Node)object3)) {
                    return;
                }
                Location location = handle.resolve();
                location = this.refineLocation(context, location, string2, matcher.start(), matcher.end());
                Location location2 = ((Location.Handle)hashMap2.get(n4)).resolve();
                location2.setMessage("Conflicting argument type here");
                location.setSecondary(location2);
                File file = location2.getFile();
                String string5 = String.format("Inconsistent formatting types for argument #%1$d in format string %2$s ('%3$s'): Found both '%4$s' and '%5$s' (in %6$s)", n4, string, string4, string3, object, file.getParentFile().getName() + File.separator + file.getName());
                context.report(ARG_TYPES, location, string5, null);
                continue block0;
            }
        }
    }

    private boolean isIncompatible(char c, char c2) {
        int n;
        int n2 = StringFormatDetector.getConversionClass(c);
        return n2 != (n = StringFormatDetector.getConversionClass(c2)) && n2 != 0 && n != 0;
    }

    private static int getConversionClass(char c) {
        switch (c) {
            case 'T': 
            case 't': {
                return 9;
            }
            case 'S': 
            case 's': {
                return 1;
            }
            case 'C': 
            case 'c': {
                return 2;
            }
            case 'X': 
            case 'd': 
            case 'o': 
            case 'x': {
                return 3;
            }
            case 'A': 
            case 'E': 
            case 'G': 
            case 'a': 
            case 'e': 
            case 'f': 
            case 'g': {
                return 4;
            }
            case 'B': 
            case 'b': {
                return 5;
            }
            case 'H': 
            case 'h': {
                return 6;
            }
            case '%': {
                return 7;
            }
            case 'n': {
                return 8;
            }
        }
        return 0;
    }

    private Location refineLocation(Context context, Location location, String string, int n, int n2) {
        Position position = location.getStart();
        Position position2 = location.getStart();
        if (position != null && position2 != null) {
            int n3;
            String string2;
            int n4 = position.getOffset();
            int n5 = position2.getOffset();
            if (n4 >= 0 && (string2 = context.getClient().readFile(location.getFile())) != null && n5 <= string2.length() && n4 < n5 && (n3 = string2.indexOf(string, n4)) != -1 && n3 <= n5) {
                return Location.create(context.file, string2, n3 + n, n3 + n2);
            }
        }
        return location;
    }

    private void checkArity(Context context, String string, List<Pair<Location.Handle, String>> list) {
        int n = -1;
        for (Pair<Location.Handle, String> pair : list) {
            Object object;
            Object object2;
            Object object3;
            HashSet<Integer> hashSet = new HashSet<Integer>();
            int n2 = StringFormatDetector.getFormatArgumentCount(pair.getSecond(), hashSet);
            Location.Handle handle = pair.getFirst();
            if (n != -1 && n != n2) {
                Object object4 = handle.getClientData();
                if (object4 instanceof org.w3c.dom.Node && context.getDriver().isSuppressed(ARG_COUNT, (org.w3c.dom.Node)object4)) {
                    return;
                }
                object3 = handle.resolve();
                object2 = list.get(0).getFirst().resolve();
                ((Location)object2).setMessage("Conflicting number of arguments here");
                ((Location)object3).setSecondary((Location)object2);
                object = String.format("Inconsistent number of arguments in formatting string %1$s; found both %2$d and %3$d", string, n, n2);
                context.report(ARG_COUNT, (Location)object3, (String)object, null);
                break;
            }
            for (int i = 1; i <= n2; ++i) {
                if (hashSet.contains(i)) continue;
                object3 = handle.getClientData();
                if (object3 instanceof org.w3c.dom.Node && context.getDriver().isSuppressed(ARG_COUNT, (org.w3c.dom.Node)object3)) {
                    return;
                }
                object2 = new HashSet();
                for (int j = 1; j < n2; ++j) {
                    object2.add(j);
                }
                object2.removeAll(hashSet);
                object = new ArrayList(object2);
                Collections.sort(object);
                Location location = handle.resolve();
                String string2 = String.format("Formatting string '%1$s' is not referencing numbered arguments %2$s", string, object);
                context.report(ARG_COUNT, location, string2, null);
                break;
            }
            n = n2;
        }
    }

    static String getFormatArgumentType(String string, int n) {
        Matcher matcher = FORMAT.matcher(string);
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        while (matcher.find(n2)) {
            int n5;
            int n6 = matcher.start();
            while (n3 < n6) {
                n5 = string.charAt(n3);
                if (n5 == 92) {
                    ++n3;
                }
                ++n3;
            }
            if (n3 > n6) {
                n2 = n3;
                continue;
            }
            String string2 = matcher.group(1);
            if (string2 != null) {
                string2 = string2.substring(0, string2.length() - 1);
                n5 = Integer.parseInt(string2);
                n4 = n5 + 1;
            } else {
                n5 = n4++;
            }
            if (n5 == n) {
                return matcher.group(6);
            }
            n2 = matcher.end();
        }
        return null;
    }

    static int getFormatArgumentCount(String string, Set<Integer> set) {
        Matcher matcher = FORMAT.matcher(string);
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        while (matcher.find(n)) {
            int n5;
            int n6 = matcher.start();
            while (n2 < n6) {
                n5 = string.charAt(n2);
                if (n5 == 92) {
                    ++n2;
                }
                ++n2;
            }
            if (n2 > n6) {
                n = n2;
                continue;
            }
            String string2 = matcher.group(1);
            if (string2 != null) {
                string2 = string2.substring(0, string2.length() - 1);
                n5 = Integer.parseInt(string2);
                n3 = n5 + 1;
            } else {
                n5 = n3++;
            }
            if (n5 > n4) {
                n4 = n5;
            }
            if (set != null) {
                set.add(n5);
            }
            n = matcher.end();
        }
        return n4;
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(FORMAT_METHOD);
    }

    @Override
    public void visitMethod(JavaContext javaContext, AstVisitor astVisitor, MethodInvocation methodInvocation) {
        VariableReference variableReference;
        if (this.mFormatStrings == null) {
            return;
        }
        String string = methodInvocation.astName().getDescription();
        assert (string.equals(FORMAT_METHOD));
        if (methodInvocation.astOperand() instanceof VariableReference && "String".equals((variableReference = (VariableReference)methodInvocation.astOperand()).astIdentifier().astValue())) {
            Node node;
            for (node = methodInvocation.getParent(); node != null && !(node instanceof MethodDeclaration); node = node.getParent()) {
            }
            if (node instanceof MethodDeclaration) {
                this.checkStringFormatCall(javaContext, (MethodDeclaration)node, methodInvocation);
            }
        }
    }

    private void checkStringFormatCall(JavaContext javaContext, MethodDeclaration methodDeclaration, MethodInvocation methodInvocation) {
        StrictListAccessor strictListAccessor = methodInvocation.astArguments();
        if (strictListAccessor.size() == 0) {
            return;
        }
        StringTracker stringTracker = new StringTracker(methodDeclaration, methodInvocation);
        methodDeclaration.accept((AstVisitor)stringTracker);
        String string = stringTracker.getFormatStringName();
        if (string == null) {
            return;
        }
        if (this.mNotFormatStrings.containsKey(string)) {
            Location.Handle handle = this.mNotFormatStrings.get(string);
            Object object = handle.getClientData();
            if (object instanceof org.w3c.dom.Node && javaContext.getDriver().isSuppressed(INVALID, (org.w3c.dom.Node)object)) {
                return;
            }
            Location location = handle.resolve();
            String string2 = String.format("Format string '%1$s' is not a valid format string so it should not be passed to String.format", string);
            javaContext.report(INVALID, location, string2, null);
            return;
        }
        List<Pair<Location.Handle, String>> list = this.mFormatStrings.get(string);
        if (list != null) {
            for (Pair<Location.Handle, String> pair : list) {
                Class<?> clazz;
                String string3 = pair.getSecond();
                int n = StringFormatDetector.getFormatArgumentCount(string3, null);
                Location.Handle handle = pair.getFirst();
                if (n != strictListAccessor.size() - 1) {
                    Location location = javaContext.parser.getLocation(javaContext, (Node)methodInvocation);
                    clazz = handle.resolve();
                    ((Location)((Object)clazz)).setMessage(String.format("This definition requires %1$d arguments", n));
                    location.setSecondary((Location)((Object)clazz));
                    String string4 = String.format("Wrong argument count, format string %1$s requires %2$d but format call supplies %3$d", string, n, strictListAccessor.size() - 1);
                    javaContext.report(ARG_TYPES, (Node)methodDeclaration, location, string4, null);
                    continue;
                }
                for (int i = 1; i <= n; ++i) {
                    clazz = stringTracker.getArgumentType(i);
                    if (clazz == null) continue;
                    boolean bl = true;
                    String string5 = StringFormatDetector.getFormatArgumentType(string3, i);
                    char c = string5.charAt(string5.length() - 1);
                    if (string5.length() >= 2 && Character.toLowerCase(string5.charAt(string5.length() - 2)) == 't') continue;
                    switch (c) {
                        case 'B': 
                        case 'b': {
                            bl = clazz == Boolean.TYPE;
                            break;
                        }
                        case 'A': 
                        case 'E': 
                        case 'G': 
                        case 'X': 
                        case 'a': 
                        case 'd': 
                        case 'e': 
                        case 'f': 
                        case 'g': 
                        case 'o': 
                        case 'x': {
                            bl = clazz == Integer.TYPE || clazz == Float.TYPE;
                            break;
                        }
                        case 'C': 
                        case 'c': {
                            bl = clazz == Character.TYPE;
                            break;
                        }
                        case 'H': 
                        case 'S': 
                        case 'h': 
                        case 's': {
                            boolean bl2 = bl = clazz != Boolean.TYPE && !clazz.isAssignableFrom(Number.class);
                        }
                    }
                    if (bl) continue;
                    IJavaParser iJavaParser = javaContext.parser;
                    Expression expression = stringTracker.getArgument(i);
                    Location location = iJavaParser.getLocation(javaContext, (Node)expression);
                    Location location2 = handle.resolve();
                    location2.setMessage("Conflicting argument declaration here");
                    location.setSecondary(location2);
                    String string6 = String.format("Wrong argument type for formatting argument '#%1$d' in %2$s: conversion is '%3$s', received %4$s", i, string, string5, clazz.getSimpleName());
                    javaContext.report(ARG_TYPES, (Node)methodDeclaration, location, string6, null);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringTracker
    extends ForwardingAstVisitor {
        private final MethodDeclaration mTop;
        private final Map<String, String> mMap = new HashMap<String, String>();
        private final Map<String, Class<?>> mTypes = new HashMap();
        private MethodInvocation mTargetNode;
        private boolean mDone;
        private String mName;

        public StringTracker(MethodDeclaration methodDeclaration, MethodInvocation methodInvocation) {
            this.mTop = methodDeclaration;
            this.mTargetNode = methodInvocation;
        }

        public String getFormatStringName() {
            return this.mName;
        }

        public Class<?> getArgumentType(int n) {
            Class<?> clazz;
            Expression expression = this.getArgument(n);
            if (expression != null && (clazz = this.getType(expression)) != null) {
                return clazz;
            }
            return null;
        }

        public Expression getArgument(int n) {
            StrictListAccessor strictListAccessor = this.mTargetNode.astArguments();
            if (n >= strictListAccessor.size()) {
                return null;
            }
            Iterator iterator = strictListAccessor.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                Expression expression = (Expression)iterator.next();
                if (n2++ != n) continue;
                return expression;
            }
            return null;
        }

        public boolean visitNode(Node node) {
            if (this.mDone) {
                return true;
            }
            return super.visitNode(node);
        }

        public boolean visitVariableReference(VariableReference variableReference) {
            if (variableReference.astIdentifier().getDescription().equals("R") && variableReference.getParent() instanceof Select && variableReference.getParent().getParent() instanceof Select) {
                Node node;
                String string = ((Select)node).astIdentifier().astValue();
                for (node = variableReference.getParent().getParent(); node != this.mTop && !(node instanceof VariableDefinitionEntry); node = node.getParent()) {
                }
                if (node instanceof VariableDefinitionEntry) {
                    VariableDefinitionEntry variableDefinitionEntry = (VariableDefinitionEntry)node;
                    String string2 = variableDefinitionEntry.astName().astValue();
                    this.mMap.put(string2, string);
                }
            }
            return false;
        }

        public boolean visitMethodInvocation(MethodInvocation methodInvocation) {
            Expression expression;
            StrictListAccessor strictListAccessor;
            if (methodInvocation == this.mTargetNode && (strictListAccessor = methodInvocation.astArguments()).size() > 0 && (expression = (Expression)strictListAccessor.first()) instanceof VariableReference) {
                VariableReference variableReference = (VariableReference)expression;
                String string = variableReference.astIdentifier().astValue();
                this.mName = this.mMap.get(string);
                this.mDone = true;
                return true;
            }
            return super.visitMethodInvocation(methodInvocation);
        }

        public boolean visitVariableDefinitionEntry(VariableDefinitionEntry variableDefinitionEntry) {
            String string = variableDefinitionEntry.astName().astValue();
            Expression expression = variableDefinitionEntry.astInitializer();
            Class<?> clazz = this.getType(expression);
            if (clazz != null) {
                this.mTypes.put(string, clazz);
            } else if (expression != this.mTargetNode) {
                this.mTypes.remove(string);
            }
            return super.visitVariableDefinitionEntry(variableDefinitionEntry);
        }

        private Class<?> getType(Expression expression) {
            if (expression instanceof VariableReference) {
                VariableReference variableReference = (VariableReference)expression;
                String string = variableReference.astIdentifier().astValue();
                return this.mTypes.get(string);
            }
            if (expression instanceof MethodInvocation) {
                MethodInvocation methodInvocation = (MethodInvocation)expression;
                String string = methodInvocation.astName().astValue();
                if (string.equals("getString")) {
                    return String.class;
                }
            } else {
                if (expression instanceof StringLiteral) {
                    return String.class;
                }
                if (expression instanceof IntegralLiteral) {
                    return Integer.TYPE;
                }
                if (expression instanceof FloatingPointLiteral) {
                    return Float.TYPE;
                }
                if (expression instanceof CharLiteral) {
                    return Character.TYPE;
                }
                if (expression instanceof NullLiteral) {
                    return Object.class;
                }
            }
            return null;
        }

        public boolean visitVariableDefinition(VariableDefinition variableDefinition) {
            return super.visitVariableDefinition(variableDefinition);
        }
    }
}

