/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextFieldDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("TextFields", "Looks for text fields missing inputType or hint settings", "Providing an inputType attribute on a text field improves usability because depending on the data to be input, optimized keyboards can be shown to the user (such as just digits and parentheses for a phone number). Similarly,a hint attribute displays a hint to the user for what is expected in the text field.\n\nIf you really want to keep the text field generic, you can suppress this warning by setting inputType=\"text\".", Category.USABILITY, 5, Severity.WARNING, TextFieldDetector.class, Scope.RESOURCE_FILE_SCOPE);

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("EditText");
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        if (!element.hasAttributeNS("http://schemas.android.com/apk/res/android", "inputType") && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "hint")) {
            if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "inputMethod")) {
                return;
            }
            xmlContext.report(ISSUE, element, xmlContext.getLocation(element), "This text field does not specify an inputType or a hint", null);
        }
    }
}

