/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationDetector
extends ResourceXmlDetector {
    static boolean COMPLETE_REGIONS = System.getenv("ANDROID_LINT_COMPLETE_REGIONS") != null;
    private static final Pattern LANGUAGE_PATTERN = Pattern.compile("^[a-z]{2}$");
    private static final Pattern REGION_PATTERN = Pattern.compile("^r([A-Z]{2})$");
    public static final Issue MISSING = Issue.create("MissingTranslation", "Checks for incomplete translations where not all strings are translated", "If an application has more than one locale, then all the strings declared in one language should also be translated in all other languages.\n\nBy default this detector allows regions of a language to just provide a subset of the strings and fall back to the standard language strings. You can require all regions to provide a full translation by setting the environment variable ANDROID_LINT_COMPLETE_REGIONS.", Category.MESSAGES, 8, Severity.FATAL, TranslationDetector.class, Scope.ALL_RESOURCES_SCOPE);
    public static final Issue EXTRA = Issue.create("ExtraTranslation", "Checks for translations that appear to be unused (no default language string)", "If a string appears in a specific language translation file, but there is no corresponding string in the default locale, then this string is probably unused. (It's technically possible that your application is only intended to run in a specific locale, but it's still a good idea to provide a fallback.)", Category.MESSAGES, 6, Severity.WARNING, TranslationDetector.class, Scope.ALL_RESOURCES_SCOPE);
    private Set<String> mNames;
    private boolean mIgnoreFile;
    private Map<File, Set<String>> mFileToNames;
    private Map<String, Location> mMissingLocations;
    private Map<String, Location> mExtraLocations;
    private Map<String, String> mDescriptions;

    @Override
    public boolean appliesTo(ResourceFolderType resourceFolderType) {
        return resourceFolderType == ResourceFolderType.VALUES;
    }

    @Override
    public Speed getSpeed() {
        return Speed.NORMAL;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("string", "string-array");
    }

    @Override
    public void beforeCheckProject(Context context) {
        if (context.getDriver().getPhase() == 1) {
            this.mFileToNames = new HashMap<File, Set<String>>();
        }
    }

    @Override
    public void beforeCheckFile(Context context) {
        if (context.getPhase() == 1) {
            this.mNames = new HashSet<String>();
        }
        this.mIgnoreFile = context.file.getName().startsWith("donottranslate");
    }

    @Override
    public void afterCheckFile(Context context) {
        if (context.getPhase() == 1) {
            this.mFileToNames.put(context.file, this.mNames);
            this.mNames = null;
        }
    }

    @Override
    public void afterCheckProject(Context context) {
        if (context.getPhase() == 1) {
            this.checkTranslations(context);
            this.mFileToNames = null;
            if (this.mMissingLocations != null || this.mExtraLocations != null) {
                context.getDriver().requestRepeat(this, Scope.ALL_RESOURCES_SCOPE);
            }
        } else {
            assert (context.getPhase() == 2);
            this.reportMap(context, MISSING, this.mMissingLocations);
            this.reportMap(context, EXTRA, this.mExtraLocations);
            this.mMissingLocations = null;
            this.mExtraLocations = null;
            this.mDescriptions = null;
        }
    }

    private void reportMap(Context context, Issue issue, Map<String, Location> map) {
        if (map != null) {
            for (Map.Entry<String, Location> entry : map.entrySet()) {
                Location location = entry.getValue();
                String string = entry.getKey();
                String string2 = this.mDescriptions.get(string);
                location = Location.reverse(location);
                context.report(issue, location, string2, null);
            }
        }
    }

    private void checkTranslations(Context context) {
        String string;
        Sets.SetView<String> setView;
        Map.Entry entry3;
        int n;
        Object object;
        Object object2;
        Set<File> set = this.mFileToNames.keySet();
        if (set.size() == 1) {
            return;
        }
        HashSet<File> hashSet = new HashSet<File>();
        for (File file : set) {
            hashSet.add(file.getParentFile());
        }
        if (hashSet.size() == 1) {
            return;
        }
        boolean bl = context.isEnabled(MISSING);
        boolean bl2 = context.isEnabled(EXTRA);
        String string2 = "Default";
        HashMap<File, String> hashMap = new HashMap<File, String>();
        for (File serializable2 : hashSet) {
            object2 = serializable2.getName();
            object = TranslationDetector.getLanguage((String)object2);
            if (object == null) {
                object = string2;
            }
            hashMap.put(serializable2, (String)object);
        }
        int n2 = hashMap.values().size();
        if (n2 <= 1) {
            return;
        }
        HashMap hashMap2 = new HashMap(n2);
        object2 = new HashSet(200);
        for (File n3 : set) {
            String bl3 = (String)hashMap.get(n3.getParentFile());
            assert (bl3 != null) : n3.getParent();
            Object object3 = this.mFileToNames.get(n3);
            Set set2 = (Set)hashMap2.get(bl3);
            if (set2 == null) {
                hashMap2.put(bl3, object3);
            } else {
                set2.addAll(object3);
            }
            object2.addAll(object3);
        }
        object = (Set)hashMap2.get(string2);
        if (object == null) {
            object = new HashSet();
        }
        if ((n = object2.size()) == object.size()) {
            boolean bl3 = false;
            for (Map.Entry entry2 : hashMap2.entrySet()) {
                entry3 = (Set)entry2.getValue();
                if (n == entry3.size()) continue;
                bl3 = true;
                break;
            }
            if (!bl3) {
                return;
            }
        }
        if (!COMPLETE_REGIONS) {
            for (Object object3 : hashMap2.keySet()) {
                if (((String)object3).indexOf(45) == -1) continue;
                for (Map.Entry entry3 : hashMap2.entrySet()) {
                    Set set3;
                    Iterator iterator;
                    int n4;
                    setView = (Sets.SetView<String>)entry3.getValue();
                    if (n == setView.size() || (n4 = ((String)((Object)(iterator = (String)entry3.getKey()))).indexOf(45)) == -1 || (set3 = (Set)hashMap2.get(string = ((String)((Object)iterator)).substring(0, n4))) == null) continue;
                    setView.addAll(set3);
                }
            }
        }
        ArrayList arrayList = new ArrayList(hashMap2.keySet());
        Collections.sort(arrayList);
        for (String string3 : arrayList) {
            entry3 = (Set)hashMap2.get(string3);
            if (string2.equals(string3) || n == entry3.size()) continue;
            if (bl && (setView = Sets.difference(object, entry3)).size() > 0) {
                if (this.mMissingLocations == null) {
                    this.mMissingLocations = new HashMap<String, Location>();
                }
                if (this.mDescriptions == null) {
                    this.mDescriptions = new HashMap<String, String>();
                }
                for (String string4 : setView) {
                    this.mMissingLocations.put(string4, null);
                    string = this.mDescriptions.get(string4);
                    string = string == null ? String.format("\"%1$s\" is not translated in %2$s", string4, string3) : string + ", " + string3;
                    this.mDescriptions.put(string4, string);
                }
            }
            if (!bl2 || (setView = Sets.difference(entry3, object)).size() <= 0) continue;
            if (this.mExtraLocations == null) {
                this.mExtraLocations = new HashMap<String, Location>();
            }
            if (this.mDescriptions == null) {
                this.mDescriptions = new HashMap<String, String>();
            }
            for (String string4 : setView) {
                this.mExtraLocations.put(string4, null);
                string = String.format("\"%1$s\" is translated here but not found in default locale", string4);
                this.mDescriptions.put(string4, string);
            }
        }
    }

    private static String getLanguage(String string) {
        String[] stringArray = string.split("-");
        String string2 = null;
        for (String string3 : stringArray) {
            if (string2 == null && string3.length() == 2 && LANGUAGE_PATTERN.matcher(string3).matches()) {
                string2 = string3;
            }
            if (string2 == null || string3.length() != 3 || !REGION_PATTERN.matcher(string3).matches()) continue;
            string2 = string2 + '-' + string3;
            break;
        }
        return string2;
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        if (this.mIgnoreFile) {
            return;
        }
        Attr attr = element.getAttributeNode("name");
        if (xmlContext.getPhase() == 2) {
            Object object;
            if (attr == null) {
                return;
            }
            String string = attr.getValue();
            if (this.mMissingLocations != null && this.mMissingLocations.containsKey(string) && (object = TranslationDetector.getLanguage(xmlContext.file.getParentFile().getName())) == null) {
                if (xmlContext.getDriver().isSuppressed(MISSING, element)) {
                    this.mMissingLocations.remove(string);
                    return;
                }
                Location location = xmlContext.getLocation(element);
                location.setClientData(element);
                location.setSecondary(this.mMissingLocations.get(string));
                this.mMissingLocations.put(string, location);
            }
            if (this.mExtraLocations != null && this.mExtraLocations.containsKey(string)) {
                if (xmlContext.getDriver().isSuppressed(EXTRA, element)) {
                    this.mExtraLocations.remove(string);
                    return;
                }
                object = xmlContext.getLocation(element);
                ((Location)object).setClientData(element);
                ((Location)object).setMessage("Also translated here");
                ((Location)object).setSecondary(this.mExtraLocations.get(string));
                this.mExtraLocations.put(string, (Location)object);
            }
            return;
        }
        assert (xmlContext.getPhase() == 1);
        if (attr == null || attr.getValue().length() == 0) {
            xmlContext.report(MISSING, element, xmlContext.getLocation(element), "Missing name attribute in <string> declaration", null);
        } else {
            String string = attr.getValue();
            Attr attr2 = element.getAttributeNode("translatable");
            if (attr2 != null && !Boolean.valueOf(attr2.getValue()).booleanValue()) {
                return;
            }
            if (element.getTagName().equals("string-array") && this.allItemsAreReferences(element)) {
                return;
            }
            this.mNames.add(string);
        }
    }

    private boolean allItemsAreReferences(Element element) {
        assert (element.getTagName().equals("string-array"));
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !"item".equals(node.getNodeName())) continue;
            NodeList nodeList2 = node.getChildNodes();
            int n2 = nodeList2.getLength();
            for (int j = 0; j < n2; ++j) {
                String string;
                Node node2 = nodeList2.item(j);
                if (node2.getNodeType() != 3 || (string = node2.getNodeValue().trim()).startsWith("@android:") || string.startsWith("@string/")) continue;
                return false;
            }
        }
        return true;
    }
}

