/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UseCompoundDrawableDetector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("UseCompoundDrawables", "Checks whether the current node can be replaced by a TextView using compound drawables.", "A LinearLayout which contains an ImageView and a TextView can be more efficiently handled as a compound drawable.\n\nThere's a lint quickfix to perform this conversion in the Eclipse plugin.", Category.PERFORMANCE, 6, Severity.WARNING, UseCompoundDrawableDetector.class, Scope.RESOURCE_FILE_SCOPE);

    @Override
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Collections.singletonList("LinearLayout");
    }

    @Override
    public void visitElement(XmlContext xmlContext, Element element) {
        int n = LintUtils.getChildCount(element);
        if (n == 2) {
            List<Element> list = LintUtils.getChildren(element);
            Element element2 = list.get(0);
            Element element3 = list.get(1);
            if (element2.getTagName().equals("ImageView") && element3.getTagName().equals("TextView") && !element2.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_weight") || element3.getTagName().equals("ImageView") && element2.getTagName().equals("TextView") && !element3.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_weight")) {
                if (element.hasAttributeNS("http://schemas.android.com/apk/res/android", "background")) {
                    return;
                }
                xmlContext.report(ISSUE, element, xmlContext.getLocation(element), "This tag and its children can be replaced by one <TextView/> and a compound drawable", null);
            }
        }
    }
}

