/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;

public class Utf8Detector
extends LayoutDetector {
    public static final Issue ISSUE = Issue.create("EnforceUTF8", "Checks that all XML resource files are using UTF-8 as the file encoding", "XML supports encoding in a wide variety of character sets. However, not all tools handle the XML encoding attribute correctly, and nearly all Android apps use UTF-8, so by using UTF-8 you can protect yourself against subtle bugs when using non-ASCII characters.", Category.I18N, 2, Severity.WARNING, Utf8Detector.class, Scope.RESOURCE_FILE_SCOPE);
    private static final Pattern ENCODING_PATTERN = Pattern.compile("encoding=['\"](\\S*)['\"]");

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void visitDocument(XmlContext xmlContext, Document document) {
        Matcher matcher;
        char c;
        int n;
        String string = xmlContext.getContents();
        int n2 = string.length();
        for (n = 0; n < n2 && (c = string.charAt(n)) != '\n' && c != '\r'; ++n) {
        }
        for (n2 = 16; n2 < n - 5; ++n2) {
            if (string.charAt(n2) != 'u' && string.charAt(n2) != 'U' || string.charAt(n2 + 1) != 't' && string.charAt(n2 + 1) != 'T' || string.charAt(n2 + 2) != 'f' && string.charAt(n2 + 2) != 'F' || string.charAt(n2 + 3) != '-' && string.charAt(n2 + 3) != '_' || string.charAt(n2 + 4) != '8') continue;
            return;
        }
        n2 = string.lastIndexOf("encoding", n);
        if (n2 != -1 && (matcher = ENCODING_PATTERN.matcher(string)).find(n2)) {
            String string2 = matcher.group(1);
            Location location = Location.create(xmlContext.file, string, matcher.start(1), matcher.end(1));
            xmlContext.report(ISSUE, null, location, String.format("%1$s: Not using UTF-8 as the file encoding. This can lead to subtle bugs with non-ascii characters", string2), null);
        }
    }
}

