/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.io.File;
import java.util.EnumSet;
import java.util.List;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ViewConstructorDetector
extends Detector
implements Detector.ClassScanner {
    private static final String SIG1 = "(Landroid/content/Context;)V";
    private static final String SIG2 = "(Landroid/content/Context;Landroid/util/AttributeSet;)V";
    private static final String SIG3 = "(Landroid/content/Context;Landroid/util/AttributeSet;I)V";
    public static final Issue ISSUE = Issue.create("ViewConstructor", "Checks that custom views define the expected constructors", "Some layout tools (such as the Android layout editor for Eclipse) needs to find a constructor with one of the following signatures:\n* View(Context context)\n* View(Context context, AttributeSet attrs)\n* View(Context context, AttributeSet attrs, int defStyle)\n\nIf your custom view needs to perform initialization which does not apply when used in a layout editor, you can surround the given code with a check to see if View#isInEditMode() is false, since that method will return false at runtime but true within a user interface editor.", Category.USABILITY, 3, Severity.WARNING, ViewConstructorDetector.class, EnumSet.of(Scope.CLASS_FILE));

    public boolean appliesTo(Context context, File file) {
        return true;
    }

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void checkClass(ClassContext classContext, ClassNode classNode) {
        if (classNode.name.indexOf(36) != -1 && (classNode.access & 8) == 0) {
            return;
        }
        if (ViewConstructorDetector.isViewClass(classContext, classNode)) {
            this.checkConstructors(classContext, classNode);
        }
    }

    private static boolean isViewClass(ClassContext classContext, ClassNode classNode) {
        String string = classNode.superName;
        while (string != null) {
            if (string.equals("android/view/View") || string.equals("android/view/ViewGroup") || string.startsWith("android/widget/") && !string.endsWith("Adapter") && !string.endsWith("Controller") && !string.endsWith("Service") && !string.endsWith("Provider") && !string.endsWith("Filter")) {
                return true;
            }
            string = classContext.getDriver().getSuperClass(string);
        }
        return false;
    }

    private void checkConstructors(ClassContext classContext, ClassNode classNode) {
        Object object;
        Object object22;
        List list = classNode.methods;
        for (Object object22 : list) {
            String string;
            object = (MethodNode)object22;
            if (!((MethodNode)object).name.equals("<init>") || !(string = ((MethodNode)object).desc).equals(SIG1) && !string.equals(SIG2) && !string.equals(SIG3)) continue;
            return;
        }
        String string = String.format("Custom view %1$s is missing constructor used by tools: (Context) or (Context,AttributeSet) or (Context,AttributeSet,int)", classNode.name);
        object22 = classContext.getSourceFile();
        object = Location.create(object22 != null ? object22 : classContext.file);
        classContext.report(ISSUE, (Location)object, string, null);
    }
}

