/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddms;

import com.android.ddmlib.Log;
import com.android.ddms.Main;
import com.android.ddmuilib.ImageLoader;
import java.io.InputStream;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class AboutDialog
extends Dialog {
    private Image logoImage;

    public AboutDialog(Shell shell) {
        this(shell, 67680);
    }

    public AboutDialog(Shell shell, int n) {
        super(shell, n);
    }

    public void open() {
        Shell shell = this.getParent();
        Shell shell2 = new Shell(shell, this.getStyle());
        shell2.setText("About...");
        this.logoImage = this.loadImage(shell2, "ddms-128.png");
        this.createContents(shell2);
        shell2.pack();
        shell2.open();
        Display display = shell.getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        this.logoImage.dispose();
    }

    private Image loadImage(Shell shell, String string) {
        String string2 = "/images/" + string;
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(string2);
        if (inputStream == null) {
            Log.w("ddms", "Couldn't load " + string2);
            Display display = shell.getDisplay();
            return ImageLoader.createPlaceHolderArt(display, 100, 50, display.getSystemColor(9));
        }
        Image image = new Image((Device)shell.getDisplay(), inputStream);
        if (image == null) {
            throw new NullPointerException("couldn't load " + string2);
        }
        return image;
    }

    private void createContents(final Shell shell) {
        shell.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)shell, 2048);
        label.setImage(this.logoImage);
        Composite composite = new Composite((Composite)shell, 0);
        GridLayout gridLayout = new GridLayout(1, true);
        composite.setLayout((Layout)gridLayout);
        Label label2 = new Label(composite, 0);
        if (Main.sRevision != null && Main.sRevision.length() > 0) {
            label2.setText("Dalvik Debug Monitor Revision " + Main.sRevision);
        } else {
            label2.setText("Dalvik Debug Monitor");
        }
        label2 = new Label(composite, 0);
        label2.setText("Copyright 2007-2011, The Android Open Source Project");
        label2 = new Label(composite, 0);
        label2.setText("All Rights Reserved.");
        label2 = new Label((Composite)shell, 0);
        Button button = new Button((Composite)shell, 8);
        button.setText("OK");
        GridData gridData = new GridData(128);
        gridData.widthHint = 80;
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                shell.close();
            }
        });
        shell.pack();
        shell.setDefaultButton(button);
    }
}

