/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddms;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddms.PrefsDialog;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DeviceCommandDialog
extends Dialog {
    public static final int DEVICE_STATE = 0;
    public static final int APP_STATE = 1;
    public static final int RADIO_STATE = 2;
    public static final int LOGCAT = 3;
    private String mCommand;
    private String mFileName;
    private Label mStatusLabel;
    private Button mCancelDone;
    private Button mSave;
    private Text mText;
    private Font mFont = null;
    private boolean mCancel;
    private boolean mFinished;

    public DeviceCommandDialog(String string, String string2, Shell shell) {
        this(string, string2, shell, 67696);
    }

    public DeviceCommandDialog(String string, String string2, Shell shell, int n) {
        super(shell, n);
        this.mCommand = string;
        this.mFileName = string2;
    }

    public void open(IDevice iDevice) {
        Shell shell = this.getParent();
        Shell shell2 = new Shell(shell, this.getStyle());
        shell2.setText("Remote Command");
        this.mFinished = false;
        this.mFont = this.findFont(shell2.getDisplay());
        this.createContents(shell2);
        shell2.setMinimumSize(500, 200);
        shell2.setSize(800, 600);
        shell2.open();
        this.executeCommand(shell2, iDevice);
        Display display = shell.getDisplay();
        while (!shell2.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (this.mFont != null) {
            this.mFont.dispose();
        }
    }

    private void createContents(final Shell shell) {
        shell.setLayout((Layout)new GridLayout(2, true));
        shell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                if (!DeviceCommandDialog.this.mFinished) {
                    Log.d("ddms", "NOT closing - cancelling command");
                    event.doit = false;
                    DeviceCommandDialog.this.mCancel = true;
                }
            }
        });
        this.mStatusLabel = new Label((Composite)shell, 0);
        this.mStatusLabel.setText("Executing '" + this.shortCommandString() + "'");
        GridData gridData = new GridData(32);
        gridData.horizontalSpan = 2;
        this.mStatusLabel.setLayoutData((Object)gridData);
        this.mText = new Text((Composite)shell, 770);
        this.mText.setEditable(false);
        this.mText.setFont(this.mFont);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.mText.setLayoutData((Object)gridData);
        this.mSave = new Button((Composite)shell, 8);
        this.mSave.setText("Save");
        gridData = new GridData(64);
        gridData.widthHint = 80;
        this.mSave.setLayoutData((Object)gridData);
        this.mSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DeviceCommandDialog.this.saveText(shell);
            }
        });
        this.mSave.setEnabled(false);
        this.mCancelDone = new Button((Composite)shell, 8);
        this.mCancelDone.setText("Cancel");
        gridData = new GridData(64);
        gridData.widthHint = 80;
        this.mCancelDone.setLayoutData((Object)gridData);
        this.mCancelDone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (!DeviceCommandDialog.this.mFinished) {
                    DeviceCommandDialog.this.mCancel = true;
                } else {
                    shell.close();
                }
            }
        });
    }

    private Font findFont(Display display) {
        FontData fontData;
        String string = PrefsDialog.getStore().getString("textOutputFont");
        if (string != null && (fontData = new FontData(string)) != null) {
            return new Font((Device)display, fontData);
        }
        return null;
    }

    private void executeCommand(Shell shell, IDevice iDevice) {
        Gatherer gatherer = new Gatherer(shell, iDevice, this.commandString(), this.mText);
        gatherer.start();
    }

    private void updateForResult(int n) {
        if (n == 1) {
            this.mStatusLabel.setText("Successfully executed '" + this.shortCommandString() + "'");
            this.mSave.setEnabled(true);
        } else if (n == 3) {
            this.mStatusLabel.setText("Execution cancelled; partial results below");
            this.mSave.setEnabled(true);
        } else if (n == 2) {
            this.mStatusLabel.setText("Failed");
        }
        this.mStatusLabel.pack();
        this.mCancelDone.setText("Done");
        this.mFinished = true;
    }

    private void saveText(Shell shell) {
        FileDialog fileDialog = new FileDialog(shell, 8192);
        fileDialog.setText("Save output...");
        fileDialog.setFileName(this.defaultFileName());
        fileDialog.setFilterPath(PrefsDialog.getStore().getString("lastTextSaveDir"));
        fileDialog.setFilterNames(new String[]{"Text Files (*.txt)"});
        fileDialog.setFilterExtensions(new String[]{"*.txt"});
        String string = fileDialog.open();
        if (string != null) {
            byte[] byArray;
            PrefsDialog.getStore().setValue("lastTextSaveDir", fileDialog.getFilterPath());
            Log.d("ddms", "Saving output to " + string);
            String string2 = this.mText.getText();
            try {
                byArray = string2.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                byArray = new byte[]{};
            }
            try {
                int n = byArray.length;
                FileOutputStream fileOutputStream = new FileOutputStream(string);
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                for (int i = 0; i < n; ++i) {
                    if (i < n - 1 && byArray[i] == 13 && byArray[i + 1] == 10) continue;
                    bufferedOutputStream.write(byArray[i]);
                }
                bufferedOutputStream.close();
            }
            catch (IOException iOException) {
                Log.w("ddms", "Unable to save " + string + ": " + iOException);
            }
        }
    }

    private String commandString() {
        return this.mCommand;
    }

    private String defaultFileName() {
        return this.mFileName;
    }

    private String shortCommandString() {
        String string = this.commandString();
        if (string.length() > 50) {
            return string.substring(0, 50) + "...";
        }
        return string;
    }

    class Gatherer
    extends Thread
    implements IShellOutputReceiver {
        public static final int RESULT_UNKNOWN = 0;
        public static final int RESULT_SUCCESS = 1;
        public static final int RESULT_FAILURE = 2;
        public static final int RESULT_CANCELLED = 3;
        private Shell mShell;
        private String mCommand;
        private Text mText;
        private int mResult;
        private IDevice mDevice;

        public Gatherer(Shell shell, IDevice iDevice, String string, Text text) {
            this.mShell = shell;
            this.mDevice = iDevice;
            this.mCommand = string;
            this.mText = text;
            this.mResult = 0;
            DeviceCommandDialog.this.mCancel = false;
        }

        public void run() {
            if (this.mDevice == null) {
                Log.w("ddms", "Cannot execute command: no device selected.");
                this.mResult = 2;
            } else {
                try {
                    this.mDevice.executeShellCommand(this.mCommand, this);
                    this.mResult = DeviceCommandDialog.this.mCancel ? 3 : 1;
                }
                catch (IOException iOException) {
                    Log.w("ddms", "Remote exec failed: " + iOException.getMessage());
                    this.mResult = 2;
                }
                catch (TimeoutException timeoutException) {
                    Log.w("ddms", "Remote exec failed: " + timeoutException.getMessage());
                    this.mResult = 2;
                }
                catch (AdbCommandRejectedException adbCommandRejectedException) {
                    Log.w("ddms", "Remote exec failed: " + adbCommandRejectedException.getMessage());
                    this.mResult = 2;
                }
                catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
                    Log.w("ddms", "Remote exec failed: " + shellCommandUnresponsiveException.getMessage());
                    this.mResult = 2;
                }
            }
            this.mShell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    DeviceCommandDialog.this.updateForResult(Gatherer.this.mResult);
                }
            });
        }

        public void addOutput(byte[] byArray, int n, int n2) {
            Log.v("ddms", "received " + n2 + " bytes");
            try {
                final String string = new String(byArray, n, n2, "ISO-8859-1");
                this.mText.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        Gatherer.this.mText.append(string);
                    }
                });
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
        }

        public void flush() {
        }

        public boolean isCancelled() {
            return DeviceCommandDialog.this.mCancel;
        }
    }
}

