/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddms;

import com.android.ddms.DebugPortProvider;
import com.android.ddms.PrefsDialog;
import com.android.ddms.StaticPortEditDialog;
import com.android.ddmuilib.TableHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class StaticPortConfigDialog
extends Dialog {
    private static final String PREFS_DEVICE_COL = "spcd.deviceColumn";
    private static final String PREFS_APP_COL = "spcd.AppColumn";
    private static final String PREFS_PORT_COL = "spcd.PortColumn";
    private static final int COL_DEVICE = 0;
    private static final int COL_APPLICATION = 1;
    private static final int COL_PORT = 2;
    private static final int DLG_WIDTH = 500;
    private static final int DLG_HEIGHT = 300;
    private Shell mShell;
    private Shell mParent;
    private Table mPortTable;
    private ArrayList<Integer> mPorts = new ArrayList();

    public StaticPortConfigDialog(Shell shell) {
        super(shell, 67680);
    }

    public void open() {
        this.createUI();
        if (this.mParent == null || this.mShell == null) {
            return;
        }
        this.updateFromStore();
        this.mShell.setMinimumSize(500, 300);
        Rectangle rectangle = this.mParent.getBounds();
        int n = rectangle.x + rectangle.width / 2;
        int n2 = n - 250;
        int n3 = rectangle.y + rectangle.height / 2;
        int n4 = n3 - 150;
        this.mShell.setBounds(n2, n4, 500, 300);
        this.mShell.pack();
        this.mShell.open();
        Display display = this.mParent.getDisplay();
        while (!this.mShell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void createUI() {
        this.mParent = this.getParent();
        this.mShell = new Shell(this.mParent, this.getStyle());
        this.mShell.setText("Static Port Configuration");
        this.mShell.setLayout((Layout)new GridLayout(1, true));
        this.mShell.addListener(21, new Listener(){

            public void handleEvent(Event event) {
                event.doit = true;
            }
        });
        Composite composite = new Composite((Composite)this.mShell, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.mPortTable = new Table(composite, 65540);
        this.mPortTable.setLayoutData((Object)new GridData(1808));
        this.mPortTable.setHeaderVisible(true);
        this.mPortTable.setLinesVisible(true);
        TableHelper.createTableColumn(this.mPortTable, "Device Serial Number", 16384, "emulator-5554", PREFS_DEVICE_COL, (IPreferenceStore)PrefsDialog.getStore());
        TableHelper.createTableColumn(this.mPortTable, "Application Package", 16384, "com.android.samples.phone", PREFS_APP_COL, (IPreferenceStore)PrefsDialog.getStore());
        TableHelper.createTableColumn(this.mPortTable, "Debug Port", 131072, "Debug Port", PREFS_PORT_COL, (IPreferenceStore)PrefsDialog.getStore());
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)new GridData(1040));
        composite2.setLayout((Layout)new GridLayout(1, true));
        Button button = new Button(composite2, 0);
        button.setText("New...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StaticPortEditDialog staticPortEditDialog = new StaticPortEditDialog(StaticPortConfigDialog.this.mShell, StaticPortConfigDialog.this.mPorts);
                if (staticPortEditDialog.open()) {
                    String string = staticPortEditDialog.getDeviceSN();
                    String string2 = staticPortEditDialog.getAppName();
                    int n = staticPortEditDialog.getPortNumber();
                    StaticPortConfigDialog.this.addEntry(string, string2, n);
                }
            }
        });
        final Button button2 = new Button(composite2, 0);
        button2.setText("Edit...");
        button2.setEnabled(false);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = StaticPortConfigDialog.this.mPortTable.getSelectionIndex();
                String string = StaticPortConfigDialog.this.getDeviceName(n);
                String string2 = StaticPortConfigDialog.this.getAppName(n);
                String string3 = StaticPortConfigDialog.this.getPortNumber(n);
                StaticPortEditDialog staticPortEditDialog = new StaticPortEditDialog(StaticPortConfigDialog.this.mShell, StaticPortConfigDialog.this.mPorts, string, string2, string3);
                if (staticPortEditDialog.open()) {
                    String string4 = staticPortEditDialog.getDeviceSN();
                    String string5 = staticPortEditDialog.getAppName();
                    int n2 = staticPortEditDialog.getPortNumber();
                    StaticPortConfigDialog.this.replaceEntry(n, string4, string5, n2);
                }
            }
        });
        final Button button3 = new Button(composite2, 0);
        button3.setText("Delete");
        button3.setEnabled(false);
        button3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = StaticPortConfigDialog.this.mPortTable.getSelectionIndex();
                StaticPortConfigDialog.this.removeEntry(n);
            }
        });
        Composite composite3 = new Composite((Composite)this.mShell, 0);
        composite3.setLayoutData((Object)new GridData(64));
        composite3.setLayout((Layout)new GridLayout(2, true));
        Button button4 = new Button(composite3, 0);
        button4.setText("OK");
        button4.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StaticPortConfigDialog.this.updateStore();
                StaticPortConfigDialog.this.mShell.close();
            }
        });
        Button button5 = new Button(composite3, 0);
        button5.setText("Cancel");
        button5.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                StaticPortConfigDialog.this.mShell.close();
            }
        });
        this.mPortTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                int n = StaticPortConfigDialog.this.mPortTable.getSelectionIndex();
                boolean bl = n != -1;
                button2.setEnabled(bl);
                button3.setEnabled(bl);
            }
        });
        this.mShell.pack();
    }

    private void addEntry(String string, String string2, int n) {
        TableItem tableItem = new TableItem(this.mPortTable, 0);
        tableItem.setText(0, string);
        tableItem.setText(1, string2);
        tableItem.setText(2, Integer.toString(n));
        this.mPorts.add(n);
    }

    private void removeEntry(int n) {
        this.mPortTable.remove(n);
        this.mPorts.remove(n);
    }

    private void replaceEntry(int n, String string, String string2, int n2) {
        TableItem tableItem = this.mPortTable.getItem(n);
        tableItem.setText(0, string);
        tableItem.setText(1, string2);
        tableItem.setText(2, Integer.toString(n2));
        this.mPorts.set(n, n2);
    }

    private String getDeviceName(int n) {
        TableItem tableItem = this.mPortTable.getItem(n);
        return tableItem.getText(0);
    }

    private String getAppName(int n) {
        TableItem tableItem = this.mPortTable.getItem(n);
        return tableItem.getText(1);
    }

    private String getPortNumber(int n) {
        TableItem tableItem = this.mPortTable.getItem(n);
        return tableItem.getText(2);
    }

    private void updateFromStore() {
        DebugPortProvider debugPortProvider = DebugPortProvider.getInstance();
        Map<String, Map<String, Integer>> map = debugPortProvider.getPortList();
        Set<String> set = map.keySet();
        for (String string : set) {
            Map<String, Integer> map2 = map.get(string);
            if (map2 == null) continue;
            Set<String> set2 = map2.keySet();
            for (String string2 : set2) {
                Integer n = map2.get(string2);
                if (n == null) continue;
                this.addEntry(string, string2, n);
            }
        }
    }

    private void updateStore() {
        HashMap<String, Map<String, Integer>> hashMap = new HashMap<String, Map<String, Integer>>();
        int n = this.mPortTable.getItemCount();
        for (int i = 0; i < n; ++i) {
            TableItem tableItem = this.mPortTable.getItem(i);
            String string = tableItem.getText(0);
            Map<String, Integer> map = hashMap.get(string);
            if (map == null) {
                map = new HashMap<String, Integer>();
                hashMap.put(string, map);
            }
            map.put(tableItem.getText(1), Integer.valueOf(tableItem.getText(2)));
        }
        DebugPortProvider debugPortProvider = DebugPortProvider.getInstance();
        debugPortProvider.setPortList(hashMap);
    }
}

