/*
 * Decompiled with CFR 0.152.
 */
package com.android.chimpchat;

import com.android.chimpchat.adb.AdbBackend;
import com.android.chimpchat.core.IChimpBackend;
import com.android.chimpchat.core.IChimpDevice;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChimpChat {
    private final IChimpBackend mBackend;
    private static String sAdbLocation;

    private ChimpChat(IChimpBackend iChimpBackend) {
        this.mBackend = iChimpBackend;
    }

    public static ChimpChat getInstance(Map<String, String> map) {
        sAdbLocation = map.get("adbLocation");
        IChimpBackend iChimpBackend = ChimpChat.createBackendByName(map.get("backend"));
        if (iChimpBackend == null) {
            return null;
        }
        ChimpChat chimpChat = new ChimpChat(iChimpBackend);
        return chimpChat;
    }

    public static ChimpChat getInstance() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("backend", "adb");
        return ChimpChat.getInstance(treeMap);
    }

    private static IChimpBackend createBackendByName(String string) {
        if ("adb".equals(string)) {
            if (sAdbLocation == null) {
                return new AdbBackend();
            }
            return new AdbBackend(sAdbLocation);
        }
        return null;
    }

    public IChimpDevice waitForConnection(long l, String string) {
        return this.mBackend.waitForConnection(l, string);
    }

    public IChimpDevice waitForConnection() {
        return this.mBackend.waitForConnection(Integer.MAX_VALUE, ".*");
    }

    public void shutdown() {
        this.mBackend.shutdown();
    }
}

