/*
 * Decompiled with CFR 0.152.
 */
package com.android.chimpchat;

import com.android.chimpchat.core.ChimpException;
import com.android.chimpchat.core.ChimpView;
import com.android.chimpchat.core.IChimpView;
import com.android.chimpchat.core.PhysicalButton;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChimpManager {
    private static Logger LOG = Logger.getLogger(ChimpManager.class.getName());
    private Socket monkeySocket;
    private BufferedWriter monkeyWriter;
    private BufferedReader monkeyReader;

    public ChimpManager(Socket socket) throws IOException {
        this.monkeySocket = socket;
        this.monkeyWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
        this.monkeyReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.quit();
        }
        finally {
            this.close();
            super.finalize();
        }
    }

    public boolean touchDown(int n, int n2) throws IOException {
        return this.sendMonkeyEvent("touch down " + n + " " + n2);
    }

    public boolean touchUp(int n, int n2) throws IOException {
        return this.sendMonkeyEvent("touch up " + n + " " + n2);
    }

    public boolean touchMove(int n, int n2) throws IOException {
        return this.sendMonkeyEvent("touch move " + n + " " + n2);
    }

    public boolean touch(int n, int n2) throws IOException {
        return this.sendMonkeyEvent("tap " + n + " " + n2);
    }

    public boolean press(String string) throws IOException {
        return this.sendMonkeyEvent("press " + string);
    }

    public boolean keyDown(String string) throws IOException {
        return this.sendMonkeyEvent("key down " + string);
    }

    public boolean keyUp(String string) throws IOException {
        return this.sendMonkeyEvent("key up " + string);
    }

    public boolean press(PhysicalButton physicalButton) throws IOException {
        return this.press(physicalButton.getKeyName());
    }

    private String sendMonkeyEventAndGetResponse(String string) throws IOException {
        string = string.trim();
        LOG.info("Monkey Command: " + string + ".");
        this.monkeyWriter.write(string + "\n");
        this.monkeyWriter.flush();
        return this.monkeyReader.readLine();
    }

    private boolean parseResponseForSuccess(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("OK");
    }

    private String parseResponseForExtra(String string) {
        int n = string.indexOf(58);
        if (n < 0) {
            return "";
        }
        return string.substring(n + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendMonkeyEvent(String string) throws IOException {
        ChimpManager chimpManager = this;
        synchronized (chimpManager) {
            String string2 = this.sendMonkeyEventAndGetResponse(string);
            return this.parseResponseForSuccess(string2);
        }
    }

    public void close() {
        try {
            this.monkeySocket.close();
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Unable to close monkeySocket", iOException);
        }
        try {
            this.monkeyReader.close();
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Unable to close monkeyReader", iOException);
        }
        try {
            this.monkeyWriter.close();
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Unable to close monkeyWriter", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVariable(String string) throws IOException {
        ChimpManager chimpManager = this;
        synchronized (chimpManager) {
            String string2 = this.sendMonkeyEventAndGetResponse("getvar " + string);
            if (!this.parseResponseForSuccess(string2)) {
                return null;
            }
            return this.parseResponseForExtra(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> listVariable() throws IOException {
        ChimpManager chimpManager = this;
        synchronized (chimpManager) {
            String string = this.sendMonkeyEventAndGetResponse("listvar");
            if (!this.parseResponseForSuccess(string)) {
                Collections.emptyList();
            }
            String string2 = this.parseResponseForExtra(string);
            return Lists.newArrayList((Object[])string2.split(" "));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() throws IOException {
        ChimpManager chimpManager = this;
        synchronized (chimpManager) {
            this.sendMonkeyEventAndGetResponse("done");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() throws IOException {
        ChimpManager chimpManager = this;
        synchronized (chimpManager) {
            try {
                this.sendMonkeyEventAndGetResponse("quit");
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    public boolean tap(int n, int n2) throws IOException {
        return this.sendMonkeyEvent("tap " + n + " " + n2);
    }

    public boolean type(String string) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            boolean bl;
            String string2 = stringTokenizer.nextToken();
            if (!("\n".equals(string2) ? !(bl = this.press(PhysicalButton.ENTER)) : !(bl = this.sendMonkeyEvent("type " + string2)))) continue;
            return false;
        }
        return true;
    }

    public boolean type(char c) throws IOException {
        return this.type(Character.toString(c));
    }

    public void wake() throws IOException {
        this.sendMonkeyEvent("wake");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> listViewIds() throws IOException {
        ChimpManager chimpManager = this;
        synchronized (chimpManager) {
            String string = this.sendMonkeyEventAndGetResponse("listviews");
            if (!this.parseResponseForSuccess(string)) {
                Collections.emptyList();
            }
            String string2 = this.parseResponseForExtra(string);
            return Lists.newArrayList((Object[])string2.split(" "));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryView(String string, List<String> list, String string2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder("queryview " + string + " ");
        for (String string3 : list) {
            stringBuilder.append(string3).append(" ");
        }
        stringBuilder.append(string2);
        ChimpManager chimpManager = this;
        synchronized (chimpManager) {
            String string3;
            string3 = this.sendMonkeyEventAndGetResponse(stringBuilder.toString());
            if (!this.parseResponseForSuccess(string3)) {
                throw new ChimpException(this.parseResponseForExtra(string3));
            }
            return this.parseResponseForExtra(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChimpView getRootView() throws IOException {
        ChimpManager chimpManager = this;
        synchronized (chimpManager) {
            String string = this.sendMonkeyEventAndGetResponse("getrootview");
            String string2 = this.parseResponseForExtra(string);
            List<String> list = Arrays.asList(string2.split(" "));
            if (!this.parseResponseForSuccess(string) || list.size() != 2) {
                throw new ChimpException(string2);
            }
            ChimpView chimpView = new ChimpView("accessibilityids", list);
            chimpView.setManager(this);
            return chimpView;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getViewsWithText(String string) throws IOException {
        ChimpManager chimpManager = this;
        synchronized (chimpManager) {
            String string2;
            if (string.split(" ").length > 1) {
                string = "\"" + string + "\"";
            }
            if (!this.parseResponseForSuccess(string2 = this.sendMonkeyEventAndGetResponse("getviewswithtext " + string))) {
                throw new ChimpException(this.parseResponseForExtra(string2));
            }
            return this.parseResponseForExtra(string2);
        }
    }
}

