/*
 * Decompiled with CFR 0.152.
 */
package com.android.chimpchat.adb;

import com.android.chimpchat.ChimpManager;
import com.android.chimpchat.adb.AdbChimpImage;
import com.android.chimpchat.adb.CommandOutputCapture;
import com.android.chimpchat.adb.LinearInterpolator;
import com.android.chimpchat.adb.LoggingOutputReceiver;
import com.android.chimpchat.core.IChimpDevice;
import com.android.chimpchat.core.IChimpImage;
import com.android.chimpchat.core.IChimpView;
import com.android.chimpchat.core.IMultiSelector;
import com.android.chimpchat.core.ISelector;
import com.android.chimpchat.core.PhysicalButton;
import com.android.chimpchat.core.TouchPressType;
import com.android.chimpchat.hierarchyviewer.HierarchyViewer;
import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdbChimpDevice
implements IChimpDevice {
    private static final Logger LOG = Logger.getLogger(AdbChimpDevice.class.getName());
    private static final String[] ZERO_LENGTH_STRING_ARRAY = new String[0];
    private static final long MANAGER_CREATE_TIMEOUT_MS = 30000L;
    private static final long MANAGER_CREATE_WAIT_TIME_MS = 1000L;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final IDevice device;
    private ChimpManager manager;

    public AdbChimpDevice(IDevice iDevice) {
        this.device = iDevice;
        this.manager = this.createManager("127.0.0.1", 12345);
        Preconditions.checkNotNull((Object)this.manager);
    }

    @Override
    public ChimpManager getManager() {
        return this.manager;
    }

    @Override
    public void dispose() {
        try {
            this.manager.quit();
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Error getting the manager to quit", iOException);
        }
        this.manager.close();
        this.executor.shutdown();
        this.manager = null;
    }

    @Override
    public HierarchyViewer getHierarchyViewer() {
        return new HierarchyViewer(this.device);
    }

    private void executeAsyncCommand(final String string, final LoggingOutputReceiver loggingOutputReceiver) {
        this.executor.submit(new Runnable(){

            public void run() {
                try {
                    AdbChimpDevice.this.device.executeShellCommand(string, (IShellOutputReceiver)loggingOutputReceiver);
                }
                catch (TimeoutException timeoutException) {
                    LOG.log(Level.SEVERE, "Error starting command: " + string, timeoutException);
                    throw new RuntimeException(timeoutException);
                }
                catch (AdbCommandRejectedException adbCommandRejectedException) {
                    LOG.log(Level.SEVERE, "Error starting command: " + string, adbCommandRejectedException);
                    throw new RuntimeException(adbCommandRejectedException);
                }
                catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
                    LOG.log(Level.INFO, "Error starting command: " + string, shellCommandUnresponsiveException);
                    throw new RuntimeException(shellCommandUnresponsiveException);
                }
                catch (IOException iOException) {
                    LOG.log(Level.SEVERE, "Error starting command: " + string, iOException);
                    throw new RuntimeException(iOException);
                }
            }
        });
    }

    private ChimpManager createManager(String string, int n) {
        InetAddress inetAddress;
        try {
            this.device.createForward(n, n);
        }
        catch (TimeoutException timeoutException) {
            LOG.log(Level.SEVERE, "Timeout creating adb port forwarding", timeoutException);
            return null;
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            LOG.log(Level.SEVERE, "Adb rejected adb port forwarding command: " + adbCommandRejectedException.getMessage(), adbCommandRejectedException);
            return null;
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Unable to create adb port forwarding: " + iOException.getMessage(), iOException);
            return null;
        }
        String string2 = "monkey --port " + n;
        this.executeAsyncCommand(string2, new LoggingOutputReceiver(LOG, Level.FINE));
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            LOG.log(Level.SEVERE, "Unable to sleep", interruptedException);
        }
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            LOG.log(Level.SEVERE, "Unable to convert address into InetAddress: " + string, unknownHostException);
            return null;
        }
        boolean bl = false;
        ChimpManager chimpManager = null;
        long l = System.currentTimeMillis();
        while (!bl) {
            Socket socket;
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (l3 > 30000L) {
                LOG.severe("Timeout while trying to create chimp mananger");
                return null;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.SEVERE, "Unable to sleep", interruptedException);
            }
            try {
                socket = new Socket(inetAddress, n);
            }
            catch (IOException iOException) {
                LOG.log(Level.FINE, "Unable to connect socket", iOException);
                bl = false;
                continue;
            }
            try {
                chimpManager = new ChimpManager(socket);
            }
            catch (IOException iOException) {
                LOG.log(Level.SEVERE, "Unable to open writer and reader to socket");
                continue;
            }
            try {
                chimpManager.wake();
            }
            catch (IOException iOException) {
                LOG.log(Level.FINE, "Unable to wake up device", iOException);
                bl = false;
                continue;
            }
            bl = true;
        }
        return chimpManager;
    }

    @Override
    public IChimpImage takeSnapshot() {
        try {
            return new AdbChimpImage(this.device.getScreenshot());
        }
        catch (TimeoutException timeoutException) {
            LOG.log(Level.SEVERE, "Unable to take snapshot", timeoutException);
            return null;
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            LOG.log(Level.SEVERE, "Unable to take snapshot", adbCommandRejectedException);
            return null;
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Unable to take snapshot", iOException);
            return null;
        }
    }

    @Override
    public String getSystemProperty(String string) {
        return this.device.getProperty(string);
    }

    @Override
    public String getProperty(String string) {
        try {
            return this.manager.getVariable(string);
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Unable to get variable: " + string, iOException);
            return null;
        }
    }

    @Override
    public Collection<String> getPropertyList() {
        try {
            return this.manager.listVariable();
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Unable to get variable list", iOException);
            return null;
        }
    }

    @Override
    public void wake() {
        try {
            this.manager.wake();
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Unable to wake device (too sleepy?)", iOException);
        }
    }

    private String shell(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string).append(" ");
        }
        return this.shell(stringBuilder.toString());
    }

    @Override
    public String shell(String string) {
        CommandOutputCapture commandOutputCapture = new CommandOutputCapture();
        try {
            this.device.executeShellCommand(string, (IShellOutputReceiver)commandOutputCapture);
        }
        catch (TimeoutException timeoutException) {
            LOG.log(Level.SEVERE, "Error executing command: " + string, timeoutException);
            return null;
        }
        catch (ShellCommandUnresponsiveException shellCommandUnresponsiveException) {
            LOG.log(Level.SEVERE, "Error executing command: " + string, shellCommandUnresponsiveException);
            return null;
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            LOG.log(Level.SEVERE, "Error executing command: " + string, adbCommandRejectedException);
            return null;
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Error executing command: " + string, iOException);
            return null;
        }
        return commandOutputCapture.toString();
    }

    @Override
    public boolean installPackage(String string) {
        try {
            String string2 = this.device.installPackage(string, true, new String[0]);
            if (string2 != null) {
                LOG.log(Level.SEVERE, "Got error installing package: " + string2);
                return false;
            }
            return true;
        }
        catch (InstallException installException) {
            LOG.log(Level.SEVERE, "Error installing package: " + string, installException);
            return false;
        }
    }

    @Override
    public boolean removePackage(String string) {
        try {
            String string2 = this.device.uninstallPackage(string);
            if (string2 != null) {
                LOG.log(Level.SEVERE, "Got error uninstalling package " + string + ": " + string2);
                return false;
            }
            return true;
        }
        catch (InstallException installException) {
            LOG.log(Level.SEVERE, "Error installing package: " + string, installException);
            return false;
        }
    }

    @Override
    public void press(String string, TouchPressType touchPressType) {
        try {
            switch (touchPressType) {
                case DOWN_AND_UP: {
                    this.manager.press(string);
                    break;
                }
                case DOWN: {
                    this.manager.keyDown(string);
                    break;
                }
                case UP: {
                    this.manager.keyUp(string);
                }
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Error sending press event: " + string + " " + (Object)((Object)touchPressType), iOException);
        }
    }

    @Override
    public void press(PhysicalButton physicalButton, TouchPressType touchPressType) {
        this.press(physicalButton.getKeyName(), touchPressType);
    }

    @Override
    public void type(String string) {
        try {
            this.manager.type(string);
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Error Typing: " + string, iOException);
        }
    }

    @Override
    public void touch(int n, int n2, TouchPressType touchPressType) {
        try {
            switch (touchPressType) {
                case DOWN: {
                    this.manager.touchDown(n, n2);
                    break;
                }
                case UP: {
                    this.manager.touchUp(n, n2);
                    break;
                }
                case DOWN_AND_UP: {
                    this.manager.tap(n, n2);
                }
            }
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Error sending touch event: " + n + " " + n2 + " " + (Object)((Object)touchPressType), iOException);
        }
    }

    @Override
    public void reboot(String string) {
        try {
            this.device.reboot(string);
        }
        catch (TimeoutException timeoutException) {
            LOG.log(Level.SEVERE, "Unable to reboot device", timeoutException);
        }
        catch (AdbCommandRejectedException adbCommandRejectedException) {
            LOG.log(Level.SEVERE, "Unable to reboot device", adbCommandRejectedException);
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Unable to reboot device", iOException);
        }
    }

    @Override
    public void startActivity(String string, String string2, String string3, String string4, Collection<String> collection, Map<String, Object> map, String string5, int n) {
        List<String> list = this.buildIntentArgString(string, string2, string3, string4, collection, map, string5, n);
        this.shell(Lists.asList((Object)"am", (Object)"start", (Object[])list.toArray(ZERO_LENGTH_STRING_ARRAY)).toArray(ZERO_LENGTH_STRING_ARRAY));
    }

    @Override
    public void broadcastIntent(String string, String string2, String string3, String string4, Collection<String> collection, Map<String, Object> map, String string5, int n) {
        List<String> list = this.buildIntentArgString(string, string2, string3, string4, collection, map, string5, n);
        this.shell(Lists.asList((Object)"am", (Object)"broadcast", (Object[])list.toArray(ZERO_LENGTH_STRING_ARRAY)).toArray(ZERO_LENGTH_STRING_ARRAY));
    }

    private static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.length() == 0;
    }

    private List<String> buildIntentArgString(String string, String string2, String string3, String string4, Collection<String> collection, Map<String, Object> map, String string5, int n) {
        ArrayList arrayList = Lists.newArrayList();
        if (!AdbChimpDevice.isNullOrEmpty(string2)) {
            arrayList.add("-a");
            arrayList.add(string2);
        }
        if (!AdbChimpDevice.isNullOrEmpty(string3)) {
            arrayList.add("-d");
            arrayList.add(string3);
        }
        if (!AdbChimpDevice.isNullOrEmpty(string4)) {
            arrayList.add("-t");
            arrayList.add(string4);
        }
        for (String object : collection) {
            arrayList.add("-c");
            arrayList.add(object);
        }
        for (Map.Entry entry : map.entrySet()) {
            String string6;
            String string7;
            Object v = entry.getValue();
            if (v instanceof Integer) {
                string7 = Integer.toString((Integer)v);
                string6 = "--ei";
            } else if (v instanceof Boolean) {
                string7 = Boolean.toString((Boolean)v);
                string6 = "--ez";
            } else {
                string7 = v.toString();
                string6 = "--es";
            }
            arrayList.add(string6);
            arrayList.add(entry.getKey());
            arrayList.add(string7);
        }
        if (!AdbChimpDevice.isNullOrEmpty(string5)) {
            arrayList.add("-n");
            arrayList.add(string5);
        }
        if (n != 0) {
            arrayList.add("-f");
            arrayList.add(Integer.toString(n));
        }
        if (!AdbChimpDevice.isNullOrEmpty(string)) {
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public Map<String, Object> instrument(String string, Map<String, Object> map) {
        ArrayList arrayList = Lists.newArrayList((Object[])new String[]{"am", "instrument", "-w", "-r", string});
        String string2 = this.shell(arrayList.toArray(ZERO_LENGTH_STRING_ARRAY));
        return AdbChimpDevice.convertInstrumentResult(string2);
    }

    @VisibleForTesting
    static Map<String, Object> convertInstrumentResult(String string) {
        String string2;
        String string3;
        int n;
        String string4;
        HashMap hashMap = Maps.newHashMap();
        Pattern pattern = Pattern.compile("^INSTRUMENTATION_(\\w+): ", 8);
        Matcher matcher = pattern.matcher(string);
        int n2 = 0;
        String string5 = null;
        while (matcher.find()) {
            if ("RESULT".equals(string5)) {
                string4 = string.substring(n2, matcher.start()).trim();
                n = string4.indexOf("=");
                string3 = string4.substring(0, n);
                string2 = string4.substring(n + 1);
                hashMap.put(string3, string2);
            }
            n2 = matcher.end();
            string5 = matcher.group(1);
        }
        if ("RESULT".equals(string5)) {
            string4 = string.substring(n2, matcher.start()).trim();
            n = string4.indexOf("=");
            string3 = string4.substring(0, n);
            string2 = string4.substring(n + 1);
            hashMap.put(string3, string2);
        }
        return hashMap;
    }

    @Override
    public void drag(int n, int n2, int n3, int n4, int n5, long l) {
        final long l2 = l / (long)n5;
        LinearInterpolator linearInterpolator = new LinearInterpolator(n5);
        LinearInterpolator.Point point = new LinearInterpolator.Point(n, n2);
        LinearInterpolator.Point point2 = new LinearInterpolator.Point(n3, n4);
        linearInterpolator.interpolate(point, point2, new LinearInterpolator.Callback(){

            public void step(LinearInterpolator.Point point) {
                try {
                    AdbChimpDevice.this.manager.touchMove(point.getX(), point.getY());
                }
                catch (IOException iOException) {
                    LOG.log(Level.SEVERE, "Error sending drag start event", iOException);
                }
                try {
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedException) {
                    LOG.log(Level.SEVERE, "Error sleeping", interruptedException);
                }
            }

            public void start(LinearInterpolator.Point point) {
                try {
                    AdbChimpDevice.this.manager.touchDown(point.getX(), point.getY());
                    AdbChimpDevice.this.manager.touchMove(point.getX(), point.getY());
                }
                catch (IOException iOException) {
                    LOG.log(Level.SEVERE, "Error sending drag start event", iOException);
                }
                try {
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedException) {
                    LOG.log(Level.SEVERE, "Error sleeping", interruptedException);
                }
            }

            public void end(LinearInterpolator.Point point) {
                try {
                    AdbChimpDevice.this.manager.touchMove(point.getX(), point.getY());
                    AdbChimpDevice.this.manager.touchUp(point.getX(), point.getY());
                }
                catch (IOException iOException) {
                    LOG.log(Level.SEVERE, "Error sending drag end event", iOException);
                }
            }
        });
    }

    @Override
    public Collection<String> getViewIdList() {
        try {
            return this.manager.listViewIds();
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Error retrieving view IDs", iOException);
            return new ArrayList<String>();
        }
    }

    @Override
    public IChimpView getView(ISelector iSelector) {
        return iSelector.getView(this.manager);
    }

    @Override
    public Collection<IChimpView> getViews(IMultiSelector iMultiSelector) {
        return iMultiSelector.getViews(this.manager);
    }

    @Override
    public IChimpView getRootView() {
        try {
            return this.manager.getRootView();
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Error retrieving root view");
            return null;
        }
    }
}

