/*
 * Decompiled with CFR 0.152.
 */
package com.android.chimpchat.core;

import com.android.chimpchat.ChimpManager;
import com.android.chimpchat.core.ChimpView;
import com.android.chimpchat.core.IChimpView;
import com.android.chimpchat.core.IMultiSelector;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiSelectorText
implements IMultiSelector {
    private static final Logger LOG = Logger.getLogger(ChimpView.class.getName());
    private String text;

    public MultiSelectorText(String string) {
        this.text = string;
    }

    @Override
    public Collection<IChimpView> getViews(ChimpManager chimpManager) {
        List<String> list;
        String string;
        try {
            string = chimpManager.getViewsWithText(this.text);
            list = Arrays.asList(string.split(" "));
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Error communicating with device: " + iOException.getMessage());
            return new ArrayList<IChimpView>();
        }
        if (list.size() % 2 == 0) {
            ArrayList<IChimpView> arrayList = new ArrayList<IChimpView>();
            for (int i = 0; i < list.size() / 2; ++i) {
                ArrayList arrayList2 = Lists.newArrayList((Object[])new String[]{list.get(2 * i), list.get(2 * i + 1)});
                ChimpView chimpView = new ChimpView("accessibilityids", arrayList2);
                chimpView.setManager(chimpManager);
                arrayList.add(chimpView);
            }
            return arrayList;
        }
        LOG.log(Level.SEVERE, "Error retrieving views: " + string);
        return Collections.emptyList();
    }
}

