/*
 * Decompiled with CFR 0.152.
 */
package com.android.menubar;

import com.android.menubar.IMenuBarCallback;
import com.android.menubar.IMenuBarEnhancer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public final class MenuBarEnhancer {
    private MenuBarEnhancer() {
    }

    public static IMenuBarEnhancer setupMenu(String string, final Menu menu, IMenuBarCallback iMenuBarCallback) {
        IMenuBarEnhancer iMenuBarEnhancer = MenuBarEnhancer.getEnhancer(iMenuBarCallback);
        if (iMenuBarEnhancer == null) {
            iMenuBarEnhancer = new IMenuBarEnhancer(){

                public IMenuBarEnhancer.MenuBarMode getMenuBarMode() {
                    return IMenuBarEnhancer.MenuBarMode.GENERIC;
                }

                public void setupMenu(String string, Display display, final IMenuBarCallback iMenuBarCallback) {
                    if (menu.getItemCount() > 0) {
                        new MenuItem(menu, 2);
                    }
                    final MenuItem menuItem = new MenuItem(menu, 0);
                    menuItem.setText("&Options...");
                    final MenuItem menuItem2 = new MenuItem(menu, 0);
                    menuItem2.setText("&About...");
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void widgetSelected(SelectionEvent selectionEvent) {
                            try {
                                menuItem.setEnabled(false);
                                iMenuBarCallback.onPreferencesMenuSelected();
                                super.widgetSelected(selectionEvent);
                            }
                            finally {
                                menuItem.setEnabled(true);
                            }
                        }
                    });
                    menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void widgetSelected(SelectionEvent selectionEvent) {
                            try {
                                menuItem2.setEnabled(false);
                                iMenuBarCallback.onAboutMenuSelected();
                                super.widgetSelected(selectionEvent);
                            }
                            finally {
                                menuItem2.setEnabled(true);
                            }
                        }
                    });
                }
            };
        }
        iMenuBarEnhancer.setupMenu(string, menu.getDisplay(), iMenuBarCallback);
        return iMenuBarEnhancer;
    }

    public static IMenuBarEnhancer setupMenuManager(String string, Display display, final IMenuManager iMenuManager, final IAction iAction, final IAction iAction2, final IAction iAction3) {
        IMenuBarCallback iMenuBarCallback = new IMenuBarCallback(){

            public void printError(String string, Object ... objectArray) {
                System.err.println(String.format(string, objectArray));
            }

            public void onPreferencesMenuSelected() {
                if (iAction2 != null) {
                    iAction2.run();
                }
            }

            public void onAboutMenuSelected() {
                if (iAction != null) {
                    iAction.run();
                }
            }
        };
        IMenuBarEnhancer iMenuBarEnhancer = MenuBarEnhancer.getEnhancer(iMenuBarCallback);
        if (iMenuBarEnhancer == null) {
            iMenuBarEnhancer = new IMenuBarEnhancer(){

                public IMenuBarEnhancer.MenuBarMode getMenuBarMode() {
                    return IMenuBarEnhancer.MenuBarMode.GENERIC;
                }

                public void setupMenu(String string, Display display, IMenuBarCallback iMenuBarCallback) {
                    if (!iMenuManager.isEmpty()) {
                        iMenuManager.add((IContributionItem)new Separator());
                    }
                    if (iAction != null) {
                        iMenuManager.add(iAction);
                    }
                    if (iAction2 != null) {
                        iMenuManager.add(iAction2);
                    }
                    if (iAction3 != null) {
                        if (iAction != null || iAction2 != null) {
                            iMenuManager.add((IContributionItem)new Separator());
                        }
                        iMenuManager.add(iAction3);
                    }
                }
            };
        }
        iMenuBarEnhancer.setupMenu(string, display, iMenuBarCallback);
        return iMenuBarEnhancer;
    }

    private static IMenuBarEnhancer getEnhancer(IMenuBarCallback iMenuBarCallback) {
        IMenuBarEnhancer iMenuBarEnhancer = null;
        String string = SWT.getPlatform();
        String string2 = null;
        if ("carbon".equals(string)) {
            string2 = "com.android.menubar.internal.MenuBarEnhancerCarbon";
        } else if ("cocoa".equals(string)) {
            string2 = "com.android.menubar.internal.MenuBarEnhancerCocoa";
        }
        if (System.getenv("DEBUG_SWTMENUBAR") != null) {
            iMenuBarCallback.printError("DEBUG SwtMenuBar: SWT=%1$s, class=%2$s", string, string2);
        }
        if (string2 != null) {
            try {
                Class<?> clazz = Class.forName(string2);
                iMenuBarEnhancer = (IMenuBarEnhancer)clazz.newInstance();
            }
            catch (Exception exception) {
                iMenuBarCallback.printError("Failed to instantiate %1$s: %2$s", string2, exception.toString());
            }
        }
        return iMenuBarEnhancer;
    }
}

