/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.InputPath;
import com.android.ant.SingleDependencyTask;
import com.android.ant.TaskHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Path;

public final class AaptExecTask
extends SingleDependencyTask {
    private String mExecutable;
    private String mCommand;
    private boolean mForce = true;
    private boolean mDebug = false;
    private boolean mVerbose = false;
    private boolean mUseCrunchCache = false;
    private int mVersionCode = 0;
    private String mVersionName;
    private String mManifest;
    private String mManifestPackage;
    private ArrayList<Path> mResources;
    private String mAssets;
    private String mAndroidJar;
    private String mApkFolder;
    private String mApkName;
    private String mResourceFilter;
    private String mRFolder;
    private final ArrayList<NoCompress> mNoCompressList = new ArrayList();
    private String mProjectLibrariesResName;
    private String mProjectLibrariesPackageName;
    private boolean mNonConstantId;
    private static final SingleDependencyTask.InputPathFactory sPathFactory = new SingleDependencyTask.InputPathFactory(){

        @Override
        public InputPath createPath(File file, Set<String> set) {
            return new ResFolderInputPath(file, set);
        }
    };

    public void setExecutable(Path path) {
        this.mExecutable = TaskHelper.checkSinglePath("executable", path);
    }

    public void setCommand(String string) {
        this.mCommand = string;
    }

    public void setForce(boolean bl) {
        this.mForce = bl;
    }

    public void setVerbose(boolean bl) {
        this.mVerbose = bl;
    }

    public void setNoCrunch(boolean bl) {
        this.mUseCrunchCache = bl;
    }

    public void setNonConstantId(boolean bl) {
        this.mNonConstantId = bl;
    }

    public void setVersioncode(String string) {
        if (string.length() > 0) {
            try {
                this.mVersionCode = Integer.decode(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println(String.format("WARNING: Ignoring invalid version code value '%s'.", string));
            }
        }
    }

    public void setVersionname(String string) {
        this.mVersionName = string;
    }

    public void setDebug(boolean bl) {
        this.mDebug = bl;
    }

    public void setManifest(Path path) {
        this.mManifest = TaskHelper.checkSinglePath("manifest", path);
    }

    public void setManifestpackage(String string) {
        if (string != null && string.length() != 0) {
            this.mManifestPackage = string;
        }
    }

    @Deprecated
    public void setResources(Path path) {
        System.out.println("WARNNG: Using deprecated 'resources' attribute in AaptExecLoopTask.Use nested element(s) <res path=\"value\" /> instead.");
        if (this.mResources == null) {
            this.mResources = new ArrayList();
        }
        this.mResources.add(new Path(this.getProject(), path.toString()));
    }

    public void setAssets(Path path) {
        this.mAssets = TaskHelper.checkSinglePath("assets", path);
    }

    public void setAndroidjar(Path path) {
        this.mAndroidJar = TaskHelper.checkSinglePath("androidjar", path);
    }

    @Deprecated
    public void setOutfolder(Path path) {
        System.out.println("WARNNG: Using deprecated 'outfolder' attribute in AaptExecLoopTask.Use 'apkfolder' (path) instead.");
        this.mApkFolder = TaskHelper.checkSinglePath("outfolder", path);
    }

    public void setApkfolder(Path path) {
        this.mApkFolder = TaskHelper.checkSinglePath("apkfolder", path);
    }

    public void setResourcefilename(String string) {
        this.mApkName = string;
    }

    public void setRfolder(Path path) {
        this.mRFolder = TaskHelper.checkSinglePath("rfolder", path);
    }

    public void setresourcefilter(String string) {
        if (string != null && string.length() > 0) {
            this.mResourceFilter = string;
        }
    }

    public void setProjectLibrariesResName(String string) {
        this.mProjectLibrariesResName = string;
    }

    public void setProjectLibrariesPackageName(String string) {
        this.mProjectLibrariesPackageName = string;
    }

    public Object createNocompress() {
        NoCompress noCompress = new NoCompress();
        this.mNoCompressList.add(noCompress);
        return noCompress;
    }

    public Object createRes() {
        if (this.mResources == null) {
            this.mResources = new ArrayList();
        }
        Path path = new Path(this.getProject());
        this.mResources.add(path);
        return path;
    }

    public void execute() throws BuildException {
        if (this.mProjectLibrariesResName == null) {
            throw new BuildException("Missing attribute projectLibrariesResName");
        }
        if (this.mProjectLibrariesPackageName == null) {
            throw new BuildException("Missing attribute projectLibrariesPackageName");
        }
        Project project = this.getProject();
        String string = null;
        if (!this.mNonConstantId && this.mRFolder != null && new File(this.mRFolder).isDirectory() && (string = project.getProperty(this.mProjectLibrariesPackageName)) != null) {
            string = string.replace(';', ':');
        }
        this.callAapt(string);
    }

    protected String getExecTaskName() {
        return "aapt";
    }

    /*
     * WARNING - void declaration
     */
    private void callAapt(String string) {
        void var8_24;
        Object object;
        Project project = this.getProject();
        boolean bl = this.mRFolder != null && new File(this.mRFolder).isDirectory();
        Object object2 = project.getReference(this.mProjectLibrariesResName);
        ArrayList<File> arrayList = new ArrayList<File>();
        for (Path path : this.mResources) {
            for (String string2 : path.list()) {
                arrayList.add(new File(string2));
            }
        }
        if (object2 instanceof Path) {
            void object3;
            object = ((Path)object2).list();
            int n = ((String[])object).length;
            boolean bl2 = false;
            while (object3 < n) {
                String string3 = object[object3];
                arrayList.add(new File(string3));
                ++object3;
            }
        }
        if (bl) {
            object = AaptExecTask.getInputPaths(arrayList, Collections.singleton("xml"), sPathFactory);
            if (this.mManifest != null) {
                object.add(new InputPath(new File(this.mManifest)));
            }
            if (this.initDependencies(this.mRFolder + File.separator + "R.java.d", (List<InputPath>)object) && !this.dependenciesHaveChanged()) {
                System.out.println("No changed resources. R.java and Manifest.java untouched.");
                return;
            }
            System.out.println("Generating resource IDs...");
        } else {
            File file;
            object = AaptExecTask.getInputPaths(arrayList, null, sPathFactory);
            if (this.mManifest != null) {
                object.add(new InputPath(new File(this.mManifest)));
            }
            if (this.mAssets != null && (file = new File(this.mAssets)).isDirectory()) {
                object.add(new InputPath(file));
            }
            String string4 = this.mApkFolder + File.separator + this.mApkName;
            if (this.initDependencies(string4 = string4 + ".d", (List<InputPath>)object) && !this.dependenciesHaveChanged()) {
                System.out.println("No changed resources or assets. " + this.mApkName + " remains untouched");
                return;
            }
            if (this.mResourceFilter == null) {
                System.out.println("Creating full resource package...");
            } else {
                System.out.println(String.format("Creating resource package with filter: (%1$s)...", this.mResourceFilter));
            }
        }
        object = new ExecTask();
        object.setExecutable(this.mExecutable);
        object.setFailonerror(true);
        object.setTaskName(this.getExecTaskName());
        object.createArg().setValue(this.mCommand);
        if (this.mUseCrunchCache) {
            object.createArg().setValue("--no-crunch");
        }
        if (this.mNonConstantId) {
            object.createArg().setValue("--non-constant-id");
        }
        if (this.mForce) {
            object.createArg().setValue("-f");
        }
        if (this.mVerbose) {
            object.createArg().setValue("-v");
        }
        if (this.mDebug) {
            object.createArg().setValue("--debug-mode");
        }
        if (bl) {
            object.createArg().setValue("-m");
        }
        if (this.mResourceFilter != null && this.mResourceFilter.length() > 0) {
            object.createArg().setValue("-c");
            object.createArg().setValue(this.mResourceFilter);
        }
        boolean bl2 = false;
        for (NoCompress noCompress : this.mNoCompressList) {
            if (noCompress.mExtension != null) continue;
            object.createArg().setValue("-0");
            object.createArg().setValue("");
            bl2 = true;
            break;
        }
        if (!bl2) {
            for (NoCompress noCompress : this.mNoCompressList) {
                object.createArg().setValue("-0");
                object.createArg().setValue(noCompress.mExtension);
            }
        }
        if (!this.mNonConstantId && string != null && string.length() > 0) {
            object.createArg().setValue("--extra-packages");
            object.createArg().setValue(string);
        }
        if (object2 != null) {
            object.createArg().setValue("--auto-add-overlay");
        }
        if (this.mVersionCode != 0) {
            object.createArg().setValue("--version-code");
            object.createArg().setValue(Integer.toString(this.mVersionCode));
        }
        if (this.mVersionName != null && this.mVersionName.length() > 0) {
            object.createArg().setValue("--version-name");
            object.createArg().setValue(this.mVersionName);
        }
        if (this.mManifest != null && this.mManifest.length() > 0) {
            object.createArg().setValue("-M");
            object.createArg().setValue(this.mManifest);
        }
        if (this.mManifestPackage != null) {
            object.createArg().setValue("--rename-manifest-package");
            object.createArg().setValue(this.mManifestPackage);
        }
        if (this.mResources.size() > 0) {
            for (Path path : this.mResources) {
                for (String string4 : path.list()) {
                    File file = new File(string4);
                    if (!file.isDirectory()) continue;
                    object.createArg().setValue("-S");
                    object.createArg().setValue(string4);
                }
            }
        }
        if (object2 instanceof Path) {
            for (String string5 : ((Path)object2).list()) {
                File file = new File(string5);
                if (!file.isDirectory()) continue;
                object.createArg().setValue("-S");
                object.createArg().setValue(string5);
            }
        }
        if (this.mAssets != null && new File(this.mAssets).isDirectory()) {
            object.createArg().setValue("-A");
            object.createArg().setValue(this.mAssets);
        }
        if (this.mAndroidJar != null) {
            object.createArg().setValue("-I");
            object.createArg().setValue(this.mAndroidJar);
        }
        Object var8_22 = null;
        if (this.mApkName != null) {
            String string6 = this.mApkName;
        }
        if (var8_24 != null) {
            File file = new File(this.mApkFolder, (String)var8_24);
            object.createArg().setValue("-F");
            object.createArg().setValue(file.getAbsolutePath());
        }
        if (bl) {
            object.createArg().setValue("-J");
            object.createArg().setValue(this.mRFolder);
        }
        object.createArg().setValue("--generate-dependencies");
        object.setProject(project);
        object.setOwningTarget(this.getOwningTarget());
        object.execute();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResFolderInputPath
    extends InputPath {
        public ResFolderInputPath(File file, Set<String> set) {
            super(file, set);
        }

        @Override
        public boolean ignores(File file) {
            String string = file.getName();
            char c = string.charAt(0);
            if (c == '.' || c == '_' && file.isDirectory() || string.charAt(string.length() - 1) == '~') {
                return true;
            }
            if ("CVS".equals(string) || "thumbs.db".equalsIgnoreCase(string) || "picasa.ini".equalsIgnoreCase(string)) {
                return true;
            }
            String string2 = ResFolderInputPath.getExtension(string);
            return "scc".equalsIgnoreCase(string2);
        }
    }

    public static final class NoCompress {
        String mExtension;

        public void setExtension(String string) {
            this.mExtension = string;
        }
    }
}

