/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.MultiFilesTask;
import com.android.ant.TaskHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Path;

public class AidlExecTask
extends MultiFilesTask {
    private String mExecutable;
    private String mFramework;
    private String mGenFolder;
    private final ArrayList<Path> mPaths = new ArrayList();

    public void setExecutable(Path path) {
        this.mExecutable = TaskHelper.checkSinglePath("executable", path);
    }

    public void setFramework(Path path) {
        this.mFramework = TaskHelper.checkSinglePath("framework", path);
    }

    public void setGenFolder(Path path) {
        this.mGenFolder = TaskHelper.checkSinglePath("genFolder", path);
    }

    public Path createSource() {
        Path path = new Path(this.getProject());
        this.mPaths.add(path);
        return path;
    }

    public void execute() throws BuildException {
        if (this.mExecutable == null) {
            throw new BuildException("AidlExecTask's 'executable' is required.");
        }
        if (this.mFramework == null) {
            throw new BuildException("AidlExecTask's 'framework' is required.");
        }
        if (this.mGenFolder == null) {
            throw new BuildException("AidlExecTask's 'genFolder' is required.");
        }
        this.processFiles(new AidlProcessor(), this.mPaths, this.mGenFolder);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AidlProcessor
    implements MultiFilesTask.SourceProcessor {
        private AidlProcessor() {
        }

        @Override
        public String getSourceFileExtension() {
            return "aidl";
        }

        @Override
        public void process(String string, String string2, List<String> list, Project project) {
            ExecTask execTask = new ExecTask();
            execTask.setProject(project);
            execTask.setOwningTarget(AidlExecTask.this.getOwningTarget());
            execTask.setExecutable(AidlExecTask.this.mExecutable);
            execTask.setTaskName("aidl");
            execTask.setFailonerror(true);
            execTask.createArg().setValue("-p" + AidlExecTask.this.mFramework);
            execTask.createArg().setValue("-o" + AidlExecTask.this.mGenFolder);
            for (String string3 : list) {
                execTask.createArg().setValue("-I" + string3);
            }
            execTask.createArg().setValue("-a");
            execTask.createArg().setValue(string);
            execTask.execute();
        }

        @Override
        public void displayMessage(MultiFilesTask.DisplayType displayType, int n) {
            switch (displayType) {
                case FOUND: {
                    System.out.println(String.format("Found %1$d AIDL files.", n));
                    break;
                }
                case COMPILING: {
                    if (n > 0) {
                        System.out.println(String.format("Compiling %1$d AIDL files.", n));
                        break;
                    }
                    System.out.println("No AIDL files to compile.");
                    break;
                }
                case REMOVE_OUTPUT: {
                    System.out.println(String.format("Found %1$d obsolete output files to remove.", n));
                    break;
                }
                case REMOVE_DEP: {
                    System.out.println(String.format("Found %1$d obsolete dependency files to remove.", n));
                }
            }
        }
    }
}

