/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.InputPath;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyGraph {
    private static final boolean DEBUG = false;
    private Set<File> mTargets = Collections.emptySet();
    private Set<File> mPrereqs = this.mTargets;
    private File mFirstPrereq = null;
    private boolean mMissingDepFile = false;
    private long mDepFileLastModified;
    private final List<InputPath> mNewInputs;

    public DependencyGraph(String string, List<InputPath> list) {
        this.mNewInputs = list;
        this.parseDependencyFile(string);
    }

    public boolean dependenciesHaveChanged(boolean bl) {
        if (this.mMissingDepFile) {
            System.out.println("No Dependency File Found");
            return true;
        }
        if (this.missingTargetFile()) {
            if (bl) {
                System.out.println("Found Deleted Target File");
            }
            return true;
        }
        long l = this.getOutputLastModified();
        DependencyStatus dependencyStatus = this.checkInputs(l);
        switch (dependencyStatus) {
            case ERROR: {
                throw new BuildException();
            }
            case NEW_FILE: {
                if (bl) {
                    System.out.println("Found new input file");
                }
                return true;
            }
            case UPDATED_FILE: {
                if (bl) {
                    System.out.println("Found modified input file");
                }
                return true;
            }
        }
        dependencyStatus = this.checkPrereqFiles(l);
        switch (dependencyStatus) {
            case ERROR: {
                throw new BuildException();
            }
            case MISSING_FILE: {
                if (bl) {
                    System.out.println("Found deleted input file");
                }
                return true;
            }
            case UPDATED_FILE: {
                if (bl) {
                    System.out.println("Found modified input file");
                }
                return true;
            }
        }
        return false;
    }

    public Set<File> getTargets() {
        return Collections.unmodifiableSet(this.mTargets);
    }

    public File getFirstPrereq() {
        return this.mFirstPrereq;
    }

    /*
     * WARNING - void declaration
     */
    private void parseDependencyFile(String string) {
        File file = new File(string);
        if (!file.isFile()) {
            this.mMissingDepFile = true;
            return;
        }
        this.mDepFileLastModified = file.lastModified();
        String string2 = DependencyGraph.readFile(string);
        if (string2 == null) {
            System.err.println("ERROR: Couldn't read " + string);
            return;
        }
        String[] stringArray = string2.toString().split("\n");
        StringBuilder stringBuilder = new StringBuilder(string2.length());
        for (String string3 : stringArray) {
            void stringArray2;
            String string4 = string3.trim();
            if (string4.endsWith("\\")) {
                String string5 = string4.substring(0, string4.length() - 1);
            }
            stringBuilder.append((String)stringArray2);
        }
        String[] stringArray3 = stringBuilder.toString().split(":");
        String[] stringArray4 = stringArray3[0].trim().split(" ");
        String[] stringArray5 = new String[]{};
        if (stringArray3.length < 1) {
            System.err.println("Warning! Dependency file does not list any prerequisites after ':' ");
        } else {
            stringArray5 = stringArray3[1].trim().split(" ");
        }
        this.mTargets = new HashSet<File>(stringArray4.length);
        for (String string6 : stringArray4) {
            if (string6.length() <= 0) continue;
            this.mTargets.add(new File(string6));
        }
        this.mPrereqs = new HashSet<File>(stringArray5.length);
        for (String string6 : stringArray5) {
            if (string6.length() <= 0) continue;
            File file2 = new File(string6);
            if (this.mFirstPrereq == null) {
                this.mFirstPrereq = file2;
            }
            this.mPrereqs.add(file2);
        }
    }

    private DependencyStatus checkInputs(long l) {
        if (this.mNewInputs != null) {
            for (InputPath inputPath : this.mNewInputs) {
                DependencyStatus dependencyStatus;
                File file = inputPath.getFile();
                if (!(file.isDirectory() ? (dependencyStatus = this.checkInputFolder(file, inputPath, l)) != DependencyStatus.NONE : file.isFile() && (dependencyStatus = this.checkInputFile(file, inputPath, l)) != DependencyStatus.NONE)) continue;
                return dependencyStatus;
            }
        }
        return DependencyStatus.NONE;
    }

    private DependencyStatus checkInputFolder(File file, InputPath inputPath, long l) {
        if (inputPath.ignores(file)) {
            return DependencyStatus.NONE;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            System.err.println("ERROR " + file.toString() + " is not a dir or can't be read");
            return DependencyStatus.ERROR;
        }
        for (File file2 : fileArray) {
            DependencyStatus dependencyStatus;
            if (!(file2.isDirectory() ? (dependencyStatus = this.checkInputFolder(file2, inputPath, l)) != DependencyStatus.NONE : file2.isFile() && (dependencyStatus = this.checkInputFile(file2, inputPath, l)) != DependencyStatus.NONE)) continue;
            return dependencyStatus;
        }
        return DependencyStatus.NONE;
    }

    private DependencyStatus checkInputFile(File file, InputPath inputPath, long l) {
        if (inputPath.ignores(file)) {
            return DependencyStatus.NONE;
        }
        if (!this.mPrereqs.remove(file)) {
            return DependencyStatus.NEW_FILE;
        }
        if (inputPath.checksForModification(file) && file.lastModified() > l) {
            return DependencyStatus.UPDATED_FILE;
        }
        return DependencyStatus.NONE;
    }

    private DependencyStatus checkPrereqFiles(long l) {
        for (File file : this.mPrereqs) {
            if (!file.exists()) {
                return DependencyStatus.MISSING_FILE;
            }
            if (this.mNewInputs != null) {
                String string = file.getAbsolutePath();
                for (InputPath inputPath : this.mNewInputs) {
                    File file2 = inputPath.getFile();
                    if (!(file2.isDirectory() ? string.startsWith(file2.getAbsolutePath()) && inputPath.checksForModification(file) && file.lastModified() > l : file.equals(file2) && inputPath.checksForModification(file) && file.lastModified() > l)) continue;
                    return DependencyStatus.UPDATED_FILE;
                }
                continue;
            }
            if (file.lastModified() <= l) continue;
            return DependencyStatus.UPDATED_FILE;
        }
        return DependencyStatus.NONE;
    }

    private boolean missingTargetFile() {
        for (File file : this.mTargets) {
            if (file.exists()) continue;
            return true;
        }
        return false;
    }

    private long getOutputLastModified() {
        long l = Long.MAX_VALUE;
        if (this.mTargets.size() == 0) {
            l = this.mDepFileLastModified;
        } else {
            for (File file : this.mTargets) {
                if (file.lastModified() >= l) continue;
                l = file.lastModified();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readFile(String string) {
        block6: {
            String string2;
            FileInputStream fileInputStream = new FileInputStream(string);
            if (fileInputStream == null) break block6;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            try {
                String string3;
                StringBuilder stringBuilder = new StringBuilder(bufferedReader.readLine());
                while ((string3 = bufferedReader.readLine()) != null) {
                    stringBuilder.append('\n');
                    stringBuilder.append(string3);
                }
                string2 = stringBuilder.toString();
            }
            catch (Throwable throwable) {
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            bufferedReader.close();
            return string2;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DependencyStatus {
        NONE,
        NEW_FILE,
        UPDATED_FILE,
        MISSING_FILE,
        ERROR;

    }
}

