/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.InputPath;
import com.android.ant.SingleDependencyTask;
import com.android.ant.TaskHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.resources.FileResource;

public class DexExecTask
extends SingleDependencyTask {
    private String mExecutable;
    private String mOutput;
    private boolean mVerbose = false;
    private boolean mNoLocals = false;
    private List<Path> mPathInputs;
    private List<FileSet> mFileSetInputs;

    public void setExecutable(Path path) {
        this.mExecutable = TaskHelper.checkSinglePath("executable", path);
    }

    public void setVerbose(boolean bl) {
        this.mVerbose = bl;
    }

    public void setOutput(Path path) {
        this.mOutput = TaskHelper.checkSinglePath("output", path);
    }

    public void setNoLocals(boolean bl) {
        this.mNoLocals = bl;
    }

    public Object createPath() {
        if (this.mPathInputs == null) {
            this.mPathInputs = new ArrayList<Path>();
        }
        Path path = new Path(this.getProject());
        this.mPathInputs.add(path);
        return path;
    }

    public Object createFileSet() {
        if (this.mFileSetInputs == null) {
            this.mFileSetInputs = new ArrayList<FileSet>();
        }
        FileSet fileSet = new FileSet();
        fileSet.setProject(this.getProject());
        this.mFileSetInputs.add(fileSet);
        return fileSet;
    }

    public void execute() throws BuildException {
        Object object;
        Object object2;
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.mPathInputs != null) {
            object2 = this.mPathInputs.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                for (String object3 : object.list()) {
                    arrayList.add(new File(object3));
                }
            }
        }
        if (this.mFileSetInputs != null) {
            object2 = this.mFileSetInputs.iterator();
            while (object2.hasNext()) {
                object = (FileSet)object2.next();
                for (FileResource fileResource : object) {
                    arrayList.add(fileResource.getFile());
                }
            }
        }
        if (this.initDependencies((String)(object2 = this.mOutput + ".d"), (List<InputPath>)(object = DexExecTask.getInputPaths(arrayList, null, null))) && !this.dependenciesHaveChanged()) {
            System.out.println("No new compiled code. No need to convert bytecode to dalvik format.");
            return;
        }
        System.out.println(String.format("Converting compiled files and external libraries into %1$s...", this.mOutput));
        ExecTask execTask = new ExecTask();
        execTask.setProject(this.getProject());
        execTask.setOwningTarget(this.getOwningTarget());
        execTask.setExecutable(this.mExecutable);
        execTask.setTaskName(this.getExecTaskName());
        execTask.setFailonerror(true);
        execTask.createArg().setValue("--dex");
        if (this.mNoLocals) {
            execTask.createArg().setValue("--no-locals");
        }
        if (this.mVerbose) {
            execTask.createArg().setValue("--verbose");
        }
        execTask.createArg().setValue("--output");
        execTask.createArg().setValue(this.mOutput);
        for (File file : arrayList) {
            String string = file.getAbsolutePath();
            if (this.mVerbose) {
                System.out.println("Input: " + string);
            }
            execTask.createArg().setValue(string);
        }
        execTask.execute();
        this.generateDependencyFile((String)object2, (List<InputPath>)object, this.mOutput);
    }

    protected String getExecTaskName() {
        return "dx";
    }
}

