/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.TaskHelper;
import com.android.io.FileWrapper;
import com.android.io.FolderWrapper;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISdkLog;
import com.android.sdklib.SdkConstants;
import com.android.sdklib.SdkManager;
import com.android.sdklib.build.JarListSanitizer;
import com.android.sdklib.internal.project.ProjectProperties;
import com.android.sdklib.xml.AndroidManifest;
import com.android.sdklib.xml.AndroidXPathFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.DeweyDecimal;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewSetupTask
extends Task {
    private static final String ANT_MIN_VERSION = "1.8.0";
    private String mProjectTypeOut;
    private String mAndroidJarFileOut;
    private String mAndroidAidlFileOut;
    private String mRenderScriptExeOut;
    private String mRenderScriptIncludeDirOut;
    private String mBootclasspathrefOut;
    private String mProjectLibrariesRootOut;
    private String mProjectLibrariesResOut;
    private String mProjectLibrariesPackageOut;
    private String mProjectLibrariesJarsOut;
    private String mProjectLibrariesLibsOut;
    private String mTargetApiOut;
    private boolean mVerbose = false;

    public void setProjectTypeOut(String string) {
        this.mProjectTypeOut = string;
    }

    public void setAndroidJarFileOut(String string) {
        this.mAndroidJarFileOut = string;
    }

    public void setAndroidAidlFileOut(String string) {
        this.mAndroidAidlFileOut = string;
    }

    public void setRenderScriptExeOut(String string) {
        this.mRenderScriptExeOut = string;
    }

    public void setRenderScriptIncludeDirOut(String string) {
        this.mRenderScriptIncludeDirOut = string;
    }

    public void setBootclasspathrefOut(String string) {
        this.mBootclasspathrefOut = string;
    }

    public void setProjectLibrariesRootOut(String string) {
        this.mProjectLibrariesRootOut = string;
    }

    public void setProjectLibrariesResOut(String string) {
        this.mProjectLibrariesResOut = string;
    }

    public void setProjectLibrariesPackageOut(String string) {
        this.mProjectLibrariesPackageOut = string;
    }

    public void setProjectLibrariesJarsOut(String string) {
        this.mProjectLibrariesJarsOut = string;
    }

    public void setProjectLibrariesLibsOut(String string) {
        this.mProjectLibrariesLibsOut = string;
    }

    public void setTargetApiOut(String string) {
        this.mTargetApiOut = string;
    }

    public void setVerbose(boolean bl) {
        this.mVerbose = bl;
    }

    public void execute() throws BuildException {
        File file;
        int n;
        if (this.mProjectTypeOut == null) {
            throw new BuildException("Missing attribute projectTypeOut");
        }
        if (this.mAndroidJarFileOut == null) {
            throw new BuildException("Missing attribute androidJarFileOut");
        }
        if (this.mAndroidAidlFileOut == null) {
            throw new BuildException("Missing attribute androidAidlFileOut");
        }
        if (this.mRenderScriptExeOut == null) {
            throw new BuildException("Missing attribute renderScriptExeOut");
        }
        if (this.mRenderScriptIncludeDirOut == null) {
            throw new BuildException("Missing attribute renderScriptIncludeDirOut");
        }
        if (this.mBootclasspathrefOut == null) {
            throw new BuildException("Missing attribute bootclasspathrefOut");
        }
        if (this.mProjectLibrariesRootOut == null) {
            throw new BuildException("Missing attribute projectLibrariesRootOut");
        }
        if (this.mProjectLibrariesResOut == null) {
            throw new BuildException("Missing attribute projectLibrariesResOut");
        }
        if (this.mProjectLibrariesPackageOut == null) {
            throw new BuildException("Missing attribute projectLibrariesPackageOut");
        }
        if (this.mProjectLibrariesJarsOut == null) {
            throw new BuildException("Missing attribute projectLibrariesJarsOut");
        }
        if (this.mProjectLibrariesLibsOut == null) {
            throw new BuildException("Missing attribute projectLibrariesLibsOut");
        }
        if (this.mTargetApiOut == null) {
            throw new BuildException("Missing attribute targetApiOut");
        }
        DeweyDecimal deweyDecimal = new DeweyDecimal(ANT_MIN_VERSION);
        Project project = this.getProject();
        DeweyDecimal deweyDecimal2 = this.getVersion(project);
        if (deweyDecimal.isGreaterThan(deweyDecimal2)) {
            throw new BuildException("The Android Ant-based build system requires Ant 1.8.0 or later. Current version is " + deweyDecimal2);
        }
        File file2 = TaskHelper.getSdkLocation(project);
        String string = file2.getPath();
        if (string.length() > 0 && !string.endsWith(File.separator)) {
            string = string + File.separator;
        }
        if ((n = TaskHelper.getToolsRevision(file2)) != -1) {
            System.out.println("Android SDK Tools Revision " + n);
        }
        if (!(file = new File(file2, "platform-tools")).isDirectory()) {
            throw new BuildException(String.format("SDK Platform Tools component is missing. Please install it with the SDK Manager (%1$s%2$c%3$s)", "tools", Character.valueOf(File.separatorChar), SdkConstants.androidCmdName()));
        }
        String string2 = project.getProperty("target");
        boolean bl = false;
        if (project.getProperty("tested.project.dir") != null) {
            bl = true;
        }
        if (string2 == null) {
            throw new BuildException("Android Target is not set.");
        }
        final ArrayList arrayList = new ArrayList();
        SdkManager sdkManager = SdkManager.createManager(string, new ISdkLog(){

            public void error(Throwable throwable, String string, Object ... objectArray) {
                if (string != null) {
                    arrayList.add(String.format("Error: " + string, objectArray));
                }
                if (throwable != null) {
                    arrayList.add("Error: " + throwable.getMessage());
                }
            }

            public void printf(String string, Object ... objectArray) {
                arrayList.add(String.format(string, objectArray));
            }

            public void warning(String string, Object ... objectArray) {
                arrayList.add(String.format("Warning: " + string, objectArray));
            }
        });
        if (sdkManager == null) {
            for (String string3 : arrayList) {
                System.out.println(string3);
            }
            throw new BuildException("Failed to parse SDK content.");
        }
        IAndroidTarget iAndroidTarget = sdkManager.getTargetFromHashString(string2);
        if (iAndroidTarget == null) {
            throw new BuildException(String.format("Unable to resolve target '%s'", string2));
        }
        System.out.println("Project Target: " + iAndroidTarget.getName());
        if (!iAndroidTarget.isPlatform()) {
            System.out.println("Vendor: " + iAndroidTarget.getVendor());
            System.out.println("Platform Version: " + iAndroidTarget.getVersionName());
        }
        System.out.println("API level: " + iAndroidTarget.getVersion().getApiString());
        boolean bl2 = false;
        String string4 = project.getProperty("android.library");
        if (string4 != null) {
            bl2 = Boolean.valueOf(string4);
        }
        if (bl2) {
            System.out.println("Project Type: Android Library");
        }
        this.processReferencedLibraries(project, iAndroidTarget, string);
        this.checkManifest(project, iAndroidTarget.getVersion());
        String string5 = iAndroidTarget.getPath(1);
        project.setProperty(this.mAndroidJarFileOut, string5);
        String string6 = iAndroidTarget.getPath(2);
        project.setProperty(this.mAndroidAidlFileOut, string6);
        Path path = new Path(project);
        Path.PathElement pathElement = path.createPathElement();
        pathElement.setPath(iAndroidTarget.getPath(25));
        pathElement = path.createPathElement();
        pathElement.setPath(iAndroidTarget.getPath(26));
        project.setProperty(this.mRenderScriptIncludeDirOut, path.toString());
        project.setProperty(this.mRenderScriptExeOut, string + SdkConstants.OS_SDK_PLATFORM_TOOLS_FOLDER + SdkConstants.FN_RENDERSCRIPT);
        Path path2 = new Path(project);
        pathElement = path2.createPathElement();
        pathElement.setPath(string5);
        IAndroidTarget.IOptionalLibrary[] iOptionalLibraryArray = iAndroidTarget.getOptionalLibraries();
        if (iOptionalLibraryArray != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (IAndroidTarget.IOptionalLibrary iOptionalLibrary : iOptionalLibraryArray) {
                String string7 = iOptionalLibrary.getJarPath();
                if (hashSet.contains(string7)) continue;
                hashSet.add(string7);
                pathElement = path2.createPathElement();
                pathElement.setPath(iOptionalLibrary.getJarPath());
            }
        }
        project.addReference(this.mBootclasspathrefOut, (Object)path2);
        if (bl2) {
            project.setProperty(this.mProjectTypeOut, "library");
        } else if (bl) {
            project.setProperty(this.mProjectTypeOut, "test");
        } else {
            project.setProperty(this.mProjectTypeOut, "project");
        }
    }

    private void checkManifest(Project project, AndroidVersion androidVersion) {
        block10: {
            try {
                File file = new File(project.getBaseDir(), "AndroidManifest.xml");
                XPath xPath = AndroidXPathFactory.newXPath();
                String string = xPath.evaluate("/manifest/@package", new InputSource(new FileInputStream(file)));
                if (string != null && string.indexOf(46) == -1) {
                    throw new BuildException(String.format("Application package '%1$s' must have a minimum of 2 segments.", string));
                }
                string = xPath.evaluate("/manifest/uses-sdk/@android:minSdkVersion", new InputSource(new FileInputStream(file)));
                if (androidVersion.isPreview()) {
                    String string2 = androidVersion.getCodename();
                    if (!string2.equals(string)) {
                        throw new BuildException(String.format("For '%1$s' SDK Preview, attribute minSdkVersion in AndroidManifest.xml must be '%1$s' (current: %2$s)", string2, string));
                    }
                    project.setProperty(this.mTargetApiOut, Integer.toString(androidVersion.getApiLevel()));
                    break block10;
                }
                if (string.length() > 0) {
                    int n = -1;
                    try {
                        n = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new BuildException(String.format("Attribute %1$s in AndroidManifest.xml must be an Integer!", "minSdkVersion"));
                    }
                    project.setProperty(this.mTargetApiOut, string);
                    int n2 = androidVersion.getApiLevel();
                    if (n > androidVersion.getApiLevel()) {
                        System.out.println(String.format("WARNING: Attribute %1$s in AndroidManifest.xml (%2$d) is higher than the project target API level (%3$d)", "minSdkVersion", n, n2));
                    }
                    break block10;
                }
                System.out.println("WARNING: No minSdkVersion value set. Application will install on all Android versions.");
                project.setProperty(this.mTargetApiOut, "1");
            }
            catch (XPathExpressionException xPathExpressionException) {
                throw new BuildException((Throwable)xPathExpressionException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new BuildException((Throwable)fileNotFoundException);
            }
        }
    }

    private void processReferencedLibraries(Project project, IAndroidTarget iAndroidTarget, String string) {
        File file;
        int n;
        Path.PathElement pathElement;
        Path.PathElement pathElement2;
        Path path = new Path(project);
        Path path2 = new Path(project);
        Path path3 = new Path(project);
        StringBuilder stringBuilder = new StringBuilder();
        List<File> list = new ArrayList<File>();
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.toLowerCase().endsWith(".jar");
            }
        };
        System.out.println("\n------------------\nResolving library dependencies:");
        ArrayList<File> arrayList = this.getProjectLibraries(project);
        if (arrayList.size() > 0) {
            System.out.println("------------------\nOrdered libraries:");
            for (File file2 : arrayList) {
                pathElement2 = file2.getAbsolutePath();
                System.out.println((String)pathElement2);
                pathElement = path2.createPathElement();
                pathElement.setPath((String)pathElement2 + "/" + "bin" + "/" + "res");
                pathElement = path2.createPathElement();
                pathElement.setPath((String)pathElement2 + "/" + "res");
                pathElement = path3.createPathElement();
                pathElement.setPath((String)pathElement2 + "/" + "libs");
                list.add(new File((String)pathElement2 + "/" + "bin" + "/" + "classes.jar"));
                File file3 = new File(file2, "libs");
                File[] fileArray = file3.listFiles(filenameFilter);
                if (fileArray != null) {
                    for (File file4 : fileArray) {
                        list.add(file4);
                    }
                }
                FileWrapper object2 = new FileWrapper(file2, "AndroidManifest.xml");
                try {
                    String string2 = AndroidManifest.getPackage(object2);
                    if (string2 == null) continue;
                    stringBuilder.append(';');
                    stringBuilder.append(string2);
                }
                catch (Exception exception) {
                    throw new BuildException((Throwable)exception);
                }
            }
            n = arrayList.size();
            for (int i = n - 1; i >= 0; --i) {
                pathElement2 = arrayList.get(i);
                pathElement = path.createPathElement();
                pathElement.setPath(pathElement2.getAbsolutePath());
            }
            System.out.println();
        } else {
            System.out.println("No library dependencies.\n");
        }
        System.out.println("------------------");
        int n2 = n = list.size() > 0 ? 1 : 0;
        if (iAndroidTarget.getVersion().getApiLevel() <= 15) {
            System.out.println("API<=15: Adding annotations.jar to the classpath.\n");
            list.add(new File(string + "/" + "tools" + "/" + "support" + "/" + "annotations.jar"));
            System.out.println("------------------");
        }
        project.addReference(this.mProjectLibrariesLibsOut, (Object)path3);
        if (n != 0) {
            project.addReference(this.mProjectLibrariesRootOut, (Object)path);
            project.addReference(this.mProjectLibrariesResOut, (Object)path2);
            project.setProperty(this.mProjectLibrariesPackageOut, stringBuilder.toString());
        }
        if ((pathElement2 = (file = new File("libs")).listFiles(filenameFilter)) != null) {
            for (Path.PathElement pathElement3 : pathElement2) {
                list.add((File)pathElement3);
            }
        }
        list = this.sanitizePaths(project, list);
        pathElement = new Path(project);
        if (this.mVerbose) {
            System.out.println("Sanitized jar list:");
        }
        for (File file5 : list) {
            if (this.mVerbose) {
                System.out.println("- " + file5.getAbsolutePath());
            }
            Path.PathElement pathElement4 = pathElement.createPathElement();
            pathElement4.setPath(file5.getAbsolutePath());
        }
        project.addReference(this.mProjectLibrariesJarsOut, (Object)pathElement);
        if (this.mVerbose) {
            System.out.println();
        }
    }

    private ArrayList<File> getProjectLibraries(final Project project) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = project.getBaseDir();
        List<File> list = this.getDirectDependencies(file, new IPropertySource(){

            public String getProperty(String string) {
                return project.getProperty(string);
            }
        });
        this.resolveFullLibraryDependencies(list, arrayList);
        return arrayList;
    }

    private void resolveFullLibraryDependencies(List<File> list, List<File> list2) {
        for (int i = list.size() - 1; i >= 0; --i) {
            File file = list.get(i);
            final ProjectProperties projectProperties = ProjectProperties.load(new FolderWrapper(file), ProjectProperties.PropertyType.PROJECT);
            List<File> list3 = this.getDirectDependencies(file, new IPropertySource(){

                public String getProperty(String string) {
                    return projectProperties.getProperty(string);
                }
            });
            this.resolveFullLibraryDependencies(list3, list2);
            if (list2.contains(file)) continue;
            list2.add(0, file);
        }
    }

    private List<File> getDirectDependencies(File file, IPropertySource iPropertySource) {
        String string;
        String string2;
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = 1;
        while ((string2 = iPropertySource.getProperty(string = "android.library.reference." + Integer.toString(n++))) != null) {
            try {
                File file2 = new File(file, string2).getCanonicalFile();
                File file3 = new File(file2, ProjectProperties.PropertyType.PROJECT.getFilename());
                if (!file3.isFile()) {
                    throw new BuildException(String.format("%1$s resolve to a path with no %2$s file for project %3$s", string2, ProjectProperties.PropertyType.PROJECT.getFilename(), file.getAbsolutePath()));
                }
                if (arrayList.contains(file2)) continue;
                System.out.println(String.format("%1$s: %2$s => %3$s", file.getAbsolutePath(), string2, file2.getAbsolutePath()));
                arrayList.add(file2);
            }
            catch (IOException iOException) {
                throw new BuildException("Failed to resolve library path: " + string2, (Throwable)iOException);
            }
        }
        return arrayList;
    }

    private DeweyDecimal getVersion(Project project) {
        char[] cArray = project.getProperty("ant.version").toCharArray();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (Character.isDigit(cArray[i])) {
                stringBuilder.append(cArray[i]);
                bl = true;
            }
            if (cArray[i] == '.' && bl) {
                stringBuilder.append(cArray[i]);
            }
            if (Character.isLetter(cArray[i]) && bl) break;
        }
        return new DeweyDecimal(stringBuilder.toString());
    }

    private List<File> sanitizePaths(Project project, List<File> list) {
        Object object;
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = 0;
        while (n < list.size()) {
            object = list.get(n);
            if (((File)object).isFile() && !((File)object).getName().equals("classes.jar")) {
                ++n;
                continue;
            }
            arrayList.add((File)object);
            list.remove(n);
        }
        File file = new File(project.getProperty("out.absolute.dir"));
        object = new JarListSanitizer(file);
        try {
            arrayList.addAll(((JarListSanitizer)object).sanitize(list));
        }
        catch (JarListSanitizer.DifferentLibException differentLibException) {
            String[] stringArray;
            for (String string : stringArray = differentLibException.getDetails()) {
                System.err.println(string);
            }
            throw new BuildException(differentLibException.getMessage(), (Throwable)differentLibException);
        }
        catch (JarListSanitizer.Sha1Exception sha1Exception) {
            throw new BuildException("Failed to compute sha1 for " + sha1Exception.getJarFile().getAbsolutePath(), (Throwable)sha1Exception);
        }
        return arrayList;
    }

    public static interface IPropertySource {
        public String getProperty(String var1);
    }
}

