/*
 * Decompiled with CFR 0.152.
 */
package com.android.ant;

import com.android.ant.TaskHelper;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.types.Path;

public class ZipAlignTask
extends Task {
    private String mExecutable;
    private String mInput;
    private String mOutput;
    private int mAlign = 4;
    private boolean mVerbose = false;

    public void setExecutable(Path path) {
        this.mExecutable = TaskHelper.checkSinglePath("executable", path);
    }

    public void setInput(Path path) {
        this.mInput = TaskHelper.checkSinglePath("input", path);
    }

    public void setOutput(Path path) {
        this.mOutput = TaskHelper.checkSinglePath("output", path);
    }

    public void setAlign(int n) {
        this.mAlign = n;
    }

    public void setVerbose(boolean bl) {
        this.mVerbose = bl;
    }

    public void execute() throws BuildException {
        if (this.mExecutable == null) {
            throw new BuildException("Missing attribute executable");
        }
        if (this.mInput == null) {
            throw new BuildException("Missing attribute input");
        }
        if (this.mOutput == null) {
            throw new BuildException("Missing attribute output");
        }
        File file = new File(this.mOutput);
        if (file.isFile()) {
            File file2 = new File(this.mInput);
            if (file.lastModified() >= file2.lastModified()) {
                System.out.println("No changes. No need to run zip-align on the apk.");
                return;
            }
        }
        System.out.println("Running zip align on final apk...");
        this.doZipAlign();
    }

    private void doZipAlign() {
        ExecTask execTask = new ExecTask();
        execTask.setExecutable(this.mExecutable);
        execTask.setFailonerror(true);
        execTask.setProject(this.getProject());
        execTask.setOwningTarget(this.getOwningTarget());
        execTask.setTaskName("zip-align");
        execTask.createArg().setValue("-f");
        if (this.mVerbose) {
            execTask.createArg().setValue("-v");
        }
        execTask.createArg().setValue(Integer.toString(this.mAlign));
        execTask.createArg().setValue(this.mInput);
        execTask.createArg().setValue(this.mOutput);
        execTask.execute();
    }
}

