/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Local;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.ts.BaseLiveAnalyze;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;

public class LiveAnalyze
extends BaseLiveAnalyze {
    private static LivePhi trim(LivePhi phi) {
        while (phi.tag != null) {
            phi = (LivePhi)phi.tag;
        }
        return phi;
    }

    public LiveAnalyze(IrMethod method) {
        super(method);
    }

    @Override
    protected void onUseLocal(BaseLiveAnalyze.Phi phi, Local local) {
        LivePhi phi2 = (LivePhi)phi;
        phi2.local = local;
    }

    @Override
    protected BaseLiveAnalyze.Phi newPhi() {
        return new LivePhi();
    }

    @Override
    protected void analyzePhi() {
        Set<BaseLiveAnalyze.Phi> used = super.markUsed();
        for (BaseLiveAnalyze.Phi x : used) {
            LivePhi reg = (LivePhi)x;
            LivePhi a = LiveAnalyze.trim(reg);
            if (a != reg && reg.local != null) {
                a.local = reg.local;
            }
            if (reg.parents.size() <= 0) continue;
            for (BaseLiveAnalyze.Phi r : reg.parents) {
                LivePhi b = LiveAnalyze.trim((LivePhi)r);
                if (a == b) continue;
                b.tag = a;
                if (b.local == null) continue;
                a.local = b.local;
            }
        }
        Stmt p = this.method.stmts.getFirst();
        while (p != null) {
            BaseLiveAnalyze.Phi[] frame = (BaseLiveAnalyze.Phi[])p._ls_forward_frame;
            if (frame != null) {
                int i = 0;
                while (i < frame.length) {
                    BaseLiveAnalyze.Phi r = frame[i];
                    if (r != null) {
                        frame[i] = r.used ? LiveAnalyze.trim((LivePhi)r) : null;
                    }
                    ++i;
                }
            }
            p = p.getNext();
        }
        this.phis.clear();
        for (BaseLiveAnalyze.Phi x : used) {
            LivePhi r = (LivePhi)x;
            if (!r.used || r.tag != null) continue;
            r.parents.clear();
            this.phis.add(r);
        }
        used.clear();
        ArrayList nPhis = new ArrayList(this.phis);
        this.phis.clear();
        Collections.sort(nPhis, new Comparator<BaseLiveAnalyze.Phi>(){

            @Override
            public int compare(BaseLiveAnalyze.Phi o1, BaseLiveAnalyze.Phi o2) {
                LivePhi a1 = (LivePhi)o1;
                LivePhi a2 = (LivePhi)o2;
                return a1.local._ls_index - a2.local._ls_index;
            }
        });
        this.phis.addAll(nPhis);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Stmt stmt = this.method.stmts.getFirst();
        while (stmt != null) {
            BaseLiveAnalyze.Phi[] frame = (BaseLiveAnalyze.Phi[])stmt._ls_forward_frame;
            if (frame != null) {
                BaseLiveAnalyze.Phi[] phiArray = frame;
                int n = frame.length;
                int n2 = 0;
                while (n2 < n) {
                    BaseLiveAnalyze.Phi p = phiArray[n2];
                    if (p == null) {
                        sb.append('.');
                    } else if (p.used) {
                        sb.append('x');
                    } else {
                        sb.append('?');
                    }
                    ++n2;
                }
                sb.append(" | ");
            }
            sb.append(stmt.toString()).append('\n');
            stmt = stmt.getNext();
        }
        return sb.toString();
    }

    public static class LivePhi
    extends BaseLiveAnalyze.Phi {
        public Local local;
        public BaseLiveAnalyze.Phi tag;

        @Override
        public String toString() {
            if (this.tag != null) {
                return this.tag.toString();
            }
            if (this.local != null) {
                return this.local.toString();
            }
            return "?";
        }
    }
}

