/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentManagerImpl;
import android.support.v4.app.FragmentTransaction;
import android.util.Log;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;

final class BackStackRecord
extends FragmentTransaction
implements FragmentManager.BackStackEntry,
Runnable {
    static final int OP_ADD = 1;
    static final int OP_ATTACH = 7;
    static final int OP_DETACH = 6;
    static final int OP_HIDE = 4;
    static final int OP_NULL = 0;
    static final int OP_REMOVE = 3;
    static final int OP_REPLACE = 2;
    static final int OP_SHOW = 5;
    static final String TAG = "BackStackEntry";
    boolean mAddToBackStack;
    boolean mAllowAddToBackStack = true;
    int mBreadCrumbShortTitleRes;
    CharSequence mBreadCrumbShortTitleText;
    int mBreadCrumbTitleRes;
    CharSequence mBreadCrumbTitleText;
    boolean mCommitted;
    int mEnterAnim;
    int mExitAnim;
    Op mHead;
    int mIndex;
    final FragmentManagerImpl mManager;
    String mName;
    int mNumOp;
    int mPopEnterAnim;
    int mPopExitAnim;
    Op mTail;
    int mTransition;
    int mTransitionStyle;

    public BackStackRecord(FragmentManagerImpl fragmentManagerImpl) {
        this.mManager = fragmentManagerImpl;
    }

    private void doAddOp(int n, Fragment fragment, String string2, int n2) {
        fragment.mFragmentManager = this.mManager;
        if (string2 != null) {
            if (fragment.mTag != null && !string2.equals(fragment.mTag)) {
                throw new IllegalStateException("Can't change tag of fragment " + fragment + ": was " + fragment.mTag + " now " + string2);
            }
            fragment.mTag = string2;
        }
        if (n != 0) {
            if (fragment.mFragmentId != 0 && fragment.mFragmentId != n) {
                throw new IllegalStateException("Can't change container ID of fragment " + fragment + ": was " + fragment.mFragmentId + " now " + n);
            }
            fragment.mFragmentId = n;
            fragment.mContainerId = n;
        }
        Op op = new Op();
        op.cmd = n2;
        op.fragment = fragment;
        this.addOp(op);
    }

    @Override
    public FragmentTransaction add(int n, Fragment fragment) {
        this.doAddOp(n, fragment, null, 1);
        return this;
    }

    @Override
    public FragmentTransaction add(int n, Fragment fragment, String string2) {
        this.doAddOp(n, fragment, string2, 1);
        return this;
    }

    @Override
    public FragmentTransaction add(Fragment fragment, String string2) {
        this.doAddOp(0, fragment, string2, 1);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    void addOp(Op op) {
        if (this.mHead == null) {
            this.mTail = op;
            this.mHead = op;
        } else {
            op.prev = this.mTail;
            this.mTail.next = op;
            this.mTail = op;
        }
        op.enterAnim = this.mEnterAnim;
        op.exitAnim = this.mExitAnim;
        op.popEnterAnim = this.mPopEnterAnim;
        op.popExitAnim = this.mPopExitAnim;
        this.mNumOp = 1 + this.mNumOp;
    }

    @Override
    public FragmentTransaction addToBackStack(String string2) {
        if (!this.mAllowAddToBackStack) {
            throw new IllegalStateException("This FragmentTransaction is not allowed to be added to the back stack.");
        }
        this.mAddToBackStack = true;
        this.mName = string2;
        return this;
    }

    @Override
    public FragmentTransaction attach(Fragment fragment) {
        Op op = new Op();
        op.cmd = 7;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    void bumpBackStackNesting(int n) {
        if (this.mAddToBackStack) {
            if (FragmentManagerImpl.DEBUG) {
                Log.v((String)TAG, (String)("Bump nesting in " + this + " by " + n));
            }
            Op op = this.mHead;
            while (op != null) {
                if (op.fragment != null) {
                    Fragment fragment = op.fragment;
                    fragment.mBackStackNesting = n + fragment.mBackStackNesting;
                    if (FragmentManagerImpl.DEBUG) {
                        Log.v((String)TAG, (String)("Bump nesting of " + op.fragment + " to " + op.fragment.mBackStackNesting));
                    }
                }
                if (op.removed != null) {
                    for (int i = -1 + op.removed.size(); i >= 0; --i) {
                        Fragment fragment = op.removed.get(i);
                        fragment.mBackStackNesting = n + fragment.mBackStackNesting;
                        if (!FragmentManagerImpl.DEBUG) continue;
                        Log.v((String)TAG, (String)("Bump nesting of " + fragment + " to " + fragment.mBackStackNesting));
                    }
                }
                op = op.next;
            }
        }
    }

    @Override
    public int commit() {
        return this.commitInternal(false);
    }

    @Override
    public int commitAllowingStateLoss() {
        return this.commitInternal(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    int commitInternal(boolean bl) {
        if (this.mCommitted) {
            throw new IllegalStateException("commit already called");
        }
        if (FragmentManagerImpl.DEBUG) {
            Log.v((String)TAG, (String)("Commit: " + this));
        }
        this.mCommitted = true;
        this.mIndex = this.mAddToBackStack ? this.mManager.allocBackStackIndex(this) : -1;
        this.mManager.enqueueAction(this, bl);
        return this.mIndex;
    }

    @Override
    public FragmentTransaction detach(Fragment fragment) {
        Op op = new Op();
        op.cmd = 6;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    @Override
    public FragmentTransaction disallowAddToBackStack() {
        if (this.mAddToBackStack) {
            throw new IllegalStateException("This transaction is already being added to the back stack");
        }
        this.mAllowAddToBackStack = false;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.print(string2);
        printWriter.print("mName=");
        printWriter.print(this.mName);
        printWriter.print(" mIndex=");
        printWriter.print(this.mIndex);
        printWriter.print(" mCommitted=");
        printWriter.println(this.mCommitted);
        if (this.mTransition != 0) {
            printWriter.print(string2);
            printWriter.print("mTransition=#");
            printWriter.print(Integer.toHexString(this.mTransition));
            printWriter.print(" mTransitionStyle=#");
            printWriter.println(Integer.toHexString(this.mTransitionStyle));
        }
        if (this.mEnterAnim != 0 || this.mExitAnim != 0) {
            printWriter.print(string2);
            printWriter.print("mEnterAnim=#");
            printWriter.print(Integer.toHexString(this.mEnterAnim));
            printWriter.print(" mExitAnim=#");
            printWriter.println(Integer.toHexString(this.mExitAnim));
        }
        if (this.mPopEnterAnim != 0 || this.mPopExitAnim != 0) {
            printWriter.print(string2);
            printWriter.print("mPopEnterAnim=#");
            printWriter.print(Integer.toHexString(this.mPopEnterAnim));
            printWriter.print(" mPopExitAnim=#");
            printWriter.println(Integer.toHexString(this.mPopExitAnim));
        }
        if (this.mBreadCrumbTitleRes != 0 || this.mBreadCrumbTitleText != null) {
            printWriter.print(string2);
            printWriter.print("mBreadCrumbTitleRes=#");
            printWriter.print(Integer.toHexString(this.mBreadCrumbTitleRes));
            printWriter.print(" mBreadCrumbTitleText=");
            printWriter.println(this.mBreadCrumbTitleText);
        }
        if (this.mBreadCrumbShortTitleRes != 0 || this.mBreadCrumbShortTitleText != null) {
            printWriter.print(string2);
            printWriter.print("mBreadCrumbShortTitleRes=#");
            printWriter.print(Integer.toHexString(this.mBreadCrumbShortTitleRes));
            printWriter.print(" mBreadCrumbShortTitleText=");
            printWriter.println(this.mBreadCrumbShortTitleText);
        }
        if (this.mHead != null) {
            printWriter.print(string2);
            printWriter.println("Operations:");
            String string3 = string2 + "    ";
            Op op = this.mHead;
            while (op != null) {
                printWriter.print(string2);
                printWriter.print("  Op #");
                printWriter.print(0);
                printWriter.println(":");
                printWriter.print(string3);
                printWriter.print("cmd=");
                printWriter.print(op.cmd);
                printWriter.print(" fragment=");
                printWriter.println(op.fragment);
                if (op.enterAnim != 0 || op.exitAnim != 0) {
                    printWriter.print(string2);
                    printWriter.print("enterAnim=#");
                    printWriter.print(Integer.toHexString(op.enterAnim));
                    printWriter.print(" exitAnim=#");
                    printWriter.println(Integer.toHexString(op.exitAnim));
                }
                if (op.popEnterAnim != 0 || op.popExitAnim != 0) {
                    printWriter.print(string2);
                    printWriter.print("popEnterAnim=#");
                    printWriter.print(Integer.toHexString(op.popEnterAnim));
                    printWriter.print(" popExitAnim=#");
                    printWriter.println(Integer.toHexString(op.popExitAnim));
                }
                if (op.removed != null && op.removed.size() > 0) {
                    for (int i = 0; i < op.removed.size(); ++i) {
                        printWriter.print(string3);
                        if (op.removed.size() == 1) {
                            printWriter.print("Removed: ");
                        } else {
                            printWriter.println("Removed:");
                            printWriter.print(string3);
                            printWriter.print("  #");
                            printWriter.print(0);
                            printWriter.print(": ");
                        }
                        printWriter.println(op.removed.get(i));
                    }
                }
                op = op.next;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CharSequence getBreadCrumbShortTitle() {
        if (this.mBreadCrumbShortTitleRes == 0) return this.mBreadCrumbShortTitleText;
        return this.mManager.mActivity.getText(this.mBreadCrumbShortTitleRes);
    }

    @Override
    public int getBreadCrumbShortTitleRes() {
        return this.mBreadCrumbShortTitleRes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CharSequence getBreadCrumbTitle() {
        if (this.mBreadCrumbTitleRes == 0) return this.mBreadCrumbTitleText;
        return this.mManager.mActivity.getText(this.mBreadCrumbTitleRes);
    }

    @Override
    public int getBreadCrumbTitleRes() {
        return this.mBreadCrumbTitleRes;
    }

    @Override
    public int getId() {
        return this.mIndex;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public int getTransition() {
        return this.mTransition;
    }

    public int getTransitionStyle() {
        return this.mTransitionStyle;
    }

    @Override
    public FragmentTransaction hide(Fragment fragment) {
        Op op = new Op();
        op.cmd = 4;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    @Override
    public boolean isAddToBackStackAllowed() {
        return this.mAllowAddToBackStack;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEmpty() {
        if (this.mNumOp != 0) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void popFromBackStack(boolean bl) {
        if (FragmentManagerImpl.DEBUG) {
            Log.v((String)TAG, (String)("popFromBackStack: " + this));
        }
        this.bumpBackStackNesting(-1);
        Op op = this.mTail;
        while (op != null) {
            switch (op.cmd) {
                default: {
                    throw new IllegalArgumentException("Unknown cmd: " + op.cmd);
                }
                case 1: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.popExitAnim;
                    this.mManager.removeFragment(fragment, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 2: {
                    Fragment fragment = op.fragment;
                    if (fragment != null) {
                        fragment.mNextAnim = op.popExitAnim;
                        this.mManager.removeFragment(fragment, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    }
                    if (op.removed == null) break;
                    for (int i = 0; i < op.removed.size(); ++i) {
                        Fragment fragment2 = op.removed.get(i);
                        fragment2.mNextAnim = op.popEnterAnim;
                        this.mManager.addFragment(fragment2, false);
                    }
                    break;
                }
                case 3: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.popEnterAnim;
                    this.mManager.addFragment(fragment, false);
                    break;
                }
                case 4: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.popEnterAnim;
                    this.mManager.showFragment(fragment, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 5: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.popExitAnim;
                    this.mManager.hideFragment(fragment, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 6: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.popEnterAnim;
                    this.mManager.attachFragment(fragment, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 7: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.popEnterAnim;
                    this.mManager.detachFragment(fragment, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                }
            }
            op = op.prev;
        }
        if (bl) {
            this.mManager.moveToState(this.mManager.mCurState, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle, true);
        }
        if (this.mIndex >= 0) {
            this.mManager.freeBackStackIndex(this.mIndex);
            this.mIndex = -1;
        }
    }

    @Override
    public FragmentTransaction remove(Fragment fragment) {
        Op op = new Op();
        op.cmd = 3;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    @Override
    public FragmentTransaction replace(int n, Fragment fragment) {
        return this.replace(n, fragment, null);
    }

    @Override
    public FragmentTransaction replace(int n, Fragment fragment, String string2) {
        if (n == 0) {
            throw new IllegalArgumentException("Must use non-zero containerViewId");
        }
        this.doAddOp(n, fragment, string2, 2);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void run() {
        if (FragmentManagerImpl.DEBUG) {
            Log.v((String)TAG, (String)("Run: " + this));
        }
        if (this.mAddToBackStack && this.mIndex < 0) {
            throw new IllegalStateException("addToBackStack() called after commit()");
        }
        this.bumpBackStackNesting(1);
        Op op = this.mHead;
        while (op != null) {
            switch (op.cmd) {
                default: {
                    throw new IllegalArgumentException("Unknown cmd: " + op.cmd);
                }
                case 1: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.enterAnim;
                    this.mManager.addFragment(fragment, false);
                    break;
                }
                case 2: {
                    Fragment fragment = op.fragment;
                    if (this.mManager.mAdded != null) {
                        for (int i = 0; i < this.mManager.mAdded.size(); ++i) {
                            Fragment fragment2 = this.mManager.mAdded.get(i);
                            if (FragmentManagerImpl.DEBUG) {
                                Log.v((String)TAG, (String)("OP_REPLACE: adding=" + fragment + " old=" + fragment2));
                            }
                            if (fragment != null && fragment2.mContainerId != fragment.mContainerId) continue;
                            if (fragment2 == fragment) {
                                op.fragment = fragment = null;
                                continue;
                            }
                            if (op.removed == null) {
                                op.removed = new ArrayList();
                            }
                            op.removed.add(fragment2);
                            fragment2.mNextAnim = op.exitAnim;
                            if (this.mAddToBackStack) {
                                fragment2.mBackStackNesting = 1 + fragment2.mBackStackNesting;
                                if (FragmentManagerImpl.DEBUG) {
                                    Log.v((String)TAG, (String)("Bump nesting of " + fragment2 + " to " + fragment2.mBackStackNesting));
                                }
                            }
                            this.mManager.removeFragment(fragment2, this.mTransition, this.mTransitionStyle);
                        }
                    }
                    if (fragment == null) break;
                    fragment.mNextAnim = op.enterAnim;
                    this.mManager.addFragment(fragment, false);
                    break;
                }
                case 3: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.exitAnim;
                    this.mManager.removeFragment(fragment, this.mTransition, this.mTransitionStyle);
                    break;
                }
                case 4: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.exitAnim;
                    this.mManager.hideFragment(fragment, this.mTransition, this.mTransitionStyle);
                    break;
                }
                case 5: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.enterAnim;
                    this.mManager.showFragment(fragment, this.mTransition, this.mTransitionStyle);
                    break;
                }
                case 6: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.exitAnim;
                    this.mManager.detachFragment(fragment, this.mTransition, this.mTransitionStyle);
                    break;
                }
                case 7: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.enterAnim;
                    this.mManager.attachFragment(fragment, this.mTransition, this.mTransitionStyle);
                }
            }
            op = op.next;
        }
        this.mManager.moveToState(this.mManager.mCurState, this.mTransition, this.mTransitionStyle, true);
        if (this.mAddToBackStack) {
            this.mManager.addBackStackState(this);
        }
    }

    @Override
    public FragmentTransaction setBreadCrumbShortTitle(int n) {
        this.mBreadCrumbShortTitleRes = n;
        this.mBreadCrumbShortTitleText = null;
        return this;
    }

    @Override
    public FragmentTransaction setBreadCrumbShortTitle(CharSequence charSequence) {
        this.mBreadCrumbShortTitleRes = 0;
        this.mBreadCrumbShortTitleText = charSequence;
        return this;
    }

    @Override
    public FragmentTransaction setBreadCrumbTitle(int n) {
        this.mBreadCrumbTitleRes = n;
        this.mBreadCrumbTitleText = null;
        return this;
    }

    @Override
    public FragmentTransaction setBreadCrumbTitle(CharSequence charSequence) {
        this.mBreadCrumbTitleRes = 0;
        this.mBreadCrumbTitleText = charSequence;
        return this;
    }

    @Override
    public FragmentTransaction setCustomAnimations(int n, int n2) {
        return this.setCustomAnimations(n, n2, 0, 0);
    }

    @Override
    public FragmentTransaction setCustomAnimations(int n, int n2, int n3, int n4) {
        this.mEnterAnim = n;
        this.mExitAnim = n2;
        this.mPopEnterAnim = n3;
        this.mPopExitAnim = n4;
        return this;
    }

    @Override
    public FragmentTransaction setTransition(int n) {
        this.mTransition = n;
        return this;
    }

    @Override
    public FragmentTransaction setTransitionStyle(int n) {
        this.mTransitionStyle = n;
        return this;
    }

    @Override
    public FragmentTransaction show(Fragment fragment) {
        Op op = new Op();
        op.cmd = 5;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    static final class Op {
        int cmd;
        int enterAnim;
        int exitAnim;
        Fragment fragment;
        Op next;
        int popEnterAnim;
        int popExitAnim;
        Op prev;
        ArrayList<Fragment> removed;

        Op() {
        }
    }
}

