/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.app.BackStackRecord;
import android.support.v4.app.BackStackState;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentManagerState;
import android.support.v4.app.FragmentState;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.app.NoSaveStateFrameLayout;
import android.support.v4.app.SuperNotCalledException;
import android.support.v4.util.DebugUtils;
import android.support.v4.util.LogWriter;
import android.util.Log;
import android.util.SparseArray;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

final class FragmentManagerImpl
extends FragmentManager {
    static final Interpolator ACCELERATE_CUBIC;
    static final Interpolator ACCELERATE_QUINT;
    static final int ANIM_DUR = 220;
    public static final int ANIM_STYLE_CLOSE_ENTER = 3;
    public static final int ANIM_STYLE_CLOSE_EXIT = 4;
    public static final int ANIM_STYLE_FADE_ENTER = 5;
    public static final int ANIM_STYLE_FADE_EXIT = 6;
    public static final int ANIM_STYLE_OPEN_ENTER = 1;
    public static final int ANIM_STYLE_OPEN_EXIT = 2;
    static boolean DEBUG = false;
    static final Interpolator DECELERATE_CUBIC;
    static final Interpolator DECELERATE_QUINT;
    static final boolean HONEYCOMB = false;
    static final String TAG = "FragmentManager";
    static final String TARGET_REQUEST_CODE_STATE_TAG = "android:target_req_state";
    static final String TARGET_STATE_TAG = "android:target_state";
    static final String USER_VISIBLE_HINT_TAG = "android:user_visible_hint";
    static final String VIEW_STATE_TAG = "android:view_state";
    ArrayList<Fragment> mActive;
    FragmentActivity mActivity;
    ArrayList<Fragment> mAdded;
    ArrayList<Integer> mAvailBackStackIndices;
    ArrayList<Integer> mAvailIndices;
    ArrayList<BackStackRecord> mBackStack;
    ArrayList<FragmentManager.OnBackStackChangedListener> mBackStackChangeListeners;
    ArrayList<BackStackRecord> mBackStackIndices;
    ArrayList<Fragment> mCreatedMenus;
    int mCurState = 0;
    boolean mDestroyed;
    Runnable mExecCommit = new Runnable(){

        @Override
        public void run() {
            FragmentManagerImpl.this.execPendingActions();
        }
    };
    boolean mExecutingActions;
    boolean mHavePendingDeferredStart;
    boolean mNeedMenuInvalidate;
    String mNoTransactionsBecause;
    ArrayList<Runnable> mPendingActions;
    SparseArray<Parcelable> mStateArray = null;
    Bundle mStateBundle = null;
    boolean mStateSaved;
    Runnable[] mTmpActions;

    static {
        boolean bl;
        DEBUG = bl = false;
        if (Build.VERSION.SDK_INT >= 11) {
            bl = true;
        }
        HONEYCOMB = bl;
        DECELERATE_QUINT = new DecelerateInterpolator(2.5f);
        DECELERATE_CUBIC = new DecelerateInterpolator(1.5f);
        ACCELERATE_QUINT = new AccelerateInterpolator(2.5f);
        ACCELERATE_CUBIC = new AccelerateInterpolator(1.5f);
    }

    FragmentManagerImpl() {
    }

    private void checkStateLoss() {
        if (this.mStateSaved) {
            throw new IllegalStateException("Can not perform this action after onSaveInstanceState");
        }
        if (this.mNoTransactionsBecause != null) {
            throw new IllegalStateException("Can not perform this action inside of " + this.mNoTransactionsBecause);
        }
    }

    static Animation makeFadeAnimation(Context context, float f, float f2) {
        AlphaAnimation alphaAnimation = new AlphaAnimation(f, f2);
        alphaAnimation.setInterpolator(DECELERATE_CUBIC);
        alphaAnimation.setDuration(220L);
        return alphaAnimation;
    }

    static Animation makeOpenCloseAnimation(Context context, float f, float f2, float f3, float f4) {
        AnimationSet animationSet = new AnimationSet(false);
        ScaleAnimation scaleAnimation = new ScaleAnimation(f, f2, f, f2, 1, 0.5f, 1, 0.5f);
        scaleAnimation.setInterpolator(DECELERATE_QUINT);
        scaleAnimation.setDuration(220L);
        animationSet.addAnimation((Animation)scaleAnimation);
        AlphaAnimation alphaAnimation = new AlphaAnimation(f3, f4);
        alphaAnimation.setInterpolator(DECELERATE_CUBIC);
        alphaAnimation.setDuration(220L);
        animationSet.addAnimation((Animation)alphaAnimation);
        return animationSet;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int reverseTransit(int n) {
        int n2 = 0;
        switch (n) {
            case 4097: {
                return 8194;
            }
            case 8194: {
                return 4097;
            }
            case 4099: {
                return 4099;
            }
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int transitToStyleIndex(int n, boolean bl) {
        int n2 = -1;
        switch (n) {
            case 4097: {
                if (!bl) return 2;
                return 1;
            }
            case 8194: {
                if (!bl) return 4;
                return 3;
            }
            case 4099: {
                if (!bl) return 6;
                return 5;
            }
        }
        return n2;
    }

    void addBackStackState(BackStackRecord backStackRecord) {
        if (this.mBackStack == null) {
            this.mBackStack = new ArrayList();
        }
        this.mBackStack.add(backStackRecord);
        this.reportBackStackChanged();
    }

    public void addFragment(Fragment fragment, boolean bl) {
        if (this.mAdded == null) {
            this.mAdded = new ArrayList();
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("add: " + fragment));
        }
        this.makeActive(fragment);
        if (!fragment.mDetached) {
            this.mAdded.add(fragment);
            fragment.mAdded = true;
            fragment.mRemoving = false;
            if (fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            if (bl) {
                this.moveToState(fragment);
            }
        }
    }

    @Override
    public void addOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener onBackStackChangedListener) {
        if (this.mBackStackChangeListeners == null) {
            this.mBackStackChangeListeners = new ArrayList();
        }
        this.mBackStackChangeListeners.add(onBackStackChangedListener);
    }

    public int allocBackStackIndex(BackStackRecord backStackRecord) {
        int n;
        synchronized (this) {
            if (this.mAvailBackStackIndices == null || this.mAvailBackStackIndices.size() <= 0) {
                if (this.mBackStackIndices == null) {
                    this.mBackStackIndices = new ArrayList();
                }
                int n2 = this.mBackStackIndices.size();
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Setting back stack index " + n2 + " to " + backStackRecord));
                }
                this.mBackStackIndices.add(backStackRecord);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 7] lbl12 : MonitorExitStatement: MONITOREXIT : this
                n = n2;
            } else {
                int n3 = this.mAvailBackStackIndices.remove(-1 + this.mAvailBackStackIndices.size());
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Adding back stack index " + n3 + " with " + backStackRecord));
                }
                this.mBackStackIndices.set(n3, backStackRecord);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl21 : MonitorExitStatement: MONITOREXIT : this
                n = n3;
            }
        }
        return n;
    }

    public void attachActivity(FragmentActivity fragmentActivity) {
        if (this.mActivity != null) {
            throw new IllegalStateException();
        }
        this.mActivity = fragmentActivity;
    }

    public void attachFragment(Fragment fragment, int n, int n2) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("attach: " + fragment));
        }
        if (fragment.mDetached) {
            fragment.mDetached = false;
            if (!fragment.mAdded) {
                if (this.mAdded == null) {
                    this.mAdded = new ArrayList();
                }
                this.mAdded.add(fragment);
                fragment.mAdded = true;
                if (fragment.mHasMenu && fragment.mMenuVisible) {
                    this.mNeedMenuInvalidate = true;
                }
                this.moveToState(fragment, this.mCurState, n, n2, false);
            }
        }
    }

    @Override
    public FragmentTransaction beginTransaction() {
        return new BackStackRecord(this);
    }

    public void detachFragment(Fragment fragment, int n, int n2) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("detach: " + fragment));
        }
        if (!fragment.mDetached) {
            fragment.mDetached = true;
            if (fragment.mAdded) {
                if (this.mAdded != null) {
                    this.mAdded.remove(fragment);
                }
                if (fragment.mHasMenu && fragment.mMenuVisible) {
                    this.mNeedMenuInvalidate = true;
                }
                fragment.mAdded = false;
                this.moveToState(fragment, 1, n, n2, false);
            }
        }
    }

    public void dispatchActivityCreated() {
        this.mStateSaved = false;
        this.moveToState(2, false);
    }

    public void dispatchConfigurationChanged(Configuration configuration) {
        if (this.mAdded != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment fragment = this.mAdded.get(i);
                if (fragment == null) continue;
                fragment.onConfigurationChanged(configuration);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dispatchContextItemSelected(MenuItem menuItem) {
        if (this.mAdded == null) return false;
        int n = 0;
        while (n < this.mAdded.size()) {
            Fragment fragment = this.mAdded.get(n);
            if (fragment != null && !fragment.mHidden && fragment.mUserVisibleHint && fragment.onContextItemSelected(menuItem)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void dispatchCreate() {
        this.mStateSaved = false;
        this.moveToState(1, false);
    }

    public boolean dispatchCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
        boolean bl = false;
        ArrayList<Fragment> arrayList = null;
        if (this.mAdded != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment fragment = this.mAdded.get(i);
                if (fragment == null || fragment.mHidden || !fragment.mHasMenu || !fragment.mMenuVisible) continue;
                bl = true;
                fragment.onCreateOptionsMenu(menu2, menuInflater);
                if (arrayList == null) {
                    arrayList = new ArrayList<Fragment>();
                }
                arrayList.add(fragment);
            }
        }
        if (this.mCreatedMenus != null) {
            for (int i = 0; i < this.mCreatedMenus.size(); ++i) {
                Fragment fragment = this.mCreatedMenus.get(i);
                if (arrayList != null && arrayList.contains(fragment)) continue;
                fragment.onDestroyOptionsMenu();
            }
        }
        this.mCreatedMenus = arrayList;
        return bl;
    }

    public void dispatchDestroy() {
        this.mDestroyed = true;
        this.execPendingActions();
        this.moveToState(0, false);
        this.mActivity = null;
    }

    public void dispatchLowMemory() {
        if (this.mAdded != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment fragment = this.mAdded.get(i);
                if (fragment == null) continue;
                fragment.onLowMemory();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dispatchOptionsItemSelected(MenuItem menuItem) {
        if (this.mAdded == null) return false;
        int n = 0;
        while (n < this.mAdded.size()) {
            Fragment fragment = this.mAdded.get(n);
            if (fragment != null && !fragment.mHidden && fragment.mHasMenu && fragment.mMenuVisible && fragment.onOptionsItemSelected(menuItem)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void dispatchOptionsMenuClosed(Menu menu2) {
        if (this.mAdded != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment fragment = this.mAdded.get(i);
                if (fragment == null || fragment.mHidden || !fragment.mHasMenu || !fragment.mMenuVisible) continue;
                fragment.onOptionsMenuClosed(menu2);
            }
        }
    }

    public void dispatchPause() {
        this.moveToState(4, false);
    }

    public boolean dispatchPrepareOptionsMenu(Menu menu2) {
        boolean bl = false;
        if (this.mAdded != null) {
            for (int i = 0; i < this.mAdded.size(); ++i) {
                Fragment fragment = this.mAdded.get(i);
                if (fragment == null || fragment.mHidden || !fragment.mHasMenu || !fragment.mMenuVisible) continue;
                bl = true;
                fragment.onPrepareOptionsMenu(menu2);
            }
        }
        return bl;
    }

    public void dispatchReallyStop() {
        this.moveToState(2, false);
    }

    public void dispatchResume() {
        this.mStateSaved = false;
        this.moveToState(5, false);
    }

    public void dispatchStart() {
        this.mStateSaved = false;
        this.moveToState(4, false);
    }

    public void dispatchStop() {
        this.mStateSaved = true;
        this.moveToState(3, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        String string3 = string2 + "    ";
        if (this.mActive != null && (n6 = this.mActive.size()) > 0) {
            printWriter.print(string2);
            printWriter.print("Active Fragments in ");
            printWriter.print(Integer.toHexString(System.identityHashCode(this)));
            printWriter.println(":");
            for (int i = 0; i < n6; ++i) {
                Fragment fragment = this.mActive.get(i);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(i);
                printWriter.print(": ");
                printWriter.println(fragment);
                if (fragment == null) continue;
                fragment.dump(string3, fileDescriptor, printWriter, stringArray);
            }
        }
        if (this.mAdded != null && (n5 = this.mAdded.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Added Fragments:");
            for (int i = 0; i < n5; ++i) {
                Fragment fragment = this.mAdded.get(i);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(i);
                printWriter.print(": ");
                printWriter.println(fragment.toString());
            }
        }
        if (this.mCreatedMenus != null && (n4 = this.mCreatedMenus.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Fragments Created Menus:");
            for (int i = 0; i < n4; ++i) {
                Fragment fragment = this.mCreatedMenus.get(i);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(i);
                printWriter.print(": ");
                printWriter.println(fragment.toString());
            }
        }
        if (this.mBackStack != null && (n3 = this.mBackStack.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Back Stack:");
            for (int i = 0; i < n3; ++i) {
                BackStackRecord backStackRecord = this.mBackStack.get(i);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(i);
                printWriter.print(": ");
                printWriter.println(backStackRecord.toString());
                backStackRecord.dump(string3, fileDescriptor, printWriter, stringArray);
            }
        }
        // MONITORENTER : this
        if (this.mBackStackIndices != null && (n2 = this.mBackStackIndices.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Back Stack Indices:");
            for (int i = 0; i < n2; ++i) {
                BackStackRecord backStackRecord = this.mBackStackIndices.get(i);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(i);
                printWriter.print(": ");
                printWriter.println(backStackRecord);
            }
        }
        if (this.mAvailBackStackIndices != null && this.mAvailBackStackIndices.size() > 0) {
            printWriter.print(string2);
            printWriter.print("mAvailBackStackIndices: ");
            printWriter.println(Arrays.toString(this.mAvailBackStackIndices.toArray()));
        }
        // MONITOREXIT : this
        if (this.mPendingActions != null && (n = this.mPendingActions.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Pending Actions:");
            for (int i = 0; i < n; ++i) {
                Runnable runnable = this.mPendingActions.get(i);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(i);
                printWriter.print(": ");
                printWriter.println(runnable);
            }
        }
        printWriter.print(string2);
        printWriter.println("FragmentManager misc state:");
        printWriter.print(string2);
        printWriter.print("  mCurState=");
        printWriter.print(this.mCurState);
        printWriter.print(" mStateSaved=");
        printWriter.print(this.mStateSaved);
        printWriter.print(" mDestroyed=");
        printWriter.println(this.mDestroyed);
        if (this.mNeedMenuInvalidate) {
            printWriter.print(string2);
            printWriter.print("  mNeedMenuInvalidate=");
            printWriter.println(this.mNeedMenuInvalidate);
        }
        if (this.mNoTransactionsBecause != null) {
            printWriter.print(string2);
            printWriter.print("  mNoTransactionsBecause=");
            printWriter.println(this.mNoTransactionsBecause);
        }
        if (this.mAvailIndices == null) return;
        if (this.mAvailIndices.size() <= 0) return;
        printWriter.print(string2);
        printWriter.print("  mAvailIndices: ");
        printWriter.println(Arrays.toString(this.mAvailIndices.toArray()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enqueueAction(Runnable runnable, boolean bl) {
        if (!bl) {
            this.checkStateLoss();
        }
        synchronized (this) {
            if (this.mActivity == null) {
                throw new IllegalStateException("Activity has been destroyed");
            }
            if (this.mPendingActions == null) {
                this.mPendingActions = new ArrayList();
            }
            this.mPendingActions.add(runnable);
            if (this.mPendingActions.size() == 1) {
                this.mActivity.mHandler.removeCallbacks(this.mExecCommit);
                this.mActivity.mHandler.post(this.mExecCommit);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execPendingActions() {
        boolean bl;
        block12: {
            boolean bl2;
            if (this.mExecutingActions) {
                throw new IllegalStateException("Recursive entry to executePendingTransactions");
            }
            if (Looper.myLooper() != this.mActivity.mHandler.getLooper()) {
                throw new IllegalStateException("Must be called from main thread of process");
            }
            bl = false;
            while (true) {
                int n;
                synchronized (this) {
                    if (this.mPendingActions == null || this.mPendingActions.size() == 0) {
                        // MONITOREXIT @DISABLED, blocks:[3, 4, 11] lbl9 : MonitorExitStatement: MONITOREXIT : this
                        if (!this.mHavePendingDeferredStart) break block12;
                        bl2 = false;
                        for (int i = 0; i < this.mActive.size(); ++i) {
                            Fragment fragment = this.mActive.get(i);
                            if (fragment == null || fragment.mLoaderManager == null) continue;
                            bl2 |= fragment.mLoaderManager.hasRunningLoaders();
                        }
                        break;
                    }
                    n = this.mPendingActions.size();
                    if (this.mTmpActions == null || this.mTmpActions.length < n) {
                        this.mTmpActions = new Runnable[n];
                    }
                    this.mPendingActions.toArray(this.mTmpActions);
                    this.mPendingActions.clear();
                    this.mActivity.mHandler.removeCallbacks(this.mExecCommit);
                }
                this.mExecutingActions = true;
                for (int i = 0; i < n; ++i) {
                    this.mTmpActions[i].run();
                    this.mTmpActions[i] = null;
                }
                this.mExecutingActions = false;
                bl = true;
            }
            if (!bl2) {
                this.mHavePendingDeferredStart = false;
                this.startPendingDeferredFragments();
            }
        }
        return bl;
    }

    @Override
    public boolean executePendingTransactions() {
        return this.execPendingActions();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Fragment findFragmentById(int n) {
        Fragment fragment;
        if (this.mAdded != null) {
            for (int i = -1 + this.mAdded.size(); i >= 0; --i) {
                fragment = this.mAdded.get(i);
                if (fragment == null || fragment.mFragmentId != n) continue;
                return fragment;
            }
        }
        if (this.mActive == null) return null;
        int n2 = -1 + this.mActive.size();
        while (n2 >= 0) {
            fragment = this.mActive.get(n2);
            if (fragment != null) {
                if (fragment.mFragmentId == n) return fragment;
            }
            --n2;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Fragment findFragmentByTag(String string2) {
        Fragment fragment;
        if (this.mAdded != null && string2 != null) {
            for (int i = -1 + this.mAdded.size(); i >= 0; --i) {
                fragment = this.mAdded.get(i);
                if (fragment == null || !string2.equals(fragment.mTag)) continue;
                return fragment;
            }
        }
        if (this.mActive == null) return null;
        if (string2 == null) return null;
        int n = -1 + this.mActive.size();
        while (n >= 0) {
            fragment = this.mActive.get(n);
            if (fragment != null) {
                if (string2.equals(fragment.mTag)) return fragment;
            }
            --n;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Fragment findFragmentByWho(String string2) {
        if (this.mActive == null) return null;
        if (string2 == null) return null;
        int n = -1 + this.mActive.size();
        while (n >= 0) {
            Fragment fragment = this.mActive.get(n);
            if (fragment != null && string2.equals(fragment.mWho)) {
                return fragment;
            }
            --n;
        }
        return null;
    }

    public void freeBackStackIndex(int n) {
        synchronized (this) {
            this.mBackStackIndices.set(n, null);
            if (this.mAvailBackStackIndices == null) {
                this.mAvailBackStackIndices = new ArrayList();
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)("Freeing back stack index " + n));
            }
            this.mAvailBackStackIndices.add(n);
            return;
        }
    }

    @Override
    public FragmentManager.BackStackEntry getBackStackEntryAt(int n) {
        return this.mBackStack.get(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getBackStackEntryCount() {
        if (this.mBackStack == null) return 0;
        return this.mBackStack.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Fragment getFragment(Bundle bundle, String string2) {
        int n = bundle.getInt(string2, -1);
        if (n == -1) {
            return null;
        }
        if (n >= this.mActive.size()) {
            throw new IllegalStateException("Fragement no longer exists for key " + string2 + ": index " + n);
        }
        Fragment fragment = this.mActive.get(n);
        if (fragment != null) return fragment;
        throw new IllegalStateException("Fragement no longer exists for key " + string2 + ": index " + n);
    }

    public void hideFragment(Fragment fragment, int n, int n2) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("hide: " + fragment));
        }
        if (!fragment.mHidden) {
            fragment.mHidden = true;
            if (fragment.mView != null) {
                Animation animation = this.loadAnimation(fragment, n, true, n2);
                if (animation != null) {
                    fragment.mView.startAnimation(animation);
                }
                fragment.mView.setVisibility(8);
            }
            if (fragment.mAdded && fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.onHiddenChanged(true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Animation loadAnimation(Fragment fragment, int n, boolean bl, int n2) {
        Animation animation;
        Animation animation2 = fragment.onCreateAnimation(n, bl, fragment.mNextAnim);
        if (animation2 != null) {
            return animation2;
        }
        if (fragment.mNextAnim != 0 && (animation = AnimationUtils.loadAnimation((Context)this.mActivity, (int)fragment.mNextAnim)) != null) {
            return animation;
        }
        if (n == 0) {
            return null;
        }
        int n3 = FragmentManagerImpl.transitToStyleIndex(n, bl);
        if (n3 < 0) {
            return null;
        }
        switch (n3) {
            default: {
                if (n2 == 0 && this.mActivity.getWindow() != null) {
                    n2 = this.mActivity.getWindow().getAttributes().windowAnimations;
                }
                if (n2 != 0) return null;
                return null;
            }
            case 1: {
                return FragmentManagerImpl.makeOpenCloseAnimation((Context)this.mActivity, 1.125f, 1.0f, 0.0f, 1.0f);
            }
            case 2: {
                return FragmentManagerImpl.makeOpenCloseAnimation((Context)this.mActivity, 1.0f, 0.975f, 1.0f, 0.0f);
            }
            case 3: {
                return FragmentManagerImpl.makeOpenCloseAnimation((Context)this.mActivity, 0.975f, 1.0f, 0.0f, 1.0f);
            }
            case 4: {
                return FragmentManagerImpl.makeOpenCloseAnimation((Context)this.mActivity, 1.0f, 1.075f, 1.0f, 0.0f);
            }
            case 5: {
                return FragmentManagerImpl.makeFadeAnimation((Context)this.mActivity, 0.0f, 1.0f);
            }
            case 6: {
                return FragmentManagerImpl.makeFadeAnimation((Context)this.mActivity, 1.0f, 0.0f);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void makeActive(Fragment fragment) {
        if (fragment.mIndex >= 0) {
            return;
        }
        if (this.mAvailIndices == null || this.mAvailIndices.size() <= 0) {
            if (this.mActive == null) {
                this.mActive = new ArrayList();
            }
            fragment.setIndex(this.mActive.size());
            this.mActive.add(fragment);
        } else {
            fragment.setIndex(this.mAvailIndices.remove(-1 + this.mAvailIndices.size()));
            this.mActive.set(fragment.mIndex, fragment);
        }
        if (!DEBUG) return;
        Log.v((String)TAG, (String)("Allocated fragment index " + fragment));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void makeInactive(Fragment fragment) {
        if (fragment.mIndex < 0) {
            return;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("Freeing fragment index " + fragment));
        }
        this.mActive.set(fragment.mIndex, null);
        if (this.mAvailIndices == null) {
            this.mAvailIndices = new ArrayList();
        }
        this.mAvailIndices.add(fragment.mIndex);
        this.mActivity.invalidateSupportFragmentIndex(fragment.mIndex);
        fragment.initState();
    }

    /*
     * Enabled aggressive block sorting
     */
    void moveToState(int n, int n2, int n3, boolean bl) {
        if (this.mActivity == null && n != 0) {
            throw new IllegalStateException("No activity");
        }
        if (!bl && this.mCurState == n) {
            return;
        }
        this.mCurState = n;
        if (this.mActive == null) return;
        boolean bl2 = false;
        for (int i = 0; i < this.mActive.size(); ++i) {
            Fragment fragment = this.mActive.get(i);
            if (fragment == null) continue;
            this.moveToState(fragment, n, n2, n3, false);
            if (fragment.mLoaderManager == null) continue;
            bl2 |= fragment.mLoaderManager.hasRunningLoaders();
        }
        if (!bl2) {
            this.startPendingDeferredFragments();
        }
        if (!this.mNeedMenuInvalidate) return;
        if (this.mActivity == null) return;
        if (this.mCurState != 5) return;
        this.mActivity.supportInvalidateOptionsMenu();
        this.mNeedMenuInvalidate = false;
    }

    void moveToState(int n, boolean bl) {
        this.moveToState(n, 0, 0, bl);
    }

    void moveToState(Fragment fragment) {
        this.moveToState(fragment, this.mCurState, 0, 0, false);
    }

    /*
     * Unable to fully structure code
     */
    void moveToState(final Fragment var1_1, int var2_2, int var3_3, int var4_4, boolean var5_5) {
        block67: {
            block66: {
                block65: {
                    if (!var1_1.mAdded && var2_2 > 1) {
                        var2_2 = 1;
                    }
                    if (var1_1.mRemoving && var2_2 > var1_1.mState) {
                        var2_2 = var1_1.mState;
                    }
                    if (var1_1.mDeferStart && var1_1.mState < 4 && var2_2 > 3) {
                        var2_2 = 3;
                    }
                    if (var1_1.mState >= var2_2) break block66;
                    if (var1_1.mFromLayout && !var1_1.mInLayout) lbl-1000:
                    // 2 sources

                    {
                        return;
                    }
                    if (var1_1.mAnimatingAway != null) {
                        var1_1.mAnimatingAway = null;
                        this.moveToState(var1_1, var1_1.mStateAfterAnimating, 0, 0, true);
                    }
                    switch (var1_1.mState) {
                        default: lbl-1000:
                        // 10 sources

                        {
                            while (true) {
                                var1_1.mState = var2_2;
                                ** continue;
                                break;
                            }
                        }
                        case 0: {
                            if (FragmentManagerImpl.DEBUG) {
                                Log.v((String)"FragmentManager", (String)("moveto CREATED: " + var1_1));
                            }
                            if (var1_1.mSavedFragmentState != null) {
                                var1_1.mSavedViewState = var1_1.mSavedFragmentState.getSparseParcelableArray("android:view_state");
                                var1_1.mTarget = this.getFragment(var1_1.mSavedFragmentState, "android:target_state");
                                if (var1_1.mTarget != null) {
                                    var1_1.mTargetRequestCode = var1_1.mSavedFragmentState.getInt("android:target_req_state", 0);
                                }
                                var1_1.mUserVisibleHint = var1_1.mSavedFragmentState.getBoolean("android:user_visible_hint", true);
                                if (!var1_1.mUserVisibleHint) {
                                    var1_1.mDeferStart = true;
                                    if (var2_2 > 3) {
                                        var2_2 = 3;
                                    }
                                }
                            }
                            var1_1.mActivity = this.mActivity;
                            var1_1.mFragmentManager = this.mActivity.mFragments;
                            var1_1.mCalled = false;
                            var1_1.onAttach(this.mActivity);
                            if (!var1_1.mCalled) {
                                throw new SuperNotCalledException("Fragment " + var1_1 + " did not call through to super.onAttach()");
                            }
                            this.mActivity.onAttachFragment(var1_1);
                            if (!var1_1.mRetaining) {
                                var1_1.mCalled = false;
                                var1_1.onCreate(var1_1.mSavedFragmentState);
                                if (!var1_1.mCalled) {
                                    throw new SuperNotCalledException("Fragment " + var1_1 + " did not call through to super.onCreate()");
                                }
                            }
                            var1_1.mRetaining = false;
                            if (var1_1.mFromLayout) {
                                var1_1.mView = var1_1.onCreateView(var1_1.getLayoutInflater(var1_1.mSavedFragmentState), null, var1_1.mSavedFragmentState);
                                if (var1_1.mView == null) break;
                                var1_1.mInnerView = var1_1.mView;
                                var1_1.mView = NoSaveStateFrameLayout.wrap(var1_1.mView);
                                if (var1_1.mHidden) {
                                    var1_1.mView.setVisibility(8);
                                }
                                var1_1.onViewCreated(var1_1.mView, var1_1.mSavedFragmentState);
                            }
                        }
                        case 1: lbl-1000:
                        // 2 sources

                        {
                            while (var2_2 > 1) {
                                if (FragmentManagerImpl.DEBUG) {
                                    Log.v((String)"FragmentManager", (String)("moveto ACTIVITY_CREATED: " + var1_1));
                                }
                                if (!var1_1.mFromLayout) {
                                    var15_6 = null;
                                    if (var1_1.mContainerId != 0 && (var15_6 = (ViewGroup)this.mActivity.findViewById(var1_1.mContainerId)) == null && !var1_1.mRestored) {
                                        throw new IllegalArgumentException("No view found for id 0x" + Integer.toHexString(var1_1.mContainerId) + " for fragment " + var1_1);
                                    }
                                    break block65;
                                }
                                ** GOTO lbl82
                            }
                            ** GOTO lbl-1000
                        }
                    }
                    var1_1.mInnerView = null;
                    ** GOTO lbl-1000
                }
                var1_1.mContainer = var15_6;
                var1_1.mView = var1_1.onCreateView(var1_1.getLayoutInflater(var1_1.mSavedFragmentState), var15_6, var1_1.mSavedFragmentState);
                if (var1_1.mView != null) {
                    var1_1.mInnerView = var1_1.mView;
                    var1_1.mView = NoSaveStateFrameLayout.wrap(var1_1.mView);
                    if (var15_6 != null) {
                        var16_7 = this.loadAnimation(var1_1, var3_3, true, var4_4);
                        if (var16_7 != null) {
                            var1_1.mView.startAnimation(var16_7);
                        }
                        var15_6.addView(var1_1.mView);
                    }
                    if (var1_1.mHidden) {
                        var1_1.mView.setVisibility(8);
                    }
                    var1_1.onViewCreated(var1_1.mView, var1_1.mSavedFragmentState);
lbl82:
                    // 3 sources

                    while (true) {
                        var1_1.mCalled = false;
                        var1_1.onActivityCreated(var1_1.mSavedFragmentState);
                        if (!var1_1.mCalled) {
                            throw new SuperNotCalledException("Fragment " + var1_1 + " did not call through to super.onActivityCreated()");
                        }
                        break;
                    }
                } else {
                    var1_1.mInnerView = null;
                    ** continue;
                }
                if (var1_1.mView != null) {
                    var1_1.restoreViewState();
                }
                var1_1.mSavedFragmentState = null;
lbl-1000:
                // 3 sources

                {
                    case 2: 
                    case 3: {
                        if (var2_2 <= 3) break;
                        if (FragmentManagerImpl.DEBUG) {
                            Log.v((String)"FragmentManager", (String)("moveto STARTED: " + var1_1));
                        }
                        var1_1.mCalled = false;
                        var1_1.performStart();
                        if (var1_1.mCalled) break;
                        throw new SuperNotCalledException("Fragment " + var1_1 + " did not call through to super.onStart()");
                    }
                    ** case 4:
                }
lbl103:
                // 3 sources

                if (var2_2 <= 4) ** GOTO lbl-1000
                if (FragmentManagerImpl.DEBUG) {
                    Log.v((String)"FragmentManager", (String)("moveto RESUMED: " + var1_1));
                }
                var1_1.mCalled = false;
                var1_1.mResumed = true;
                var1_1.onResume();
                if (!var1_1.mCalled) {
                    throw new SuperNotCalledException("Fragment " + var1_1 + " did not call through to super.onResume()");
                }
                var1_1.mSavedFragmentState = null;
                var1_1.mSavedViewState = null;
                ** GOTO lbl-1000
            }
            if (var1_1.mState <= var2_2) ** GOTO lbl-1000
            switch (var1_1.mState) {
                default: {
                    ** GOTO lbl-1000
                }
lbl120:
                // 3 sources

                case 1: {
                    if (var2_2 >= 1) ** GOTO lbl-1000
                    if (this.mDestroyed && var1_1.mAnimatingAway != null) {
                        var7_8 = var1_1.mAnimatingAway;
                        var1_1.mAnimatingAway = null;
                        var7_8.clearAnimation();
                    }
                    if (var1_1.mAnimatingAway == null) break;
                    var1_1.mStateAfterAnimating = var2_2;
                    var2_2 = 1;
                    ** GOTO lbl-1000
                }
                case 5: {
                    if (var2_2 < 5) {
                        if (FragmentManagerImpl.DEBUG) {
                            Log.v((String)"FragmentManager", (String)("movefrom RESUMED: " + var1_1));
                        }
                        var1_1.mCalled = false;
                        var1_1.onPause();
                        if (!var1_1.mCalled) {
                            throw new SuperNotCalledException("Fragment " + var1_1 + " did not call through to super.onPause()");
                        }
                        var1_1.mResumed = false;
                    }
                }
                case 4: {
                    if (var2_2 < 4) {
                        if (FragmentManagerImpl.DEBUG) {
                            Log.v((String)"FragmentManager", (String)("movefrom STARTED: " + var1_1));
                        }
                        var1_1.mCalled = false;
                        var1_1.performStop();
                        if (!var1_1.mCalled) {
                            throw new SuperNotCalledException("Fragment " + var1_1 + " did not call through to super.onStop()");
                        }
                    }
                }
                case 3: {
                    if (var2_2 < 3) {
                        if (FragmentManagerImpl.DEBUG) {
                            Log.v((String)"FragmentManager", (String)("movefrom STOPPED: " + var1_1));
                        }
                        var1_1.performReallyStop();
                    }
                }
                case 2: {
                    if (var2_2 >= 2) ** GOTO lbl120
                    if (FragmentManagerImpl.DEBUG) {
                        Log.v((String)"FragmentManager", (String)("movefrom ACTIVITY_CREATED: " + var1_1));
                    }
                    if (var1_1.mView != null && !this.mActivity.isFinishing() && var1_1.mSavedViewState == null) {
                        this.saveFragmentViewState(var1_1);
                    }
                    var1_1.mCalled = false;
                    var1_1.performDestroyView();
                    if (!var1_1.mCalled) {
                        throw new SuperNotCalledException("Fragment " + var1_1 + " did not call through to super.onDestroyView()");
                    }
                    if (var1_1.mView != null && var1_1.mContainer != null) {
                        var8_9 = null;
                        if (this.mCurState > 0 && !this.mDestroyed) {
                            var8_9 = this.loadAnimation(var1_1, var3_3, false, var4_4);
                        }
                        if (var8_9 != null) {
                            var1_1.mAnimatingAway = var1_1.mView;
                            var1_1.mStateAfterAnimating = var2_2;
                            var8_9.setAnimationListener(new Animation.AnimationListener(){

                                public void onAnimationEnd(Animation animation) {
                                    if (var1_1.mAnimatingAway != null) {
                                        var1_1.mAnimatingAway = null;
                                        FragmentManagerImpl.this.moveToState(var1_1, var1_1.mStateAfterAnimating, 0, 0, false);
                                    }
                                }

                                public void onAnimationRepeat(Animation animation) {
                                }

                                public void onAnimationStart(Animation animation) {
                                }
                            });
                            var1_1.mView.startAnimation(var8_9);
                        }
                        var1_1.mContainer.removeView(var1_1.mView);
                    }
                    var1_1.mContainer = null;
                    var1_1.mView = null;
                    var1_1.mInnerView = null;
                    ** GOTO lbl120
                }
            }
            if (FragmentManagerImpl.DEBUG) {
                Log.v((String)"FragmentManager", (String)("movefrom CREATED: " + var1_1));
            }
            if (!var1_1.mRetaining) {
                var1_1.mCalled = false;
                var1_1.onDestroy();
                if (!var1_1.mCalled) {
                    throw new SuperNotCalledException("Fragment " + var1_1 + " did not call through to super.onDestroy()");
                }
            }
            var1_1.mCalled = false;
            var1_1.onDetach();
            if (!var1_1.mCalled) {
                throw new SuperNotCalledException("Fragment " + var1_1 + " did not call through to super.onDetach()");
            }
            if (var5_5) ** GOTO lbl-1000
            if (var1_1.mRetaining) break block67;
            this.makeInactive(var1_1);
            ** GOTO lbl-1000
        }
        var1_1.mActivity = null;
        var1_1.mFragmentManager = null;
        ** while (true)
    }

    public void noteStateNotSaved() {
        this.mStateSaved = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void performPendingDeferredStart(Fragment fragment) {
        block4: {
            block3: {
                if (!fragment.mDeferStart) break block3;
                if (!this.mExecutingActions) break block4;
                this.mHavePendingDeferredStart = true;
            }
            return;
        }
        fragment.mDeferStart = false;
        this.moveToState(fragment, this.mCurState, 0, 0, false);
    }

    @Override
    public void popBackStack() {
        this.enqueueAction(new Runnable(){

            @Override
            public void run() {
                FragmentManagerImpl.this.popBackStackState(FragmentManagerImpl.this.mActivity.mHandler, null, -1, 0);
            }
        }, false);
    }

    @Override
    public void popBackStack(final int n, final int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("Bad id: " + n);
        }
        this.enqueueAction(new Runnable(){

            @Override
            public void run() {
                FragmentManagerImpl.this.popBackStackState(FragmentManagerImpl.this.mActivity.mHandler, null, n, n2);
            }
        }, false);
    }

    @Override
    public void popBackStack(final String string2, final int n) {
        this.enqueueAction(new Runnable(){

            @Override
            public void run() {
                FragmentManagerImpl.this.popBackStackState(FragmentManagerImpl.this.mActivity.mHandler, string2, -1, n);
            }
        }, false);
    }

    @Override
    public boolean popBackStackImmediate() {
        this.checkStateLoss();
        this.executePendingTransactions();
        return this.popBackStackState(this.mActivity.mHandler, null, -1, 0);
    }

    @Override
    public boolean popBackStackImmediate(int n, int n2) {
        this.checkStateLoss();
        this.executePendingTransactions();
        if (n < 0) {
            throw new IllegalArgumentException("Bad id: " + n);
        }
        return this.popBackStackState(this.mActivity.mHandler, null, n, n2);
    }

    @Override
    public boolean popBackStackImmediate(String string2, int n) {
        this.checkStateLoss();
        this.executePendingTransactions();
        return this.popBackStackState(this.mActivity.mHandler, string2, -1, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean popBackStackState(Handler handler, String string2, int n, int n2) {
        int n3;
        boolean bl;
        block9: {
            bl = false;
            if (this.mBackStack == null) {
                return bl;
            }
            if (string2 == null && n < 0 && (n2 & 1) == 0) {
                int n4 = -1 + this.mBackStack.size();
                if (n4 < 0) return bl;
                this.mBackStack.remove(n4).popFromBackStack(true);
                this.reportBackStackChanged();
                return true;
            }
            n3 = -1;
            if (string2 == null && n < 0) break block9;
            for (n3 = -1 + this.mBackStack.size(); n3 >= 0; --n3) {
                BackStackRecord backStackRecord = this.mBackStack.get(n3);
                if (string2 != null && string2.equals(backStackRecord.getName()) || n >= 0 && n == backStackRecord.mIndex) break;
            }
            if (n3 < 0) return bl;
            if ((n2 & 1) != 0) {
                --n3;
                while (n3 >= 0) {
                    BackStackRecord backStackRecord = this.mBackStack.get(n3);
                    if ((string2 == null || !string2.equals(backStackRecord.getName())) && (n < 0 || n != backStackRecord.mIndex)) break;
                    --n3;
                }
            }
        }
        if (n3 == -1 + this.mBackStack.size()) return bl;
        ArrayList<BackStackRecord> arrayList = new ArrayList<BackStackRecord>();
        for (int i = -1 + this.mBackStack.size(); i > n3; --i) {
            arrayList.add(this.mBackStack.remove(i));
        }
        int n5 = -1 + arrayList.size();
        for (int i = 0; i <= n5; ++i) {
            if (DEBUG) {
                Log.v((String)TAG, (String)("Popping back stack state: " + arrayList.get(i)));
            }
            BackStackRecord backStackRecord = (BackStackRecord)arrayList.get(i);
            boolean bl2 = i == n5 ? true : bl;
            backStackRecord.popFromBackStack(bl2);
        }
        this.reportBackStackChanged();
        return true;
    }

    @Override
    public void putFragment(Bundle bundle, String string2, Fragment fragment) {
        if (fragment.mIndex < 0) {
            throw new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager");
        }
        bundle.putInt(string2, fragment.mIndex);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeFragment(Fragment fragment, int n, int n2) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("remove: " + fragment + " nesting=" + fragment.mBackStackNesting));
        }
        boolean bl = !fragment.isInBackStack();
        if (!fragment.mDetached || bl) {
            if (this.mAdded != null) {
                this.mAdded.remove(fragment);
            }
            if (fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.mAdded = false;
            fragment.mRemoving = true;
            int n3 = bl ? 0 : 1;
            this.moveToState(fragment, n3, n, n2, false);
        }
    }

    @Override
    public void removeOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener onBackStackChangedListener) {
        if (this.mBackStackChangeListeners != null) {
            this.mBackStackChangeListeners.remove(onBackStackChangedListener);
        }
    }

    void reportBackStackChanged() {
        if (this.mBackStackChangeListeners != null) {
            for (int i = 0; i < this.mBackStackChangeListeners.size(); ++i) {
                this.mBackStackChangeListeners.get(i).onBackStackChanged();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void restoreAllState(Parcelable parcelable, ArrayList<Fragment> arrayList) {
        if (parcelable == null) {
            return;
        }
        FragmentManagerState fragmentManagerState = (FragmentManagerState)parcelable;
        if (fragmentManagerState.mActive == null) return;
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Fragment fragment = arrayList.get(i);
                if (DEBUG) {
                    Log.v((String)TAG, (String)("restoreAllState: re-attaching retained " + fragment));
                }
                FragmentState fragmentState = fragmentManagerState.mActive[fragment.mIndex];
                fragmentState.mInstance = fragment;
                fragment.mSavedViewState = null;
                fragment.mBackStackNesting = 0;
                fragment.mInLayout = false;
                fragment.mAdded = false;
                fragment.mTarget = null;
                if (fragmentState.mSavedFragmentState == null) continue;
                fragmentState.mSavedFragmentState.setClassLoader(this.mActivity.getClassLoader());
                fragment.mSavedViewState = fragmentState.mSavedFragmentState.getSparseParcelableArray(VIEW_STATE_TAG);
            }
        }
        this.mActive = new ArrayList(fragmentManagerState.mActive.length);
        if (this.mAvailIndices != null) {
            this.mAvailIndices.clear();
        }
        for (int i = 0; i < fragmentManagerState.mActive.length; ++i) {
            FragmentState fragmentState = fragmentManagerState.mActive[i];
            if (fragmentState != null) {
                Fragment fragment = fragmentState.instantiate(this.mActivity);
                if (DEBUG) {
                    Log.v((String)TAG, (String)("restoreAllState: adding #" + i + ": " + fragment));
                }
                this.mActive.add(fragment);
                fragmentState.mInstance = null;
                continue;
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)("restoreAllState: adding #" + i + ": (null)"));
            }
            this.mActive.add(null);
            if (this.mAvailIndices == null) {
                this.mAvailIndices = new ArrayList();
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)("restoreAllState: adding avail #" + i));
            }
            this.mAvailIndices.add(i);
        }
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Fragment fragment = arrayList.get(i);
                if (fragment.mTargetIndex < 0) continue;
                if (fragment.mTargetIndex < this.mActive.size()) {
                    fragment.mTarget = this.mActive.get(fragment.mTargetIndex);
                    continue;
                }
                Log.w((String)TAG, (String)("Re-attaching retained fragment " + fragment + " target no longer exists: " + fragment.mTargetIndex));
                fragment.mTarget = null;
            }
        }
        if (fragmentManagerState.mAdded == null) {
            this.mAdded = null;
        } else {
            this.mAdded = new ArrayList(fragmentManagerState.mAdded.length);
            for (int i = 0; i < fragmentManagerState.mAdded.length; ++i) {
                Fragment fragment = this.mActive.get(fragmentManagerState.mAdded[i]);
                if (fragment == null) {
                    throw new IllegalStateException("No instantiated fragment for index #" + fragmentManagerState.mAdded[i]);
                }
                fragment.mAdded = true;
                if (DEBUG) {
                    Log.v((String)TAG, (String)("restoreAllState: making added #" + i + ": " + fragment));
                }
                this.mAdded.add(fragment);
            }
        }
        if (fragmentManagerState.mBackStack == null) {
            this.mBackStack = null;
            return;
        }
        this.mBackStack = new ArrayList(fragmentManagerState.mBackStack.length);
        int n = 0;
        while (n < fragmentManagerState.mBackStack.length) {
            BackStackRecord backStackRecord = fragmentManagerState.mBackStack[n].instantiate(this);
            if (DEBUG) {
                Log.v((String)TAG, (String)("restoreAllState: adding bse #" + n + " (index " + backStackRecord.mIndex + "): " + backStackRecord));
            }
            this.mBackStack.add(backStackRecord);
            if (backStackRecord.mIndex >= 0) {
                this.setBackStackIndex(backStackRecord.mIndex, backStackRecord);
            }
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    ArrayList<Fragment> retainNonConfig() {
        ArrayList<Fragment> arrayList = null;
        if (this.mActive != null) {
            for (int i = 0; i < this.mActive.size(); ++i) {
                Fragment fragment = this.mActive.get(i);
                if (fragment == null || !fragment.mRetainInstance) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<Fragment>();
                }
                arrayList.add(fragment);
                fragment.mRetaining = true;
                int n = fragment.mTarget != null ? fragment.mTarget.mIndex : -1;
                fragment.mTargetIndex = n;
                if (!DEBUG) continue;
                Log.v((String)TAG, (String)("retainNonConfig: keeping retained " + fragment));
            }
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    Parcelable saveAllState() {
        int n;
        int n2;
        FragmentManagerState fragmentManagerState = null;
        this.execPendingActions();
        if (HONEYCOMB) {
            this.mStateSaved = true;
        }
        if (this.mActive == null) return fragmentManagerState;
        if (this.mActive.size() <= 0) {
            return fragmentManagerState;
        }
        int n3 = this.mActive.size();
        FragmentState[] fragmentStateArray = new FragmentState[n3];
        boolean bl = false;
        for (int i = 0; i < n3; ++i) {
            FragmentState fragmentState;
            Fragment fragment;
            block15: {
                block14: {
                    fragment = this.mActive.get(i);
                    if (fragment == null) continue;
                    if (fragment.mIndex < 0) {
                        String string2 = "Failure saving state: active " + fragment + " has cleared index: " + fragment.mIndex;
                        Log.e((String)TAG, (String)string2);
                        this.dump("  ", (FileDescriptor)((Object)fragmentManagerState), new PrintWriter(new LogWriter(TAG)), new String[0]);
                        throw new IllegalStateException(string2);
                    }
                    bl = true;
                    fragmentStateArray[i] = fragmentState = new FragmentState(fragment);
                    if (fragment.mState <= 0 || fragmentState.mSavedFragmentState != null) break block14;
                    fragmentState.mSavedFragmentState = this.saveFragmentBasicState(fragment);
                    if (fragment.mTarget != null) {
                        if (fragment.mTarget.mIndex < 0) {
                            String string3 = "Failure saving state: " + fragment + " has target not in fragment manager: " + fragment.mTarget;
                            Log.e((String)TAG, (String)string3);
                            this.dump("  ", (FileDescriptor)((Object)fragmentManagerState), new PrintWriter(new LogWriter(TAG)), new String[0]);
                            throw new IllegalStateException(string3);
                        }
                        if (fragmentState.mSavedFragmentState == null) {
                            fragmentState.mSavedFragmentState = new Bundle();
                        }
                        this.putFragment(fragmentState.mSavedFragmentState, TARGET_STATE_TAG, fragment.mTarget);
                        if (fragment.mTargetRequestCode != 0) {
                            fragmentState.mSavedFragmentState.putInt(TARGET_REQUEST_CODE_STATE_TAG, fragment.mTargetRequestCode);
                        }
                    }
                    break block15;
                }
                fragmentState.mSavedFragmentState = fragment.mSavedFragmentState;
            }
            if (!DEBUG) continue;
            Log.v((String)TAG, (String)("Saved state of " + fragment + ": " + fragmentState.mSavedFragmentState));
        }
        if (!bl) {
            if (!DEBUG) return fragmentManagerState;
            Log.v((String)TAG, (String)"saveAllState: no fragments!");
            return fragmentManagerState;
        }
        int[] nArray = null;
        BackStackState[] backStackStateArray = null;
        if (this.mAdded != null && (n2 = this.mAdded.size()) > 0) {
            nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                nArray[i] = this.mAdded.get((int)i).mIndex;
                if (nArray[i] < 0) {
                    String string4 = "Failure saving state: active " + this.mAdded.get(i) + " has cleared index: " + nArray[i];
                    Log.e((String)TAG, (String)string4);
                    this.dump("  ", (FileDescriptor)((Object)fragmentManagerState), new PrintWriter(new LogWriter(TAG)), new String[0]);
                    throw new IllegalStateException(string4);
                }
                if (!DEBUG) continue;
                Log.v((String)TAG, (String)("saveAllState: adding fragment #" + i + ": " + this.mAdded.get(i)));
            }
        }
        if (this.mBackStack != null && (n = this.mBackStack.size()) > 0) {
            backStackStateArray = new BackStackState[n];
            for (int i = 0; i < n; ++i) {
                backStackStateArray[i] = new BackStackState(this, this.mBackStack.get(i));
                if (!DEBUG) continue;
                Log.v((String)TAG, (String)("saveAllState: adding back stack #" + i + ": " + this.mBackStack.get(i)));
            }
        }
        fragmentManagerState = new FragmentManagerState();
        fragmentManagerState.mActive = fragmentStateArray;
        fragmentManagerState.mAdded = nArray;
        fragmentManagerState.mBackStack = backStackStateArray;
        return fragmentManagerState;
    }

    Bundle saveFragmentBasicState(Fragment fragment) {
        Bundle bundle = null;
        if (this.mStateBundle == null) {
            this.mStateBundle = new Bundle();
        }
        fragment.onSaveInstanceState(this.mStateBundle);
        if (!this.mStateBundle.isEmpty()) {
            bundle = this.mStateBundle;
            this.mStateBundle = null;
        }
        if (fragment.mView != null) {
            this.saveFragmentViewState(fragment);
        }
        if (fragment.mSavedViewState != null) {
            if (bundle == null) {
                bundle = new Bundle();
            }
            bundle.putSparseParcelableArray(VIEW_STATE_TAG, fragment.mSavedViewState);
        }
        if (!fragment.mUserVisibleHint) {
            if (bundle == null) {
                bundle = new Bundle();
            }
            bundle.putBoolean(USER_VISIBLE_HINT_TAG, fragment.mUserVisibleHint);
        }
        return bundle;
    }

    @Override
    public Fragment.SavedState saveFragmentInstanceState(Fragment fragment) {
        Bundle bundle;
        Fragment.SavedState savedState = null;
        if (fragment.mIndex < 0) {
            throw new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager");
        }
        if (fragment.mState > 0 && (bundle = this.saveFragmentBasicState(fragment)) != null) {
            savedState = new Fragment.SavedState(bundle);
        }
        return savedState;
    }

    /*
     * Enabled aggressive block sorting
     */
    void saveFragmentViewState(Fragment fragment) {
        if (fragment.mInnerView == null) {
            return;
        }
        if (this.mStateArray == null) {
            this.mStateArray = new SparseArray();
        } else {
            this.mStateArray.clear();
        }
        fragment.mInnerView.saveHierarchyState(this.mStateArray);
        if (this.mStateArray.size() <= 0) return;
        fragment.mSavedViewState = this.mStateArray;
        this.mStateArray = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBackStackIndex(int n, BackStackRecord backStackRecord) {
        synchronized (this) {
            int n2;
            if (this.mBackStackIndices == null) {
                this.mBackStackIndices = new ArrayList();
            }
            if (n < (n2 = this.mBackStackIndices.size())) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Setting back stack index " + n + " to " + backStackRecord));
                }
                this.mBackStackIndices.set(n, backStackRecord);
            } else {
                while (n2 < n) {
                    this.mBackStackIndices.add(null);
                    if (this.mAvailBackStackIndices == null) {
                        this.mAvailBackStackIndices = new ArrayList();
                    }
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("Adding available back stack index " + n2));
                    }
                    this.mAvailBackStackIndices.add(n2);
                    ++n2;
                }
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Adding back stack index " + n + " with " + backStackRecord));
                }
                this.mBackStackIndices.add(backStackRecord);
            }
            return;
        }
    }

    public void showFragment(Fragment fragment, int n, int n2) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("show: " + fragment));
        }
        if (fragment.mHidden) {
            fragment.mHidden = false;
            if (fragment.mView != null) {
                Animation animation = this.loadAnimation(fragment, n, true, n2);
                if (animation != null) {
                    fragment.mView.startAnimation(animation);
                }
                fragment.mView.setVisibility(0);
            }
            if (fragment.mAdded && fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.onHiddenChanged(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void startPendingDeferredFragments() {
        if (this.mActive != null) {
            for (int i = 0; i < this.mActive.size(); ++i) {
                Fragment fragment = this.mActive.get(i);
                if (fragment == null) continue;
                this.performPendingDeferredStart(fragment);
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("FragmentManager{");
        stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
        stringBuilder.append(" in ");
        DebugUtils.buildShortClassTag((Object)this.mActivity, stringBuilder);
        stringBuilder.append("}}");
        return stringBuilder.toString();
    }
}

