/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.support.v4.app.ShareCompatICS;
import android.support.v4.app.ShareCompatJB;
import android.text.Html;
import android.text.Spanned;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import java.util.ArrayList;

public class ShareCompat {
    public static final String EXTRA_CALLING_ACTIVITY = "android.support.v4.app.EXTRA_CALLING_ACTIVITY";
    public static final String EXTRA_CALLING_PACKAGE = "android.support.v4.app.EXTRA_CALLING_PACKAGE";
    private static ShareCompatImpl IMPL;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        if (Build.VERSION.SDK_INT >= 16) {
            IMPL = new ShareCompatImplJB();
            return;
        }
        if (Build.VERSION.SDK_INT >= 14) {
            IMPL = new ShareCompatImplICS();
            return;
        }
        IMPL = new ShareCompatImplBase();
    }

    public static void configureMenuItem(Menu menu2, int n, IntentBuilder intentBuilder) {
        MenuItem menuItem = menu2.findItem(n);
        if (menuItem == null) {
            throw new IllegalArgumentException("Could not find menu item with id " + n + " in the supplied menu");
        }
        ShareCompat.configureMenuItem(menuItem, intentBuilder);
    }

    public static void configureMenuItem(MenuItem menuItem, IntentBuilder intentBuilder) {
        IMPL.configureMenuItem(menuItem, intentBuilder);
    }

    public static ComponentName getCallingActivity(Activity activity) {
        ComponentName componentName = activity.getCallingActivity();
        if (componentName == null) {
            componentName = (ComponentName)activity.getIntent().getParcelableExtra(EXTRA_CALLING_ACTIVITY);
        }
        return componentName;
    }

    public static String getCallingPackage(Activity activity) {
        String string2 = activity.getCallingPackage();
        if (string2 == null) {
            string2 = activity.getIntent().getStringExtra(EXTRA_CALLING_PACKAGE);
        }
        return string2;
    }

    public static class IntentReader {
        private static final String TAG = "IntentReader";
        private Activity mActivity;
        private ComponentName mCallingActivity;
        private String mCallingPackage;
        private Intent mIntent;
        private ArrayList<Uri> mStreams;

        private IntentReader(Activity activity) {
            this.mActivity = activity;
            this.mIntent = activity.getIntent();
            this.mCallingPackage = ShareCompat.getCallingPackage(activity);
            this.mCallingActivity = ShareCompat.getCallingActivity(activity);
        }

        public static IntentReader from(Activity activity) {
            return new IntentReader(activity);
        }

        public ComponentName getCallingActivity() {
            return this.mCallingActivity;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Drawable getCallingActivityIcon() {
            Drawable drawable2 = null;
            if (this.mCallingActivity == null) {
                return drawable2;
            }
            PackageManager packageManager = this.mActivity.getPackageManager();
            try {
                Drawable drawable3 = packageManager.getActivityIcon(this.mCallingActivity);
                return drawable3;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.e((String)TAG, (String)"Could not retrieve icon for calling activity", (Throwable)nameNotFoundException);
                return drawable2;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Drawable getCallingApplicationIcon() {
            Drawable drawable2 = null;
            if (this.mCallingPackage == null) {
                return drawable2;
            }
            PackageManager packageManager = this.mActivity.getPackageManager();
            try {
                Drawable drawable3 = packageManager.getApplicationIcon(this.mCallingPackage);
                return drawable3;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.e((String)TAG, (String)"Could not retrieve icon for calling application", (Throwable)nameNotFoundException);
                return drawable2;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public CharSequence getCallingApplicationLabel() {
            CharSequence charSequence = null;
            if (this.mCallingPackage == null) {
                return charSequence;
            }
            PackageManager packageManager = this.mActivity.getPackageManager();
            try {
                CharSequence charSequence2 = packageManager.getApplicationLabel(packageManager.getApplicationInfo(this.mCallingPackage, 0));
                return charSequence2;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.e((String)TAG, (String)"Could not retrieve label for calling application", (Throwable)nameNotFoundException);
                return charSequence;
            }
        }

        public String getCallingPackage() {
            return this.mCallingPackage;
        }

        public String[] getEmailBcc() {
            return this.mIntent.getStringArrayExtra("android.intent.extra.BCC");
        }

        public String[] getEmailCc() {
            return this.mIntent.getStringArrayExtra("android.intent.extra.CC");
        }

        public String[] getEmailTo() {
            return this.mIntent.getStringArrayExtra("android.intent.extra.EMAIL");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public String getHtmlText() {
            String string2 = this.mIntent.getStringExtra("android.intent.extra.HTML_TEXT");
            if (this.mIntent != null) return string2;
            CharSequence charSequence = this.getText();
            if (charSequence instanceof Spanned) {
                return Html.toHtml((Spanned)((Spanned)charSequence));
            }
            if (charSequence == null) return string2;
            return IMPL.escapeHtml(charSequence);
        }

        public Uri getStream() {
            return (Uri)this.mIntent.getParcelableExtra("android.intent.extra.STREAM");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Uri getStream(int n) {
            if (this.mStreams == null && this.isMultipleShare()) {
                this.mStreams = this.mIntent.getParcelableArrayListExtra("android.intent.extra.STREAM");
            }
            if (this.mStreams != null) {
                return this.mStreams.get(n);
            }
            if (n != 0) throw new IndexOutOfBoundsException("Stream items available: " + this.getStreamCount() + " index requested: " + n);
            return (Uri)this.mIntent.getParcelableExtra("android.intent.extra.STREAM");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getStreamCount() {
            if (this.mStreams == null && this.isMultipleShare()) {
                this.mStreams = this.mIntent.getParcelableArrayListExtra("android.intent.extra.STREAM");
            }
            if (this.mStreams != null) {
                return this.mStreams.size();
            }
            if (!this.mIntent.hasExtra("android.intent.extra.STREAM")) return 0;
            return 1;
        }

        public String getSubject() {
            return this.mIntent.getStringExtra("android.intent.extra.SUBJECT");
        }

        public CharSequence getText() {
            return this.mIntent.getCharSequenceExtra("android.intent.extra.TEXT");
        }

        public String getType() {
            return this.mIntent.getType();
        }

        public boolean isMultipleShare() {
            return this.mIntent.getAction().equals("android.intent.action.SEND_MULTIPLE");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean isShareIntent() {
            String string2 = this.mIntent.getAction();
            if (string2.equals("android.intent.action.SEND")) return true;
            if (!string2.equals("android.intent.action.SEND_MULTIPLE")) return false;
            return true;
        }

        public boolean isSingleShare() {
            return this.mIntent.getAction().equals("android.intent.action.SEND");
        }
    }

    public static class IntentBuilder {
        private Activity mActivity;
        private ArrayList<String> mBccAddresses;
        private ArrayList<String> mCcAddresses;
        private CharSequence mChooserTitle;
        private Intent mIntent;
        private ArrayList<Uri> mStreams;
        private ArrayList<String> mToAddresses;

        private IntentBuilder(Activity activity) {
            this.mActivity = activity;
            this.mIntent = new Intent().setAction("android.intent.action.SEND");
            this.mIntent.putExtra(ShareCompat.EXTRA_CALLING_PACKAGE, activity.getPackageName());
            this.mIntent.putExtra(ShareCompat.EXTRA_CALLING_ACTIVITY, (Parcelable)activity.getComponentName());
            this.mIntent.addFlags(524288);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void combineArrayExtra(String string2, ArrayList<String> arrayList) {
            String[] stringArray = this.mIntent.getStringArrayExtra(string2);
            int n = stringArray != null ? stringArray.length : 0;
            String[] stringArray2 = new String[n + arrayList.size()];
            arrayList.toArray(stringArray2);
            if (stringArray != null) {
                System.arraycopy(stringArray, 0, stringArray2, arrayList.size(), n);
            }
            this.mIntent.putExtra(string2, stringArray2);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void combineArrayExtra(String string2, String[] stringArray) {
            Intent intent = this.getIntent();
            String[] stringArray2 = intent.getStringArrayExtra(string2);
            int n = stringArray2 != null ? stringArray2.length : 0;
            String[] stringArray3 = new String[n + stringArray.length];
            if (stringArray2 != null) {
                System.arraycopy(stringArray2, 0, stringArray3, 0, n);
            }
            System.arraycopy(stringArray, 0, stringArray3, n, stringArray.length);
            intent.putExtra(string2, stringArray3);
        }

        public static IntentBuilder from(Activity activity) {
            return new IntentBuilder(activity);
        }

        public IntentBuilder addEmailBcc(String string2) {
            if (this.mBccAddresses == null) {
                this.mBccAddresses = new ArrayList();
            }
            this.mBccAddresses.add(string2);
            return this;
        }

        public IntentBuilder addEmailBcc(String[] stringArray) {
            this.combineArrayExtra("android.intent.extra.BCC", stringArray);
            return this;
        }

        public IntentBuilder addEmailCc(String string2) {
            if (this.mCcAddresses == null) {
                this.mCcAddresses = new ArrayList();
            }
            this.mCcAddresses.add(string2);
            return this;
        }

        public IntentBuilder addEmailCc(String[] stringArray) {
            this.combineArrayExtra("android.intent.extra.CC", stringArray);
            return this;
        }

        public IntentBuilder addEmailTo(String string2) {
            if (this.mToAddresses == null) {
                this.mToAddresses = new ArrayList();
            }
            this.mToAddresses.add(string2);
            return this;
        }

        public IntentBuilder addEmailTo(String[] stringArray) {
            this.combineArrayExtra("android.intent.extra.EMAIL", stringArray);
            return this;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public IntentBuilder addStream(Uri uri) {
            Uri uri2 = (Uri)this.mIntent.getParcelableExtra("android.intent.extra.STREAM");
            if (uri2 == null) {
                return this.setStream(uri);
            }
            if (this.mStreams == null) {
                this.mStreams = new ArrayList();
            }
            if (uri2 != null) {
                this.mIntent.removeExtra("android.intent.extra.STREAM");
                this.mStreams.add(uri2);
            }
            this.mStreams.add(uri);
            return this;
        }

        public Intent createChooserIntent() {
            return Intent.createChooser((Intent)this.getIntent(), (CharSequence)this.mChooserTitle);
        }

        Activity getActivity() {
            return this.mActivity;
        }

        /*
         * Enabled aggressive block sorting
         */
        public Intent getIntent() {
            int n = 1;
            if (this.mToAddresses != null) {
                this.combineArrayExtra("android.intent.extra.EMAIL", this.mToAddresses);
                this.mToAddresses = null;
            }
            if (this.mCcAddresses != null) {
                this.combineArrayExtra("android.intent.extra.CC", this.mCcAddresses);
                this.mCcAddresses = null;
            }
            if (this.mBccAddresses != null) {
                this.combineArrayExtra("android.intent.extra.BCC", this.mBccAddresses);
                this.mBccAddresses = null;
            }
            if (this.mStreams == null || this.mStreams.size() <= n) {
                n = 0;
            }
            boolean bl = this.mIntent.getAction().equals("android.intent.action.SEND_MULTIPLE");
            if (n == 0 && bl) {
                this.mIntent.setAction("android.intent.action.SEND");
                if (this.mStreams != null && !this.mStreams.isEmpty()) {
                    this.mIntent.putExtra("android.intent.extra.STREAM", (Parcelable)this.mStreams.get(0));
                } else {
                    this.mIntent.removeExtra("android.intent.extra.STREAM");
                }
                this.mStreams = null;
            }
            if (n == 0) return this.mIntent;
            if (bl) return this.mIntent;
            this.mIntent.setAction("android.intent.action.SEND_MULTIPLE");
            if (this.mStreams != null && !this.mStreams.isEmpty()) {
                this.mIntent.putParcelableArrayListExtra("android.intent.extra.STREAM", this.mStreams);
                return this.mIntent;
            }
            this.mIntent.removeExtra("android.intent.extra.STREAM");
            return this.mIntent;
        }

        public IntentBuilder setChooserTitle(int n) {
            return this.setChooserTitle(this.mActivity.getText(n));
        }

        public IntentBuilder setChooserTitle(CharSequence charSequence) {
            this.mChooserTitle = charSequence;
            return this;
        }

        public IntentBuilder setEmailBcc(String[] stringArray) {
            this.mIntent.putExtra("android.intent.extra.BCC", stringArray);
            return this;
        }

        public IntentBuilder setEmailCc(String[] stringArray) {
            this.mIntent.putExtra("android.intent.extra.CC", stringArray);
            return this;
        }

        public IntentBuilder setEmailTo(String[] stringArray) {
            if (this.mToAddresses != null) {
                this.mToAddresses = null;
            }
            this.mIntent.putExtra("android.intent.extra.EMAIL", stringArray);
            return this;
        }

        public IntentBuilder setHtmlText(String string2) {
            this.mIntent.putExtra("android.intent.extra.HTML_TEXT", string2);
            if (!this.mIntent.hasExtra("android.intent.extra.TEXT")) {
                this.setText((CharSequence)Html.fromHtml((String)string2));
            }
            return this;
        }

        public IntentBuilder setStream(Uri uri) {
            if (!this.mIntent.getAction().equals("android.intent.action.SEND")) {
                this.mIntent.setAction("android.intent.action.SEND");
            }
            this.mStreams = null;
            this.mIntent.putExtra("android.intent.extra.STREAM", (Parcelable)uri);
            return this;
        }

        public IntentBuilder setSubject(String string2) {
            this.mIntent.putExtra("android.intent.extra.SUBJECT", string2);
            return this;
        }

        public IntentBuilder setText(CharSequence charSequence) {
            this.mIntent.putExtra("android.intent.extra.TEXT", charSequence);
            return this;
        }

        public IntentBuilder setType(String string2) {
            this.mIntent.setType(string2);
            return this;
        }

        public void startChooser() {
            this.mActivity.startActivity(this.createChooserIntent());
        }
    }

    static class ShareCompatImplJB
    extends ShareCompatImplICS {
        ShareCompatImplJB() {
        }

        @Override
        public String escapeHtml(CharSequence charSequence) {
            return ShareCompatJB.escapeHtml(charSequence);
        }

        @Override
        boolean shouldAddChooserIntent(MenuItem menuItem) {
            return false;
        }
    }

    static class ShareCompatImplICS
    extends ShareCompatImplBase {
        ShareCompatImplICS() {
        }

        @Override
        public void configureMenuItem(MenuItem menuItem, IntentBuilder intentBuilder) {
            ShareCompatICS.configureMenuItem(menuItem, intentBuilder.getActivity(), intentBuilder.getIntent());
            if (this.shouldAddChooserIntent(menuItem)) {
                menuItem.setIntent(intentBuilder.createChooserIntent());
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean shouldAddChooserIntent(MenuItem menuItem) {
            if (menuItem.hasSubMenu()) return false;
            return true;
        }
    }

    static class ShareCompatImplBase
    implements ShareCompatImpl {
        ShareCompatImplBase() {
        }

        /*
         * Enabled aggressive block sorting
         */
        private static void withinStyle(StringBuilder stringBuilder, CharSequence charSequence, int n, int n2) {
            int n3 = n;
            while (n3 < n2) {
                char c = charSequence.charAt(n3);
                if (c == '<') {
                    stringBuilder.append("&lt;");
                } else if (c == '>') {
                    stringBuilder.append("&gt;");
                } else if (c == '&') {
                    stringBuilder.append("&amp;");
                } else if (c > '~' || c < ' ') {
                    stringBuilder.append("&#" + c + ";");
                } else if (c == ' ') {
                    while (n3 + 1 < n2 && charSequence.charAt(n3 + 1) == ' ') {
                        stringBuilder.append("&nbsp;");
                        ++n3;
                    }
                    stringBuilder.append(' ');
                } else {
                    stringBuilder.append(c);
                }
                ++n3;
            }
            return;
        }

        @Override
        public void configureMenuItem(MenuItem menuItem, IntentBuilder intentBuilder) {
            menuItem.setIntent(intentBuilder.createChooserIntent());
        }

        @Override
        public String escapeHtml(CharSequence charSequence) {
            StringBuilder stringBuilder = new StringBuilder();
            ShareCompatImplBase.withinStyle(stringBuilder, charSequence, 0, charSequence.length());
            return stringBuilder.toString();
        }
    }

    static interface ShareCompatImpl {
        public void configureMenuItem(MenuItem var1, IntentBuilder var2);

        public String escapeHtml(CharSequence var1);
    }
}

