/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.v4.view.PagerTitleStrip;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;

public class PagerTabStrip
extends PagerTitleStrip {
    private static final int FULL_UNDERLINE_HEIGHT = 1;
    private static final int INDICATOR_HEIGHT = 3;
    private static final int MIN_PADDING_BOTTOM = 6;
    private static final int MIN_STRIP_HEIGHT = 32;
    private static final int MIN_TEXT_SPACING = 64;
    private static final int TAB_PADDING = 16;
    private static final int TAB_SPACING = 32;
    private static final String TAG = "PagerTabStrip";
    private boolean mDrawFullUnderline = false;
    private boolean mDrawFullUnderlineSet = false;
    private int mFullUnderlineHeight;
    private boolean mIgnoreTap;
    private int mIndicatorColor;
    private int mIndicatorHeight;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private int mMinPaddingBottom;
    private int mMinStripHeight;
    private int mMinTextSpacing;
    private int mTabAlpha = 255;
    private int mTabPadding;
    private final Paint mTabPaint = new Paint();
    private final Rect mTempRect = new Rect();
    private int mTouchSlop;

    public PagerTabStrip(Context context) {
        this(context, null);
    }

    public PagerTabStrip(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mIndicatorColor = this.mTextColor;
        this.mTabPaint.setColor(this.mIndicatorColor);
        float f = context.getResources().getDisplayMetrics().density;
        this.mIndicatorHeight = (int)(0.5f + 3.0f * f);
        this.mMinPaddingBottom = (int)(0.5f + 6.0f * f);
        this.mMinTextSpacing = (int)(64.0f * f);
        this.mTabPadding = (int)(0.5f + 16.0f * f);
        this.mFullUnderlineHeight = (int)(0.5f + 1.0f * f);
        this.mMinStripHeight = (int)(0.5f + 32.0f * f);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.setPadding(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        this.setTextSpacing(this.getTextSpacing());
        this.setWillNotDraw(false);
        this.mPrevText.setFocusable(true);
        this.mPrevText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PagerTabStrip.this.mPager.setCurrentItem(-1 + PagerTabStrip.this.mPager.getCurrentItem());
            }
        });
        this.mNextText.setFocusable(true);
        this.mNextText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                PagerTabStrip.this.mPager.setCurrentItem(1 + PagerTabStrip.this.mPager.getCurrentItem());
            }
        });
        if (this.getBackground() == null) {
            this.mDrawFullUnderline = true;
        }
    }

    public boolean getDrawFullUnderline() {
        return this.mDrawFullUnderline;
    }

    @Override
    int getMinHeight() {
        return Math.max(super.getMinHeight(), this.mMinStripHeight);
    }

    public int getTabIndicatorColor() {
        return this.mIndicatorColor;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int n = this.getHeight();
        int n2 = this.mCurrText.getLeft() - this.mTabPadding;
        int n3 = this.mCurrText.getRight() + this.mTabPadding;
        int n4 = n - this.mIndicatorHeight;
        this.mTabPaint.setColor(this.mTabAlpha << 24 | 0xFFFFFF & this.mIndicatorColor);
        canvas.drawRect((float)n2, (float)n4, (float)n3, (float)n, this.mTabPaint);
        if (this.mDrawFullUnderline) {
            this.mTabPaint.setColor(0xFF000000 | 0xFFFFFF & this.mIndicatorColor);
            canvas.drawRect(0.0f, (float)(n - this.mFullUnderlineHeight), (float)this.getWidth(), (float)n, this.mTabPaint);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean bl = false;
        int n = motionEvent.getAction();
        if (n != 0 && this.mIgnoreTap) {
            return bl;
        }
        float f = motionEvent.getX();
        float f2 = motionEvent.getY();
        switch (n) {
            case 0: {
                this.mInitialMotionX = f;
                this.mInitialMotionY = f2;
                this.mIgnoreTap = bl;
                return true;
            }
            case 2: {
                if (!(Math.abs(f - this.mInitialMotionX) > (float)this.mTouchSlop)) {
                    if (!(Math.abs(f2 - this.mInitialMotionY) > (float)this.mTouchSlop)) return true;
                }
                this.mIgnoreTap = true;
                return true;
            }
            case 1: {
                if (f < (float)(this.mCurrText.getLeft() - this.mTabPadding)) {
                    this.mPager.setCurrentItem(-1 + this.mPager.getCurrentItem());
                    return true;
                }
                if (!(f > (float)(this.mCurrText.getRight() + this.mTabPadding))) return true;
                this.mPager.setCurrentItem(1 + this.mPager.getCurrentItem());
                return true;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setBackgroundColor(int n) {
        super.setBackgroundColor(n);
        if (!this.mDrawFullUnderlineSet) {
            boolean bl = (0xFF000000 & n) == 0;
            this.mDrawFullUnderline = bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setBackgroundDrawable(Drawable drawable2) {
        super.setBackgroundDrawable(drawable2);
        if (!this.mDrawFullUnderlineSet) {
            boolean bl = drawable2 == null;
            this.mDrawFullUnderline = bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setBackgroundResource(int n) {
        super.setBackgroundResource(n);
        if (!this.mDrawFullUnderlineSet) {
            boolean bl = n == 0;
            this.mDrawFullUnderline = bl;
        }
    }

    public void setDrawFullUnderline(boolean bl) {
        this.mDrawFullUnderline = bl;
        this.mDrawFullUnderlineSet = true;
        this.invalidate();
    }

    public void setPadding(int n, int n2, int n3, int n4) {
        if (n4 < this.mMinPaddingBottom) {
            n4 = this.mMinPaddingBottom;
        }
        super.setPadding(n, n2, n3, n4);
    }

    public void setTabIndicatorColor(int n) {
        this.mIndicatorColor = n;
        this.mTabPaint.setColor(this.mIndicatorColor);
        this.invalidate();
    }

    public void setTabIndicatorColorResource(int n) {
        this.setTabIndicatorColor(this.getContext().getResources().getColor(n));
    }

    @Override
    public void setTextSpacing(int n) {
        if (n < this.mMinTextSpacing) {
            n = this.mMinTextSpacing;
        }
        super.setTextSpacing(n);
    }

    @Override
    void updateTextPositions(int n, float f, boolean bl) {
        Rect rect = this.mTempRect;
        int n2 = this.getHeight();
        int n3 = this.mCurrText.getLeft() - this.mTabPadding;
        int n4 = this.mCurrText.getRight() + this.mTabPadding;
        int n5 = n2 - this.mIndicatorHeight;
        rect.set(n3, n5, n4, n2);
        super.updateTextPositions(n, f, bl);
        this.mTabAlpha = (int)(255.0f * (2.0f * Math.abs(f - 0.5f)));
        rect.union(this.mCurrText.getLeft() - this.mTabPadding, n5, this.mCurrText.getRight() + this.mTabPadding, n2);
        this.invalidate(rect);
    }
}

