/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.v4.os.ParcelableCompat;
import android.support.v4.os.ParcelableCompatCreatorCallbacks;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.KeyEventCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.VelocityTrackerCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewConfigurationCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.widget.EdgeEffectCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class ViewPager
extends ViewGroup {
    private static final int CLOSE_ENOUGH = 2;
    private static final Comparator<ItemInfo> COMPARATOR;
    private static final boolean DEBUG = false;
    private static final int DEFAULT_GUTTER_SIZE = 16;
    private static final int DEFAULT_OFFSCREEN_PAGES = 1;
    private static final int INVALID_POINTER = -1;
    private static final int[] LAYOUT_ATTRS;
    private static final int MAX_SETTLE_DURATION = 600;
    private static final int MIN_DISTANCE_FOR_FLING = 25;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_SETTLING = 2;
    private static final String TAG = "ViewPager";
    private static final boolean USE_CACHE;
    private static final Interpolator sInterpolator;
    private int mActivePointerId = -1;
    private PagerAdapter mAdapter;
    private OnAdapterChangeListener mAdapterChangeListener;
    private int mBottomPageBounds;
    private boolean mCalledSuper;
    private int mChildHeightMeasureSpec;
    private int mChildWidthMeasureSpec;
    private int mCloseEnough;
    private int mCurItem;
    private int mDecorChildCount;
    private int mDefaultGutterSize;
    private long mFakeDragBeginTime;
    private boolean mFakeDragging;
    private boolean mFirstLayout = true;
    private float mFirstOffset = -3.4028235E38f;
    private int mFlingDistance;
    private int mGutterSize;
    private boolean mIgnoreGutter;
    private boolean mInLayout;
    private float mInitialMotionX;
    private OnPageChangeListener mInternalPageChangeListener;
    private boolean mIsBeingDragged;
    private boolean mIsUnableToDrag;
    private final ArrayList<ItemInfo> mItems = new ArrayList();
    private float mLastMotionX;
    private float mLastMotionY;
    private float mLastOffset;
    private EdgeEffectCompat mLeftEdge;
    private Drawable mMarginDrawable;
    private int mMaximumVelocity;
    private int mMinimumVelocity;
    private boolean mNeedCalculatePageOffsets = false;
    private PagerObserver mObserver;
    private int mOffscreenPageLimit = 1;
    private OnPageChangeListener mOnPageChangeListener;
    private int mPageMargin;
    private boolean mPopulatePending;
    private Parcelable mRestoredAdapterState = null;
    private ClassLoader mRestoredClassLoader = null;
    private int mRestoredCurItem = -1;
    private EdgeEffectCompat mRightEdge;
    private int mScrollState = 0;
    private Scroller mScroller;
    private boolean mScrollingCacheEnabled;
    private final ItemInfo mTempItem = new ItemInfo();
    private final Rect mTempRect = new Rect();
    private int mTopPageBounds;
    private int mTouchSlop;
    private VelocityTracker mVelocityTracker;

    static {
        int[] nArray = new int[]{16842931};
        LAYOUT_ATTRS = nArray;
        COMPARATOR = new Comparator<ItemInfo>(){

            @Override
            public int compare(ItemInfo itemInfo, ItemInfo itemInfo2) {
                return itemInfo.position - itemInfo2.position;
            }
        };
        sInterpolator = new Interpolator(){

            public float getInterpolation(float f) {
                float f2 = f - 1.0f;
                return 1.0f + f2 * (f2 * (f2 * (f2 * f2)));
            }
        };
    }

    public ViewPager(Context context) {
        super(context);
        this.mLastOffset = Float.MAX_VALUE;
        this.initViewPager();
    }

    public ViewPager(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mLastOffset = Float.MAX_VALUE;
        this.initViewPager();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void calculatePageOffsets(ItemInfo itemInfo, int n, ItemInfo itemInfo2) {
        float f;
        int n2;
        block12: {
            int n3;
            block15: {
                ItemInfo itemInfo3;
                float f2;
                int n4;
                block14: {
                    int n5;
                    block13: {
                        n2 = this.mAdapter.getCount();
                        int n6 = this.getWidth();
                        f = n6 > 0 ? (float)this.mPageMargin / (float)n6 : 0.0f;
                        if (itemInfo2 == null) break block12;
                        n5 = itemInfo2.position;
                        if (n5 >= itemInfo.position) break block13;
                        n4 = 0;
                        f2 = f + (itemInfo2.offset + itemInfo2.widthFactor);
                        break block14;
                    }
                    if (n5 <= itemInfo.position) break block12;
                    n3 = -1 + this.mItems.size();
                    float f3 = itemInfo2.offset;
                    break block15;
                }
                for (int i = n5 + 1; i <= itemInfo.position && n4 < this.mItems.size(); f2 += f + itemInfo3.widthFactor, ++i) {
                    itemInfo3 = this.mItems.get(n4);
                    while (i > itemInfo3.position && n4 < -1 + this.mItems.size()) {
                        itemInfo3 = this.mItems.get(++n4);
                    }
                    while (i < itemInfo3.position) {
                        f2 += f + this.mAdapter.getPageWidth(i);
                        ++i;
                    }
                    itemInfo3.offset = f2;
                }
                break block12;
            }
            for (int i = n5 + -1; i >= itemInfo.position && n3 >= 0; --i) {
                ItemInfo itemInfo4 = this.mItems.get(n3);
                while (i < itemInfo4.position && n3 > 0) {
                    itemInfo4 = this.mItems.get(--n3);
                }
                while (i > itemInfo4.position) {
                    f3 -= f + this.mAdapter.getPageWidth(i);
                    --i;
                }
                itemInfo4.offset = f3 -= f + itemInfo4.widthFactor;
            }
        }
        int n7 = this.mItems.size();
        float f4 = itemInfo.offset;
        int n8 = -1 + itemInfo.position;
        float f5 = itemInfo.position == 0 ? itemInfo.offset : -3.4028235E38f;
        this.mFirstOffset = f5;
        float f6 = itemInfo.position == n2 + -1 ? itemInfo.offset + itemInfo.widthFactor - 1.0f : Float.MAX_VALUE;
        this.mLastOffset = f6;
        for (int i = n + -1; i >= 0; --i, --n8) {
            ItemInfo itemInfo5 = this.mItems.get(i);
            while (n8 > itemInfo5.position) {
                PagerAdapter pagerAdapter = this.mAdapter;
                int n9 = n8 + -1;
                f4 -= f + pagerAdapter.getPageWidth(n8);
                n8 = n9;
            }
            itemInfo5.offset = f4 -= f + itemInfo5.widthFactor;
            if (itemInfo5.position != 0) continue;
            this.mFirstOffset = f4;
        }
        float f7 = f + (itemInfo.offset + itemInfo.widthFactor);
        int n10 = 1 + itemInfo.position;
        int n11 = n + 1;
        while (true) {
            if (n11 >= n7) {
                this.mNeedCalculatePageOffsets = false;
                return;
            }
            ItemInfo itemInfo6 = this.mItems.get(n11);
            while (n10 < itemInfo6.position) {
                PagerAdapter pagerAdapter = this.mAdapter;
                int n12 = n10 + 1;
                f7 += f + pagerAdapter.getPageWidth(n10);
                n10 = n12;
            }
            if (itemInfo6.position == n2 + -1) {
                this.mLastOffset = f7 + itemInfo6.widthFactor - 1.0f;
            }
            itemInfo6.offset = f7;
            f7 += f + itemInfo6.widthFactor;
            ++n11;
            ++n10;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void completeScroll() {
        boolean bl = this.mScrollState == 2;
        if (bl) {
            this.setScrollingCacheEnabled(false);
            this.mScroller.abortAnimation();
            int n = this.getScrollX();
            int n2 = this.getScrollY();
            int n3 = this.mScroller.getCurrX();
            int n4 = this.mScroller.getCurrY();
            if (n != n3 || n2 != n4) {
                this.scrollTo(n3, n4);
            }
            this.setScrollState(0);
        }
        this.mPopulatePending = false;
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo itemInfo = this.mItems.get(i);
            if (!itemInfo.scrolling) continue;
            bl = true;
            itemInfo.scrolling = false;
        }
        if (bl) {
            this.populate();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private int determineTargetPage(int n, float f, int n2, int n3) {
        int n4 = Math.abs(n3) > this.mFlingDistance && Math.abs(n2) > this.mMinimumVelocity ? (n2 > 0 ? n : n + 1) : (int)(0.5f + (f + (float)n));
        if (this.mItems.size() <= 0) return n4;
        ItemInfo itemInfo = this.mItems.get(0);
        ItemInfo itemInfo2 = this.mItems.get(-1 + this.mItems.size());
        return Math.max(itemInfo.position, Math.min(n4, itemInfo2.position));
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.mIsUnableToDrag = false;
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Rect getChildRectInPagerCoordinates(Rect rect, View view) {
        if (rect == null) {
            rect = new Rect();
        }
        if (view == null) {
            rect.set(0, 0, 0, 0);
            return rect;
        } else {
            rect.left = view.getLeft();
            rect.right = view.getRight();
            rect.top = view.getTop();
            rect.bottom = view.getBottom();
            ViewParent viewParent = view.getParent();
            while (viewParent instanceof ViewGroup && viewParent != this) {
                ViewGroup viewGroup = (ViewGroup)viewParent;
                rect.left += viewGroup.getLeft();
                rect.right += viewGroup.getRight();
                rect.top += viewGroup.getTop();
                rect.bottom += viewGroup.getBottom();
                viewParent = viewGroup.getParent();
            }
        }
        return rect;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ItemInfo infoForCurrentScrollPosition() {
        float f = 0.0f;
        int n = this.getWidth();
        float f2 = n > 0 ? (float)this.getScrollX() / (float)n : f;
        if (n > 0) {
            f = (float)this.mPageMargin / (float)n;
        }
        int n2 = -1;
        float f3 = 0.0f;
        float f4 = 0.0f;
        boolean bl = true;
        ItemInfo itemInfo = null;
        int n3 = 0;
        while (n3 < this.mItems.size()) {
            ItemInfo itemInfo2 = this.mItems.get(n3);
            if (!bl && itemInfo2.position != n2 + 1) {
                itemInfo2 = this.mTempItem;
                itemInfo2.offset = f + (f3 + f4);
                itemInfo2.position = n2 + 1;
                itemInfo2.widthFactor = this.mAdapter.getPageWidth(itemInfo2.position);
                --n3;
            }
            float f5 = itemInfo2.offset;
            float f6 = f + (f5 + itemInfo2.widthFactor);
            if (!bl) {
                if (!(f2 >= f5)) return itemInfo;
            }
            if (f2 < f6) return itemInfo2;
            if (n3 == -1 + this.mItems.size()) {
                return itemInfo2;
            }
            bl = false;
            n2 = itemInfo2.position;
            f3 = f5;
            f4 = itemInfo2.widthFactor;
            itemInfo = itemInfo2;
            ++n3;
        }
        return itemInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isGutterDrag(float f, float f2) {
        if (f < (float)this.mGutterSize) {
            if (f2 > 0.0f) return true;
        }
        if (!(f > (float)(this.getWidth() - this.mGutterSize))) return false;
        if (!(f2 < 0.0f)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        int n = MotionEventCompat.getActionIndex(motionEvent);
        if (MotionEventCompat.getPointerId(motionEvent, n) == this.mActivePointerId) {
            int n2 = n == 0 ? 1 : 0;
            this.mLastMotionX = MotionEventCompat.getX(motionEvent, n2);
            this.mActivePointerId = MotionEventCompat.getPointerId(motionEvent, n2);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private boolean pageScrolled(int n) {
        boolean bl = false;
        if (this.mItems.size() == 0) {
            this.mCalledSuper = bl;
            this.onPageScrolled(bl ? 1 : 0, 0.0f, bl ? 1 : 0);
            if (!this.mCalledSuper) {
                throw new IllegalStateException("onPageScrolled did not call superclass implementation");
            }
        } else {
            ItemInfo itemInfo = this.infoForCurrentScrollPosition();
            int n2 = this.getWidth();
            int n3 = n2 + this.mPageMargin;
            float f = (float)this.mPageMargin / (float)n2;
            int n4 = itemInfo.position;
            float f2 = ((float)n / (float)n2 - itemInfo.offset) / (f + itemInfo.widthFactor);
            int n5 = (int)(f2 * (float)n3);
            this.mCalledSuper = bl;
            this.onPageScrolled(n4, f2, n5);
            if (!this.mCalledSuper) {
                throw new IllegalStateException("onPageScrolled did not call superclass implementation");
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean performDrag(float f) {
        boolean bl = false;
        float f2 = this.mLastMotionX - f;
        this.mLastMotionX = f;
        float f3 = f2 + (float)this.getScrollX();
        int n = this.getWidth();
        float f4 = (float)n * this.mFirstOffset;
        float f5 = (float)n * this.mLastOffset;
        boolean bl2 = true;
        boolean bl3 = true;
        ItemInfo itemInfo = this.mItems.get(0);
        ItemInfo itemInfo2 = this.mItems.get(-1 + this.mItems.size());
        if (itemInfo.position != 0) {
            bl2 = false;
            f4 = itemInfo.offset * (float)n;
        }
        if (itemInfo2.position != -1 + this.mAdapter.getCount()) {
            bl3 = false;
            f5 = itemInfo2.offset * (float)n;
        }
        if (f3 < f4) {
            if (bl2) {
                float f6 = f4 - f3;
                bl = this.mLeftEdge.onPull(Math.abs(f6) / (float)n);
            }
            f3 = f4;
        } else if (f3 > f5) {
            if (bl3) {
                float f7 = f3 - f5;
                bl = this.mRightEdge.onPull(Math.abs(f7) / (float)n);
            }
            f3 = f5;
        }
        this.mLastMotionX += f3 - (float)((int)f3);
        this.scrollTo((int)f3, this.getScrollY());
        this.pageScrolled((int)f3);
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void recomputeScrollPosition(int n, int n2, int n3, int n4) {
        if (n2 > 0 && !this.mItems.isEmpty()) {
            int n5 = n + n3;
            int n6 = n2 + n4;
            int n7 = (int)((float)this.getScrollX() / (float)n6 * (float)n5);
            this.scrollTo(n7, this.getScrollY());
            if (this.mScroller.isFinished()) return;
            int n8 = this.mScroller.getDuration() - this.mScroller.timePassed();
            ItemInfo itemInfo = this.infoForPosition(this.mCurItem);
            this.mScroller.startScroll(n7, 0, (int)(itemInfo.offset * (float)n), 0, n8);
            return;
        }
        ItemInfo itemInfo = this.infoForPosition(this.mCurItem);
        float f = itemInfo != null ? Math.min(itemInfo.offset, this.mLastOffset) : 0.0f;
        int n9 = (int)(f * (float)n);
        if (n9 == this.getScrollX()) return;
        this.completeScroll();
        this.scrollTo(n9, this.getScrollY());
    }

    private void removeNonDecorViews() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (((LayoutParams)this.getChildAt((int)i).getLayoutParams()).isDecor) continue;
            this.removeViewAt(i);
            --i;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setScrollState(int n) {
        if (this.mScrollState == n) {
            return;
        }
        this.mScrollState = n;
        if (this.mOnPageChangeListener == null) return;
        this.mOnPageChangeListener.onPageScrollStateChanged(n);
    }

    private void setScrollingCacheEnabled(boolean bl) {
        if (this.mScrollingCacheEnabled != bl) {
            this.mScrollingCacheEnabled = bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addFocusables(ArrayList<View> arrayList, int n, int n2) {
        int n3 = arrayList.size();
        int n4 = this.getDescendantFocusability();
        if (n4 != 393216) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ItemInfo itemInfo;
                View view = this.getChildAt(i);
                if (view.getVisibility() != 0 || (itemInfo = this.infoForChild(view)) == null || itemInfo.position != this.mCurItem) continue;
                view.addFocusables(arrayList, n, n2);
            }
        }
        if (n4 == 262144) {
            if (n3 != arrayList.size()) return;
        }
        if (!this.isFocusable()) {
            return;
        }
        if ((n2 & 1) == 1 && this.isInTouchMode()) {
            if (!this.isFocusableInTouchMode()) return;
        }
        if (arrayList == null) return;
        arrayList.add((View)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ItemInfo addNewItem(int n, int n2) {
        ItemInfo itemInfo = new ItemInfo();
        itemInfo.position = n;
        itemInfo.object = this.mAdapter.instantiateItem(this, n);
        itemInfo.widthFactor = this.mAdapter.getPageWidth(n);
        if (n2 < 0 || n2 >= this.mItems.size()) {
            this.mItems.add(itemInfo);
            return itemInfo;
        }
        this.mItems.add(n2, itemInfo);
        return itemInfo;
    }

    public void addTouchables(ArrayList<View> arrayList) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ItemInfo itemInfo;
            View view = this.getChildAt(i);
            if (view.getVisibility() != 0 || (itemInfo = this.infoForChild(view)) == null || itemInfo.position != this.mCurItem) continue;
            view.addTouchables(arrayList);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        if (!this.checkLayoutParams(layoutParams)) {
            layoutParams = this.generateLayoutParams(layoutParams);
        }
        LayoutParams layoutParams2 = (LayoutParams)layoutParams;
        layoutParams2.isDecor |= view instanceof Decor;
        if (this.mInLayout) {
            if (layoutParams2 != null && layoutParams2.isDecor) {
                throw new IllegalStateException("Cannot add pager decor view during layout");
            }
            layoutParams2.needsMeasure = true;
            this.addViewInLayout(view, n, layoutParams);
            return;
        }
        super.addView(view, n, layoutParams);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean arrowScroll(int n) {
        boolean bl;
        block9: {
            block8: {
                View view = this.findFocus();
                if (view == this) {
                    view = null;
                }
                bl = false;
                View view2 = FocusFinder.getInstance().findNextFocus((ViewGroup)this, view, n);
                if (view2 == null || view2 == view) break block8;
                if (n == 17) {
                    int n2 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)view2).left;
                    int n3 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)view).left;
                    bl = view != null && n2 >= n3 ? this.pageLeft() : view2.requestFocus();
                    break block9;
                } else if (n == 66) {
                    int n4 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)view2).left;
                    int n5 = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)view).left;
                    bl = view != null && n4 <= n5 ? this.pageRight() : view2.requestFocus();
                }
                break block9;
            }
            if (n == 17 || n == 1) {
                bl = this.pageLeft();
            } else if (n == 66 || n == 2) {
                bl = this.pageRight();
            }
        }
        if (bl) {
            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection((int)n));
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean beginFakeDrag() {
        int n = 0;
        if (this.mIsBeingDragged) {
            return n != 0;
        }
        this.mFakeDragging = true;
        this.setScrollState(1);
        this.mLastMotionX = 0.0f;
        this.mInitialMotionX = 0.0f;
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
        long l = SystemClock.uptimeMillis();
        MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)n, (float)0.0f, (float)0.0f, (int)n);
        this.mVelocityTracker.addMovement(motionEvent);
        motionEvent.recycle();
        this.mFakeDragBeginTime = l;
        return 1 != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean canScroll(View view, boolean bl, int n, int n2, int n3) {
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n4 = view.getScrollX();
            int n5 = view.getScrollY();
            for (int i = -1 + viewGroup.getChildCount(); i >= 0; --i) {
                View view2 = viewGroup.getChildAt(i);
                if (n2 + n4 < view2.getLeft() || n2 + n4 >= view2.getRight() || n3 + n5 < view2.getTop() || n3 + n5 >= view2.getBottom() || !this.canScroll(view2, true, n, n2 + n4 - view2.getLeft(), n3 + n5 - view2.getTop())) continue;
                return true;
            }
        }
        if (!bl) return false;
        if (!ViewCompat.canScrollHorizontally(view, -n)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (!(layoutParams instanceof LayoutParams)) return false;
        if (!super.checkLayoutParams(layoutParams)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void computeScroll() {
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            int n = this.getScrollX();
            int n2 = this.getScrollY();
            int n3 = this.mScroller.getCurrX();
            int n4 = this.mScroller.getCurrY();
            if (n != n3 || n2 != n4) {
                this.scrollTo(n3, n4);
                if (!this.pageScrolled(n3)) {
                    this.mScroller.abortAnimation();
                    this.scrollTo(0, n4);
                }
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
            return;
        }
        this.completeScroll();
    }

    /*
     * Enabled aggressive block sorting
     */
    void dataSetChanged() {
        boolean bl = this.mItems.size() < 1 + 2 * this.mOffscreenPageLimit && this.mItems.size() < this.mAdapter.getCount();
        int n = this.mCurItem;
        boolean bl2 = false;
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo itemInfo = this.mItems.get(i);
            int n2 = this.mAdapter.getItemPosition(itemInfo.object);
            if (n2 == -1) continue;
            if (n2 == -2) {
                this.mItems.remove(i);
                --i;
                if (!bl2) {
                    this.mAdapter.startUpdate(this);
                    bl2 = true;
                }
                this.mAdapter.destroyItem(this, itemInfo.position, itemInfo.object);
                bl = true;
                if (this.mCurItem != itemInfo.position) continue;
                n = Math.max(0, Math.min(this.mCurItem, -1 + this.mAdapter.getCount()));
                bl = true;
                continue;
            }
            if (itemInfo.position == n2) continue;
            if (itemInfo.position == this.mCurItem) {
                n = n2;
            }
            itemInfo.position = n2;
            bl = true;
        }
        if (bl2) {
            this.mAdapter.finishUpdate(this);
        }
        Collections.sort(this.mItems, COMPARATOR);
        if (bl) {
            int n3 = this.getChildCount();
            for (int i = 0; i < n3; ++i) {
                LayoutParams layoutParams = (LayoutParams)this.getChildAt(i).getLayoutParams();
                if (layoutParams.isDecor) continue;
                layoutParams.widthFactor = 0.0f;
            }
            this.setCurrentItemInternal(n, false, true);
            this.requestLayout();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (super.dispatchKeyEvent(keyEvent)) return true;
        if (!this.executeKeyEvent(keyEvent)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            ItemInfo itemInfo;
            View view = this.getChildAt(n2);
            if (view.getVisibility() == 0 && (itemInfo = this.infoForChild(view)) != null && itemInfo.position == this.mCurItem && view.dispatchPopulateAccessibilityEvent(accessibilityEvent)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    float distanceInfluenceForSnapDuration(float f) {
        return (float)Math.sin((float)(0.4712389167638204 * (double)(f - 0.5f)));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void draw(Canvas canvas) {
        super.draw(canvas);
        boolean bl = false;
        int n = ViewCompat.getOverScrollMode((View)this);
        if (n == 0 || n == 1 && this.mAdapter != null && this.mAdapter.getCount() > 1) {
            if (!this.mLeftEdge.isFinished()) {
                int n2 = canvas.save();
                int n3 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                int n4 = this.getWidth();
                canvas.rotate(270.0f);
                canvas.translate((float)(-n3 + this.getPaddingTop()), this.mFirstOffset * (float)n4);
                this.mLeftEdge.setSize(n3, n4);
                bl |= this.mLeftEdge.draw(canvas);
                canvas.restoreToCount(n2);
            }
            if (!this.mRightEdge.isFinished()) {
                int n5 = canvas.save();
                int n6 = this.getWidth();
                int n7 = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                canvas.rotate(90.0f);
                canvas.translate((float)(-this.getPaddingTop()), -(1.0f + this.mLastOffset) * (float)n6);
                this.mRightEdge.setSize(n7, n6);
                bl |= this.mRightEdge.draw(canvas);
                canvas.restoreToCount(n5);
            }
        } else {
            this.mLeftEdge.finish();
            this.mRightEdge.finish();
        }
        if (bl) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable drawable2 = this.mMarginDrawable;
        if (drawable2 != null && drawable2.isStateful()) {
            drawable2.setState(this.getDrawableState());
        }
    }

    public void endFakeDrag() {
        if (!this.mFakeDragging) {
            throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
        }
        VelocityTracker velocityTracker = this.mVelocityTracker;
        velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
        int n = (int)VelocityTrackerCompat.getXVelocity(velocityTracker, this.mActivePointerId);
        this.mPopulatePending = true;
        int n2 = this.getWidth();
        int n3 = this.getScrollX();
        ItemInfo itemInfo = this.infoForCurrentScrollPosition();
        this.setCurrentItemInternal(this.determineTargetPage(itemInfo.position, ((float)n3 / (float)n2 - itemInfo.offset) / itemInfo.widthFactor, n, (int)(this.mLastMotionX - this.mInitialMotionX)), true, true, n);
        this.endDrag();
        this.mFakeDragging = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean executeKeyEvent(KeyEvent keyEvent) {
        boolean bl = false;
        if (keyEvent.getAction() != 0) return bl;
        switch (keyEvent.getKeyCode()) {
            case 21: {
                return this.arrowScroll(17);
            }
            case 22: {
                return this.arrowScroll(66);
            }
            case 61: {
                if (Build.VERSION.SDK_INT < 11) return bl;
                if (KeyEventCompat.hasNoModifiers(keyEvent)) {
                    return this.arrowScroll(2);
                }
                if (!KeyEventCompat.hasModifiers(keyEvent, 1)) return bl;
                return this.arrowScroll(1);
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void fakeDragBy(float f) {
        if (!this.mFakeDragging) {
            throw new IllegalStateException("No fake drag in progress. Call beginFakeDrag first.");
        }
        this.mLastMotionX = f + this.mLastMotionX;
        float f2 = (float)this.getScrollX() - f;
        int n = this.getWidth();
        float f3 = (float)n * this.mFirstOffset;
        float f4 = (float)n * this.mLastOffset;
        ItemInfo itemInfo = this.mItems.get(0);
        ItemInfo itemInfo2 = this.mItems.get(-1 + this.mItems.size());
        if (itemInfo.position != 0) {
            f3 = itemInfo.offset * (float)n;
        }
        if (itemInfo2.position != -1 + this.mAdapter.getCount()) {
            f4 = itemInfo2.offset * (float)n;
        }
        if (f2 < f3) {
            f2 = f3;
        } else if (f2 > f4) {
            f2 = f4;
        }
        this.mLastMotionX += f2 - (float)((int)f2);
        this.scrollTo((int)f2, this.getScrollY());
        this.pageScrolled((int)f2);
        long l = SystemClock.uptimeMillis();
        MotionEvent motionEvent = MotionEvent.obtain((long)this.mFakeDragBeginTime, (long)l, (int)2, (float)this.mLastMotionX, (float)0.0f, (int)0);
        this.mVelocityTracker.addMovement(motionEvent);
        motionEvent.recycle();
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new LayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return this.generateDefaultLayoutParams();
    }

    public PagerAdapter getAdapter() {
        return this.mAdapter;
    }

    public int getCurrentItem() {
        return this.mCurItem;
    }

    public int getOffscreenPageLimit() {
        return this.mOffscreenPageLimit;
    }

    public int getPageMargin() {
        return this.mPageMargin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ItemInfo infoForAnyChild(View view) {
        ViewParent viewParent;
        while ((viewParent = view.getParent()) != this) {
            if (viewParent == null) return null;
            if (!(viewParent instanceof View)) {
                return null;
            }
            view = (View)viewParent;
        }
        return this.infoForChild(view);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ItemInfo infoForChild(View view) {
        int n = 0;
        while (n < this.mItems.size()) {
            ItemInfo itemInfo = this.mItems.get(n);
            if (this.mAdapter.isViewFromObject(view, itemInfo.object)) {
                return itemInfo;
            }
            ++n;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ItemInfo infoForPosition(int n) {
        int n2 = 0;
        while (n2 < this.mItems.size()) {
            ItemInfo itemInfo = this.mItems.get(n2);
            if (itemInfo.position == n) {
                return itemInfo;
            }
            ++n2;
        }
        return null;
    }

    void initViewPager() {
        this.setWillNotDraw(false);
        this.setDescendantFocusability(262144);
        this.setFocusable(true);
        Context context = this.getContext();
        this.mScroller = new Scroller(context, sInterpolator);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mTouchSlop = ViewConfigurationCompat.getScaledPagingTouchSlop(viewConfiguration);
        this.mMinimumVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mLeftEdge = new EdgeEffectCompat(context);
        this.mRightEdge = new EdgeEffectCompat(context);
        float f = context.getResources().getDisplayMetrics().density;
        this.mFlingDistance = (int)(25.0f * f);
        this.mCloseEnough = (int)(2.0f * f);
        this.mDefaultGutterSize = (int)(16.0f * f);
        ViewCompat.setAccessibilityDelegate((View)this, new MyAccessibilityDelegate());
        if (ViewCompat.getImportantForAccessibility((View)this) == 0) {
            ViewCompat.setImportantForAccessibility((View)this, 1);
        }
    }

    public boolean isFakeDragging() {
        return this.mFakeDragging;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mPageMargin > 0 && this.mMarginDrawable != null && this.mItems.size() > 0 && this.mAdapter != null) {
            int n = this.getScrollX();
            int n2 = this.getWidth();
            float f = (float)this.mPageMargin / (float)n2;
            int n3 = 0;
            ItemInfo itemInfo = this.mItems.get(0);
            float f2 = itemInfo.offset;
            int n4 = this.mItems.size();
            int n5 = itemInfo.position;
            int n6 = this.mItems.get((int)(n4 + -1)).position;
            for (int i = n5; i < n6; ++i) {
                float f3;
                while (i > itemInfo.position && n3 < n4) {
                    ArrayList<ItemInfo> arrayList = this.mItems;
                    itemInfo = arrayList.get(++n3);
                }
                if (i == itemInfo.position) {
                    f3 = (itemInfo.offset + itemInfo.widthFactor) * (float)n2;
                    f2 = f + (itemInfo.offset + itemInfo.widthFactor);
                } else {
                    float f4 = this.mAdapter.getPageWidth(i);
                    f3 = (f2 + f4) * (float)n2;
                    f2 += f4 + f;
                }
                if (f3 + (float)this.mPageMargin > (float)n) {
                    this.mMarginDrawable.setBounds((int)f3, this.mTopPageBounds, (int)(0.5f + (f3 + (float)this.mPageMargin)), this.mBottomPageBounds);
                    this.mMarginDrawable.draw(canvas);
                }
                if (f3 > (float)(n + n2)) break;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean onInterceptTouchEvent(MotionEvent var1_1) {
        block15: {
            block16: {
                var2_2 = 255 & var1_1.getAction();
                if (var2_2 == 3 || var2_2 == 1) {
                    this.mIsBeingDragged = false;
                    this.mIsUnableToDrag = false;
                    this.mActivePointerId = -1;
                    if (this.mVelocityTracker != null) {
                        this.mVelocityTracker.recycle();
                        this.mVelocityTracker = null;
                    }
                    var3_3 = false;
lbl10:
                    // 5 sources

                    return var3_3;
                }
                if (var2_2 == 0) break block15;
                if (!this.mIsBeingDragged) break block16;
                var3_3 = true;
                ** GOTO lbl10
            }
            if (!this.mIsUnableToDrag) break block15;
            var3_3 = false;
            ** GOTO lbl10
        }
        switch (var2_2) lbl-1000:
        // 5 sources

        {
            default: lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (this.mVelocityTracker == null) {
                        this.mVelocityTracker = VelocityTracker.obtain();
                    }
                    this.mVelocityTracker.addMovement(var1_1);
                    var3_3 = this.mIsBeingDragged;
                    ** GOTO lbl10
                    break;
                }
            }
            case 2: {
                var6_4 = this.mActivePointerId;
                if (var6_4 == -1) ** GOTO lbl-1000
                var7_5 = MotionEventCompat.findPointerIndex(var1_1, var6_4);
                var8_6 = MotionEventCompat.getX(var1_1, var7_5);
                var9_7 = var8_6 - this.mLastMotionX;
                var10_8 = Math.abs(var9_7);
                var11_9 = MotionEventCompat.getY(var1_1, var7_5);
                var12_10 = Math.abs(var11_9 - this.mLastMotionY);
                if (var9_7 != 0.0f && !this.isGutterDrag(this.mLastMotionX, var9_7) && this.canScroll((View)this, false, (int)var9_7, (int)var8_6, (int)var11_9)) {
                    this.mLastMotionX = var8_6;
                    this.mInitialMotionX = var8_6;
                    this.mLastMotionY = var11_9;
                    this.mIsUnableToDrag = true;
                    var3_3 = false;
                    ** continue;
                }
                if (!(var10_8 > (float)this.mTouchSlop) || !(var10_8 > var12_10)) ** GOTO lbl59
                this.mIsBeingDragged = true;
                this.setScrollState(1);
                if (!(var9_7 > 0.0f)) ** GOTO lbl57
                var13_11 = this.mInitialMotionX + (float)this.mTouchSlop;
lbl50:
                // 2 sources

                while (true) {
                    this.mLastMotionX = var13_11;
                    this.setScrollingCacheEnabled(true);
lbl53:
                    // 3 sources

                    while (true) {
                        if (this.mIsBeingDragged && this.performDrag(var8_6)) {
                            ViewCompat.postInvalidateOnAnimation((View)this);
                        }
                        ** GOTO lbl-1000
                        break;
                    }
                    break;
                }
lbl57:
                // 1 sources

                var13_11 = this.mInitialMotionX - (float)this.mTouchSlop;
                ** continue;
lbl59:
                // 1 sources

                if (!(var12_10 > (float)this.mTouchSlop)) ** GOTO lbl53
                this.mIsUnableToDrag = true;
                ** continue;
            }
            case 0: {
                this.mInitialMotionX = var4_12 = var1_1.getX();
                this.mLastMotionX = var4_12;
                this.mLastMotionY = var1_1.getY();
                this.mActivePointerId = MotionEventCompat.getPointerId(var1_1, 0);
                this.mIsUnableToDrag = false;
                this.mScroller.computeScrollOffset();
                if (this.mScrollState != 2 || Math.abs(this.mScroller.getFinalX() - this.mScroller.getCurrX()) <= this.mCloseEnough) ** GOTO lbl77
                this.mScroller.abortAnimation();
                this.mPopulatePending = false;
                this.populate();
                this.mIsBeingDragged = true;
                this.setScrollState(1);
                ** GOTO lbl-1000
lbl77:
                // 1 sources

                this.completeScroll();
                this.mIsBeingDragged = false;
                ** GOTO lbl-1000
            }
            case 6: 
        }
        this.onSecondaryPointerUp(var1_1);
        ** while (true)
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.mInLayout = true;
        this.populate();
        this.mInLayout = false;
        int n5 = this.getChildCount();
        int n6 = n3 - n;
        int n7 = n4 - n2;
        int n8 = this.getPaddingLeft();
        int n9 = this.getPaddingTop();
        int n10 = this.getPaddingRight();
        int n11 = this.getPaddingBottom();
        int n12 = this.getScrollX();
        int n13 = 0;
        for (int i = 0; i < n5; ++i) {
            int n14;
            int n15;
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) continue;
            LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
            if (!layoutParams.isDecor) continue;
            int n16 = 7 & layoutParams.gravity;
            int n17 = 0x70 & layoutParams.gravity;
            switch (n16) {
                default: {
                    n15 = n8;
                    break;
                }
                case 3: {
                    n15 = n8;
                    n8 += view.getMeasuredWidth();
                    break;
                }
                case 1: {
                    n15 = Math.max((n6 - view.getMeasuredWidth()) / 2, n8);
                    break;
                }
                case 5: {
                    n15 = n6 - n10 - view.getMeasuredWidth();
                    n10 += view.getMeasuredWidth();
                }
            }
            switch (n17) {
                default: {
                    n14 = n9;
                    break;
                }
                case 48: {
                    n14 = n9;
                    n9 += view.getMeasuredHeight();
                    break;
                }
                case 16: {
                    n14 = Math.max((n7 - view.getMeasuredHeight()) / 2, n9);
                    break;
                }
                case 80: {
                    n14 = n7 - n11 - view.getMeasuredHeight();
                    n11 += view.getMeasuredHeight();
                }
            }
            int n18 = n15 + n12;
            view.layout(n18, n14, n18 + view.getMeasuredWidth(), n14 + view.getMeasuredHeight());
            ++n13;
        }
        int n19 = 0;
        while (true) {
            if (n19 >= n5) {
                this.mTopPageBounds = n9;
                this.mBottomPageBounds = n7 - n11;
                this.mDecorChildCount = n13;
                this.mFirstLayout = false;
                return;
            }
            View view = this.getChildAt(n19);
            if (view.getVisibility() != 8) {
                ItemInfo itemInfo;
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (!layoutParams.isDecor && (itemInfo = this.infoForChild(view)) != null) {
                    int n20 = n8 + (int)((float)n6 * itemInfo.offset);
                    int n21 = n9;
                    if (layoutParams.needsMeasure) {
                        layoutParams.needsMeasure = false;
                        view.measure(View.MeasureSpec.makeMeasureSpec((int)((int)((float)(n6 - n8 - n10) * layoutParams.widthFactor)), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(n7 - n9 - n11), (int)0x40000000));
                    }
                    view.layout(n20, n21, n20 + view.getMeasuredWidth(), n21 + view.getMeasuredHeight());
                }
            }
            ++n19;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n, int n2) {
        this.setMeasuredDimension(ViewPager.getDefaultSize((int)0, (int)n), ViewPager.getDefaultSize((int)0, (int)n2));
        int n3 = this.getMeasuredWidth();
        this.mGutterSize = Math.min(n3 / 10, this.mDefaultGutterSize);
        int n4 = n3 - this.getPaddingLeft() - this.getPaddingRight();
        int n5 = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int n6 = this.getChildCount();
        for (int i = 0; i < n6; ++i) {
            LayoutParams layoutParams;
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8 || (layoutParams = (LayoutParams)view.getLayoutParams()) == null || !layoutParams.isDecor) continue;
            int n7 = 7 & layoutParams.gravity;
            int n8 = 0x70 & layoutParams.gravity;
            int n9 = Integer.MIN_VALUE;
            int n10 = Integer.MIN_VALUE;
            boolean bl = n8 == 48 || n8 == 80;
            boolean bl2 = n7 == 3 || n7 == 5;
            if (bl) {
                n9 = 0x40000000;
            } else if (bl2) {
                n10 = 0x40000000;
            }
            int n11 = n4;
            int n12 = n5;
            if (layoutParams.width != -2) {
                n9 = 0x40000000;
                if (layoutParams.width != -1) {
                    n11 = layoutParams.width;
                }
            }
            if (layoutParams.height != -2) {
                n10 = 0x40000000;
                if (layoutParams.height != -1) {
                    n12 = layoutParams.height;
                }
            }
            view.measure(View.MeasureSpec.makeMeasureSpec((int)n11, (int)n9), View.MeasureSpec.makeMeasureSpec((int)n12, (int)n10));
            if (bl) {
                n5 -= view.getMeasuredHeight();
                continue;
            }
            if (!bl2) continue;
            n4 -= view.getMeasuredWidth();
        }
        this.mChildWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)n4, (int)0x40000000);
        this.mChildHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)n5, (int)0x40000000);
        this.mInLayout = true;
        this.populate();
        this.mInLayout = false;
        int n13 = this.getChildCount();
        int n14 = 0;
        while (n14 < n13) {
            LayoutParams layoutParams;
            View view = this.getChildAt(n14);
            if (!(view.getVisibility() == 8 || (layoutParams = (LayoutParams)view.getLayoutParams()) != null && layoutParams.isDecor)) {
                view.measure(View.MeasureSpec.makeMeasureSpec((int)((int)((float)n4 * layoutParams.widthFactor)), (int)0x40000000), this.mChildHeightMeasureSpec);
            }
            ++n14;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onPageScrolled(int n, float f, int n2) {
        if (this.mDecorChildCount > 0) {
            int n3 = this.getScrollX();
            int n4 = this.getPaddingLeft();
            int n5 = this.getPaddingRight();
            int n6 = this.getWidth();
            int n7 = this.getChildCount();
            for (int i = 0; i < n7; ++i) {
                int n8;
                int n9;
                View view = this.getChildAt(i);
                LayoutParams layoutParams = (LayoutParams)view.getLayoutParams();
                if (!layoutParams.isDecor) continue;
                switch (7 & layoutParams.gravity) {
                    default: {
                        n9 = n4;
                        break;
                    }
                    case 3: {
                        n9 = n4;
                        n4 += view.getWidth();
                        break;
                    }
                    case 1: {
                        n9 = Math.max((n6 - view.getMeasuredWidth()) / 2, n4);
                        break;
                    }
                    case 5: {
                        n9 = n6 - n5 - view.getMeasuredWidth();
                        n5 += view.getMeasuredWidth();
                    }
                }
                if ((n8 = n9 + n3 - view.getLeft()) == 0) continue;
                view.offsetLeftAndRight(n8);
            }
        }
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrolled(n, f, n2);
        }
        if (this.mInternalPageChangeListener != null) {
            this.mInternalPageChangeListener.onPageScrolled(n, f, n2);
        }
        this.mCalledSuper = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean onRequestFocusInDescendants(int n, Rect rect) {
        int n2;
        int n3;
        int n4;
        int n5 = this.getChildCount();
        if ((n & 2) != 0) {
            n4 = 0;
            n3 = 1;
            n2 = n5;
        } else {
            n4 = n5 + -1;
            n3 = -1;
            n2 = -1;
        }
        int n6 = n4;
        while (n6 != n2) {
            ItemInfo itemInfo;
            View view = this.getChildAt(n6);
            if (view.getVisibility() == 0 && (itemInfo = this.infoForChild(view)) != null && itemInfo.position == this.mCurItem && view.requestFocus(n, rect)) {
                return true;
            }
            n6 += n3;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState)parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        if (this.mAdapter != null) {
            this.mAdapter.restoreState(savedState.adapterState, savedState.loader);
            this.setCurrentItemInternal(savedState.position, false, true);
            return;
        }
        this.mRestoredCurItem = savedState.position;
        this.mRestoredAdapterState = savedState.adapterState;
        this.mRestoredClassLoader = savedState.loader;
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.position = this.mCurItem;
        if (this.mAdapter != null) {
            savedState.adapterState = this.mAdapter.saveState();
        }
        return savedState;
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (n != n3) {
            this.recomputeScrollPosition(n, n3, this.mPageMargin, this.mPageMargin);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mFakeDragging) {
            return true;
        }
        if (motionEvent.getAction() == 0 && motionEvent.getEdgeFlags() != 0) {
            return false;
        }
        if (this.mAdapter == null) return false;
        if (this.mAdapter.getCount() == 0) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        int n = motionEvent.getAction();
        boolean bl = false;
        switch (n & 0xFF) {
            case 0: {
                float f;
                this.mScroller.abortAnimation();
                this.mPopulatePending = false;
                this.populate();
                this.mIsBeingDragged = true;
                this.setScrollState(1);
                this.mInitialMotionX = f = motionEvent.getX();
                this.mLastMotionX = f;
                this.mActivePointerId = MotionEventCompat.getPointerId(motionEvent, 0);
                break;
            }
            case 2: {
                if (!this.mIsBeingDragged) {
                    int n2 = MotionEventCompat.findPointerIndex(motionEvent, this.mActivePointerId);
                    float f = MotionEventCompat.getX(motionEvent, n2);
                    float f2 = Math.abs(f - this.mLastMotionX);
                    float f3 = Math.abs(MotionEventCompat.getY(motionEvent, n2) - this.mLastMotionY);
                    if (f2 > (float)this.mTouchSlop && f2 > f3) {
                        this.mIsBeingDragged = true;
                        float f4 = f - this.mInitialMotionX > 0.0f ? this.mInitialMotionX + (float)this.mTouchSlop : this.mInitialMotionX - (float)this.mTouchSlop;
                        this.mLastMotionX = f4;
                        this.setScrollState(1);
                        this.setScrollingCacheEnabled(true);
                    }
                }
                if (!this.mIsBeingDragged) break;
                bl |= this.performDrag(MotionEventCompat.getX(motionEvent, MotionEventCompat.findPointerIndex(motionEvent, this.mActivePointerId)));
                break;
            }
            case 1: {
                if (!this.mIsBeingDragged) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                int n3 = (int)VelocityTrackerCompat.getXVelocity(velocityTracker, this.mActivePointerId);
                this.mPopulatePending = true;
                int n4 = this.getWidth();
                int n5 = this.getScrollX();
                ItemInfo itemInfo = this.infoForCurrentScrollPosition();
                this.setCurrentItemInternal(this.determineTargetPage(itemInfo.position, ((float)n5 / (float)n4 - itemInfo.offset) / itemInfo.widthFactor, n3, (int)(MotionEventCompat.getX(motionEvent, MotionEventCompat.findPointerIndex(motionEvent, this.mActivePointerId)) - this.mInitialMotionX)), true, true, n3);
                this.mActivePointerId = -1;
                this.endDrag();
                bl = this.mLeftEdge.onRelease() | this.mRightEdge.onRelease();
                break;
            }
            case 3: {
                if (!this.mIsBeingDragged) break;
                this.setCurrentItemInternal(this.mCurItem, true, true);
                this.mActivePointerId = -1;
                this.endDrag();
                bl = this.mLeftEdge.onRelease() | this.mRightEdge.onRelease();
                break;
            }
            case 5: {
                int n6 = MotionEventCompat.getActionIndex(motionEvent);
                this.mLastMotionX = MotionEventCompat.getX(motionEvent, n6);
                this.mActivePointerId = MotionEventCompat.getPointerId(motionEvent, n6);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(motionEvent);
                this.mLastMotionX = MotionEventCompat.getX(motionEvent, MotionEventCompat.findPointerIndex(motionEvent, this.mActivePointerId));
                break;
            }
        }
        if (!bl) return true;
        ViewCompat.postInvalidateOnAnimation((View)this);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean pageLeft() {
        boolean bl = true;
        if (this.mCurItem <= 0) return false;
        this.setCurrentItem(-1 + this.mCurItem, bl);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean pageRight() {
        boolean bl = true;
        if (this.mAdapter == null) return false;
        if (this.mCurItem >= -1 + this.mAdapter.getCount()) return false;
        this.setCurrentItem(1 + this.mCurItem, bl);
        return bl;
    }

    void populate() {
        this.populate(this.mCurItem);
    }

    /*
     * Enabled aggressive block sorting
     */
    void populate(int n) {
        block22: {
            View view;
            ItemInfo itemInfo;
            ItemInfo itemInfo2;
            block20: {
                int n2;
                ItemInfo itemInfo3;
                block21: {
                    ItemInfo itemInfo4;
                    int n3;
                    float f;
                    itemInfo3 = null;
                    if (this.mCurItem != n) {
                        itemInfo3 = this.infoForPosition(this.mCurItem);
                        this.mCurItem = n;
                    }
                    if (this.mAdapter == null || this.mPopulatePending || this.getWindowToken() == null) break block22;
                    this.mAdapter.startUpdate(this);
                    int n4 = this.mOffscreenPageLimit;
                    int n5 = Math.max(0, this.mCurItem - n4);
                    int n6 = this.mAdapter.getCount();
                    int n7 = Math.min(n6 + -1, n4 + this.mCurItem);
                    itemInfo2 = null;
                    n2 = 0;
                    while (true) {
                        block24: {
                            block23: {
                                if (n2 >= this.mItems.size()) break block23;
                                ItemInfo itemInfo5 = this.mItems.get(n2);
                                if (itemInfo5.position < this.mCurItem) break block24;
                                if (itemInfo5.position == this.mCurItem) {
                                    itemInfo2 = itemInfo5;
                                }
                            }
                            if (itemInfo2 == null && n6 > 0) {
                                itemInfo2 = this.addNewItem(this.mCurItem, n2);
                            }
                            if (itemInfo2 != null) {
                                break;
                            }
                            break block20;
                        }
                        ++n2;
                    }
                    float f2 = 0.0f;
                    int n8 = n2 + -1;
                    ItemInfo itemInfo6 = n8 >= 0 ? this.mItems.get(n8) : null;
                    float f3 = 2.0f - itemInfo2.widthFactor;
                    int n9 = -1 + this.mCurItem;
                    while (true) {
                        block28: {
                            int n10;
                            block26: {
                                block27: {
                                    block25: {
                                        if (n9 < 0) break block25;
                                        if (!(f2 >= f3) || n9 >= n5) break block26;
                                        if (itemInfo6 != null) break block27;
                                    }
                                    f = itemInfo2.widthFactor;
                                    n3 = n2 + 1;
                                    if (f < 2.0f) {
                                        itemInfo4 = n3 < this.mItems.size() ? this.mItems.get(n3) : null;
                                        break;
                                    }
                                    break block21;
                                }
                                int n11 = itemInfo6.position;
                                if (n9 == n11 && !itemInfo6.scrolling) {
                                    this.mItems.remove(n8);
                                    PagerAdapter pagerAdapter = this.mAdapter;
                                    Object object = itemInfo6.object;
                                    pagerAdapter.destroyItem(this, n9, object);
                                    --n2;
                                    itemInfo6 = --n8 >= 0 ? this.mItems.get(n8) : null;
                                }
                                break block28;
                            }
                            if (itemInfo6 != null && n9 == (n10 = itemInfo6.position)) {
                                f2 += itemInfo6.widthFactor;
                                itemInfo6 = --n8 >= 0 ? this.mItems.get(n8) : null;
                            } else {
                                int n12 = n8 + 1;
                                f2 += this.addNewItem((int)n9, (int)n12).widthFactor;
                                ++n2;
                                itemInfo6 = n8 >= 0 ? this.mItems.get(n8) : null;
                            }
                        }
                        --n9;
                    }
                    for (int i = 1 + this.mCurItem; i < n6; ++i) {
                        int n13;
                        if (f >= 2.0f && i > n7) {
                            if (itemInfo4 == null) break;
                            int n14 = itemInfo4.position;
                            if (i != n14 || itemInfo4.scrolling) continue;
                            this.mItems.remove(n3);
                            PagerAdapter pagerAdapter = this.mAdapter;
                            Object object = itemInfo4.object;
                            pagerAdapter.destroyItem(this, i, object);
                            if (n3 < this.mItems.size()) {
                                itemInfo4 = this.mItems.get(n3);
                                continue;
                            }
                            itemInfo4 = null;
                            continue;
                        }
                        if (itemInfo4 != null && i == (n13 = itemInfo4.position)) {
                            f += itemInfo4.widthFactor;
                            if (++n3 < this.mItems.size()) {
                                itemInfo4 = this.mItems.get(n3);
                                continue;
                            }
                            itemInfo4 = null;
                            continue;
                        }
                        ItemInfo itemInfo7 = this.addNewItem(i, n3);
                        f += itemInfo7.widthFactor;
                        itemInfo4 = ++n3 < this.mItems.size() ? this.mItems.get(n3) : null;
                    }
                }
                this.calculatePageOffsets(itemInfo2, n2, itemInfo3);
            }
            PagerAdapter pagerAdapter = this.mAdapter;
            int n15 = this.mCurItem;
            Object object = itemInfo2 != null ? itemInfo2.object : null;
            pagerAdapter.setPrimaryItem(this, n15, object);
            this.mAdapter.finishUpdate(this);
            int n16 = this.getChildCount();
            for (int i = 0; i < n16; ++i) {
                ItemInfo itemInfo8;
                View view2 = this.getChildAt(i);
                LayoutParams layoutParams = (LayoutParams)view2.getLayoutParams();
                if (layoutParams.isDecor || layoutParams.widthFactor != 0.0f || (itemInfo8 = this.infoForChild(view2)) == null) continue;
                layoutParams.widthFactor = itemInfo8.widthFactor;
            }
            if (this.hasFocus() && ((itemInfo = (view = this.findFocus()) != null ? this.infoForAnyChild(view) : null) == null || itemInfo.position != this.mCurItem)) {
                View view3;
                ItemInfo itemInfo9;
                for (int i = 0; !(i >= this.getChildCount() || (itemInfo9 = this.infoForChild(view3 = this.getChildAt(i))) != null && itemInfo9.position == this.mCurItem && view3.requestFocus(2)); ++i) {
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAdapter(PagerAdapter pagerAdapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mObserver);
            this.mAdapter.startUpdate(this);
            for (int i = 0; i < this.mItems.size(); ++i) {
                ItemInfo itemInfo = this.mItems.get(i);
                this.mAdapter.destroyItem(this, itemInfo.position, itemInfo.object);
            }
            this.mAdapter.finishUpdate(this);
            this.mItems.clear();
            this.removeNonDecorViews();
            this.mCurItem = 0;
            this.scrollTo(0, 0);
        }
        PagerAdapter pagerAdapter2 = this.mAdapter;
        this.mAdapter = pagerAdapter;
        if (this.mAdapter != null) {
            if (this.mObserver == null) {
                this.mObserver = new PagerObserver();
            }
            this.mAdapter.registerDataSetObserver(this.mObserver);
            this.mPopulatePending = false;
            this.mFirstLayout = true;
            if (this.mRestoredCurItem >= 0) {
                this.mAdapter.restoreState(this.mRestoredAdapterState, this.mRestoredClassLoader);
                this.setCurrentItemInternal(this.mRestoredCurItem, false, true);
                this.mRestoredCurItem = -1;
                this.mRestoredAdapterState = null;
                this.mRestoredClassLoader = null;
            } else {
                this.populate();
            }
        }
        if (this.mAdapterChangeListener != null && pagerAdapter2 != pagerAdapter) {
            this.mAdapterChangeListener.onAdapterChanged(pagerAdapter2, pagerAdapter);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setCurrentItem(int n) {
        this.mPopulatePending = false;
        boolean bl = !this.mFirstLayout;
        this.setCurrentItemInternal(n, bl, false);
    }

    public void setCurrentItem(int n, boolean bl) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(n, bl, false);
    }

    void setCurrentItemInternal(int n, boolean bl, boolean bl2) {
        this.setCurrentItemInternal(n, bl, bl2, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    void setCurrentItemInternal(int n, boolean bl, boolean bl2, int n2) {
        int n3;
        boolean bl3 = true;
        if (this.mAdapter == null || this.mAdapter.getCount() <= 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        if (!bl2 && this.mCurItem == n && this.mItems.size() != 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        if (n < 0) {
            n = 0;
        } else if (n >= this.mAdapter.getCount()) {
            n = -1 + this.mAdapter.getCount();
        }
        if (n > (n3 = this.mOffscreenPageLimit) + this.mCurItem || n < this.mCurItem - n3) {
            for (int i = 0; i < this.mItems.size(); ++i) {
                this.mItems.get((int)i).scrolling = bl3;
            }
        }
        if (this.mCurItem == n) {
            bl3 = false;
        }
        this.populate(n);
        ItemInfo itemInfo = this.infoForPosition(n);
        int n4 = 0;
        if (itemInfo != null) {
            n4 = (int)((float)this.getWidth() * Math.max(this.mFirstOffset, Math.min(itemInfo.offset, this.mLastOffset)));
        }
        if (bl) {
            this.smoothScrollTo(n4, 0, n2);
            if (bl3 && this.mOnPageChangeListener != null) {
                this.mOnPageChangeListener.onPageSelected(n);
            }
            if (!bl3) return;
            if (this.mInternalPageChangeListener == null) return;
            this.mInternalPageChangeListener.onPageSelected(n);
            return;
        }
        if (bl3 && this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageSelected(n);
        }
        if (bl3 && this.mInternalPageChangeListener != null) {
            this.mInternalPageChangeListener.onPageSelected(n);
        }
        this.completeScroll();
        this.scrollTo(n4, 0);
    }

    OnPageChangeListener setInternalPageChangeListener(OnPageChangeListener onPageChangeListener) {
        OnPageChangeListener onPageChangeListener2 = this.mInternalPageChangeListener;
        this.mInternalPageChangeListener = onPageChangeListener;
        return onPageChangeListener2;
    }

    public void setOffscreenPageLimit(int n) {
        if (n < 1) {
            Log.w((String)TAG, (String)("Requested offscreen page limit " + n + " too small; defaulting to " + 1));
            n = 1;
        }
        if (n != this.mOffscreenPageLimit) {
            this.mOffscreenPageLimit = n;
            this.populate();
        }
    }

    void setOnAdapterChangeListener(OnAdapterChangeListener onAdapterChangeListener) {
        this.mAdapterChangeListener = onAdapterChangeListener;
    }

    public void setOnPageChangeListener(OnPageChangeListener onPageChangeListener) {
        this.mOnPageChangeListener = onPageChangeListener;
    }

    public void setPageMargin(int n) {
        int n2 = this.mPageMargin;
        this.mPageMargin = n;
        int n3 = this.getWidth();
        this.recomputeScrollPosition(n3, n3, n, n2);
        this.requestLayout();
    }

    public void setPageMarginDrawable(int n) {
        this.setPageMarginDrawable(this.getContext().getResources().getDrawable(n));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setPageMarginDrawable(Drawable drawable2) {
        this.mMarginDrawable = drawable2;
        if (drawable2 != null) {
            this.refreshDrawableState();
        }
        boolean bl = drawable2 == null;
        this.setWillNotDraw(bl);
        this.invalidate();
    }

    void smoothScrollTo(int n, int n2) {
        this.smoothScrollTo(n, n2, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    void smoothScrollTo(int n, int n2, int n3) {
        int n4;
        if (this.getChildCount() == 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        int n5 = this.getScrollX();
        int n6 = this.getScrollY();
        int n7 = n - n5;
        int n8 = n2 - n6;
        if (n7 == 0 && n8 == 0) {
            this.completeScroll();
            this.populate();
            this.setScrollState(0);
            return;
        }
        this.setScrollingCacheEnabled(true);
        this.setScrollState(2);
        int n9 = this.getWidth();
        int n10 = n9 / 2;
        float f = Math.min(1.0f, 1.0f * (float)Math.abs(n7) / (float)n9);
        float f2 = (float)n10 + (float)n10 * this.distanceInfluenceForSnapDuration(f);
        int n11 = Math.abs(n3);
        if (n11 > 0) {
            n4 = 4 * Math.round(1000.0f * Math.abs(f2 / (float)n11));
        } else {
            float f3 = (float)n9 * this.mAdapter.getPageWidth(this.mCurItem);
            n4 = (int)(100.0f * (1.0f + (float)Math.abs(n7) / (f3 + (float)this.mPageMargin)));
        }
        int n12 = Math.min(n4, 600);
        this.mScroller.startScroll(n5, n6, n7, n8, n12);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean verifyDrawable(Drawable drawable2) {
        if (super.verifyDrawable(drawable2)) return true;
        if (drawable2 != this.mMarginDrawable) return false;
        return true;
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public int gravity;
        public boolean isDecor;
        public boolean needsMeasure;
        public float widthFactor = 0.0f;

        public LayoutParams() {
            super(-1, -1);
        }

        public LayoutParams(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            TypedArray typedArray = context.obtainStyledAttributes(attributeSet, LAYOUT_ATTRS);
            this.gravity = typedArray.getInteger(0, 48);
            typedArray.recycle();
        }
    }

    private class PagerObserver
    extends DataSetObserver {
        private PagerObserver() {
        }

        public void onChanged() {
            ViewPager.this.dataSetChanged();
        }

        public void onInvalidated() {
            ViewPager.this.dataSetChanged();
        }
    }

    class MyAccessibilityDelegate
    extends AccessibilityDelegateCompat {
        MyAccessibilityDelegate() {
        }

        @Override
        public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            super.onInitializeAccessibilityEvent(view, accessibilityEvent);
            accessibilityEvent.setClassName((CharSequence)ViewPager.class.getName());
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
            int n = 1;
            super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
            accessibilityNodeInfoCompat.setClassName(ViewPager.class.getName());
            if (ViewPager.this.mAdapter == null || ViewPager.this.mAdapter.getCount() <= n) {
                n = 0;
            }
            accessibilityNodeInfoCompat.setScrollable(n != 0);
            if (ViewPager.this.mAdapter != null && ViewPager.this.mCurItem >= 0 && ViewPager.this.mCurItem < -1 + ViewPager.this.mAdapter.getCount()) {
                accessibilityNodeInfoCompat.addAction(4096);
            }
            if (ViewPager.this.mAdapter != null && ViewPager.this.mCurItem > 0 && ViewPager.this.mCurItem < ViewPager.this.mAdapter.getCount()) {
                accessibilityNodeInfoCompat.addAction(8192);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean performAccessibilityAction(View view, int n, Bundle bundle) {
            boolean bl = true;
            if (super.performAccessibilityAction(view, n, bundle)) {
                return bl;
            }
            switch (n) {
                default: {
                    return false;
                }
                case 4096: {
                    if (ViewPager.this.mAdapter == null) return false;
                    if (ViewPager.this.mCurItem < 0) return false;
                    if (ViewPager.this.mCurItem >= -1 + ViewPager.this.mAdapter.getCount()) return false;
                    ViewPager.this.setCurrentItem(1 + ViewPager.this.mCurItem);
                    return bl;
                }
                case 8192: 
            }
            if (ViewPager.this.mAdapter == null) return false;
            if (ViewPager.this.mCurItem <= 0) return false;
            if (ViewPager.this.mCurItem >= ViewPager.this.mAdapter.getCount()) return false;
            ViewPager.this.setCurrentItem(-1 + ViewPager.this.mCurItem);
            return bl;
        }
    }

    public static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = ParcelableCompat.newCreator(new ParcelableCompatCreatorCallbacks<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            public SavedState[] newArray(int n) {
                return new SavedState[n];
            }
        });
        Parcelable adapterState;
        ClassLoader loader;
        int position;

        SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel);
            if (classLoader == null) {
                classLoader = ((Object)((Object)this)).getClass().getClassLoader();
            }
            this.position = parcel.readInt();
            this.adapterState = parcel.readParcelable(classLoader);
            this.loader = classLoader;
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        public String toString() {
            return "FragmentPager.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " position=" + this.position + "}";
        }

        public void writeToParcel(Parcel parcel, int n) {
            super.writeToParcel(parcel, n);
            parcel.writeInt(this.position);
            parcel.writeParcelable(this.adapterState, n);
        }
    }

    static interface Decor {
    }

    static interface OnAdapterChangeListener {
        public void onAdapterChanged(PagerAdapter var1, PagerAdapter var2);
    }

    public static class SimpleOnPageChangeListener
    implements OnPageChangeListener {
        @Override
        public void onPageScrollStateChanged(int n) {
        }

        @Override
        public void onPageScrolled(int n, float f, int n2) {
        }

        @Override
        public void onPageSelected(int n) {
        }
    }

    public static interface OnPageChangeListener {
        public void onPageScrollStateChanged(int var1);

        public void onPageScrolled(int var1, float var2, int var3);

        public void onPageSelected(int var1);
    }

    static class ItemInfo {
        Object object;
        float offset;
        int position;
        boolean scrolling;
        float widthFactor;

        ItemInfo() {
        }
    }
}

