/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal;

import android.app.Activity;
import android.content.Context;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.ContextThemeWrapper;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import com.actionbarsherlock.ActionBarSherlock;
import com.actionbarsherlock.app.ActionBar;
import com.actionbarsherlock.internal.app.ActionBarWrapper;
import com.actionbarsherlock.internal.view.menu.MenuWrapper;
import com.actionbarsherlock.view.ActionMode;
import com.actionbarsherlock.view.MenuInflater;

@ActionBarSherlock.Implementation(api=14)
public class ActionBarSherlockNative
extends ActionBarSherlock {
    private ActionBarWrapper mActionBar;
    private ActionModeWrapper mActionMode;
    private MenuWrapper mMenu;

    public ActionBarSherlockNative(Activity activity, int n) {
        super(activity, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initActionBar() {
        if (this.mActionBar != null || this.mActivity.getActionBar() == null) {
            return;
        }
        this.mActionBar = new ActionBarWrapper(this.mActivity);
    }

    @Override
    public void addContentView(View view, ViewGroup.LayoutParams layoutParams) {
        this.mActivity.getWindow().addContentView(view, layoutParams);
        this.initActionBar();
    }

    @Override
    public boolean dispatchCreateOptionsMenu(Menu menu2) {
        if (this.mMenu == null || menu2 != this.mMenu.unwrap()) {
            this.mMenu = new MenuWrapper(menu2);
        }
        return this.callbackCreateOptionsMenu(this.mMenu);
    }

    @Override
    public void dispatchInvalidateOptionsMenu() {
        this.mActivity.getWindow().invalidatePanelMenu(0);
    }

    @Override
    public boolean dispatchOptionsItemSelected(MenuItem menuItem) {
        return this.callbackOptionsItemSelected(this.mMenu.findItem(menuItem));
    }

    @Override
    public boolean dispatchPrepareOptionsMenu(Menu menu2) {
        return this.callbackPrepareOptionsMenu(this.mMenu);
    }

    @Override
    public ActionBar getActionBar() {
        this.initActionBar();
        return this.mActionBar;
    }

    @Override
    protected Context getThemedContext() {
        Activity activity = this.mActivity;
        TypedValue typedValue = new TypedValue();
        this.mActivity.getTheme().resolveAttribute(16843671, typedValue, true);
        if (typedValue.resourceId != 0) {
            activity = new ContextThemeWrapper((Context)activity, typedValue.resourceId);
        }
        return activity;
    }

    @Override
    public boolean hasFeature(int n) {
        return this.mActivity.getWindow().hasFeature(n);
    }

    @Override
    public boolean requestFeature(int n) {
        return this.mActivity.getWindow().requestFeature(n);
    }

    @Override
    public void setContentView(int n) {
        this.mActivity.getWindow().setContentView(n);
        this.initActionBar();
    }

    @Override
    public void setContentView(View view, ViewGroup.LayoutParams layoutParams) {
        this.mActivity.getWindow().setContentView(view, layoutParams);
        this.initActionBar();
    }

    @Override
    public void setProgress(int n) {
        this.mActivity.setProgress(n);
    }

    @Override
    public void setProgressBarIndeterminate(boolean bl) {
        this.mActivity.setProgressBarIndeterminate(bl);
    }

    @Override
    public void setProgressBarIndeterminateVisibility(boolean bl) {
        this.mActivity.setProgressBarIndeterminateVisibility(bl);
    }

    @Override
    public void setProgressBarVisibility(boolean bl) {
        this.mActivity.setProgressBarVisibility(bl);
    }

    @Override
    public void setSecondaryProgress(int n) {
        this.mActivity.setSecondaryProgress(n);
    }

    @Override
    public void setTitle(CharSequence charSequence) {
        this.mActivity.getWindow().setTitle(charSequence);
    }

    @Override
    public void setUiOptions(int n) {
        this.mActivity.getWindow().setUiOptions(n);
    }

    @Override
    public void setUiOptions(int n, int n2) {
        this.mActivity.getWindow().setUiOptions(n, n2);
    }

    @Override
    public com.actionbarsherlock.view.ActionMode startActionMode(ActionMode.Callback callback) {
        if (this.mActionMode != null) {
            this.mActionMode.finish();
        }
        ActionModeCallbackWrapper actionModeCallbackWrapper = null;
        if (callback != null) {
            actionModeCallbackWrapper = new ActionModeCallbackWrapper(callback);
        }
        this.mActivity.startActionMode(actionModeCallbackWrapper);
        return this.mActionMode;
    }

    private class ActionModeCallbackWrapper
    implements ActionMode.Callback {
        private final ActionMode.Callback mCallback;

        public ActionModeCallbackWrapper(ActionMode.Callback callback) {
            this.mCallback = callback;
        }

        public boolean onActionItemClicked(ActionMode actionMode, MenuItem menuItem) {
            return this.mCallback.onActionItemClicked(ActionBarSherlockNative.this.mActionMode, ActionBarSherlockNative.this.mActionMode.getMenu().findItem(menuItem));
        }

        public boolean onCreateActionMode(ActionMode actionMode, Menu menu2) {
            ActionBarSherlockNative.this.mActionMode = new ActionModeWrapper(actionMode);
            return this.mCallback.onCreateActionMode(ActionBarSherlockNative.this.mActionMode, ActionBarSherlockNative.this.mActionMode.getMenu());
        }

        public void onDestroyActionMode(ActionMode actionMode) {
            this.mCallback.onDestroyActionMode(ActionBarSherlockNative.this.mActionMode);
        }

        public boolean onPrepareActionMode(ActionMode actionMode, Menu menu2) {
            return this.mCallback.onPrepareActionMode(ActionBarSherlockNative.this.mActionMode, ActionBarSherlockNative.this.mActionMode.getMenu());
        }
    }

    private class ActionModeWrapper
    extends com.actionbarsherlock.view.ActionMode {
        private final ActionMode mActionMode;
        private MenuWrapper mMenu = null;

        ActionModeWrapper(ActionMode actionMode) {
            this.mActionMode = actionMode;
        }

        @Override
        public void finish() {
            this.mActionMode.finish();
        }

        @Override
        public View getCustomView() {
            return this.mActionMode.getCustomView();
        }

        @Override
        public MenuWrapper getMenu() {
            if (this.mMenu == null) {
                this.mMenu = new MenuWrapper(this.mActionMode.getMenu());
            }
            return this.mMenu;
        }

        @Override
        public MenuInflater getMenuInflater() {
            return ActionBarSherlockNative.this.getMenuInflater();
        }

        @Override
        public CharSequence getSubtitle() {
            return this.mActionMode.getSubtitle();
        }

        @Override
        public Object getTag() {
            return this.mActionMode.getTag();
        }

        @Override
        public CharSequence getTitle() {
            return this.mActionMode.getTitle();
        }

        @Override
        public void invalidate() {
            this.mActionMode.invalidate();
        }

        @Override
        public void setCustomView(View view) {
            this.mActionMode.setCustomView(view);
        }

        @Override
        public void setSubtitle(int n) {
            this.mActionMode.setSubtitle(n);
        }

        @Override
        public void setSubtitle(CharSequence charSequence) {
            this.mActionMode.setSubtitle(charSequence);
        }

        @Override
        public void setTag(Object object) {
            this.mActionMode.setTag(object);
        }

        @Override
        public void setTitle(int n) {
            this.mActionMode.setTitle(n);
        }

        @Override
        public void setTitle(CharSequence charSequence) {
            this.mActionMode.setTitle(charSequence);
        }
    }
}

