/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.nineoldandroids.animation;

import android.view.animation.Interpolator;
import com.actionbarsherlock.internal.nineoldandroids.animation.Keyframe;
import com.actionbarsherlock.internal.nineoldandroids.animation.KeyframeSet;
import java.util.ArrayList;

class FloatKeyframeSet
extends KeyframeSet {
    private float deltaValue;
    private boolean firstTime = true;
    private float firstValue;
    private float lastValue;

    public FloatKeyframeSet(Keyframe.FloatKeyframe ... floatKeyframeArray) {
        super(floatKeyframeArray);
    }

    @Override
    public FloatKeyframeSet clone() {
        ArrayList arrayList = this.mKeyframes;
        int n = this.mKeyframes.size();
        Keyframe.FloatKeyframe[] floatKeyframeArray = new Keyframe.FloatKeyframe[n];
        int n2 = 0;
        while (n2 < n) {
            floatKeyframeArray[n2] = (Keyframe.FloatKeyframe)((Keyframe)arrayList.get(n2)).clone();
            ++n2;
        }
        return new FloatKeyframeSet(floatKeyframeArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getFloatValue(float f) {
        if (this.mNumKeyframes == 2) {
            if (this.firstTime) {
                this.firstTime = false;
                this.firstValue = ((Keyframe.FloatKeyframe)this.mKeyframes.get(0)).getFloatValue();
                this.lastValue = ((Keyframe.FloatKeyframe)this.mKeyframes.get(1)).getFloatValue();
                this.deltaValue = this.lastValue - this.firstValue;
            }
            if (this.mInterpolator != null) {
                f = this.mInterpolator.getInterpolation(f);
            }
            if (this.mEvaluator != null) return ((Number)this.mEvaluator.evaluate(f, Float.valueOf(this.firstValue), Float.valueOf(this.lastValue))).floatValue();
            return this.firstValue + f * this.deltaValue;
        }
        if (f <= 0.0f) {
            Keyframe.FloatKeyframe floatKeyframe = (Keyframe.FloatKeyframe)this.mKeyframes.get(0);
            Keyframe.FloatKeyframe floatKeyframe2 = (Keyframe.FloatKeyframe)this.mKeyframes.get(1);
            float f2 = floatKeyframe.getFloatValue();
            float f3 = floatKeyframe2.getFloatValue();
            float f4 = floatKeyframe.getFraction();
            float f5 = floatKeyframe2.getFraction();
            Interpolator interpolator = floatKeyframe2.getInterpolator();
            if (interpolator != null) {
                f = interpolator.getInterpolation(f);
            }
            float f6 = (f - f4) / (f5 - f4);
            if (this.mEvaluator != null) return ((Number)this.mEvaluator.evaluate(f6, Float.valueOf(f2), Float.valueOf(f3))).floatValue();
            return f2 + f6 * (f3 - f2);
        }
        if (f >= 1.0f) {
            Keyframe.FloatKeyframe floatKeyframe = (Keyframe.FloatKeyframe)this.mKeyframes.get(-2 + this.mNumKeyframes);
            Keyframe.FloatKeyframe floatKeyframe3 = (Keyframe.FloatKeyframe)this.mKeyframes.get(-1 + this.mNumKeyframes);
            float f7 = floatKeyframe.getFloatValue();
            float f8 = floatKeyframe3.getFloatValue();
            float f9 = floatKeyframe.getFraction();
            float f10 = floatKeyframe3.getFraction();
            Interpolator interpolator = floatKeyframe3.getInterpolator();
            if (interpolator != null) {
                f = interpolator.getInterpolation(f);
            }
            float f11 = (f - f9) / (f10 - f9);
            if (this.mEvaluator != null) return ((Number)this.mEvaluator.evaluate(f11, Float.valueOf(f7), Float.valueOf(f8))).floatValue();
            return f7 + f11 * (f8 - f7);
        }
        Keyframe.FloatKeyframe floatKeyframe = (Keyframe.FloatKeyframe)this.mKeyframes.get(0);
        int n = 1;
        while (n < this.mNumKeyframes) {
            Keyframe.FloatKeyframe floatKeyframe4 = (Keyframe.FloatKeyframe)this.mKeyframes.get(n);
            if (f < floatKeyframe4.getFraction()) {
                Interpolator interpolator = floatKeyframe4.getInterpolator();
                if (interpolator != null) {
                    f = interpolator.getInterpolation(f);
                }
                float f12 = (f - floatKeyframe.getFraction()) / (floatKeyframe4.getFraction() - floatKeyframe.getFraction());
                float f13 = floatKeyframe.getFloatValue();
                float f14 = floatKeyframe4.getFloatValue();
                if (this.mEvaluator != null) return ((Number)this.mEvaluator.evaluate(f12, Float.valueOf(f13), Float.valueOf(f14))).floatValue();
                return f13 + f12 * (f14 - f13);
            }
            floatKeyframe = floatKeyframe4;
            ++n;
        }
        return ((Number)((Keyframe)this.mKeyframes.get(-1 + this.mNumKeyframes)).getValue()).floatValue();
    }

    @Override
    public Object getValue(float f) {
        return Float.valueOf(this.getFloatValue(f));
    }
}

