/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.nineoldandroids.animation;

import android.view.animation.Interpolator;
import com.actionbarsherlock.internal.nineoldandroids.animation.FloatKeyframeSet;
import com.actionbarsherlock.internal.nineoldandroids.animation.IntKeyframeSet;
import com.actionbarsherlock.internal.nineoldandroids.animation.Keyframe;
import com.actionbarsherlock.internal.nineoldandroids.animation.TypeEvaluator;
import java.util.ArrayList;
import java.util.Arrays;

class KeyframeSet {
    TypeEvaluator mEvaluator;
    Keyframe mFirstKeyframe;
    Interpolator mInterpolator;
    ArrayList<Keyframe> mKeyframes;
    Keyframe mLastKeyframe;
    int mNumKeyframes;

    public KeyframeSet(Keyframe ... keyframeArray) {
        this.mNumKeyframes = keyframeArray.length;
        this.mKeyframes = new ArrayList();
        this.mKeyframes.addAll(Arrays.asList(keyframeArray));
        this.mFirstKeyframe = this.mKeyframes.get(0);
        this.mLastKeyframe = this.mKeyframes.get(-1 + this.mNumKeyframes);
        this.mInterpolator = this.mLastKeyframe.getInterpolator();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static KeyframeSet ofFloat(float ... fArray) {
        int n = fArray.length;
        Keyframe.FloatKeyframe[] floatKeyframeArray = new Keyframe.FloatKeyframe[Math.max(n, 2)];
        if (n == 1) {
            floatKeyframeArray[0] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(0.0f);
            floatKeyframeArray[1] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(1.0f, fArray[0]);
            return new FloatKeyframeSet(floatKeyframeArray);
        } else {
            floatKeyframeArray[0] = (Keyframe.FloatKeyframe)Keyframe.ofFloat(0.0f, fArray[0]);
            for (int i = 1; i < n; ++i) {
                floatKeyframeArray[i] = (Keyframe.FloatKeyframe)Keyframe.ofFloat((float)i / (float)(n + -1), fArray[i]);
            }
        }
        return new FloatKeyframeSet(floatKeyframeArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static KeyframeSet ofInt(int ... nArray) {
        int n = nArray.length;
        Keyframe.IntKeyframe[] intKeyframeArray = new Keyframe.IntKeyframe[Math.max(n, 2)];
        if (n == 1) {
            intKeyframeArray[0] = (Keyframe.IntKeyframe)Keyframe.ofInt(0.0f);
            intKeyframeArray[1] = (Keyframe.IntKeyframe)Keyframe.ofInt(1.0f, nArray[0]);
            return new IntKeyframeSet(intKeyframeArray);
        } else {
            intKeyframeArray[0] = (Keyframe.IntKeyframe)Keyframe.ofInt(0.0f, nArray[0]);
            for (int i = 1; i < n; ++i) {
                intKeyframeArray[i] = (Keyframe.IntKeyframe)Keyframe.ofInt((float)i / (float)(n + -1), nArray[i]);
            }
        }
        return new IntKeyframeSet(intKeyframeArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static KeyframeSet ofKeyframe(Keyframe ... keyframeArray) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        int n;
        block11: {
            block10: {
                n = keyframeArray.length;
                bl3 = false;
                bl2 = false;
                bl = false;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        if (!bl3 || bl2 || bl) break;
                        break block10;
                    }
                    if (keyframeArray[n2] instanceof Keyframe.FloatKeyframe) {
                        bl3 = true;
                    } else if (keyframeArray[n2] instanceof Keyframe.IntKeyframe) {
                        bl2 = true;
                    } else {
                        bl = true;
                    }
                    ++n2;
                }
                break block11;
            }
            Keyframe.FloatKeyframe[] floatKeyframeArray = new Keyframe.FloatKeyframe[n];
            int n3 = 0;
            while (true) {
                if (n3 >= n) {
                    return new FloatKeyframeSet(floatKeyframeArray);
                }
                floatKeyframeArray[n3] = (Keyframe.FloatKeyframe)keyframeArray[n3];
                ++n3;
            }
        }
        if (!bl2) return new KeyframeSet(keyframeArray);
        if (bl3) return new KeyframeSet(keyframeArray);
        if (bl) return new KeyframeSet(keyframeArray);
        Keyframe.IntKeyframe[] intKeyframeArray = new Keyframe.IntKeyframe[n];
        int n4 = 0;
        while (n4 < n) {
            intKeyframeArray[n4] = (Keyframe.IntKeyframe)keyframeArray[n4];
            ++n4;
        }
        return new IntKeyframeSet(intKeyframeArray);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static KeyframeSet ofObject(Object ... objectArray) {
        int n = objectArray.length;
        Keyframe[] keyframeArray = new Keyframe.ObjectKeyframe[Math.max(n, 2)];
        if (n == 1) {
            keyframeArray[0] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(0.0f);
            keyframeArray[1] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(1.0f, objectArray[0]);
            return new KeyframeSet(keyframeArray);
        } else {
            keyframeArray[0] = (Keyframe.ObjectKeyframe)Keyframe.ofObject(0.0f, objectArray[0]);
            for (int i = 1; i < n; ++i) {
                keyframeArray[i] = (Keyframe.ObjectKeyframe)Keyframe.ofObject((float)i / (float)(n + -1), objectArray[i]);
            }
        }
        return new KeyframeSet(keyframeArray);
    }

    public KeyframeSet clone() {
        ArrayList<Keyframe> arrayList = this.mKeyframes;
        int n = this.mKeyframes.size();
        Keyframe[] keyframeArray = new Keyframe[n];
        int n2 = 0;
        while (n2 < n) {
            keyframeArray[n2] = arrayList.get(n2).clone();
            ++n2;
        }
        return new KeyframeSet(keyframeArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getValue(float f) {
        if (this.mNumKeyframes == 2) {
            if (this.mInterpolator == null) return this.mEvaluator.evaluate(f, this.mFirstKeyframe.getValue(), this.mLastKeyframe.getValue());
            f = this.mInterpolator.getInterpolation(f);
            return this.mEvaluator.evaluate(f, this.mFirstKeyframe.getValue(), this.mLastKeyframe.getValue());
        }
        if (f <= 0.0f) {
            Keyframe keyframe = this.mKeyframes.get(1);
            Interpolator interpolator = keyframe.getInterpolator();
            if (interpolator != null) {
                f = interpolator.getInterpolation(f);
            }
            float f2 = this.mFirstKeyframe.getFraction();
            float f3 = (f - f2) / (keyframe.getFraction() - f2);
            return this.mEvaluator.evaluate(f3, this.mFirstKeyframe.getValue(), keyframe.getValue());
        }
        if (f >= 1.0f) {
            Keyframe keyframe = this.mKeyframes.get(-2 + this.mNumKeyframes);
            Interpolator interpolator = this.mLastKeyframe.getInterpolator();
            if (interpolator != null) {
                f = interpolator.getInterpolation(f);
            }
            float f4 = keyframe.getFraction();
            float f5 = (f - f4) / (this.mLastKeyframe.getFraction() - f4);
            return this.mEvaluator.evaluate(f5, keyframe.getValue(), this.mLastKeyframe.getValue());
        }
        Keyframe keyframe = this.mFirstKeyframe;
        int n = 1;
        while (n < this.mNumKeyframes) {
            Keyframe keyframe2 = this.mKeyframes.get(n);
            if (f < keyframe2.getFraction()) {
                Interpolator interpolator = keyframe2.getInterpolator();
                if (interpolator != null) {
                    f = interpolator.getInterpolation(f);
                }
                float f6 = keyframe.getFraction();
                float f7 = (f - f6) / (keyframe2.getFraction() - f6);
                return this.mEvaluator.evaluate(f7, keyframe.getValue(), keyframe2.getValue());
            }
            keyframe = keyframe2;
            ++n;
        }
        return this.mLastKeyframe.getValue();
    }

    public void setEvaluator(TypeEvaluator typeEvaluator) {
        this.mEvaluator = typeEvaluator;
    }

    public String toString() {
        String string2 = " ";
        int n = 0;
        while (n < this.mNumKeyframes) {
            string2 = String.valueOf(string2) + this.mKeyframes.get(n).getValue() + "  ";
            ++n;
        }
        return string2;
    }
}

