/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.view.menu;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.Toast;
import com.actionbarsherlock.R;
import com.actionbarsherlock.internal.ResourcesCompat;
import com.actionbarsherlock.internal.view.View_HasStateListenerSupport;
import com.actionbarsherlock.internal.view.View_OnAttachStateChangeListener;
import com.actionbarsherlock.internal.view.menu.ActionMenuView;
import com.actionbarsherlock.internal.view.menu.MenuBuilder;
import com.actionbarsherlock.internal.view.menu.MenuItemImpl;
import com.actionbarsherlock.internal.view.menu.MenuView;
import com.actionbarsherlock.internal.widget.CapitalizingButton;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ActionMenuItemView
extends LinearLayout
implements MenuView.ItemView,
View.OnClickListener,
View.OnLongClickListener,
ActionMenuView.ActionMenuChildView,
View_HasStateListenerSupport {
    private boolean mAllowTextWithIcon;
    private boolean mExpandedFormat;
    private ImageButton mImageButton;
    private MenuItemImpl mItemData;
    private MenuBuilder.ItemInvoker mItemInvoker;
    private final Set<View_OnAttachStateChangeListener> mListeners = new HashSet<View_OnAttachStateChangeListener>();
    private int mMinWidth;
    private CapitalizingButton mTextButton;
    private CharSequence mTitle;

    public ActionMenuItemView(Context context) {
        this(context, null);
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet);
        this.mAllowTextWithIcon = ResourcesCompat.getResources_getBoolean(context, R.bool.abs__config_allowActionMenuItemTextWithIcon);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SherlockActionMenuItemView, 0, 0);
        this.mMinWidth = typedArray.getDimensionPixelSize(0, 0);
        typedArray.recycle();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateTextButtonVisibility() {
        int n = 1;
        int n2 = 0;
        int n3 = TextUtils.isEmpty((CharSequence)this.mTextButton.getText()) ? n2 : n;
        if (!(this.mImageButton.getDrawable() == null || this.mItemData.showsTextAsAction() && (this.mAllowTextWithIcon || this.mExpandedFormat))) {
            n = n2;
        }
        boolean bl = n3 & n;
        CapitalizingButton capitalizingButton = this.mTextButton;
        if (!bl) {
            n2 = 8;
        }
        capitalizingButton.setVisibility(n2);
    }

    @Override
    public void addOnAttachStateChangeListener(View_OnAttachStateChangeListener view_OnAttachStateChangeListener) {
        this.mListeners.add(view_OnAttachStateChangeListener);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean dispatchHoverEvent(MotionEvent motionEvent) {
        if (Build.VERSION.SDK_INT < 14) return false;
        return this.onHoverEvent(motionEvent);
    }

    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        this.onPopulateAccessibilityEvent(accessibilityEvent);
        return true;
    }

    @Override
    public MenuItemImpl getItemData() {
        return this.mItemData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasText() {
        if (this.mTextButton.getVisibility() == 8) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void initialize(MenuItemImpl menuItemImpl, int n) {
        this.mItemData = menuItemImpl;
        this.setIcon(menuItemImpl.getIcon());
        this.setTitle(menuItemImpl.getTitleForItemView(this));
        this.setId(menuItemImpl.getItemId());
        int n2 = menuItemImpl.isVisible() ? 0 : 8;
        this.setVisibility(n2);
        this.setEnabled(menuItemImpl.isEnabled());
    }

    @Override
    public boolean needsDividerAfter() {
        return this.hasText();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean needsDividerBefore() {
        if (!this.hasText()) return false;
        if (this.mItemData.getIcon() != null) return false;
        return true;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Iterator<View_OnAttachStateChangeListener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onViewAttachedToWindow((View)this);
        }
        return;
    }

    public void onClick(View view) {
        if (this.mItemInvoker != null) {
            this.mItemInvoker.invokeItem(this.mItemData);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Iterator<View_OnAttachStateChangeListener> iterator = this.mListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onViewDetachedFromWindow((View)this);
        }
        return;
    }

    public void onFinishInflate() {
        this.mImageButton = (ImageButton)this.findViewById(R.id.abs__imageButton);
        this.mTextButton = (CapitalizingButton)this.findViewById(R.id.abs__textButton);
        this.mImageButton.setOnClickListener((View.OnClickListener)this);
        this.mTextButton.setOnClickListener(this);
        this.mImageButton.setOnLongClickListener((View.OnLongClickListener)this);
        this.setOnClickListener(this);
        this.setOnLongClickListener(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onLongClick(View view) {
        int n = 0;
        if (this.hasText()) {
            return n != 0;
        }
        int[] nArray = new int[2];
        Rect rect = new Rect();
        this.getLocationOnScreen(nArray);
        this.getWindowVisibleDisplayFrame(rect);
        Context context = this.getContext();
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        int n4 = nArray[1] + n3 / 2;
        int n5 = context.getResources().getDisplayMetrics().widthPixels;
        Toast toast = Toast.makeText((Context)context, (CharSequence)this.mItemData.getTitle(), (int)n);
        if (n4 < rect.height()) {
            toast.setGravity(53, n5 - nArray[n] - n2 / 2, n3);
        } else {
            toast.setGravity(81, n, n3);
        }
        toast.show();
        return 1 != 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = View.MeasureSpec.getMode((int)n);
        int n4 = View.MeasureSpec.getSize((int)n);
        int n5 = this.getMeasuredWidth();
        int n6 = n3 == Integer.MIN_VALUE ? Math.min(n4, this.mMinWidth) : this.mMinWidth;
        if (n3 != 0x40000000 && this.mMinWidth > 0 && n5 < n6) {
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)n6, (int)0x40000000), n2);
        }
    }

    public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        CharSequence charSequence;
        if (Build.VERSION.SDK_INT >= 14) {
            super.onPopulateAccessibilityEvent(accessibilityEvent);
        }
        if (!TextUtils.isEmpty((CharSequence)(charSequence = this.getContentDescription()))) {
            accessibilityEvent.getText().add(charSequence);
        }
    }

    @Override
    public boolean prefersCondensedTitle() {
        return true;
    }

    @Override
    public void removeOnAttachStateChangeListener(View_OnAttachStateChangeListener view_OnAttachStateChangeListener) {
        this.mListeners.remove(view_OnAttachStateChangeListener);
    }

    @Override
    public void setCheckable(boolean bl) {
    }

    @Override
    public void setChecked(boolean bl) {
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.mImageButton.setEnabled(bl);
        this.mTextButton.setEnabled(bl);
    }

    public void setExpandedFormat(boolean bl) {
        if (this.mExpandedFormat != bl) {
            this.mExpandedFormat = bl;
            if (this.mItemData != null) {
                this.mItemData.actionFormatChanged();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setIcon(Drawable drawable2) {
        this.mImageButton.setImageDrawable(drawable2);
        if (drawable2 != null) {
            this.mImageButton.setVisibility(0);
        } else {
            this.mImageButton.setVisibility(8);
        }
        this.updateTextButtonVisibility();
    }

    public void setItemInvoker(MenuBuilder.ItemInvoker itemInvoker) {
        this.mItemInvoker = itemInvoker;
    }

    @Override
    public void setShortcut(boolean bl, char c) {
    }

    @Override
    public void setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        this.mTextButton.setTextCompat(this.mTitle);
        this.setContentDescription(this.mTitle);
        this.updateTextButtonVisibility();
    }

    @Override
    public boolean showsIcon() {
        return true;
    }
}

