/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.view.menu;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.View;
import com.actionbarsherlock.R;
import com.actionbarsherlock.internal.view.menu.MenuItemImpl;
import com.actionbarsherlock.internal.view.menu.MenuPresenter;
import com.actionbarsherlock.internal.view.menu.SubMenuBuilder;
import com.actionbarsherlock.view.ActionProvider;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.SubMenu;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MenuBuilder
implements Menu {
    private static final String ACTION_VIEW_STATES_KEY = "android:menu:actionviewstates";
    private static final String EXPANDED_ACTION_VIEW_ID = "android:menu:expandedactionview";
    private static final String PRESENTER_KEY = "android:menu:presenters";
    private static final int[] sCategoryToOrder;
    private ArrayList<MenuItemImpl> mActionItems;
    private Callback mCallback;
    private final Context mContext;
    private ContextMenu.ContextMenuInfo mCurrentMenuInfo;
    private int mDefaultShowAsAction = 0;
    private MenuItemImpl mExpandedItem;
    Drawable mHeaderIcon;
    CharSequence mHeaderTitle;
    View mHeaderView;
    private boolean mIsActionItemsStale;
    private boolean mIsClosing = false;
    private boolean mIsVisibleItemsStale;
    private ArrayList<MenuItemImpl> mItems;
    private boolean mItemsChangedWhileDispatchPrevented = false;
    private ArrayList<MenuItemImpl> mNonActionItems;
    private boolean mOptionalIconsVisible = false;
    private CopyOnWriteArrayList<WeakReference<MenuPresenter>> mPresenters;
    private boolean mPreventDispatchingItemsChanged = false;
    private boolean mQwertyMode;
    private final Resources mResources;
    private boolean mShortcutsVisible;
    private ArrayList<MenuItemImpl> mTempShortcutItemList = new ArrayList();
    private ArrayList<MenuItemImpl> mVisibleItems;

    static {
        int[] nArray = new int[6];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[2] = 5;
        nArray[3] = 3;
        nArray[4] = 2;
        sCategoryToOrder = nArray;
    }

    public MenuBuilder(Context context) {
        this.mPresenters = new CopyOnWriteArrayList();
        this.mContext = context;
        this.mResources = context.getResources();
        this.mItems = new ArrayList();
        this.mVisibleItems = new ArrayList();
        this.mIsVisibleItemsStale = true;
        this.mActionItems = new ArrayList();
        this.mNonActionItems = new ArrayList();
        this.mIsActionItemsStale = true;
        this.setShortcutsVisibleInner(true);
    }

    private com.actionbarsherlock.view.MenuItem addInternal(int n, int n2, int n3, CharSequence charSequence) {
        int n4 = MenuBuilder.getOrdering(n3);
        MenuItemImpl menuItemImpl = new MenuItemImpl(this, n, n2, n3, n4, charSequence, this.mDefaultShowAsAction);
        if (this.mCurrentMenuInfo != null) {
            menuItemImpl.setMenuInfo(this.mCurrentMenuInfo);
        }
        this.mItems.add(MenuBuilder.findInsertIndex(this.mItems, n4), menuItemImpl);
        this.onItemsChanged(true);
        return menuItemImpl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dispatchPresenterUpdate(boolean bl) {
        if (this.mPresenters.isEmpty()) {
            return;
        }
        this.stopDispatchingItemsChanged();
        Iterator<WeakReference<MenuPresenter>> iterator = this.mPresenters.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.startDispatchingItemsChanged();
                return;
            }
            WeakReference<MenuPresenter> weakReference = iterator.next();
            MenuPresenter menuPresenter = (MenuPresenter)weakReference.get();
            if (menuPresenter == null) {
                this.mPresenters.remove(weakReference);
                continue;
            }
            menuPresenter.updateMenuView(bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void dispatchRestoreInstanceState(Bundle bundle) {
        SparseArray sparseArray = bundle.getSparseParcelableArray(PRESENTER_KEY);
        if (sparseArray != null && !this.mPresenters.isEmpty()) {
            for (WeakReference<MenuPresenter> weakReference : this.mPresenters) {
                Parcelable parcelable;
                MenuPresenter menuPresenter = (MenuPresenter)weakReference.get();
                if (menuPresenter == null) {
                    this.mPresenters.remove(weakReference);
                    continue;
                }
                int n = menuPresenter.getId();
                if (n <= 0 || (parcelable = (Parcelable)sparseArray.get(n)) == null) continue;
                menuPresenter.onRestoreInstanceState(parcelable);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dispatchSaveInstanceState(Bundle bundle) {
        if (this.mPresenters.isEmpty()) {
            return;
        }
        SparseArray sparseArray = new SparseArray();
        Iterator<WeakReference<MenuPresenter>> iterator = this.mPresenters.iterator();
        while (true) {
            Parcelable parcelable;
            if (!iterator.hasNext()) {
                bundle.putSparseParcelableArray(PRESENTER_KEY, sparseArray);
                return;
            }
            WeakReference<MenuPresenter> weakReference = iterator.next();
            MenuPresenter menuPresenter = (MenuPresenter)weakReference.get();
            if (menuPresenter == null) {
                this.mPresenters.remove(weakReference);
                continue;
            }
            int n = menuPresenter.getId();
            if (n <= 0 || (parcelable = menuPresenter.onSaveInstanceState()) == null) continue;
            sparseArray.put(n, (Object)parcelable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean dispatchSubMenuSelected(SubMenuBuilder subMenuBuilder) {
        if (this.mPresenters.isEmpty()) {
            return false;
        }
        boolean bl = false;
        Iterator<WeakReference<MenuPresenter>> iterator = this.mPresenters.iterator();
        while (iterator.hasNext()) {
            WeakReference<MenuPresenter> weakReference = iterator.next();
            MenuPresenter menuPresenter = (MenuPresenter)weakReference.get();
            if (menuPresenter == null) {
                this.mPresenters.remove(weakReference);
                continue;
            }
            if (bl) continue;
            bl = menuPresenter.onSubMenuSelected(subMenuBuilder);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int findInsertIndex(ArrayList<MenuItemImpl> arrayList, int n) {
        int n2 = -1 + arrayList.size();
        while (n2 >= 0) {
            if (arrayList.get(n2).getOrdering() <= n) {
                return n2 + 1;
            }
            --n2;
        }
        return 0;
    }

    private static int getOrdering(int n) {
        int n2 = (0xFFFF0000 & n) >> 16;
        if (n2 < 0 || n2 >= sCategoryToOrder.length) {
            throw new IllegalArgumentException("order does not contain a valid category.");
        }
        return sCategoryToOrder[n2] << 16 | 0xFFFF & n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void removeItemAtInt(int n, boolean bl) {
        if (n < 0) return;
        if (n >= this.mItems.size()) {
            return;
        }
        this.mItems.remove(n);
        if (!bl) return;
        this.onItemsChanged(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setHeaderInternal(int n, CharSequence charSequence, int n2, Drawable drawable2, View view) {
        Resources resources = this.getResources();
        if (view != null) {
            this.mHeaderView = view;
            this.mHeaderTitle = null;
            this.mHeaderIcon = null;
        } else {
            if (n > 0) {
                this.mHeaderTitle = resources.getText(n);
            } else if (charSequence != null) {
                this.mHeaderTitle = charSequence;
            }
            if (n2 > 0) {
                this.mHeaderIcon = resources.getDrawable(n2);
            } else if (drawable2 != null) {
                this.mHeaderIcon = drawable2;
            }
            this.mHeaderView = null;
        }
        this.onItemsChanged(false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setShortcutsVisibleInner(boolean bl) {
        int n = 1;
        if (!bl || this.mResources.getConfiguration().keyboard == n || !this.mResources.getBoolean(R.bool.abs__config_showMenuShortcutsWhenKeyboardPresent)) {
            n = 0;
        }
        this.mShortcutsVisible = n;
    }

    @Override
    public com.actionbarsherlock.view.MenuItem add(int n) {
        return this.addInternal(0, 0, 0, this.mResources.getString(n));
    }

    @Override
    public com.actionbarsherlock.view.MenuItem add(int n, int n2, int n3, int n4) {
        return this.addInternal(n, n2, n3, this.mResources.getString(n4));
    }

    @Override
    public com.actionbarsherlock.view.MenuItem add(int n, int n2, int n3, CharSequence charSequence) {
        return this.addInternal(n, n2, n3, charSequence);
    }

    @Override
    public com.actionbarsherlock.view.MenuItem add(CharSequence charSequence) {
        return this.addInternal(0, 0, 0, charSequence);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int addIntentOptions(int n, int n2, int n3, ComponentName componentName, Intent[] intentArray, Intent intent, int n4, com.actionbarsherlock.view.MenuItem[] menuItemArray) {
        PackageManager packageManager = this.mContext.getPackageManager();
        List list = packageManager.queryIntentActivityOptions(componentName, intentArray, intent, 0);
        int n5 = list != null ? list.size() : 0;
        if ((n4 & 1) == 0) {
            this.removeGroup(n);
        }
        int n6 = 0;
        while (n6 < n5) {
            ResolveInfo resolveInfo = (ResolveInfo)list.get(n6);
            Intent intent2 = resolveInfo.specificIndex < 0 ? intent : intentArray[resolveInfo.specificIndex];
            Intent intent3 = new Intent(intent2);
            intent3.setComponent(new ComponentName(resolveInfo.activityInfo.applicationInfo.packageName, resolveInfo.activityInfo.name));
            com.actionbarsherlock.view.MenuItem menuItem = this.add(n, n2, n3, resolveInfo.loadLabel(packageManager)).setIcon(resolveInfo.loadIcon(packageManager)).setIntent(intent3);
            if (menuItemArray != null && resolveInfo.specificIndex >= 0) {
                menuItemArray[resolveInfo.specificIndex] = menuItem;
            }
            ++n6;
        }
        return n5;
    }

    public void addMenuPresenter(MenuPresenter menuPresenter) {
        this.mPresenters.add(new WeakReference<MenuPresenter>(menuPresenter));
        menuPresenter.initForMenu(this.mContext, this);
        this.mIsActionItemsStale = true;
    }

    @Override
    public SubMenu addSubMenu(int n) {
        return this.addSubMenu(0, 0, 0, this.mResources.getString(n));
    }

    @Override
    public SubMenu addSubMenu(int n, int n2, int n3, int n4) {
        return this.addSubMenu(n, n2, n3, this.mResources.getString(n4));
    }

    @Override
    public SubMenu addSubMenu(int n, int n2, int n3, CharSequence charSequence) {
        MenuItemImpl menuItemImpl = (MenuItemImpl)this.addInternal(n, n2, n3, charSequence);
        SubMenuBuilder subMenuBuilder = new SubMenuBuilder(this.mContext, this, menuItemImpl);
        menuItemImpl.setSubMenu(subMenuBuilder);
        return subMenuBuilder;
    }

    @Override
    public SubMenu addSubMenu(CharSequence charSequence) {
        return this.addSubMenu(0, 0, 0, charSequence);
    }

    /*
     * Unable to fully structure code
     */
    public boolean bindNativeOverflow(android.view.Menu var1_1, MenuItem.OnMenuItemClickListener var2_2, HashMap<MenuItem, MenuItemImpl> var3_3) {
        var4_4 = this.getNonActionItems();
        if (var4_4 == null || var4_4.size() == 0) {
            var5_5 = false;
            return var5_5;
        }
        var5_5 = false;
        var1_1.clear();
        var6_6 = var4_4.iterator();
        while (true) lbl-1000:
        // 3 sources

        {
            if (!var6_6.hasNext()) ** continue;
            var7_7 = (MenuItemImpl)var6_6.next();
            if (!var7_7.isVisible()) ** continue;
            var5_5 = true;
            if (!var7_7.hasSubMenu()) break;
            var19_9 = var1_1.addSubMenu(var7_7.getGroupId(), var7_7.getItemId(), var7_7.getOrder(), var7_7.getTitle());
            var20_10 = ((SubMenuBuilder)var7_7.getSubMenu()).getVisibleItems().iterator();
            while (true) {
                if (!var20_10.hasNext()) {
                    var8_8 = var19_9.getItem();
lbl20:
                    // 2 sources

                    while (true) {
                        var8_8.setIcon(var7_7.getIcon());
                        var8_8.setOnMenuItemClickListener(var2_2);
                        var8_8.setEnabled(var7_7.isEnabled());
                        var8_8.setIntent(var7_7.getIntent());
                        var8_8.setNumericShortcut(var7_7.getNumericShortcut());
                        var8_8.setAlphabeticShortcut(var7_7.getAlphabeticShortcut());
                        var8_8.setTitleCondensed(var7_7.getTitleCondensed());
                        var8_8.setCheckable(var7_7.isCheckable());
                        var8_8.setChecked(var7_7.isChecked());
                        if (var7_7.isExclusiveCheckable()) {
                            var1_1.setGroupCheckable(var7_7.getGroupId(), true, true);
                        }
                        var3_3.put(var8_8, var7_7);
                        ** continue;
                        break;
                    }
                }
                var21_11 = var20_10.next();
                var22_12 = var19_9.add(var21_11.getGroupId(), var21_11.getItemId(), var21_11.getOrder(), var21_11.getTitle());
                var22_12.setIcon(var21_11.getIcon());
                var22_12.setOnMenuItemClickListener(var2_2);
                var22_12.setEnabled(var21_11.isEnabled());
                var22_12.setIntent(var21_11.getIntent());
                var22_12.setNumericShortcut(var21_11.getNumericShortcut());
                var22_12.setAlphabeticShortcut(var21_11.getAlphabeticShortcut());
                var22_12.setTitleCondensed(var21_11.getTitleCondensed());
                var22_12.setCheckable(var21_11.isCheckable());
                var22_12.setChecked(var21_11.isChecked());
                if (var21_11.isExclusiveCheckable()) {
                    var19_9.setGroupCheckable(var21_11.getGroupId(), true, true);
                }
                var3_3.put(var22_12, var21_11);
            }
            break;
        }
        var8_8 = var1_1.add(var7_7.getGroupId(), var7_7.getItemId(), var7_7.getOrder(), var7_7.getTitle());
        ** while (true)
    }

    public void changeMenuMode() {
        if (this.mCallback != null) {
            this.mCallback.onMenuModeChange(this);
        }
    }

    @Override
    public void clear() {
        if (this.mExpandedItem != null) {
            this.collapseItemActionView(this.mExpandedItem);
        }
        this.mItems.clear();
        this.onItemsChanged(true);
    }

    public void clearAll() {
        this.mPreventDispatchingItemsChanged = true;
        this.clear();
        this.clearHeader();
        this.mPreventDispatchingItemsChanged = false;
        this.mItemsChangedWhileDispatchPrevented = false;
        this.onItemsChanged(true);
    }

    public void clearHeader() {
        this.mHeaderIcon = null;
        this.mHeaderTitle = null;
        this.mHeaderView = null;
        this.onItemsChanged(false);
    }

    @Override
    public void close() {
        this.close(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final void close(boolean bl) {
        if (this.mIsClosing) {
            return;
        }
        this.mIsClosing = true;
        Iterator<WeakReference<MenuPresenter>> iterator = this.mPresenters.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.mIsClosing = false;
                return;
            }
            WeakReference<MenuPresenter> weakReference = iterator.next();
            MenuPresenter menuPresenter = (MenuPresenter)weakReference.get();
            if (menuPresenter == null) {
                this.mPresenters.remove(weakReference);
                continue;
            }
            menuPresenter.onCloseMenu(this, bl);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean collapseItemActionView(MenuItemImpl menuItemImpl) {
        if (this.mPresenters.isEmpty()) return false;
        if (this.mExpandedItem != menuItemImpl) {
            return false;
        }
        boolean bl = false;
        this.stopDispatchingItemsChanged();
        for (WeakReference<MenuPresenter> weakReference : this.mPresenters) {
            MenuPresenter menuPresenter = (MenuPresenter)weakReference.get();
            if (menuPresenter == null) {
                this.mPresenters.remove(weakReference);
                continue;
            }
            bl = menuPresenter.collapseItemActionView(this, menuItemImpl);
            if (!bl) continue;
        }
        this.startDispatchingItemsChanged();
        if (!bl) return bl;
        this.mExpandedItem = null;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean dispatchMenuItemSelected(MenuBuilder menuBuilder, com.actionbarsherlock.view.MenuItem menuItem) {
        if (this.mCallback == null) return false;
        if (!this.mCallback.onMenuItemSelected(menuBuilder, menuItem)) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean expandItemActionView(MenuItemImpl menuItemImpl) {
        if (this.mPresenters.isEmpty()) {
            return false;
        }
        boolean bl = false;
        this.stopDispatchingItemsChanged();
        for (WeakReference<MenuPresenter> weakReference : this.mPresenters) {
            MenuPresenter menuPresenter = (MenuPresenter)weakReference.get();
            if (menuPresenter == null) {
                this.mPresenters.remove(weakReference);
                continue;
            }
            bl = menuPresenter.expandItemActionView(this, menuItemImpl);
            if (!bl) continue;
        }
        this.startDispatchingItemsChanged();
        if (!bl) return bl;
        this.mExpandedItem = menuItemImpl;
        return bl;
    }

    public int findGroupIndex(int n) {
        return this.findGroupIndex(n, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int findGroupIndex(int n, int n2) {
        int n3 = this.size();
        if (n2 < 0) {
            n2 = 0;
        }
        int n4 = n2;
        while (n4 < n3) {
            if (this.mItems.get(n4).getGroupId() == n) return n4;
            ++n4;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public com.actionbarsherlock.view.MenuItem findItem(int n) {
        int n2 = this.size();
        int n3 = 0;
        void var4_6;
        while (n3 < n2) {
            com.actionbarsherlock.view.MenuItem menuItem;
            MenuItemImpl menuItemImpl = this.mItems.get(n3);
            if (menuItemImpl.getItemId() == n) return var4_6;
            if (menuItemImpl.hasSubMenu() && (menuItem = menuItemImpl.getSubMenu().findItem(n)) != null) {
                com.actionbarsherlock.view.MenuItem menuItem2 = menuItem;
                return var4_6;
            }
            ++n3;
        }
        return var4_6;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int findItemIndex(int n) {
        int n2 = this.size();
        int n3 = 0;
        while (n3 < n2) {
            if (this.mItems.get(n3).getItemId() == n) return n3;
            ++n3;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    MenuItemImpl findItemWithShortcutForKey(int n, KeyEvent keyEvent) {
        MenuItemImpl menuItemImpl = null;
        ArrayList<MenuItemImpl> arrayList = this.mTempShortcutItemList;
        arrayList.clear();
        this.findItemsWithShortcutForKey(arrayList, n, keyEvent);
        if (arrayList.isEmpty()) {
            return menuItemImpl;
        }
        int n2 = keyEvent.getMetaState();
        KeyCharacterMap.KeyData keyData = new KeyCharacterMap.KeyData();
        keyEvent.getKeyData(keyData);
        int n3 = arrayList.size();
        if (n3 == 1) {
            return arrayList.get(0);
        }
        boolean bl = this.isQwertyMode();
        int n4 = 0;
        while (n4 < n3) {
            MenuItemImpl menuItemImpl2 = arrayList.get(n4);
            char c = bl ? menuItemImpl2.getAlphabeticShortcut() : menuItemImpl2.getNumericShortcut();
            if (c == keyData.meta[0]) {
                if ((n2 & 2) == 0) return menuItemImpl2;
            }
            if (c == keyData.meta[2]) {
                if ((n2 & 2) != 0) return menuItemImpl2;
            }
            if (bl && c == '\b' && n == 67) {
                return menuItemImpl2;
            }
            ++n4;
        }
        return menuItemImpl;
    }

    /*
     * Enabled aggressive block sorting
     */
    void findItemsWithShortcutForKey(List<MenuItemImpl> list, int n, KeyEvent keyEvent) {
        boolean bl = this.isQwertyMode();
        int n2 = keyEvent.getMetaState();
        KeyCharacterMap.KeyData keyData = new KeyCharacterMap.KeyData();
        if (keyEvent.getKeyData(keyData) || n == 67) {
            int n3 = this.mItems.size();
            for (int i = 0; i < n3; ++i) {
                MenuItemImpl menuItemImpl = this.mItems.get(i);
                if (menuItemImpl.hasSubMenu()) {
                    ((MenuBuilder)((Object)menuItemImpl.getSubMenu())).findItemsWithShortcutForKey(list, n, keyEvent);
                }
                char c = bl ? menuItemImpl.getAlphabeticShortcut() : menuItemImpl.getNumericShortcut();
                if ((n2 & 5) != 0 || c == '\u0000' || c != keyData.meta[0] && c != keyData.meta[2] && (!bl || c != '\b' || n != 67) || !menuItemImpl.isEnabled()) continue;
                list.add(menuItemImpl);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void flagActionItems() {
        block7: {
            int n;
            ArrayList<MenuItemImpl> arrayList;
            block6: {
                if (!this.mIsActionItemsStale) {
                    return;
                }
                boolean bl = false;
                Iterator<WeakReference<MenuPresenter>> iterator = this.mPresenters.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        if (!bl) break;
                        this.mActionItems.clear();
                        this.mNonActionItems.clear();
                        arrayList = this.getVisibleItems();
                        n = arrayList.size();
                        break block6;
                    }
                    WeakReference<MenuPresenter> weakReference = iterator.next();
                    MenuPresenter menuPresenter = (MenuPresenter)weakReference.get();
                    if (menuPresenter == null) {
                        this.mPresenters.remove(weakReference);
                        continue;
                    }
                    bl |= menuPresenter.flagActionItems();
                }
                this.mActionItems.clear();
                this.mNonActionItems.clear();
                this.mNonActionItems.addAll(this.getVisibleItems());
                break block7;
            }
            for (int i = 0; i < n; ++i) {
                MenuItemImpl menuItemImpl = arrayList.get(i);
                if (menuItemImpl.isActionButton()) {
                    this.mActionItems.add(menuItemImpl);
                    continue;
                }
                this.mNonActionItems.add(menuItemImpl);
            }
        }
        this.mIsActionItemsStale = false;
    }

    ArrayList<MenuItemImpl> getActionItems() {
        this.flagActionItems();
        return this.mActionItems;
    }

    protected String getActionViewStatesKey() {
        return ACTION_VIEW_STATES_KEY;
    }

    public Context getContext() {
        return this.mContext;
    }

    public MenuItemImpl getExpandedItem() {
        return this.mExpandedItem;
    }

    public Drawable getHeaderIcon() {
        return this.mHeaderIcon;
    }

    public CharSequence getHeaderTitle() {
        return this.mHeaderTitle;
    }

    public View getHeaderView() {
        return this.mHeaderView;
    }

    @Override
    public com.actionbarsherlock.view.MenuItem getItem(int n) {
        return this.mItems.get(n);
    }

    ArrayList<MenuItemImpl> getNonActionItems() {
        this.flagActionItems();
        return this.mNonActionItems;
    }

    boolean getOptionalIconsVisible() {
        return this.mOptionalIconsVisible;
    }

    Resources getResources() {
        return this.mResources;
    }

    public MenuBuilder getRootMenu() {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ArrayList<MenuItemImpl> getVisibleItems() {
        if (!this.mIsVisibleItemsStale) {
            return this.mVisibleItems;
        }
        this.mVisibleItems.clear();
        int n = this.mItems.size();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                this.mIsVisibleItemsStale = false;
                this.mIsActionItemsStale = true;
                return this.mVisibleItems;
            }
            MenuItemImpl menuItemImpl = this.mItems.get(n2);
            if (menuItemImpl.isVisible()) {
                this.mVisibleItems.add(menuItemImpl);
            }
            ++n2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasVisibleItems() {
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            if (this.mItems.get(n2).isVisible()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    boolean isQwertyMode() {
        return this.mQwertyMode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isShortcutKey(int n, KeyEvent keyEvent) {
        if (this.findItemWithShortcutForKey(n, keyEvent) == null) return false;
        return true;
    }

    public boolean isShortcutsVisible() {
        return this.mShortcutsVisible;
    }

    void onItemActionRequestChanged(MenuItemImpl menuItemImpl) {
        this.mIsActionItemsStale = true;
        this.onItemsChanged(true);
    }

    void onItemVisibleChanged(MenuItemImpl menuItemImpl) {
        this.mIsVisibleItemsStale = true;
        this.onItemsChanged(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void onItemsChanged(boolean bl) {
        if (!this.mPreventDispatchingItemsChanged) {
            if (bl) {
                this.mIsVisibleItemsStale = true;
                this.mIsActionItemsStale = true;
            }
            this.dispatchPresenterUpdate(bl);
            return;
        }
        this.mItemsChangedWhileDispatchPrevented = true;
    }

    @Override
    public boolean performIdentifierAction(int n, int n2) {
        return this.performItemAction(this.findItem(n), n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean performItemAction(com.actionbarsherlock.view.MenuItem menuItem, int n) {
        MenuItemImpl menuItemImpl = (MenuItemImpl)menuItem;
        if (menuItemImpl == null) return false;
        if (!menuItemImpl.isEnabled()) {
            return false;
        }
        boolean bl = menuItemImpl.invoke();
        if (menuItemImpl.hasCollapsibleActionView()) {
            if (!(bl |= menuItemImpl.expandActionView())) return bl;
            this.close(true);
            return bl;
        }
        if (menuItem.hasSubMenu()) {
            this.close(false);
            SubMenuBuilder subMenuBuilder = (SubMenuBuilder)menuItem.getSubMenu();
            ActionProvider actionProvider = menuItem.getActionProvider();
            if (actionProvider != null && actionProvider.hasSubMenu()) {
                actionProvider.onPrepareSubMenu(subMenuBuilder);
            }
            if (bl |= this.dispatchSubMenuSelected(subMenuBuilder)) return bl;
            this.close(true);
            return bl;
        }
        if ((n & 1) != 0) return bl;
        this.close(true);
        return bl;
    }

    @Override
    public boolean performShortcut(int n, KeyEvent keyEvent, int n2) {
        MenuItemImpl menuItemImpl = this.findItemWithShortcutForKey(n, keyEvent);
        boolean bl = false;
        if (menuItemImpl != null) {
            bl = this.performItemAction(menuItemImpl, n2);
        }
        if ((n2 & 2) != 0) {
            this.close(true);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void removeGroup(int n) {
        int n2 = this.findGroupIndex(n);
        if (n2 < 0) return;
        int n3 = this.mItems.size() - n2;
        int n4 = 0;
        while (true) {
            int n5 = n4 + 1;
            if (n4 >= n3 || this.mItems.get(n2).getGroupId() != n) {
                this.onItemsChanged(true);
                return;
            }
            this.removeItemAtInt(n2, false);
            n4 = n5;
        }
    }

    @Override
    public void removeItem(int n) {
        this.removeItemAtInt(this.findItemIndex(n), true);
    }

    public void removeItemAt(int n) {
        this.removeItemAtInt(n, true);
    }

    public void removeMenuPresenter(MenuPresenter menuPresenter) {
        Iterator<WeakReference<MenuPresenter>> iterator = this.mPresenters.iterator();
        while (iterator.hasNext()) {
            WeakReference<MenuPresenter> weakReference = iterator.next();
            MenuPresenter menuPresenter2 = (MenuPresenter)weakReference.get();
            if (menuPresenter2 != null && menuPresenter2 != menuPresenter) continue;
            this.mPresenters.remove(weakReference);
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void restoreActionViewStates(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        SparseArray sparseArray = bundle.getSparseParcelableArray(this.getActionViewStatesKey());
        int n = this.size();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                int n3 = bundle.getInt(EXPANDED_ACTION_VIEW_ID);
                if (n3 <= 0) return;
                com.actionbarsherlock.view.MenuItem menuItem = this.findItem(n3);
                if (menuItem == null) return;
                menuItem.expandActionView();
                return;
            }
            com.actionbarsherlock.view.MenuItem menuItem = this.getItem(n2);
            View view = menuItem.getActionView();
            if (view != null && view.getId() != -1) {
                view.restoreHierarchyState(sparseArray);
            }
            if (menuItem.hasSubMenu()) {
                ((SubMenuBuilder)menuItem.getSubMenu()).restoreActionViewStates(bundle);
            }
            ++n2;
        }
    }

    public void restorePresenterStates(Bundle bundle) {
        this.dispatchRestoreInstanceState(bundle);
    }

    public void saveActionViewStates(Bundle bundle) {
        SparseArray sparseArray = null;
        int n = this.size();
        int n2 = 0;
        while (true) {
            if (n2 >= n) {
                if (sparseArray != null) {
                    bundle.putSparseParcelableArray(this.getActionViewStatesKey(), sparseArray);
                }
                return;
            }
            com.actionbarsherlock.view.MenuItem menuItem = this.getItem(n2);
            View view = menuItem.getActionView();
            if (view != null && view.getId() != -1) {
                if (sparseArray == null) {
                    sparseArray = new SparseArray();
                }
                view.saveHierarchyState(sparseArray);
                if (menuItem.isActionViewExpanded()) {
                    bundle.putInt(EXPANDED_ACTION_VIEW_ID, menuItem.getItemId());
                }
            }
            if (menuItem.hasSubMenu()) {
                ((SubMenuBuilder)menuItem.getSubMenu()).saveActionViewStates(bundle);
            }
            ++n2;
        }
    }

    public void savePresenterStates(Bundle bundle) {
        this.dispatchSaveInstanceState(bundle);
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void setCurrentMenuInfo(ContextMenu.ContextMenuInfo contextMenuInfo) {
        this.mCurrentMenuInfo = contextMenuInfo;
    }

    public MenuBuilder setDefaultShowAsAction(int n) {
        this.mDefaultShowAsAction = n;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setExclusiveItemChecked(com.actionbarsherlock.view.MenuItem menuItem) {
        int n = menuItem.getGroupId();
        int n2 = this.mItems.size();
        int n3 = 0;
        while (n3 < n2) {
            MenuItemImpl menuItemImpl = this.mItems.get(n3);
            if (menuItemImpl.getGroupId() == n && menuItemImpl.isExclusiveCheckable() && menuItemImpl.isCheckable()) {
                boolean bl = menuItemImpl == menuItem;
                menuItemImpl.setCheckedInt(bl);
            }
            ++n3;
        }
        return;
    }

    @Override
    public void setGroupCheckable(int n, boolean bl, boolean bl2) {
        int n2 = this.mItems.size();
        int n3 = 0;
        while (n3 < n2) {
            MenuItemImpl menuItemImpl = this.mItems.get(n3);
            if (menuItemImpl.getGroupId() == n) {
                menuItemImpl.setExclusiveCheckable(bl2);
                menuItemImpl.setCheckable(bl);
            }
            ++n3;
        }
        return;
    }

    @Override
    public void setGroupEnabled(int n, boolean bl) {
        int n2 = this.mItems.size();
        int n3 = 0;
        while (n3 < n2) {
            MenuItemImpl menuItemImpl = this.mItems.get(n3);
            if (menuItemImpl.getGroupId() == n) {
                menuItemImpl.setEnabled(bl);
            }
            ++n3;
        }
        return;
    }

    @Override
    public void setGroupVisible(int n, boolean bl) {
        int n2 = this.mItems.size();
        boolean bl2 = false;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                if (bl2) {
                    this.onItemsChanged(true);
                }
                return;
            }
            MenuItemImpl menuItemImpl = this.mItems.get(n3);
            if (menuItemImpl.getGroupId() == n && menuItemImpl.setVisibleInt(bl)) {
                bl2 = true;
            }
            ++n3;
        }
    }

    protected MenuBuilder setHeaderIconInt(int n) {
        this.setHeaderInternal(0, null, n, null, null);
        return this;
    }

    protected MenuBuilder setHeaderIconInt(Drawable drawable2) {
        this.setHeaderInternal(0, null, 0, drawable2, null);
        return this;
    }

    protected MenuBuilder setHeaderTitleInt(int n) {
        this.setHeaderInternal(n, null, 0, null, null);
        return this;
    }

    protected MenuBuilder setHeaderTitleInt(CharSequence charSequence) {
        this.setHeaderInternal(0, charSequence, 0, null, null);
        return this;
    }

    protected MenuBuilder setHeaderViewInt(View view) {
        this.setHeaderInternal(0, null, 0, null, view);
        return this;
    }

    void setOptionalIconsVisible(boolean bl) {
        this.mOptionalIconsVisible = bl;
    }

    @Override
    public void setQwertyMode(boolean bl) {
        this.mQwertyMode = bl;
        this.onItemsChanged(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setShortcutsVisible(boolean bl) {
        if (this.mShortcutsVisible == bl) {
            return;
        }
        this.setShortcutsVisibleInner(bl);
        this.onItemsChanged(false);
    }

    @Override
    public int size() {
        return this.mItems.size();
    }

    public void startDispatchingItemsChanged() {
        this.mPreventDispatchingItemsChanged = false;
        if (this.mItemsChangedWhileDispatchPrevented) {
            this.mItemsChangedWhileDispatchPrevented = false;
            this.onItemsChanged(true);
        }
    }

    public void stopDispatchingItemsChanged() {
        if (!this.mPreventDispatchingItemsChanged) {
            this.mPreventDispatchingItemsChanged = true;
            this.mItemsChangedWhileDispatchPrevented = false;
        }
    }

    public static interface Callback {
        public boolean onMenuItemSelected(MenuBuilder var1, com.actionbarsherlock.view.MenuItem var2);

        public void onMenuModeChange(MenuBuilder var1);
    }

    public static interface ItemInvoker {
        public boolean invokeItem(MenuItemImpl var1);
    }
}

