/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.view.menu;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.actionbarsherlock.internal.view.menu.MenuBuilder;
import com.actionbarsherlock.internal.view.menu.MenuView;
import com.actionbarsherlock.internal.view.menu.SubMenuBuilder;
import com.actionbarsherlock.view.ActionProvider;
import com.actionbarsherlock.view.MenuItem;
import com.actionbarsherlock.view.SubMenu;

public final class MenuItemImpl
implements MenuItem {
    private static final int CHECKABLE = 1;
    private static final int CHECKED = 2;
    private static final int ENABLED = 16;
    private static final int EXCLUSIVE = 4;
    private static final int HIDDEN = 8;
    private static final int IS_ACTION = 32;
    static final int NO_ICON = 0;
    private static final int SHOW_AS_ACTION_MASK = 3;
    private static final String TAG = "MenuItemImpl";
    private static String sDeleteShortcutLabel;
    private static String sEnterShortcutLabel;
    private static String sPrependShortcutLabel;
    private static String sSpaceShortcutLabel;
    private ActionProvider mActionProvider;
    private View mActionView;
    private final int mCategoryOrder;
    private MenuItem.OnMenuItemClickListener mClickListener;
    private int mFlags = 16;
    private final int mGroup;
    private Drawable mIconDrawable;
    private int mIconResId = 0;
    private final int mId;
    private Intent mIntent;
    private boolean mIsActionViewExpanded = false;
    private Runnable mItemCallback;
    private MenuBuilder mMenu;
    private ContextMenu.ContextMenuInfo mMenuInfo;
    private MenuItem.OnActionExpandListener mOnActionExpandListener;
    private final int mOrdering;
    private char mShortcutAlphabeticChar;
    private char mShortcutNumericChar;
    private int mShowAsAction = 0;
    private SubMenuBuilder mSubMenu;
    private CharSequence mTitle;
    private CharSequence mTitleCondensed;

    MenuItemImpl(MenuBuilder menuBuilder, int n, int n2, int n3, int n4, CharSequence charSequence, int n5) {
        this.mMenu = menuBuilder;
        this.mId = n2;
        this.mGroup = n;
        this.mCategoryOrder = n3;
        this.mOrdering = n4;
        this.mTitle = charSequence;
        this.mShowAsAction = n5;
    }

    public void actionFormatChanged() {
        this.mMenu.onItemActionRequestChanged(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean collapseActionView() {
        boolean bl = false;
        if ((8 & this.mShowAsAction) == 0) {
            return bl;
        }
        if (this.mActionView == null) {
            return true;
        }
        if (this.mOnActionExpandListener == null) return this.mMenu.collapseItemActionView(this);
        if (!this.mOnActionExpandListener.onMenuItemActionCollapse(this)) return bl;
        return this.mMenu.collapseItemActionView(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean expandActionView() {
        boolean bl = false;
        if ((8 & this.mShowAsAction) == 0) return bl;
        if (this.mActionView == null) {
            return bl;
        }
        if (this.mOnActionExpandListener == null) return this.mMenu.expandItemActionView(this);
        if (!this.mOnActionExpandListener.onMenuItemActionExpand(this)) return bl;
        return this.mMenu.expandItemActionView(this);
    }

    @Override
    public ActionProvider getActionProvider() {
        return this.mActionProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public View getActionView() {
        if (this.mActionView != null) {
            return this.mActionView;
        }
        if (this.mActionProvider == null) return null;
        this.mActionView = this.mActionProvider.onCreateActionView();
        return this.mActionView;
    }

    @Override
    public char getAlphabeticShortcut() {
        return this.mShortcutAlphabeticChar;
    }

    Runnable getCallback() {
        return this.mItemCallback;
    }

    @Override
    public int getGroupId() {
        return this.mGroup;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Drawable getIcon() {
        if (this.mIconDrawable != null) {
            return this.mIconDrawable;
        }
        if (this.mIconResId == 0) return null;
        return this.mMenu.getResources().getDrawable(this.mIconResId);
    }

    @Override
    public Intent getIntent() {
        return this.mIntent;
    }

    @Override
    @ViewDebug.CapturedViewProperty
    public int getItemId() {
        return this.mId;
    }

    @Override
    public ContextMenu.ContextMenuInfo getMenuInfo() {
        return this.mMenuInfo;
    }

    @Override
    public char getNumericShortcut() {
        return this.mShortcutNumericChar;
    }

    @Override
    public int getOrder() {
        return this.mCategoryOrder;
    }

    public int getOrdering() {
        return this.mOrdering;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    char getShortcut() {
        if (!this.mMenu.isQwertyMode()) return this.mShortcutNumericChar;
        return this.mShortcutAlphabeticChar;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getShortcutLabel() {
        char c = this.getShortcut();
        if (c == '\u0000') {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(sPrependShortcutLabel);
        switch (c) {
            default: {
                stringBuilder.append(c);
                return stringBuilder.toString();
            }
            case '\n': {
                stringBuilder.append(sEnterShortcutLabel);
                return stringBuilder.toString();
            }
            case '\b': {
                stringBuilder.append(sDeleteShortcutLabel);
                return stringBuilder.toString();
            }
            case ' ': 
        }
        stringBuilder.append(sSpaceShortcutLabel);
        return stringBuilder.toString();
    }

    @Override
    public SubMenu getSubMenu() {
        return this.mSubMenu;
    }

    @Override
    @ViewDebug.CapturedViewProperty
    public CharSequence getTitle() {
        return this.mTitle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CharSequence getTitleCondensed() {
        if (this.mTitleCondensed == null) return this.mTitle;
        return this.mTitleCondensed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CharSequence getTitleForItemView(MenuView.ItemView itemView) {
        if (itemView == null) return this.getTitle();
        if (!itemView.prefersCondensedTitle()) return this.getTitle();
        return this.getTitleCondensed();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasCollapsibleActionView() {
        if ((8 & this.mShowAsAction) == 0) return false;
        if (this.mActionView == null) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasSubMenu() {
        if (this.mSubMenu == null) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean invoke() {
        boolean bl = true;
        if (this.mClickListener != null && this.mClickListener.onMenuItemClick(this)) {
            return bl;
        }
        if (this.mMenu.dispatchMenuItemSelected(this.mMenu.getRootMenu(), this)) return bl;
        if (this.mItemCallback != null) {
            this.mItemCallback.run();
            return bl;
        }
        if (this.mIntent != null) {
            try {
                this.mMenu.getContext().startActivity(this.mIntent);
                return bl;
            }
            catch (ActivityNotFoundException activityNotFoundException) {
                Log.e((String)TAG, (String)"Can't find activity to handle intent; ignoring", (Throwable)activityNotFoundException);
            }
        }
        if (this.mActionProvider == null) return false;
        if (this.mActionProvider.onPerformDefaultAction()) return bl;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isActionButton() {
        if ((0x20 & this.mFlags) != 32) return false;
        return true;
    }

    @Override
    public boolean isActionViewExpanded() {
        return this.mIsActionViewExpanded;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isCheckable() {
        boolean bl = true;
        if ((1 & this.mFlags) != bl) return false;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isChecked() {
        if ((2 & this.mFlags) != 2) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEnabled() {
        if ((0x10 & this.mFlags) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isExclusiveCheckable() {
        if ((4 & this.mFlags) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isVisible() {
        if ((8 & this.mFlags) != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean requestsActionButton() {
        boolean bl = true;
        if ((1 & this.mShowAsAction) != bl) return false;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean requiresActionButton() {
        if ((2 & this.mShowAsAction) != 2) return false;
        return true;
    }

    @Override
    public MenuItem setActionProvider(ActionProvider actionProvider) {
        this.mActionView = null;
        this.mActionProvider = actionProvider;
        this.mMenu.onItemsChanged(true);
        return this;
    }

    @Override
    public MenuItem setActionView(int n) {
        Context context = this.mMenu.getContext();
        this.setActionView(LayoutInflater.from((Context)context).inflate(n, (ViewGroup)new LinearLayout(context), false));
        return this;
    }

    @Override
    public MenuItem setActionView(View view) {
        this.mActionView = view;
        this.mActionProvider = null;
        if (view != null && view.getId() == -1 && this.mId > 0) {
            view.setId(this.mId);
        }
        this.mMenu.onItemActionRequestChanged(this);
        return this;
    }

    public void setActionViewExpanded(boolean bl) {
        this.mIsActionViewExpanded = bl;
        this.mMenu.onItemsChanged(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public MenuItem setAlphabeticShortcut(char c) {
        if (this.mShortcutAlphabeticChar == c) {
            return this;
        }
        this.mShortcutAlphabeticChar = Character.toLowerCase(c);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    public MenuItem setCallback(Runnable runnable) {
        this.mItemCallback = runnable;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public MenuItem setCheckable(boolean bl) {
        int n = this.mFlags;
        int n2 = 0xFFFFFFFE & this.mFlags;
        int n3 = bl ? 1 : 0;
        this.mFlags = n3 | n2;
        if (n != this.mFlags) {
            this.mMenu.onItemsChanged(false);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public MenuItem setChecked(boolean bl) {
        if ((4 & this.mFlags) != 0) {
            this.mMenu.setExclusiveItemChecked(this);
            return this;
        }
        this.setCheckedInt(bl);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    void setCheckedInt(boolean bl) {
        int n = this.mFlags;
        int n2 = 0xFFFFFFFD & this.mFlags;
        int n3 = bl ? 2 : 0;
        this.mFlags = n3 | n2;
        if (n != this.mFlags) {
            this.mMenu.onItemsChanged(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public MenuItem setEnabled(boolean bl) {
        this.mFlags = bl ? 0x10 | this.mFlags : 0xFFFFFFEF & this.mFlags;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setExclusiveCheckable(boolean bl) {
        int n = 0xFFFFFFFB & this.mFlags;
        int n2 = bl ? 4 : 0;
        this.mFlags = n2 | n;
    }

    @Override
    public MenuItem setIcon(int n) {
        this.mIconDrawable = null;
        this.mIconResId = n;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    @Override
    public MenuItem setIcon(Drawable drawable2) {
        this.mIconResId = 0;
        this.mIconDrawable = drawable2;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    @Override
    public MenuItem setIntent(Intent intent) {
        this.mIntent = intent;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIsActionButton(boolean bl) {
        if (bl) {
            this.mFlags = 0x20 | this.mFlags;
            return;
        }
        this.mFlags = 0xFFFFFFDF & this.mFlags;
    }

    void setMenuInfo(ContextMenu.ContextMenuInfo contextMenuInfo) {
        this.mMenuInfo = contextMenuInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public MenuItem setNumericShortcut(char c) {
        if (this.mShortcutNumericChar == c) {
            return this;
        }
        this.mShortcutNumericChar = c;
        this.mMenu.onItemsChanged(false);
        return this;
    }

    @Override
    public MenuItem setOnActionExpandListener(MenuItem.OnActionExpandListener onActionExpandListener) {
        this.mOnActionExpandListener = onActionExpandListener;
        return this;
    }

    @Override
    public MenuItem setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener onMenuItemClickListener) {
        this.mClickListener = onMenuItemClickListener;
        return this;
    }

    @Override
    public MenuItem setShortcut(char c, char c2) {
        this.mShortcutNumericChar = c;
        this.mShortcutAlphabeticChar = Character.toLowerCase(c2);
        this.mMenu.onItemsChanged(false);
        return this;
    }

    @Override
    public void setShowAsAction(int n) {
        switch (n & 3) {
            default: {
                throw new IllegalArgumentException("SHOW_AS_ACTION_ALWAYS, SHOW_AS_ACTION_IF_ROOM, and SHOW_AS_ACTION_NEVER are mutually exclusive.");
            }
            case 0: 
            case 1: 
            case 2: 
        }
        this.mShowAsAction = n;
        this.mMenu.onItemActionRequestChanged(this);
    }

    @Override
    public MenuItem setShowAsActionFlags(int n) {
        this.setShowAsAction(n);
        return this;
    }

    void setSubMenu(SubMenuBuilder subMenuBuilder) {
        this.mSubMenu = subMenuBuilder;
        subMenuBuilder.setHeaderTitle(this.getTitle());
    }

    @Override
    public MenuItem setTitle(int n) {
        return this.setTitle(this.mMenu.getContext().getString(n));
    }

    @Override
    public MenuItem setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        this.mMenu.onItemsChanged(false);
        if (this.mSubMenu != null) {
            this.mSubMenu.setHeaderTitle(charSequence);
        }
        return this;
    }

    @Override
    public MenuItem setTitleCondensed(CharSequence charSequence) {
        this.mTitleCondensed = charSequence;
        if (charSequence == null) {
        }
        this.mMenu.onItemsChanged(false);
        return this;
    }

    @Override
    public MenuItem setVisible(boolean bl) {
        if (this.setVisibleInt(bl)) {
            this.mMenu.onItemVisibleChanged(this);
        }
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean setVisibleInt(boolean bl) {
        int n = 0;
        int n2 = this.mFlags;
        int n3 = 0xFFFFFFF7 & this.mFlags;
        int n4 = bl ? n : 8;
        this.mFlags = n4 | n3;
        if (n2 == this.mFlags) return n != 0;
        return 1 != 0;
    }

    public boolean shouldShowIcon() {
        return this.mMenu.getOptionalIconsVisible();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean shouldShowShortcut() {
        if (!this.mMenu.isShortcutsVisible()) return false;
        if (this.getShortcut() == '\u0000') return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean showsTextAsAction() {
        if ((4 & this.mShowAsAction) != 4) return false;
        return true;
    }

    public String toString() {
        return this.mTitle.toString();
    }
}

