/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.actionbarsherlock.R;
import com.actionbarsherlock.internal.nineoldandroids.animation.Animator;
import com.actionbarsherlock.internal.nineoldandroids.animation.AnimatorSet;
import com.actionbarsherlock.internal.nineoldandroids.animation.ObjectAnimator;
import com.actionbarsherlock.internal.nineoldandroids.view.animation.AnimatorProxy;
import com.actionbarsherlock.internal.nineoldandroids.widget.NineLinearLayout;
import com.actionbarsherlock.internal.view.menu.ActionMenuPresenter;
import com.actionbarsherlock.internal.view.menu.ActionMenuView;
import com.actionbarsherlock.internal.view.menu.MenuBuilder;
import com.actionbarsherlock.internal.widget.AbsActionBarView;
import com.actionbarsherlock.view.ActionMode;

public class ActionBarContextView
extends AbsActionBarView
implements Animator.AnimatorListener {
    private static final int ANIMATE_IDLE = 0;
    private static final int ANIMATE_IN = 1;
    private static final int ANIMATE_OUT = 2;
    private boolean mAnimateInOnLayout;
    private int mAnimationMode;
    private NineLinearLayout mClose;
    private Animator mCurrentAnimation;
    private View mCustomView;
    private Drawable mSplitBackground;
    private CharSequence mSubtitle;
    private int mSubtitleStyleRes;
    private TextView mSubtitleView;
    private CharSequence mTitle;
    private LinearLayout mTitleLayout;
    private int mTitleStyleRes;
    private TextView mTitleView;

    public ActionBarContextView(Context context) {
        this(context, null);
    }

    public ActionBarContextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R.attr.actionModeStyle);
    }

    public ActionBarContextView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SherlockActionMode, n, 0);
        this.setBackgroundDrawable(typedArray.getDrawable(2));
        this.mTitleStyleRes = typedArray.getResourceId(0, 0);
        this.mSubtitleStyleRes = typedArray.getResourceId(1, 0);
        this.mContentHeight = typedArray.getLayoutDimension(4, 0);
        this.mSplitBackground = typedArray.getDrawable(3);
        typedArray.recycle();
    }

    private void finishAnimation() {
        Animator animator = this.mCurrentAnimation;
        if (animator != null) {
            this.mCurrentAnimation = null;
            animator.end();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initTitle() {
        int n = 8;
        if (this.mTitleLayout == null) {
            LayoutInflater.from((Context)this.getContext()).inflate(R.layout.abs__action_bar_title_item, (ViewGroup)this);
            this.mTitleLayout = (LinearLayout)this.getChildAt(-1 + this.getChildCount());
            this.mTitleView = (TextView)this.mTitleLayout.findViewById(R.id.abs__action_bar_title);
            this.mSubtitleView = (TextView)this.mTitleLayout.findViewById(R.id.abs__action_bar_subtitle);
            if (this.mTitleStyleRes != 0) {
                this.mTitleView.setTextAppearance(this.mContext, this.mTitleStyleRes);
            }
            if (this.mSubtitleStyleRes != 0) {
                this.mSubtitleView.setTextAppearance(this.mContext, this.mSubtitleStyleRes);
            }
        }
        this.mTitleView.setText(this.mTitle);
        this.mSubtitleView.setText(this.mSubtitle);
        boolean bl = !TextUtils.isEmpty((CharSequence)this.mTitle);
        boolean bl2 = !TextUtils.isEmpty((CharSequence)this.mSubtitle);
        TextView textView = this.mSubtitleView;
        int n2 = bl2 ? 0 : n;
        textView.setVisibility(n2);
        LinearLayout linearLayout = this.mTitleLayout;
        if (bl || bl2) {
            n = 0;
        }
        linearLayout.setVisibility(n);
        if (this.mTitleLayout.getParent() == null) {
            this.addView((View)this.mTitleLayout);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Animator makeInAnimation() {
        int n;
        this.mClose.setTranslationX(-this.mClose.getWidth() - ((ViewGroup.MarginLayoutParams)this.mClose.getLayoutParams()).leftMargin);
        NineLinearLayout nineLinearLayout = this.mClose;
        float[] fArray = new float[]{0.0f};
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)nineLinearLayout, "translationX", fArray);
        objectAnimator.setDuration(200L);
        objectAnimator.addListener(this);
        objectAnimator.setInterpolator((Interpolator)new DecelerateInterpolator());
        AnimatorSet animatorSet = new AnimatorSet();
        AnimatorSet.Builder builder = animatorSet.play(objectAnimator);
        if (this.mMenuView == null || (n = this.mMenuView.getChildCount()) <= 0) return animatorSet;
        int n2 = n + -1;
        int n3 = 0;
        while (n2 >= 0) {
            AnimatorProxy animatorProxy = AnimatorProxy.wrap(this.mMenuView.getChildAt(n2));
            animatorProxy.setScaleY(0.0f);
            float[] fArray2 = new float[]{0.0f, 1.0f};
            ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)animatorProxy, "scaleY", fArray2);
            objectAnimator2.setDuration(100L);
            objectAnimator2.setStartDelay(n3 * 70);
            builder.with(objectAnimator2);
            --n2;
            ++n3;
        }
        return animatorSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Animator makeOutAnimation() {
        NineLinearLayout nineLinearLayout = this.mClose;
        float[] fArray = new float[]{-this.mClose.getWidth() - ((ViewGroup.MarginLayoutParams)this.mClose.getLayoutParams()).leftMargin};
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat((Object)nineLinearLayout, "translationX", fArray);
        objectAnimator.setDuration(200L);
        objectAnimator.addListener(this);
        objectAnimator.setInterpolator((Interpolator)new DecelerateInterpolator());
        AnimatorSet animatorSet = new AnimatorSet();
        AnimatorSet.Builder builder = animatorSet.play(objectAnimator);
        if (this.mMenuView == null || this.mMenuView.getChildCount() <= 0) return animatorSet;
        int n = 0;
        while (n < 0) {
            AnimatorProxy animatorProxy = AnimatorProxy.wrap(this.mMenuView.getChildAt(n));
            animatorProxy.setScaleY(0.0f);
            float[] fArray2 = new float[]{0.0f};
            ObjectAnimator objectAnimator2 = ObjectAnimator.ofFloat((Object)animatorProxy, "scaleY", fArray2);
            objectAnimator2.setDuration(100L);
            objectAnimator2.setStartDelay(n * 70);
            builder.with(objectAnimator2);
            ++n;
        }
        return animatorSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void closeMode() {
        if (this.mAnimationMode == 2) {
            return;
        }
        if (this.mClose == null) {
            this.killMode();
            return;
        }
        this.finishAnimation();
        this.mAnimationMode = 2;
        this.mCurrentAnimation = this.makeOutAnimation();
        this.mCurrentAnimation.start();
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-1, -2);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attributeSet);
    }

    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hideOverflowMenu() {
        if (this.mActionMenuPresenter == null) return false;
        return this.mActionMenuPresenter.hideOverflowMenu();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void initForMode(final ActionMode actionMode) {
        if (this.mClose == null) {
            this.mClose = (NineLinearLayout)LayoutInflater.from((Context)this.mContext).inflate(R.layout.abs__action_mode_close_item, (ViewGroup)this, false);
            this.addView((View)this.mClose);
        } else if (this.mClose.getParent() == null) {
            this.addView((View)this.mClose);
        }
        this.mClose.findViewById(R.id.abs__action_mode_close_button).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                actionMode.finish();
            }
        });
        MenuBuilder menuBuilder = (MenuBuilder)actionMode.getMenu();
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.dismissPopupMenus();
        }
        this.mActionMenuPresenter = new ActionMenuPresenter(this.mContext);
        this.mActionMenuPresenter.setReserveOverflow(true);
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
        if (!this.mSplitActionBar) {
            menuBuilder.addMenuPresenter(this.mActionMenuPresenter);
            this.mMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
            this.mMenuView.setBackgroundDrawable(null);
            this.addView((View)this.mMenuView, layoutParams);
        } else {
            this.mActionMenuPresenter.setWidthLimit(this.getContext().getResources().getDisplayMetrics().widthPixels, true);
            this.mActionMenuPresenter.setItemLimit(Integer.MAX_VALUE);
            layoutParams.width = -1;
            layoutParams.height = this.mContentHeight;
            menuBuilder.addMenuPresenter(this.mActionMenuPresenter);
            this.mMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
            this.mMenuView.setBackgroundDrawable(this.mSplitBackground);
            this.mSplitView.addView((View)this.mMenuView, layoutParams);
        }
        this.mAnimateInOnLayout = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isOverflowMenuShowing() {
        if (this.mActionMenuPresenter == null) return false;
        return this.mActionMenuPresenter.isOverflowMenuShowing();
    }

    public void killMode() {
        this.finishAnimation();
        this.removeAllViews();
        if (this.mSplitView != null) {
            this.mSplitView.removeView((View)this.mMenuView);
        }
        this.mCustomView = null;
        this.mMenuView = null;
        this.mAnimateInOnLayout = false;
    }

    @Override
    public void onAnimationCancel(Animator animator) {
    }

    @Override
    public void onAnimationEnd(Animator animator) {
        if (this.mAnimationMode == 2) {
            this.killMode();
        }
        this.mAnimationMode = 0;
    }

    @Override
    public void onAnimationRepeat(Animator animator) {
    }

    @Override
    public void onAnimationStart(Animator animator) {
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mActionMenuPresenter != null) {
            this.mActionMenuPresenter.hideOverflowMenu();
            this.mActionMenuPresenter.hideSubMenus();
        }
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        if (accessibilityEvent.getEventType() == 32) {
            accessibilityEvent.setClassName((CharSequence)this.getClass().getName());
            accessibilityEvent.setPackageName((CharSequence)this.getContext().getPackageName());
            accessibilityEvent.setContentDescription(this.mTitle);
        }
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        int n5 = this.getPaddingLeft();
        int n6 = this.getPaddingTop();
        int n7 = n4 - n2 - this.getPaddingTop() - this.getPaddingBottom();
        if (this.mClose != null && this.mClose.getVisibility() != 8) {
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)this.mClose.getLayoutParams();
            int n8 = n5 + marginLayoutParams.leftMargin;
            n5 = n8 + this.positionChild((View)this.mClose, n8, n6, n7) + marginLayoutParams.rightMargin;
            if (this.mAnimateInOnLayout) {
                this.mAnimationMode = 1;
                this.mCurrentAnimation = this.makeInAnimation();
                this.mCurrentAnimation.start();
                this.mAnimateInOnLayout = false;
            }
        }
        if (this.mTitleLayout != null && this.mCustomView == null) {
            n5 += this.positionChild((View)this.mTitleLayout, n5, n6, n7);
        }
        if (this.mCustomView != null) {
            int cfr_ignored_0 = n5 + this.positionChild(this.mCustomView, n5, n6, n7);
        }
        int n9 = n3 - n - this.getPaddingRight();
        if (this.mMenuView != null) {
            int cfr_ignored_1 = n9 - this.positionChildInverse((View)this.mMenuView, n9, n6, n7);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n, int n2) {
        if (View.MeasureSpec.getMode((int)n) != 0x40000000) {
            throw new IllegalStateException(String.valueOf(this.getClass().getSimpleName()) + " can only be used " + "with android:layout_width=\"match_parent\" (or fill_parent)");
        }
        if (View.MeasureSpec.getMode((int)n2) == 0) {
            throw new IllegalStateException(String.valueOf(this.getClass().getSimpleName()) + " can only be used " + "with android:layout_height=\"wrap_content\"");
        }
        int n3 = View.MeasureSpec.getSize((int)n);
        int n4 = this.mContentHeight > 0 ? this.mContentHeight : View.MeasureSpec.getSize((int)n2);
        int n5 = this.getPaddingTop() + this.getPaddingBottom();
        int n6 = n3 - this.getPaddingLeft() - this.getPaddingRight();
        int n7 = n4 - n5;
        int n8 = View.MeasureSpec.makeMeasureSpec((int)n7, (int)Integer.MIN_VALUE);
        if (this.mClose != null) {
            int n9 = this.measureChildView((View)this.mClose, n6, n8, 0);
            ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams)this.mClose.getLayoutParams();
            n6 = n9 - (marginLayoutParams.leftMargin + marginLayoutParams.rightMargin);
        }
        if (this.mMenuView != null && this.mMenuView.getParent() == this) {
            n6 = this.measureChildView((View)this.mMenuView, n6, n8, 0);
        }
        if (this.mTitleLayout != null && this.mCustomView == null) {
            n6 = this.measureChildView((View)this.mTitleLayout, n6, n8, 0);
        }
        if (this.mCustomView != null) {
            ViewGroup.LayoutParams layoutParams = this.mCustomView.getLayoutParams();
            int n10 = layoutParams.width != -2 ? 0x40000000 : Integer.MIN_VALUE;
            int n11 = layoutParams.width >= 0 ? Math.min(layoutParams.width, n6) : n6;
            int n12 = layoutParams.height != -2 ? 0x40000000 : Integer.MIN_VALUE;
            int n13 = layoutParams.height >= 0 ? Math.min(layoutParams.height, n7) : n7;
            this.mCustomView.measure(View.MeasureSpec.makeMeasureSpec((int)n11, (int)n10), View.MeasureSpec.makeMeasureSpec((int)n13, (int)n12));
        }
        if (this.mContentHeight > 0) {
            this.setMeasuredDimension(n3, n4);
            return;
        }
        int n14 = 0;
        int n15 = this.getChildCount();
        int n16 = 0;
        while (true) {
            if (n16 >= n15) {
                this.setMeasuredDimension(n3, n14);
                return;
            }
            int n17 = n5 + this.getChildAt(n16).getMeasuredHeight();
            if (n17 > n14) {
                n14 = n17;
            }
            ++n16;
        }
    }

    @Override
    public void setContentHeight(int n) {
        this.mContentHeight = n;
    }

    public void setCustomView(View view) {
        if (this.mCustomView != null) {
            this.removeView(this.mCustomView);
        }
        this.mCustomView = view;
        if (this.mTitleLayout != null) {
            this.removeView((View)this.mTitleLayout);
            this.mTitleLayout = null;
        }
        if (view != null) {
            this.addView(view);
        }
        this.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setSplitActionBar(boolean bl) {
        if (this.mSplitActionBar != bl) {
            if (this.mActionMenuPresenter != null) {
                ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-2, -1);
                if (!bl) {
                    this.mMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
                    this.mMenuView.setBackgroundDrawable(null);
                    ViewGroup viewGroup = (ViewGroup)this.mMenuView.getParent();
                    if (viewGroup != null) {
                        viewGroup.removeView((View)this.mMenuView);
                    }
                    this.addView((View)this.mMenuView, layoutParams);
                } else {
                    this.mActionMenuPresenter.setWidthLimit(this.getContext().getResources().getDisplayMetrics().widthPixels, true);
                    this.mActionMenuPresenter.setItemLimit(Integer.MAX_VALUE);
                    layoutParams.width = -1;
                    layoutParams.height = this.mContentHeight;
                    this.mMenuView = (ActionMenuView)this.mActionMenuPresenter.getMenuView(this);
                    this.mMenuView.setBackgroundDrawable(this.mSplitBackground);
                    ViewGroup viewGroup = (ViewGroup)this.mMenuView.getParent();
                    if (viewGroup != null) {
                        viewGroup.removeView((View)this.mMenuView);
                    }
                    this.mSplitView.addView((View)this.mMenuView, layoutParams);
                }
            }
            super.setSplitActionBar(bl);
        }
    }

    public void setSubtitle(CharSequence charSequence) {
        this.mSubtitle = charSequence;
        this.initTitle();
    }

    public void setTitle(CharSequence charSequence) {
        this.mTitle = charSequence;
        this.initTitle();
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean showOverflowMenu() {
        if (this.mActionMenuPresenter == null) return false;
        return this.mActionMenuPresenter.showOverflowMenu();
    }
}

