/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.Button;
import java.util.Locale;

public class CapitalizingButton
extends Button {
    private static final boolean IS_GINGERBREAD;
    private static final int[] R_styleable_Button;
    private static final int R_styleable_Button_textAllCaps;
    private static final boolean SANS_ICE_CREAM;
    private boolean mAllCaps;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = Build.VERSION.SDK_INT < 14;
        SANS_ICE_CREAM = bl;
        boolean bl2 = Build.VERSION.SDK_INT >= 9;
        IS_GINGERBREAD = bl2;
        int[] nArray = new int[]{16843660};
        R_styleable_Button = nArray;
    }

    public CapitalizingButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R_styleable_Button);
        this.mAllCaps = typedArray.getBoolean(0, true);
        typedArray.recycle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTextCompat(CharSequence charSequence) {
        if (SANS_ICE_CREAM && this.mAllCaps && charSequence != null) {
            if (IS_GINGERBREAD) {
                this.setText(charSequence.toString().toUpperCase(Locale.ROOT));
                return;
            }
            this.setText(charSequence.toString().toUpperCase());
            return;
        }
        this.setText(charSequence);
    }
}

