/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.SpinnerAdapter;
import com.actionbarsherlock.R;
import com.actionbarsherlock.app.ActionBar;
import com.actionbarsherlock.internal.nineoldandroids.animation.Animator;
import com.actionbarsherlock.internal.nineoldandroids.animation.ObjectAnimator;
import com.actionbarsherlock.internal.nineoldandroids.widget.NineHorizontalScrollView;
import com.actionbarsherlock.internal.widget.CapitalizingTextView;
import com.actionbarsherlock.internal.widget.IcsAdapterView;
import com.actionbarsherlock.internal.widget.IcsLinearLayout;
import com.actionbarsherlock.internal.widget.IcsSpinner;

public class ScrollingTabContainerView
extends NineHorizontalScrollView
implements IcsAdapterView.OnItemSelectedListener {
    private static final int FADE_DURATION = 200;
    private static final Interpolator sAlphaInterpolator = new DecelerateInterpolator();
    private boolean mAllowCollapse;
    private int mContentHeight;
    private LayoutInflater mInflater;
    int mMaxTabWidth;
    private int mSelectedTabIndex;
    private TabClickListener mTabClickListener;
    private IcsLinearLayout mTabLayout;
    Runnable mTabSelector;
    private IcsSpinner mTabSpinner;
    protected final VisibilityAnimListener mVisAnimListener = new VisibilityAnimListener();
    protected Animator mVisibilityAnim;

    public ScrollingTabContainerView(Context context) {
        super(context);
        this.setHorizontalScrollBarEnabled(false);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(null, R.styleable.SherlockActionBar, R.attr.actionBarStyle, 0);
        this.setContentHeight(typedArray.getLayoutDimension(4, 0));
        typedArray.recycle();
        this.mInflater = LayoutInflater.from((Context)context);
        this.mTabLayout = this.createTabLayout();
        this.addView((View)this.mTabLayout, new ViewGroup.LayoutParams(-2, -1));
    }

    private IcsSpinner createSpinner() {
        IcsSpinner icsSpinner = new IcsSpinner(this.getContext(), null, R.attr.actionDropDownStyle);
        icsSpinner.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1));
        icsSpinner.setOnItemSelectedListener(this);
        return icsSpinner;
    }

    private IcsLinearLayout createTabLayout() {
        IcsLinearLayout icsLinearLayout = (IcsLinearLayout)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.abs__action_bar_tab_bar_view, null);
        icsLinearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -1));
        return icsLinearLayout;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TabView createTabView(ActionBar.Tab tab, boolean bl) {
        TabView tabView = (TabView)this.mInflater.inflate(R.layout.abs__action_bar_tab, null);
        tabView.init(this, tab, bl);
        if (bl) {
            tabView.setBackgroundDrawable(null);
            tabView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, this.mContentHeight));
            return tabView;
        }
        tabView.setFocusable(true);
        if (this.mTabClickListener == null) {
            this.mTabClickListener = new TabClickListener();
        }
        tabView.setOnClickListener(this.mTabClickListener);
        return tabView;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCollapsed() {
        if (this.mTabSpinner == null) return false;
        if (this.mTabSpinner.getParent() != this) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void performCollapse() {
        if (this.isCollapsed()) {
            return;
        }
        if (this.mTabSpinner == null) {
            this.mTabSpinner = this.createSpinner();
        }
        this.removeView((View)this.mTabLayout);
        this.addView((View)this.mTabSpinner, new ViewGroup.LayoutParams(-2, -1));
        if (this.mTabSpinner.getAdapter() == null) {
            this.mTabSpinner.setAdapter((SpinnerAdapter)new TabAdapter());
        }
        if (this.mTabSelector != null) {
            this.removeCallbacks(this.mTabSelector);
            this.mTabSelector = null;
        }
        this.mTabSpinner.setSelection(this.mSelectedTabIndex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean performExpand() {
        if (!this.isCollapsed()) {
            return false;
        }
        this.removeView((View)this.mTabSpinner);
        this.addView((View)this.mTabLayout, new ViewGroup.LayoutParams(-2, -1));
        this.setTabSelected(this.mTabSpinner.getSelectedItemPosition());
        return false;
    }

    public void addTab(ActionBar.Tab tab, int n, boolean bl) {
        TabView tabView = this.createTabView(tab, false);
        this.mTabLayout.addView((View)tabView, n, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
        if (this.mTabSpinner != null) {
            ((TabAdapter)this.mTabSpinner.getAdapter()).notifyDataSetChanged();
        }
        if (bl) {
            tabView.setSelected(true);
        }
        if (this.mAllowCollapse) {
            this.requestLayout();
        }
    }

    public void addTab(ActionBar.Tab tab, boolean bl) {
        TabView tabView = this.createTabView(tab, false);
        this.mTabLayout.addView((View)tabView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
        if (this.mTabSpinner != null) {
            ((TabAdapter)this.mTabSpinner.getAdapter()).notifyDataSetChanged();
        }
        if (bl) {
            tabView.setSelected(true);
        }
        if (this.mAllowCollapse) {
            this.requestLayout();
        }
    }

    public void animateToTab(int n) {
        final View view = this.mTabLayout.getChildAt(n);
        if (this.mTabSelector != null) {
            this.removeCallbacks(this.mTabSelector);
        }
        this.mTabSelector = new Runnable(){

            @Override
            public void run() {
                int n = view.getLeft() - (ScrollingTabContainerView.this.getWidth() - view.getWidth()) / 2;
                ScrollingTabContainerView.this.smoothScrollTo(n, 0);
                ScrollingTabContainerView.this.mTabSelector = null;
            }
        };
        this.post(this.mTabSelector);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void animateToVisibility(int n) {
        if (this.mVisibilityAnim != null) {
            this.mVisibilityAnim.cancel();
        }
        if (n == 0) {
            if (this.getVisibility() != 0) {
                this.setAlpha(0.0f);
            }
            float[] fArray = new float[]{1.0f};
            ObjectAnimator objectAnimator = ObjectAnimator.ofFloat(this, "alpha", fArray);
            objectAnimator.setDuration(200L);
            objectAnimator.setInterpolator(sAlphaInterpolator);
            objectAnimator.addListener(this.mVisAnimListener.withFinalVisibility(n));
            objectAnimator.start();
            return;
        }
        float[] fArray = new float[]{0.0f};
        ObjectAnimator objectAnimator = ObjectAnimator.ofFloat(this, "alpha", fArray);
        objectAnimator.setDuration(200L);
        objectAnimator.setInterpolator(sAlphaInterpolator);
        objectAnimator.addListener(this.mVisAnimListener.withFinalVisibility(n));
        objectAnimator.start();
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mTabSelector != null) {
            this.post(this.mTabSelector);
        }
    }

    protected void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        TypedArray typedArray = this.getContext().obtainStyledAttributes(null, R.styleable.SherlockActionBar, R.attr.actionBarStyle, 0);
        this.setContentHeight(typedArray.getLayoutDimension(4, 0));
        typedArray.recycle();
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mTabSelector != null) {
            this.removeCallbacks(this.mTabSelector);
        }
    }

    @Override
    public void onItemSelected(IcsAdapterView<?> icsAdapterView, View view, int n, long l) {
        ((TabView)view).getTab().select();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onMeasure(int n, int n2) {
        int n3 = View.MeasureSpec.getMode((int)n);
        boolean bl = n3 == 0x40000000;
        this.setFillViewport(bl);
        int n4 = this.mTabLayout.getChildCount();
        this.mMaxTabWidth = n4 > 1 && (n3 == 0x40000000 || n3 == Integer.MIN_VALUE) ? (n4 > 2 ? (int)(0.4f * (float)View.MeasureSpec.getSize((int)n)) : View.MeasureSpec.getSize((int)n) / 2) : -1;
        int n5 = View.MeasureSpec.makeMeasureSpec((int)this.mContentHeight, (int)0x40000000);
        boolean bl2 = !bl && this.mAllowCollapse;
        if (bl2) {
            this.mTabLayout.measure(0, n5);
            if (this.mTabLayout.getMeasuredWidth() > View.MeasureSpec.getSize((int)n)) {
                this.performCollapse();
            } else {
                this.performExpand();
            }
        } else {
            this.performExpand();
        }
        int n6 = this.getMeasuredWidth();
        super.onMeasure(n, n5);
        int n7 = this.getMeasuredWidth();
        if (bl && n6 != n7) {
            this.setTabSelected(this.mSelectedTabIndex);
        }
    }

    @Override
    public void onNothingSelected(IcsAdapterView<?> icsAdapterView) {
    }

    public void removeAllTabs() {
        this.mTabLayout.removeAllViews();
        if (this.mTabSpinner != null) {
            ((TabAdapter)this.mTabSpinner.getAdapter()).notifyDataSetChanged();
        }
        if (this.mAllowCollapse) {
            this.requestLayout();
        }
    }

    public void removeTabAt(int n) {
        this.mTabLayout.removeViewAt(n);
        if (this.mTabSpinner != null) {
            ((TabAdapter)this.mTabSpinner.getAdapter()).notifyDataSetChanged();
        }
        if (this.mAllowCollapse) {
            this.requestLayout();
        }
    }

    public void setAllowCollapse(boolean bl) {
        this.mAllowCollapse = bl;
    }

    public void setContentHeight(int n) {
        this.mContentHeight = n;
        this.requestLayout();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setTabSelected(int n) {
        this.mSelectedTabIndex = n;
        int n2 = this.mTabLayout.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            View view = this.mTabLayout.getChildAt(n3);
            boolean bl = n3 == n;
            view.setSelected(bl);
            if (bl) {
                this.animateToTab(n);
            }
            ++n3;
        }
        return;
    }

    public void updateTab(int n) {
        ((TabView)this.mTabLayout.getChildAt(n)).update();
        if (this.mTabSpinner != null) {
            ((TabAdapter)this.mTabSpinner.getAdapter()).notifyDataSetChanged();
        }
        if (this.mAllowCollapse) {
            this.requestLayout();
        }
    }

    private class TabAdapter
    extends BaseAdapter {
        private TabAdapter() {
        }

        public int getCount() {
            return ScrollingTabContainerView.this.mTabLayout.getChildCount();
        }

        public Object getItem(int n) {
            return ((TabView)ScrollingTabContainerView.this.mTabLayout.getChildAt(n)).getTab();
        }

        public long getItemId(int n) {
            return n;
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public View getView(int n, View object, ViewGroup viewGroup) {
            void var2_4;
            if (object == null) {
                TabView tabView = ScrollingTabContainerView.this.createTabView((ActionBar.Tab)this.getItem(n), true);
                return var2_4;
            }
            ((TabView)((Object)object)).bindTab((ActionBar.Tab)this.getItem(n));
            return var2_4;
        }
    }

    private class TabClickListener
    implements View.OnClickListener {
        private TabClickListener() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onClick(View view) {
            ((TabView)view).getTab().select();
            int n = ScrollingTabContainerView.this.mTabLayout.getChildCount();
            int n2 = 0;
            while (n2 < n) {
                View view2 = ScrollingTabContainerView.this.mTabLayout.getChildAt(n2);
                boolean bl = view2 == view;
                view2.setSelected(bl);
                ++n2;
            }
            return;
        }
    }

    public static class TabView
    extends LinearLayout {
        private View mCustomView;
        private ImageView mIconView;
        private ScrollingTabContainerView mParent;
        private ActionBar.Tab mTab;
        private CapitalizingTextView mTextView;

        public TabView(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public void bindTab(ActionBar.Tab tab) {
            this.mTab = tab;
            this.update();
        }

        public ActionBar.Tab getTab() {
            return this.mTab;
        }

        public void init(ScrollingTabContainerView scrollingTabContainerView, ActionBar.Tab tab, boolean bl) {
            this.mParent = scrollingTabContainerView;
            this.mTab = tab;
            if (bl) {
                this.setGravity(19);
            }
            this.update();
        }

        public void onMeasure(int n, int n2) {
            super.onMeasure(n, n2);
            if (this.mParent.mMaxTabWidth > 0 && this.getMeasuredWidth() > this.mParent.mMaxTabWidth) {
                super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)this.mParent.mMaxTabWidth, (int)0x40000000), n2);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void update() {
            ActionBar.Tab tab = this.mTab;
            View view = tab.getCustomView();
            if (view != null) {
                ViewParent viewParent = view.getParent();
                if (viewParent != this) {
                    if (viewParent != null) {
                        ((ViewGroup)viewParent).removeView(view);
                    }
                    this.addView(view);
                }
                this.mCustomView = view;
                if (this.mTextView != null) {
                    this.mTextView.setVisibility(8);
                }
                if (this.mIconView == null) return;
                this.mIconView.setVisibility(8);
                this.mIconView.setImageDrawable(null);
                return;
            }
            if (this.mCustomView != null) {
                this.removeView(this.mCustomView);
                this.mCustomView = null;
            }
            Drawable drawable2 = tab.getIcon();
            CharSequence charSequence = tab.getText();
            if (drawable2 != null) {
                if (this.mIconView == null) {
                    ImageView imageView = new ImageView(this.getContext());
                    LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
                    layoutParams.gravity = 16;
                    imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    this.addView((View)imageView, 0);
                    this.mIconView = imageView;
                }
                this.mIconView.setImageDrawable(drawable2);
                this.mIconView.setVisibility(0);
            } else if (this.mIconView != null) {
                this.mIconView.setVisibility(8);
                this.mIconView.setImageDrawable(null);
            }
            if (charSequence != null) {
                if (this.mTextView == null) {
                    CapitalizingTextView capitalizingTextView = new CapitalizingTextView(this.getContext(), null, R.attr.actionBarTabTextStyle);
                    capitalizingTextView.setEllipsize(TextUtils.TruncateAt.END);
                    LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
                    layoutParams.gravity = 16;
                    capitalizingTextView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    this.addView((View)capitalizingTextView);
                    this.mTextView = capitalizingTextView;
                }
                this.mTextView.setTextCompat(charSequence);
                this.mTextView.setVisibility(0);
            } else if (this.mTextView != null) {
                this.mTextView.setVisibility(8);
                this.mTextView.setText(null);
            }
            if (this.mIconView == null) return;
            this.mIconView.setContentDescription(tab.getContentDescription());
        }
    }

    protected class VisibilityAnimListener
    implements Animator.AnimatorListener {
        private boolean mCanceled = false;
        private int mFinalVisibility;

        protected VisibilityAnimListener() {
        }

        @Override
        public void onAnimationCancel(Animator animator) {
            this.mCanceled = true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void onAnimationEnd(Animator animator) {
            if (this.mCanceled) {
                return;
            }
            ScrollingTabContainerView.this.mVisibilityAnim = null;
            ScrollingTabContainerView.this.setVisibility(this.mFinalVisibility);
        }

        @Override
        public void onAnimationRepeat(Animator animator) {
        }

        @Override
        public void onAnimationStart(Animator animator) {
            ScrollingTabContainerView.this.setVisibility(0);
            ScrollingTabContainerView.this.mVisibilityAnim = animator;
            this.mCanceled = false;
        }

        public VisibilityAnimListener withFinalVisibility(int n) {
            this.mFinalVisibility = n;
            return this;
        }
    }
}

