/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.widget;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.actionbarsherlock.R;
import com.actionbarsherlock.internal.widget.IcsLinearLayout;
import com.actionbarsherlock.internal.widget.IcsListPopupWindow;
import com.actionbarsherlock.view.ActionProvider;
import com.actionbarsherlock.widget.ActivityChooserModel;

class ActivityChooserView
extends ViewGroup
implements ActivityChooserModel.ActivityChooserModelClient {
    private static final boolean IS_HONEYCOMB;
    private final IcsLinearLayout mActivityChooserContent;
    private final Drawable mActivityChooserContentBackground;
    private final ActivityChooserViewAdapter mAdapter;
    private final Callbacks mCallbacks;
    private final Context mContext;
    private int mDefaultActionButtonContentDescription;
    private final FrameLayout mDefaultActivityButton;
    private final ImageView mDefaultActivityButtonImage;
    private final FrameLayout mExpandActivityOverflowButton;
    private final ImageView mExpandActivityOverflowButtonImage;
    private int mInitialActivityCount = 4;
    private boolean mIsAttachedToWindow;
    private boolean mIsSelectingDefaultActivity;
    private final int mListPopupMaxWidth;
    private IcsListPopupWindow mListPopupWindow;
    private final DataSetObserver mModelDataSetOberver = new DataSetObserver(){

        public void onChanged() {
            super.onChanged();
            ActivityChooserView.this.mAdapter.notifyDataSetChanged();
        }

        public void onInvalidated() {
            super.onInvalidated();
            ActivityChooserView.this.mAdapter.notifyDataSetInvalidated();
        }
    };
    private PopupWindow.OnDismissListener mOnDismissListener;
    private final ViewTreeObserver.OnGlobalLayoutListener mOnGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        /*
         * Enabled aggressive block sorting
         */
        public void onGlobalLayout() {
            if (!ActivityChooserView.this.isShowingPopup()) return;
            if (!ActivityChooserView.this.isShown()) {
                ActivityChooserView.this.getListPopupWindow().dismiss();
                return;
            }
            ActivityChooserView.this.getListPopupWindow().show();
            if (ActivityChooserView.this.mProvider == null) return;
            ActivityChooserView.this.mProvider.subUiVisibilityChanged(true);
        }
    };
    ActionProvider mProvider;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = Build.VERSION.SDK_INT >= 11;
        IS_HONEYCOMB = bl;
    }

    public ActivityChooserView(Context context) {
        this(context, null);
    }

    public ActivityChooserView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ActivityChooserView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mContext = context;
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.SherlockActivityChooserView, n, 0);
        this.mInitialActivityCount = typedArray.getInt(1, 4);
        Drawable drawable2 = typedArray.getDrawable(2);
        typedArray.recycle();
        LayoutInflater.from((Context)this.mContext).inflate(R.layout.abs__activity_chooser_view, (ViewGroup)this, true);
        this.mCallbacks = new Callbacks();
        this.mActivityChooserContent = (IcsLinearLayout)this.findViewById(R.id.abs__activity_chooser_view_content);
        this.mActivityChooserContentBackground = this.mActivityChooserContent.getBackground();
        this.mDefaultActivityButton = (FrameLayout)this.findViewById(R.id.abs__default_activity_button);
        this.mDefaultActivityButton.setOnClickListener((View.OnClickListener)this.mCallbacks);
        this.mDefaultActivityButton.setOnLongClickListener((View.OnLongClickListener)this.mCallbacks);
        this.mDefaultActivityButtonImage = (ImageView)this.mDefaultActivityButton.findViewById(R.id.abs__image);
        this.mExpandActivityOverflowButton = (FrameLayout)this.findViewById(R.id.abs__expand_activities_button);
        this.mExpandActivityOverflowButton.setOnClickListener((View.OnClickListener)this.mCallbacks);
        this.mExpandActivityOverflowButtonImage = (ImageView)this.mExpandActivityOverflowButton.findViewById(R.id.abs__image);
        this.mExpandActivityOverflowButtonImage.setImageDrawable(drawable2);
        this.mAdapter = new ActivityChooserViewAdapter();
        this.mAdapter.registerDataSetObserver(new DataSetObserver(){

            public void onChanged() {
                super.onChanged();
                ActivityChooserView.this.updateAppearance();
            }
        });
        Resources resources = context.getResources();
        this.mListPopupMaxWidth = Math.max(resources.getDisplayMetrics().widthPixels / 2, resources.getDimensionPixelSize(R.dimen.abs__config_prefDialogWidth));
    }

    private IcsListPopupWindow getListPopupWindow() {
        if (this.mListPopupWindow == null) {
            this.mListPopupWindow = new IcsListPopupWindow(this.getContext());
            this.mListPopupWindow.setAdapter((ListAdapter)this.mAdapter);
            this.mListPopupWindow.setAnchorView((View)this);
            this.mListPopupWindow.setModal(true);
            this.mListPopupWindow.setOnItemClickListener(this.mCallbacks);
            this.mListPopupWindow.setOnDismissListener(this.mCallbacks);
        }
        return this.mListPopupWindow;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void showPopupUnchecked(int n) {
        IcsListPopupWindow icsListPopupWindow;
        if (this.mAdapter.getDataModel() == null) {
            throw new IllegalStateException("No data model. Did you call #setDataModel?");
        }
        this.getViewTreeObserver().addOnGlobalLayoutListener(this.mOnGlobalLayoutListener);
        boolean bl = this.mDefaultActivityButton.getVisibility() == 0;
        int n2 = this.mAdapter.getActivityCount();
        int n3 = bl ? 1 : 0;
        if (n != Integer.MAX_VALUE && n2 > n + n3) {
            this.mAdapter.setShowFooterView(true);
            this.mAdapter.setMaxActivityCount(n + -1);
        } else {
            this.mAdapter.setShowFooterView(false);
            this.mAdapter.setMaxActivityCount(n);
        }
        if (!(icsListPopupWindow = this.getListPopupWindow()).isShowing()) {
            if (this.mIsSelectingDefaultActivity || !bl) {
                this.mAdapter.setShowDefaultActivity(true, bl);
            } else {
                this.mAdapter.setShowDefaultActivity(false, false);
            }
            icsListPopupWindow.setContentWidth(Math.min(this.mAdapter.measureContentWidth(), this.mListPopupMaxWidth));
            icsListPopupWindow.show();
            if (this.mProvider != null) {
                this.mProvider.subUiVisibilityChanged(true);
            }
            icsListPopupWindow.getListView().setContentDescription((CharSequence)this.mContext.getString(R.string.abs__activitychooserview_choose_application));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateAppearance() {
        if (this.mAdapter.getCount() > 0) {
            this.mExpandActivityOverflowButton.setEnabled(true);
        } else {
            this.mExpandActivityOverflowButton.setEnabled(false);
        }
        int n = this.mAdapter.getActivityCount();
        int n2 = this.mAdapter.getHistorySize();
        if (n > 0 && n2 > 0) {
            this.mDefaultActivityButton.setVisibility(0);
            ResolveInfo resolveInfo = this.mAdapter.getDefaultActivity();
            PackageManager packageManager = this.mContext.getPackageManager();
            this.mDefaultActivityButtonImage.setImageDrawable(resolveInfo.loadIcon(packageManager));
            if (this.mDefaultActionButtonContentDescription != 0) {
                CharSequence charSequence = resolveInfo.loadLabel(packageManager);
                Context context = this.mContext;
                int n3 = this.mDefaultActionButtonContentDescription;
                Object[] objectArray = new Object[]{charSequence};
                String string2 = context.getString(n3, objectArray);
                this.mDefaultActivityButton.setContentDescription((CharSequence)string2);
            }
        } else {
            this.mDefaultActivityButton.setVisibility(8);
        }
        if (this.mDefaultActivityButton.getVisibility() == 0) {
            this.mActivityChooserContent.setBackgroundDrawable(this.mActivityChooserContentBackground);
            return;
        }
        this.mActivityChooserContent.setBackgroundDrawable(null);
    }

    public boolean dismissPopup() {
        if (this.isShowingPopup()) {
            this.getListPopupWindow().dismiss();
            ViewTreeObserver viewTreeObserver = this.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeGlobalOnLayoutListener(this.mOnGlobalLayoutListener);
            }
        }
        return true;
    }

    public ActivityChooserModel getDataModel() {
        return this.mAdapter.getDataModel();
    }

    public boolean isShowingPopup() {
        return this.getListPopupWindow().isShowing();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ActivityChooserModel activityChooserModel = this.mAdapter.getDataModel();
        if (activityChooserModel != null) {
            activityChooserModel.registerObserver(this.mModelDataSetOberver);
        }
        this.mIsAttachedToWindow = true;
    }

    protected void onDetachedFromWindow() {
        ViewTreeObserver viewTreeObserver;
        super.onDetachedFromWindow();
        ActivityChooserModel activityChooserModel = this.mAdapter.getDataModel();
        if (activityChooserModel != null) {
            activityChooserModel.unregisterObserver(this.mModelDataSetOberver);
        }
        if ((viewTreeObserver = this.getViewTreeObserver()).isAlive()) {
            viewTreeObserver.removeGlobalOnLayoutListener(this.mOnGlobalLayoutListener);
        }
        this.mIsAttachedToWindow = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.mActivityChooserContent.layout(0, 0, n3 - n, n4 - n2);
        if (this.getListPopupWindow().isShowing()) {
            this.showPopupUnchecked(this.mAdapter.getMaxActivityCount());
            return;
        }
        this.dismissPopup();
    }

    protected void onMeasure(int n, int n2) {
        IcsLinearLayout icsLinearLayout = this.mActivityChooserContent;
        if (this.mDefaultActivityButton.getVisibility() != 0) {
            n2 = View.MeasureSpec.makeMeasureSpec((int)View.MeasureSpec.getSize((int)n2), (int)0x40000000);
        }
        this.measureChild((View)icsLinearLayout, n, n2);
        this.setMeasuredDimension(icsLinearLayout.getMeasuredWidth(), icsLinearLayout.getMeasuredHeight());
    }

    @Override
    public void setActivityChooserModel(ActivityChooserModel activityChooserModel) {
        this.mAdapter.setDataModel(activityChooserModel);
        if (this.isShowingPopup()) {
            this.dismissPopup();
            this.showPopup();
        }
    }

    public void setDefaultActionButtonContentDescription(int n) {
        this.mDefaultActionButtonContentDescription = n;
    }

    public void setExpandActivityOverflowButtonContentDescription(int n) {
        String string2 = this.mContext.getString(n);
        this.mExpandActivityOverflowButtonImage.setContentDescription((CharSequence)string2);
    }

    public void setExpandActivityOverflowButtonDrawable(Drawable drawable2) {
        this.mExpandActivityOverflowButtonImage.setImageDrawable(drawable2);
    }

    public void setInitialActivityCount(int n) {
        this.mInitialActivityCount = n;
    }

    public void setOnDismissListener(PopupWindow.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    public void setProvider(ActionProvider actionProvider) {
        this.mProvider = actionProvider;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean showPopup() {
        boolean bl = false;
        if (this.isShowingPopup()) return bl;
        if (!this.mIsAttachedToWindow) {
            return bl;
        }
        this.mIsSelectingDefaultActivity = bl;
        this.showPopupUnchecked(this.mInitialActivityCount);
        return true;
    }

    private class ActivityChooserViewAdapter
    extends BaseAdapter {
        private static final int ITEM_VIEW_TYPE_ACTIVITY = 0;
        private static final int ITEM_VIEW_TYPE_COUNT = 3;
        private static final int ITEM_VIEW_TYPE_FOOTER = 1;
        public static final int MAX_ACTIVITY_COUNT_DEFAULT = 4;
        public static final int MAX_ACTIVITY_COUNT_UNLIMITED = Integer.MAX_VALUE;
        private ActivityChooserModel mDataModel;
        private boolean mHighlightDefaultActivity;
        private int mMaxActivityCount = 4;
        private boolean mShowDefaultActivity;
        private boolean mShowFooterView;

        private ActivityChooserViewAdapter() {
        }

        public int getActivityCount() {
            return this.mDataModel.getActivityCount();
        }

        public int getCount() {
            int n = this.mDataModel.getActivityCount();
            if (!this.mShowDefaultActivity && this.mDataModel.getDefaultActivity() != null) {
                --n;
            }
            int n2 = Math.min(n, this.mMaxActivityCount);
            if (this.mShowFooterView) {
                ++n2;
            }
            return n2;
        }

        public ActivityChooserModel getDataModel() {
            return this.mDataModel;
        }

        public ResolveInfo getDefaultActivity() {
            return this.mDataModel.getDefaultActivity();
        }

        public int getHistorySize() {
            return this.mDataModel.getHistorySize();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Object getItem(int n) {
            switch (this.getItemViewType(n)) {
                default: {
                    throw new IllegalArgumentException();
                }
                case 1: {
                    return null;
                }
                case 0: 
            }
            if (this.mShowDefaultActivity) return this.mDataModel.getActivity(n);
            if (this.mDataModel.getDefaultActivity() == null) return this.mDataModel.getActivity(n);
            ++n;
            return this.mDataModel.getActivity(n);
        }

        public long getItemId(int n) {
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int getItemViewType(int n) {
            if (!this.mShowFooterView) return 0;
            if (n != -1 + this.getCount()) return 0;
            return 1;
        }

        public int getMaxActivityCount() {
            return this.mMaxActivityCount;
        }

        public boolean getShowDefaultActivity() {
            return this.mShowDefaultActivity;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public View getView(int n, View view, ViewGroup viewGroup) {
            switch (this.getItemViewType(n)) {
                default: {
                    throw new IllegalArgumentException();
                }
                case 1: {
                    if (view != null) {
                        if (view.getId() == 1) return view;
                    }
                    view = LayoutInflater.from((Context)ActivityChooserView.this.getContext()).inflate(R.layout.abs__activity_chooser_view_list_item, viewGroup, false);
                    view.setId(1);
                    ((TextView)view.findViewById(R.id.abs__title)).setText((CharSequence)ActivityChooserView.this.mContext.getString(R.string.abs__activity_chooser_view_see_all));
                    return view;
                }
                case 0: 
            }
            if (view == null || view.getId() != R.id.abs__list_item) {
                view = LayoutInflater.from((Context)ActivityChooserView.this.getContext()).inflate(R.layout.abs__activity_chooser_view_list_item, viewGroup, false);
            }
            PackageManager packageManager = ActivityChooserView.this.mContext.getPackageManager();
            ImageView imageView = (ImageView)view.findViewById(R.id.abs__icon);
            ResolveInfo resolveInfo = (ResolveInfo)this.getItem(n);
            imageView.setImageDrawable(resolveInfo.loadIcon(packageManager));
            ((TextView)view.findViewById(R.id.abs__title)).setText(resolveInfo.loadLabel(packageManager));
            if (!IS_HONEYCOMB) return view;
            if (this.mShowDefaultActivity && n == 0 && this.mHighlightDefaultActivity) {
                SetActivated.invoke(view, true);
                return view;
            }
            SetActivated.invoke(view, false);
            return view;
        }

        public int getViewTypeCount() {
            return 3;
        }

        public int measureContentWidth() {
            int n = this.mMaxActivityCount;
            this.mMaxActivityCount = Integer.MAX_VALUE;
            int n2 = 0;
            View view = null;
            int n3 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            int n4 = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            int n5 = this.getCount();
            int n6 = 0;
            while (true) {
                if (n6 >= n5) {
                    this.mMaxActivityCount = n;
                    return n2;
                }
                view = this.getView(n6, view, null);
                view.measure(n3, n4);
                n2 = Math.max(n2, view.getMeasuredWidth());
                ++n6;
            }
        }

        public void setDataModel(ActivityChooserModel activityChooserModel) {
            ActivityChooserModel activityChooserModel2 = ActivityChooserView.this.mAdapter.getDataModel();
            if (activityChooserModel2 != null && ActivityChooserView.this.isShown()) {
                activityChooserModel2.unregisterObserver(ActivityChooserView.this.mModelDataSetOberver);
            }
            this.mDataModel = activityChooserModel;
            if (activityChooserModel != null && ActivityChooserView.this.isShown()) {
                activityChooserModel.registerObserver(ActivityChooserView.this.mModelDataSetOberver);
            }
            this.notifyDataSetChanged();
        }

        public void setMaxActivityCount(int n) {
            if (this.mMaxActivityCount != n) {
                this.mMaxActivityCount = n;
                this.notifyDataSetChanged();
            }
        }

        public void setShowDefaultActivity(boolean bl, boolean bl2) {
            if (this.mShowDefaultActivity != bl || this.mHighlightDefaultActivity != bl2) {
                this.mShowDefaultActivity = bl;
                this.mHighlightDefaultActivity = bl2;
                this.notifyDataSetChanged();
            }
        }

        public void setShowFooterView(boolean bl) {
            if (this.mShowFooterView != bl) {
                this.mShowFooterView = bl;
                this.notifyDataSetChanged();
            }
        }
    }

    private class Callbacks
    implements AdapterView.OnItemClickListener,
    View.OnClickListener,
    View.OnLongClickListener,
    PopupWindow.OnDismissListener {
        private Callbacks() {
        }

        private void notifyOnDismissListener() {
            if (ActivityChooserView.this.mOnDismissListener != null) {
                ActivityChooserView.this.mOnDismissListener.onDismiss();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onClick(View view) {
            if (view == ActivityChooserView.this.mDefaultActivityButton) {
                ActivityChooserView.this.dismissPopup();
                ResolveInfo resolveInfo = ActivityChooserView.this.mAdapter.getDefaultActivity();
                int n = ActivityChooserView.this.mAdapter.getDataModel().getActivityIndex(resolveInfo);
                Intent intent = ActivityChooserView.this.mAdapter.getDataModel().chooseActivity(n);
                if (intent != null) {
                    ActivityChooserView.this.mContext.startActivity(intent);
                }
                return;
            }
            if (view != ActivityChooserView.this.mExpandActivityOverflowButton) throw new IllegalArgumentException();
            ActivityChooserView.this.mIsSelectingDefaultActivity = false;
            ActivityChooserView.this.showPopupUnchecked(ActivityChooserView.this.mInitialActivityCount);
        }

        public void onDismiss() {
            this.notifyOnDismissListener();
            if (ActivityChooserView.this.mProvider != null) {
                ActivityChooserView.this.mProvider.subUiVisibilityChanged(false);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public void onItemClick(AdapterView<?> adapterView, View view, int n, long l) {
            Intent intent;
            switch (((ActivityChooserViewAdapter)adapterView.getAdapter()).getItemViewType(n)) {
                default: {
                    throw new IllegalArgumentException();
                }
                case 1: {
                    ActivityChooserView.this.showPopupUnchecked(Integer.MAX_VALUE);
                    return;
                }
                case 0: 
            }
            ActivityChooserView.this.dismissPopup();
            if (ActivityChooserView.this.mIsSelectingDefaultActivity) {
                if (n <= 0) return;
                ActivityChooserView.this.mAdapter.getDataModel().setDefaultActivity(n);
                return;
            }
            if (!ActivityChooserView.this.mAdapter.getShowDefaultActivity()) {
                ++n;
            }
            if ((intent = ActivityChooserView.this.mAdapter.getDataModel().chooseActivity(n)) == null) return;
            ActivityChooserView.this.mContext.startActivity(intent);
        }

        public boolean onLongClick(View view) {
            if (view == ActivityChooserView.this.mDefaultActivityButton) {
                if (ActivityChooserView.this.mAdapter.getCount() > 0) {
                    ActivityChooserView.this.mIsSelectingDefaultActivity = true;
                    ActivityChooserView.this.showPopupUnchecked(ActivityChooserView.this.mInitialActivityCount);
                }
                return true;
            }
            throw new IllegalArgumentException();
        }
    }

    private static class SetActivated {
        private SetActivated() {
        }

        public static void invoke(View view, boolean bl) {
            view.setActivated(bl);
        }
    }
}

