/*
 * Decompiled with CFR 0.152.
 */
package com.bugsense.trace;

import android.util.Log;
import com.bugsense.trace.BugSense;
import com.bugsense.trace.BugSenseHandler;
import com.bugsense.trace.G;
import com.bugsense.trace.Utils;
import com.bugsense.trace.models.Crash;
import java.io.PrintWriter;
import java.io.StringWriter;

public class DefaultExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private Thread.UncaughtExceptionHandler defaultExceptionHandler;

    public DefaultExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.defaultExceptionHandler = uncaughtExceptionHandler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        long l = 0L;
        try {
            long l2 = System.currentTimeMillis();
            long l3 = G.TIMESTAMP;
            l = l2 - l3;
        }
        catch (Exception exception) {}
        Crash crash = new Crash();
        crash.setHandled(1);
        crash.setAndroidVersion(G.ANDROID_VERSION);
        crash.setAppPackage(G.APP_PACKAGE);
        crash.setAppVerCode(G.APP_VERSIONCODE);
        crash.setAppVersion(G.APP_VERSION);
        crash.setBreadcrumbs(G.breadcrumbs);
        if (G.SEND_LOG) {
            crash.setConsoleLogs(BugSense.readLogs());
        }
        crash.setDate(String.valueOf(System.currentTimeMillis()));
        crash.setExtraData(BugSenseHandler.getCrashExtraData());
        crash.setIsGPSOn(Utils.isGPSOn(BugSenseHandler.gContext));
        crash.setIsMobileNetworkOn(Utils.isMobileNetworkOn(BugSenseHandler.gContext));
        crash.setIsWifiOn(Utils.isWifiOn(BugSenseHandler.gContext));
        crash.setMs_from_start(String.valueOf(l));
        crash.setPhoneModel(G.PHONE_MODEL);
        crash.setPhoneBrand(G.PHONE_BRAND);
        crash.setRooted(String.valueOf(G.HAS_ROOT));
        crash.setScreenProperties(Utils.ScreenProperties(BugSenseHandler.gContext));
        crash.setStacktrace(((Object)stringWriter).toString());
        Crash.sendCrash(BugSenseHandler.gContext, crash);
        if (BugSenseHandler.I_WANT_TO_DEBUG) {
            Log.d((String)G.TAG, (String)((Object)stringWriter).toString());
        }
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.defaultExceptionHandler.uncaughtException(thread, throwable);
    }
}

