/*
 * Decompiled with CFR 0.152.
 */
package com.bugsense.trace.models;

import android.content.Context;
import android.util.Log;
import com.bugsense.trace.ActivityAsyncTask;
import com.bugsense.trace.BugSense;
import com.bugsense.trace.BugSenseHandler;
import com.bugsense.trace.CryptoHttpClient;
import com.bugsense.trace.G;
import com.bugsense.trace.models.EventsMechanism;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public final class Event
implements Serializable {
    private static final long serialVersionUID = -7312496369662304956L;
    private final int MAX_BYTES;
    private String apiVersion = "";
    private String appVerCode = "";
    private String appVersion = "";
    private String locale = "";
    private String os = "";
    private String phoneBrand = "";
    private String phoneModel = "";
    private String tag = "";
    private String timestamp = "";

    public Event() {
        this.MAX_BYTES = 256;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void sendEvent(final Context context, final Event event) {
        String string2 = Thread.currentThread().getName();
        if (!string2.equals("main")) {
            Log.d((String)G.TAG, (String)("Error in thread: " + string2));
            Event.transmitEvent(context, event);
            return;
        }
        new ActivityAsyncTask<BugSense.Processor, Object, Object, Object>(new BugSense.Processor(){

            @Override
            public boolean beginSubmit() {
                return true;
            }

            @Override
            public void handlerInstalled() {
            }

            @Override
            public void submitDone() {
            }
        }){

            protected Object doInBackground(Object ... objectArray) {
                Event.transmitEvent(context, event);
                return null;
            }

            protected void onCancelled() {
                super.onCancelled();
            }

            protected void onPreExecute() {
                super.onPreExecute();
            }

            @Override
            protected void processPostExecute(Object object) {
                ((BugSense.Processor)this.mWrapped).submitDone();
            }
        }.execute(new Object[0]);
    }

    public static void submitEvent(Context context, Event event) {
        Event.sendEvent(context, event);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean transmitEvent(Context context, Event event) {
        boolean bl = false;
        if (BugSenseHandler.I_WANT_TO_DEBUG) {
            Log.d((String)G.TAG, (String)("URL: " + G.ANALYTICS_URL));
            Log.d((String)G.TAG, (String)("APIKEY: " + G.API_KEY));
        }
        try {
            String string2;
            DefaultHttpClient defaultHttpClient = G.ANALYTICS_URL.startsWith("https://") ? new CryptoHttpClient(context, 0) : new DefaultHttpClient();
            HttpParams httpParams = defaultHttpClient.getParams();
            HttpProtocolParams.setUseExpectContinue((HttpParams)httpParams, (boolean)false);
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)20000);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)20000);
            HttpPost httpPost = new HttpPost(G.ANALYTICS_URL);
            httpPost.addHeader("X-BugSense-Api-Key", G.API_KEY);
            new ArrayList<BasicNameValuePair>().add(new BasicNameValuePair("data", event.getFlatLine()));
            httpPost.setEntity((HttpEntity)new StringEntity(event.getFlatLine()));
            HttpEntity httpEntity = defaultHttpClient.execute((HttpUriRequest)httpPost).getEntity();
            if (httpEntity == null) {
                Log.w((String)G.TAG, (String)"It seems that there is no internet connectivity");
                throw new Exception("no internet connection");
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpEntity.getContent()));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
            if (!BugSenseHandler.I_WANT_TO_DEBUG) return true;
            Log.i((String)G.TAG, (String)("Event Response '" + event.tag + "' :" + stringBuilder.toString()));
            return true;
        }
        catch (ClientProtocolException clientProtocolException) {
            EventsMechanism.getInstance(context).saveEvent(event);
            Log.w((String)G.TAG, (String)("Transmitting event ClientProtocolException " + clientProtocolException.getMessage()));
            if (!BugSenseHandler.I_WANT_TO_DEBUG) return bl;
            clientProtocolException.printStackTrace();
            return bl;
        }
        catch (IOException iOException) {
            EventsMechanism.getInstance(context).saveEvent(event);
            Log.w((String)G.TAG, (String)("Transmitting event IOException " + iOException.getMessage()));
            if (!BugSenseHandler.I_WANT_TO_DEBUG) return bl;
            iOException.printStackTrace();
            return bl;
        }
        catch (Exception exception) {
            EventsMechanism.getInstance(context).saveEvent(event);
            Log.w((String)G.TAG, (String)("Transmitting event Exception " + exception.getMessage()));
            if (!BugSenseHandler.I_WANT_TO_DEBUG) return bl;
            exception.printStackTrace();
            return bl;
        }
    }

    public String getFlatLine() {
        String string2 = this.apiVersion + ":";
        String string3 = ":" + this.phoneModel + ":" + this.phoneBrand + ":" + this.os + ":" + this.appVersion + ":" + this.locale + ":" + this.timestamp;
        int n = 256 - (string2.getBytes().length + string3.getBytes().length);
        if (this.tag.getBytes().length > n) {
            this.tag = this.tag.substring(0, n);
        }
        return this.apiVersion + ":" + this.tag + ":" + this.phoneModel + ":" + this.phoneBrand + ":" + this.os + ":" + this.appVersion + ":" + this.locale + ":" + this.timestamp;
    }

    public void setApiVersion(String string2) {
        this.apiVersion = string2;
    }

    public void setAppVerCode(String string2) {
        this.appVerCode = string2;
    }

    public void setAppVersion(String string2) {
        this.appVersion = string2;
    }

    public void setLocale(String string2) {
        this.locale = string2;
    }

    public void setOs(String string2) {
        this.os = string2;
    }

    public void setPhoneBrand(String string2) {
        this.phoneBrand = string2;
    }

    public void setPhoneModel(String string2) {
        this.phoneModel = string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setTag(String string2) {
        this.tag = string2.getBytes().length > 256 ? string2.substring(0, 256) : string2;
        if (this.tag.equals("_ping") || this.tag.equals("_gnip")) {
            this.tag = this.tag.replaceAll("_", "-");
        }
        if (this.tag.contains(":") || this.tag.contains("|")) {
            this.tag = this.tag.replaceAll(":", "_").replace("|", "_");
        }
    }

    public void setTimestamp(long l) {
        this.timestamp = Long.toString(l);
    }
}

