/*
 * Decompiled with CFR 0.152.
 */
package com.bugsense.trace.models;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import com.bugsense.trace.BugSenseHandler;
import com.bugsense.trace.G;
import com.bugsense.trace.models.Ping;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;

public final class PingsMechanism {
    private static final int MAX_GNIPS_SIZE = 2;
    private static final int MAX_PINGS_SIZE = 2;
    private static SharedPreferences.Editor editor;
    public static final String fileName = "bpings";
    private static volatile PingsMechanism instance;
    private static SharedPreferences preferences;
    private Context ctx;

    public static PingsMechanism getInstance(Context context) {
        if (instance == null) {
            instance = new PingsMechanism();
            preferences = context.getSharedPreferences(G.TAG, 0);
            editor = preferences.edit();
        }
        PingsMechanism.instance.ctx = context;
        return instance;
    }

    public static void sendPing(Context context) {
        Ping.submitPing(context);
    }

    public void clearList() {
        if (BugSenseHandler.I_WANT_TO_DEBUG) {
            Log.d((String)G.TAG, (String)"clearing pings list");
        }
        this.saveList(new ArrayList<Ping>(0));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList<Ping> getList() {
        synchronized (this) {
            ArrayList<Ping> arrayList;
            block8: {
                editor.putBoolean("PINGS_READ_COMPLETED", false).commit();
                ObjectInputStream objectInputStream = new ObjectInputStream(this.ctx.openFileInput(fileName));
                arrayList = (ArrayList<Ping>)objectInputStream.readObject();
                objectInputStream.close();
                break block8;
                {
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    arrayList = null;
                    if (!BugSenseHandler.I_WANT_TO_DEBUG) break block8;
                    Log.d((String)G.TAG, (String)"Could not load pings list or doesn't exist");
                }
            }
            editor.putBoolean("PINGS_READ_COMPLETED", true).commit();
            if (arrayList == null) {
                arrayList = new ArrayList<Ping>();
            }
            if (BugSenseHandler.I_WANT_TO_DEBUG) {
                Log.d((String)G.TAG, (String)("Pings List has: " + arrayList.size() + " items"));
            }
            return arrayList;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveList(ArrayList<Ping> arrayList) {
        synchronized (this) {
            block4: {
                try {
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.ctx.openFileOutput(fileName, 0));
                    objectOutputStream.writeObject(arrayList);
                    objectOutputStream.close();
                }
                catch (Exception exception) {
                    Log.d((String)G.TAG, (String)"Could not save events list");
                    if (!BugSenseHandler.I_WANT_TO_DEBUG) break block4;
                    exception.printStackTrace();
                }
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void savePing(Ping var1_1) {
        var2_2 = 0;
        synchronized (this) {
            block12: {
                block11: {
                    var4_3 = this.getList();
                    var5_4 = var2_2;
                    var6_5 = var2_2;
                    var7_6 = var2_2;
                    while (true) {
                        block15: {
                            block14: {
                                block13: {
                                    if (var5_4 >= var4_3.size()) break block13;
                                    if (!var4_3.get(var5_4).getTag().equals("_ping")) break block14;
                                    var14_9 = var7_6 + 1;
                                    var15_10 = var6_5;
                                    var13_8 = var14_9;
                                    var12_7 = var15_10;
                                    break block15;
                                }
                                var4_3.add(var1_1);
                                if (var1_1.getTag().equals("_ping")) {
                                    if (var7_6 > 2) {
                                        break;
                                    }
                                    break block11;
                                }
                                if (var6_5 <= 2) break block11;
                                break block12;
                            }
                            var12_7 = var6_5 + 1;
                            var13_8 = var7_6;
                        }
                        ++var5_4;
                        var7_6 = var13_8;
                        var6_5 = var12_7;
                    }
                    while (var2_2 < var4_3.size()) {
                        if (var4_3.get(var2_2).getTag().equals("_ping")) {
                            var4_3.remove(var2_2);
                            break;
                        }
                        ++var2_2;
                    }
                }
lbl40:
                // 3 sources

                while (true) {
                    this.saveList(var4_3);
                    return;
                }
            }
            var9_11 = var2_2;
            while (true) {
                if (var9_11 >= var4_3.size()) ** GOTO lbl40
                if (var4_3.get(var9_11).getTag().equals("_gnip")) {
                    var4_3.remove(var9_11);
                    ** continue;
                }
                ++var9_11;
            }
        }
    }

    public void sendSavedPings() {
        final ArrayList<Ping> arrayList = this.getList();
        if (arrayList.size() > 0) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    ArrayList arrayList2 = new ArrayList();
                    arrayList2.addAll(arrayList);
                    PingsMechanism.this.clearList();
                    int n = 0;
                    while (true) {
                        block7: {
                            block6: {
                                if (n >= arrayList2.size()) break block6;
                                Ping ping = (Ping)arrayList2.get(n);
                                if (Ping.transmitPing(PingsMechanism.this.ctx, ping)) break block7;
                                int n2 = arrayList2.size();
                                if (n2 > 4) {
                                    n2 -= n2 + -4;
                                }
                                if (BugSenseHandler.I_WANT_TO_DEBUG) {
                                    Log.d((String)G.TAG, (String)("Could not send ping, saving the rest: " + String.valueOf(n2) + " items"));
                                }
                                arrayList.clear();
                                arrayList.addAll(arrayList2.subList(n, n2));
                                PingsMechanism.this.saveList(arrayList);
                            }
                            return;
                        }
                        ++n;
                    }
                }
            });
            BugSenseHandler.getExecutor().submit(thread);
        }
    }
}

