/*
 * Decompiled with CFR 0.152.
 */
package it.evilsocket.dsploit.net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteOrder;

public class IP4Address {
    private InetAddress mAddress = null;
    private byte[] mByteArray = null;
    private int mInteger = 0;
    private String mString = "";

    /*
     * Enabled aggressive block sorting
     */
    public IP4Address(int n) throws UnknownHostException {
        this.mByteArray = new byte[4];
        this.mInteger = n;
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            this.mByteArray[0] = (byte)(n & 0xFF);
            this.mByteArray[1] = (byte)(0xFF & n >> 8);
            this.mByteArray[2] = (byte)(0xFF & n >> 16);
            this.mByteArray[3] = (byte)(0xFF & n >> 24);
        } else {
            this.mByteArray[0] = (byte)(0xFF & n >> 24);
            this.mByteArray[1] = (byte)(0xFF & n >> 16);
            this.mByteArray[2] = (byte)(0xFF & n >> 8);
            this.mByteArray[3] = (byte)(n & 0xFF);
        }
        this.mAddress = InetAddress.getByAddress(this.mByteArray);
        this.mString = this.mAddress.getHostAddress();
    }

    public IP4Address(String string2) throws UnknownHostException {
        this.mString = string2;
        this.mAddress = InetAddress.getByName(string2);
        this.mByteArray = this.mAddress.getAddress();
        this.mInteger = ((0xFF & this.mByteArray[0]) << 24) + ((0xFF & this.mByteArray[1]) << 16) + ((0xFF & this.mByteArray[2]) << 8) + (0xFF & this.mByteArray[3]);
    }

    public IP4Address(InetAddress inetAddress) {
        this.mAddress = inetAddress;
        this.mByteArray = inetAddress.getAddress();
        this.mString = this.mAddress.getHostAddress();
        this.mInteger = ((0xFF & this.mByteArray[0]) << 24) + ((0xFF & this.mByteArray[1]) << 16) + ((0xFF & this.mByteArray[2]) << 8) + (0xFF & this.mByteArray[3]);
    }

    public IP4Address(byte[] byArray) throws UnknownHostException {
        this.mByteArray = byArray;
        this.mAddress = InetAddress.getByAddress(this.mByteArray);
        this.mString = this.mAddress.getHostAddress();
        this.mInteger = ((0xFF & this.mByteArray[0]) << 24) + ((0xFF & this.mByteArray[1]) << 16) + ((0xFF & this.mByteArray[2]) << 8) + (0xFF & this.mByteArray[3]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IP4Address next(IP4Address iP4Address) throws UnknownHostException {
        byte[] byArray = iP4Address.toByteArray();
        int n = -1 + byArray.length;
        while (true) {
            if (n < 0 || byArray[n] != -1) {
                if (n < 0) return null;
                byArray[n] = (byte)(1 + byArray[n]);
                return new IP4Address(byArray);
            }
            byArray[n] = 0;
            --n;
        }
    }

    public static int ntohl(int n) {
        return (0xFF & n >> 24) + (0xFF & n >> 16) + (0xFF & n >> 8) + (n & 0xFF);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(IP4Address iP4Address) {
        if (this.mInteger != iP4Address.toInteger()) return false;
        return true;
    }

    public boolean equals(InetAddress inetAddress) {
        return this.mAddress.equals(inetAddress);
    }

    public int getPrefixLength() {
        int n = this.mInteger;
        int n2 = 0;
        int n3 = n & 1;
        while (n2 < 32) {
            ++n2;
            n3 += (n >>>= 1) & 1;
        }
        return n3;
    }

    public byte[] toByteArray() {
        return this.mByteArray;
    }

    public InetAddress toInetAddress() {
        return this.mAddress;
    }

    public int toInteger() {
        return this.mInteger;
    }

    public String toString() {
        return this.mString;
    }
}

