/*
 * Decompiled with CFR 0.152.
 */
package it.evilsocket.dsploit.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import it.evilsocket.dsploit.net.Endpoint;
import it.evilsocket.dsploit.net.IP4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;

public class Network {
    private static final String TAG = "NETWORK";
    private IP4Address mBase = null;
    private ConnectivityManager mConnectivityManager = null;
    private IP4Address mGateway = null;
    private DhcpInfo mInfo = null;
    private NetworkInterface mInterface = null;
    private IP4Address mLocal = null;
    private IP4Address mNetmask = null;
    private WifiInfo mWifiInfo = null;
    private WifiManager mWifiManager = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Network(Context context) throws NoRouteToHostException, SocketException, UnknownHostException {
        this.mWifiManager = (WifiManager)context.getSystemService("wifi");
        this.mConnectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.mInfo = this.mWifiManager.getDhcpInfo();
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
        this.mGateway = new IP4Address(this.mInfo.gateway);
        this.mNetmask = new IP4Address(this.mInfo.netmask);
        this.mLocal = new IP4Address(this.mInfo.ipAddress);
        this.mBase = new IP4Address(this.mInfo.netmask & this.mInfo.gateway);
        if (!this.isConnected()) {
            throw new NoRouteToHostException("Not connected to any WiFi access point.");
        }
        try {
            this.mInterface = NetworkInterface.getByInetAddress(this.getLocalAddress());
            return;
        }
        catch (SocketException socketException) {
            it.evilsocket.dsploit.core.System.errorLogging(TAG, socketException);
            this.mInterface = NetworkInterface.getByName(System.getProperty("wifi.interface", "wlan0"));
            if (this.mInterface != null) return;
            throw socketException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isConnectivityAvailable(Context context) {
        NetworkInfo networkInfo = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
        if (networkInfo == null) return false;
        if (!networkInfo.isConnected()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isWifiConnected(Context context) {
        boolean bl = true;
        NetworkInfo networkInfo = ((ConnectivityManager)context.getSystemService("connectivity")).getNetworkInfo(bl ? 1 : 0);
        if (networkInfo == null) return false;
        if (!networkInfo.isConnected()) return false;
        if (!networkInfo.isAvailable()) return false;
        return bl;
    }

    public boolean equals(Network network) {
        return this.mInfo.equals(network.getInfo());
    }

    public InetAddress getGatewayAddress() {
        return this.mGateway.toInetAddress();
    }

    public byte[] getGatewayHardware() {
        return Endpoint.parseMacAddress(this.mWifiInfo.getBSSID());
    }

    public DhcpInfo getInfo() {
        return this.mInfo;
    }

    public NetworkInterface getInterface() {
        return this.mInterface;
    }

    public InetAddress getLocalAddress() {
        return this.mLocal.toInetAddress();
    }

    public String getLocalAddressAsString() {
        return this.mLocal.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] getLocalHardware() {
        try {
            byte[] byArray = this.mInterface.getHardwareAddress();
            return byArray;
        }
        catch (SocketException socketException) {
            it.evilsocket.dsploit.core.System.errorLogging(TAG, socketException);
            return null;
        }
    }

    public InetAddress getNetmaskAddress() {
        return this.mNetmask.toInetAddress();
    }

    public String getNetworkMasked() {
        int n = this.mBase.toInteger();
        return String.valueOf(n & 0xFF) + "." + (0xFF & n >> 8) + "." + (0xFF & n >> 16) + "." + (0xFF & n >> 24);
    }

    public String getNetworkRepresentation() {
        return String.valueOf(this.getNetworkMasked()) + "/" + this.mNetmask.getPrefixLength();
    }

    public int getNumberOfAddresses() {
        return IP4Address.ntohl(0xFFFFFFFF ^ this.mNetmask.toInteger());
    }

    public String getSSID() {
        return this.mWifiInfo.getSSID();
    }

    public IP4Address getStartAddress() {
        return this.mBase;
    }

    public boolean isConnected() {
        return this.mConnectivityManager.getNetworkInfo(1).isConnected();
    }

    public boolean isInternal(int n) {
        return this.isInternal(String.valueOf(n & 0xFF) + "." + (0xFF & n >> 8) + "." + (0xFF & n >> 16) + "." + (0xFF & n >> 24));
    }

    public boolean isInternal(String string2) {
        boolean bl = false;
        try {
            byte[] byArray = this.mGateway.toByteArray();
            byte[] byArray2 = InetAddress.getByName(string2).getAddress();
            byte[] byArray3 = this.mNetmask.toByteArray();
            int n = 0;
            while (true) {
                if (n >= byArray.length) {
                    bl = true;
                } else {
                    int n2 = byArray[n] & byArray3[n];
                    byte by = byArray2[n];
                    byte by2 = byArray3[n];
                    if (n2 == (by & by2)) {
                        ++n;
                        continue;
                    }
                }
                break;
            }
        }
        catch (UnknownHostException unknownHostException) {
            it.evilsocket.dsploit.core.System.errorLogging(TAG, unknownHostException);
        }
        return bl;
    }

    public static final class Protocol
    extends Enum<Protocol> {
        private static final /* synthetic */ Protocol[] ENUM$VALUES;
        public static final /* enum */ Protocol ICMP;
        public static final /* enum */ Protocol IGMP;
        public static final /* enum */ Protocol TCP;
        public static final /* enum */ Protocol UDP;
        public static final /* enum */ Protocol UNKNOWN;

        static {
            TCP = new Protocol();
            UDP = new Protocol();
            ICMP = new Protocol();
            IGMP = new Protocol();
            UNKNOWN = new Protocol();
            Protocol[] protocolArray = new Protocol[]{TCP, UDP, ICMP, IGMP, UNKNOWN};
            ENUM$VALUES = protocolArray;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Protocol fromString(String string2) {
            if (string2 == null) return UNKNOWN;
            String string3 = string2.toLowerCase();
            if (string3.equals("tcp")) {
                return TCP;
            }
            if (string3.equals("udp")) {
                return UDP;
            }
            if (string3.equals("icmp")) {
                return ICMP;
            }
            if (!string3.equals("igmp")) return UNKNOWN;
            return IGMP;
        }

        public static Protocol valueOf(String string2) {
            return Enum.valueOf(Protocol.class, string2);
        }

        public static Protocol[] values() {
            Protocol[] protocolArray = ENUM$VALUES;
            int n = protocolArray.length;
            Protocol[] protocolArray2 = new Protocol[n];
            System.arraycopy(protocolArray, 0, protocolArray2, 0, n);
            return protocolArray2;
        }
    }
}

