/*
 * Decompiled with CFR 0.152.
 */
package it.evilsocket.dsploit.plugins;

import android.os.Bundle;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.ToggleButton;
import it.evilsocket.dsploit.core.Plugin;
import it.evilsocket.dsploit.core.System;
import it.evilsocket.dsploit.net.Network;
import it.evilsocket.dsploit.net.Target;
import it.evilsocket.dsploit.tools.NMap;

public class Inspector
extends Plugin {
    private ProgressBar mActivity;
    private TextView mDeviceName;
    private TextView mDeviceOS;
    private TextView mDeviceServices;
    private TextView mDeviceType;
    private Receiver mReceiver;
    private boolean mRunning;
    private ToggleButton mStartButton;

    public Inspector() {
        Target.Type[] typeArray = new Target.Type[]{Target.Type.ENDPOINT, Target.Type.REMOTE};
        super("Inspector", "Perform target operating system and services deep detection ( slower than port scanner, but more accurate ).", typeArray, 2130903066, 2130837597);
        this.mStartButton = null;
        this.mActivity = null;
        this.mDeviceName = null;
        this.mDeviceType = null;
        this.mDeviceOS = null;
        this.mDeviceServices = null;
        this.mRunning = false;
        this.mReceiver = null;
    }

    private void setStartedState() {
        this.mActivity.setVisibility(0);
        this.mRunning = true;
        System.getNMap().inpsect(System.getCurrentTarget(), this.mReceiver).start();
    }

    private void setStoppedState() {
        System.getNMap().kill();
        this.mActivity.setVisibility(4);
        this.mRunning = false;
        this.mStartButton.setChecked(false);
    }

    @Override
    public void onBackPressed() {
        this.setStoppedState();
        super.onBackPressed();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mStartButton = (ToggleButton)this.findViewById(2131099703);
        this.mActivity = (ProgressBar)this.findViewById(2131099704);
        this.mDeviceName = (TextView)this.findViewById(2131099711);
        this.mDeviceType = (TextView)this.findViewById(2131099707);
        this.mDeviceOS = (TextView)this.findViewById(2131099709);
        this.mDeviceServices = (TextView)this.findViewById(2131099710);
        this.mDeviceName.setText((CharSequence)System.getCurrentTarget().toString());
        if (System.getCurrentTarget().getDeviceType() != null) {
            this.mDeviceType.setText((CharSequence)System.getCurrentTarget().getDeviceType());
        }
        if (System.getCurrentTarget().getDeviceOS() != null) {
            this.mDeviceOS.setText((CharSequence)System.getCurrentTarget().getDeviceOS());
        }
        if (System.getCurrentTarget().hasOpenPortsWithService()) {
            this.mDeviceServices.setText((CharSequence)"");
            for (Target.Port port : System.getCurrentTarget().getOpenPorts()) {
                if (port.service == null || port.service.isEmpty()) continue;
                this.mDeviceServices.append((CharSequence)(String.valueOf(port.number) + " ( " + port.protocol.toString().toLowerCase() + " ) : " + port.service + "\n"));
            }
        }
        this.mStartButton.setOnClickListener(new View.OnClickListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void onClick(View view) {
                if (Inspector.this.mRunning) {
                    Inspector.this.setStoppedState();
                    return;
                }
                Inspector.this.setStartedState();
            }
        });
        this.mReceiver = new Receiver();
    }

    private class Receiver
    extends NMap.InspectionReceiver {
        private Receiver() {
        }

        @Override
        public void onDeviceFound(final String string2) {
            System.getCurrentTarget().setDeviceType(string2);
            Inspector.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Inspector.this.mDeviceType.setText((CharSequence)string2);
                }
            });
        }

        @Override
        public void onEnd(int n) {
            Inspector.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (Inspector.this.mRunning) {
                        Inspector.this.setStoppedState();
                    }
                }
            });
        }

        @Override
        public void onGuessOsFound(final String string2) {
            System.getCurrentTarget().setDeviceOS(string2);
            Inspector.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Inspector.this.mDeviceOS.setText((CharSequence)string2);
                }
            });
        }

        @Override
        public void onOpenPortFound(int n, String string2) {
            System.addOpenPort(n, Network.Protocol.fromString(string2));
        }

        @Override
        public void onOsFound(final String string2) {
            System.getCurrentTarget().setDeviceOS(string2);
            Inspector.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Inspector.this.mDeviceOS.setText((CharSequence)string2);
                }
            });
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onServiceFound(final int n, final String string2, final String string3) {
            final boolean bl = !string3.trim().isEmpty();
            Inspector.this.runOnUiThread(new Runnable(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (Inspector.this.mDeviceServices.getText().equals("unknown")) {
                        Inspector.this.mDeviceServices.setText((CharSequence)"");
                    }
                    if (bl) {
                        Inspector.this.mDeviceServices.append((CharSequence)(String.valueOf(n) + " ( " + string2 + " ) : " + string3 + "\n"));
                        return;
                    }
                    Inspector.this.mDeviceServices.append((CharSequence)(String.valueOf(n) + " ( " + string2 + " )\n"));
                }
            });
            if (bl) {
                System.addOpenPort(n, Network.Protocol.fromString(string2), string3);
                return;
            }
            System.addOpenPort(n, Network.Protocol.fromString(string2));
        }

        @Override
        public void onServiceInfoFound(final String string2) {
            System.getCurrentTarget().setDeviceOS(string2);
            Inspector.this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Inspector.this.mDeviceOS.setText((CharSequence)string2);
                }
            });
        }
    }
}

