/*
 * Decompiled with CFR 0.152.
 */
package it.evilsocket.dsploit.wifi;

import android.net.wifi.ScanResult;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public abstract class Keygen
implements Comparable<Keygen> {
    public static final String EAP = "EAP";
    static final byte[] HEX_CHAR_TABLE;
    public static final String OPEN = "Open";
    public static final String PSK = "PSK";
    public static final String WEP = "WEP";
    private final String encryption;
    private String errorMessage;
    private final int level;
    private final String macAddress;
    private List<String> pwList;
    private ScanResult scanResult;
    private final String ssidName;
    private boolean stopRequested = false;

    static {
        byte[] byArray = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
        HEX_CHAR_TABLE = byArray;
    }

    public Keygen(String string2, String string3, int n, String string4) {
        this.ssidName = string2;
        this.macAddress = string3;
        this.level = n;
        this.encryption = string4;
        this.pwList = new ArrayList<String>();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String dectoString(int n) {
        String string2 = "";
        while (n > 0) {
            switch (n % 10) {
                case 0: {
                    string2 = "Zero" + string2;
                    break;
                }
                case 1: {
                    string2 = "One" + string2;
                    break;
                }
                case 2: {
                    string2 = "Two" + string2;
                    break;
                }
                case 3: {
                    string2 = "Three" + string2;
                    break;
                }
                case 4: {
                    string2 = "Four" + string2;
                    break;
                }
                case 5: {
                    string2 = "Five" + string2;
                    break;
                }
                case 6: {
                    string2 = "Six" + string2;
                    break;
                }
                case 7: {
                    string2 = "Seven" + string2;
                    break;
                }
                case 8: {
                    string2 = "Eight" + string2;
                    break;
                }
                case 9: {
                    string2 = "Nine" + string2;
                    break;
                }
            }
            n /= 10;
        }
        return string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getHexString(short s) {
        byte[] byArray = new byte[2];
        int n = s & 0xFF;
        byArray[0] = HEX_CHAR_TABLE[n >>> 4];
        byArray[1] = HEX_CHAR_TABLE[n & 0xF];
        try {
            return new String(byArray, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public static String getHexString(byte[] byArray) throws UnsupportedEncodingException {
        byte[] byArray2 = new byte[2 * byArray.length];
        int n = byArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = 0xFF & byArray[n2];
            int n5 = n3 + 1;
            byArray2[n3] = HEX_CHAR_TABLE[n4 >>> 4];
            n3 = n5 + 1;
            byArray2[n5] = HEX_CHAR_TABLE[n4 & 0xF];
            ++n2;
        }
        return new String(byArray2, "ASCII");
    }

    public static String getHexString(short[] sArray) throws UnsupportedEncodingException {
        byte[] byArray = new byte[2 * sArray.length];
        int n = sArray.length;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            int n4 = 0xFF & sArray[n2];
            int n5 = n3 + 1;
            byArray[n3] = HEX_CHAR_TABLE[n4 >>> 4];
            n3 = n5 + 1;
            byArray[n5] = HEX_CHAR_TABLE[n4 & 0xF];
            ++n2;
        }
        return new String(byArray, "ASCII");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getScanResultSecurity(Keygen keygen) {
        String string2 = keygen.encryption;
        String[] stringArray = new String[]{WEP, PSK, EAP};
        int n = -1 + stringArray.length;
        while (n >= 0) {
            if (string2.contains(stringArray[n])) {
                return stringArray[n];
            }
            --n;
        }
        return OPEN;
    }

    protected void addPassword(String string2) {
        if (!this.pwList.contains(string2)) {
            this.pwList.add(string2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(Keygen keygen) {
        if (this.isSupported() && keygen.isSupported()) {
            if (keygen.level != this.level) return keygen.level - this.level;
            return this.ssidName.compareTo(keygen.ssidName);
        }
        if (!this.isSupported()) return 1;
        return -1;
    }

    public int describeContents() {
        return 0;
    }

    public String getDisplayMacAddress() {
        return this.macAddress;
    }

    public String getEncryption() {
        return this.encryption;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public abstract List<String> getKeys();

    public int getLevel() {
        return this.level;
    }

    public String getMacAddress() {
        return this.macAddress.replace(":", "");
    }

    public List<String> getResults() {
        return this.pwList;
    }

    public ScanResult getScanResult() {
        return this.scanResult;
    }

    public String getSsidName() {
        return this.ssidName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isLocked() {
        if (!OPEN.equals(Keygen.getScanResultSecurity(this))) return true;
        return false;
    }

    public boolean isStopRequested() {
        synchronized (this) {
            boolean bl = this.stopRequested;
            return bl;
        }
    }

    public boolean isSupported() {
        return true;
    }

    public void setErrorMessage(String string2) {
        this.errorMessage = string2;
    }

    public void setScanResult(ScanResult scanResult) {
        this.scanResult = scanResult;
    }

    public void setStopRequested(boolean bl) {
        synchronized (this) {
            this.stopRequested = bl;
            return;
        }
    }
}

