/*
 * Decompiled with CFR 0.152.
 */
package it.evilsocket.dsploit.wifi.algorithms;

import it.evilsocket.dsploit.wifi.Keygen;
import it.evilsocket.dsploit.wifi.algorithms.helpers.AliceMagicInfo;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

public class AliceKeygen
extends Keygen {
    private static final String preInitCharset = "0123456789abcdefghijklmnopqrstuvwxyz0123456789abcdefghijklmnopqrstuvwxyz0123456789abcdefghijklmnopqrstuvwxyz0123456789abcdefghijklmnopqrstuvwxyz0123456789abcdefghijklmnopqrstuvwxyz0123456789abcdefghijklmnopqrstuvwxyz0123456789abcdefghijklmnopqrstuvWxyz0123";
    private static final byte[] specialSeq;
    private MessageDigest md;
    private final String ssidIdentifier;
    private final List<AliceMagicInfo> supportedAlice;

    static {
        byte[] byArray = new byte[32];
        byArray[0] = 100;
        byArray[1] = -58;
        byArray[2] = -35;
        byArray[3] = -29;
        byArray[4] = -27;
        byArray[5] = 121;
        byArray[6] = -74;
        byArray[7] = -39;
        byArray[8] = -122;
        byArray[9] = -106;
        byArray[10] = -115;
        byArray[11] = 52;
        byArray[12] = 69;
        byArray[13] = -46;
        byArray[14] = 59;
        byArray[15] = 21;
        byArray[16] = -54;
        byArray[17] = -81;
        byArray[18] = 18;
        byArray[19] = -124;
        byArray[20] = 2;
        byArray[21] = -84;
        byArray[22] = 86;
        byArray[24] = 5;
        byArray[25] = -50;
        byArray[26] = 32;
        byArray[27] = 117;
        byArray[28] = -111;
        byArray[29] = 63;
        byArray[30] = -36;
        byArray[31] = -24;
        specialSeq = byArray;
    }

    public AliceKeygen(String string2, String string3, int n, String string4, List<AliceMagicInfo> list) {
        super(string2, string3, n, string4);
        this.ssidIdentifier = string2.substring(-8 + string2.length());
        this.supportedAlice = list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getKeys() {
        int n;
        if (this.supportedAlice == null || this.supportedAlice.isEmpty()) {
            this.setErrorMessage("This Alice series is not yet supported!");
            return null;
        }
        try {
            this.md = MessageDigest.getInstance("SHA-256");
            n = 0;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.setErrorMessage("This phone cannot process a SHA256 hash.");
            return null;
        }
        block6: while (true) {
            byte[] byArray;
            String string2;
            block26: {
                String string3;
                if (n >= this.supportedAlice.size()) {
                    return this.getResults();
                }
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.supportedAlice.get(n).getSerial()));
                String string4 = stringBuilder.append("X").toString();
                int n2 = this.supportedAlice.get(n).getMagic()[0];
                int n3 = this.supportedAlice.get(n).getMagic()[1];
                String string5 = Integer.toString((Integer.valueOf(this.ssidIdentifier) - n2) / n3);
                int n4 = 0;
                while (true) {
                    if (n4 >= 7 - string5.length()) {
                        string2 = String.valueOf(string4) + string5;
                        byArray = new byte[6];
                        string3 = "";
                        if (this.getMacAddress().length() == 12) {
                            break;
                        }
                        break block26;
                    }
                    string4 = String.valueOf(string4) + "0";
                    ++n4;
                }
                int n5 = 0;
                while (true) {
                    if (n5 >= 12) {
                        this.md.reset();
                        this.md.update(specialSeq);
                        this.md.update(string2.getBytes("ASCII"));
                    }
                    byArray[n5 / 2] = (byte)((Character.digit(this.getMacAddress().charAt(n5), 16) << 4) + Character.digit(this.getMacAddress().charAt(n5 + 1), 16));
                    n5 += 2;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
                this.md.update(byArray);
                byte[] byArray2 = this.md.digest();
                int n6 = 0;
                while (true) {
                    if (n6 >= 24) {
                        this.addPassword(string3);
                        break;
                    }
                    string3 = String.valueOf(string3) + preInitCharset.charAt(0xFF & byArray2[n6]);
                    ++n6;
                }
            }
            String string6 = this.getMacAddress().substring(0, 6);
            int n7 = 0;
            while (true) {
                block28: {
                    block27: {
                        if (n7 > 9) break block27;
                        String string7 = Integer.toHexString(Integer.valueOf(String.valueOf(n7) + this.ssidIdentifier)).toUpperCase();
                        if (string6.charAt(5) != string7.charAt(0)) break block28;
                        string6 = String.valueOf(string6) + string7.substring(1);
                    }
                    if (!string6.equals(this.getMacAddress().substring(0, 6))) break;
                    return this.getResults();
                }
                ++n7;
            }
            int n8 = 0;
            while (true) {
                if (n8 >= 12) {
                    this.md.reset();
                    this.md.update(specialSeq);
                    this.md.update(string2.getBytes("ASCII"));
                }
                byArray[n8 / 2] = (byte)((Character.digit(string6.charAt(n8), 16) << 4) + Character.digit(string6.charAt(n8 + 1), 16));
                n8 += 2;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            this.md.update(byArray);
            String string8 = "";
            byte[] byArray3 = this.md.digest();
            int n9 = 0;
            while (true) {
                if (n9 >= 24) {
                    this.addPassword(string8);
                    ++n;
                    continue block6;
                }
                string8 = String.valueOf(string8) + preInitCharset.charAt(0xFF & byArray3[n9]);
                ++n9;
            }
            break;
        }
    }
}

