/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet;

import java.io.FileInputStream;
import org.mozilla.universalchardet.CharsetListener;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.EscCharsetProber;
import org.mozilla.universalchardet.prober.Latin1Prober;
import org.mozilla.universalchardet.prober.MBCSGroupProber;
import org.mozilla.universalchardet.prober.SBCSGroupProber;

public class UniversalDetector {
    public static final float MINIMUM_THRESHOLD = 0.2f;
    public static final float SHORTCUT_THRESHOLD = 0.95f;
    private String detectedCharset;
    private boolean done;
    private CharsetProber escCharsetProber;
    private boolean gotData;
    private InputState inputState;
    private byte lastChar;
    private CharsetListener listener;
    private CharsetProber[] probers;
    private boolean start;

    public UniversalDetector(CharsetListener charsetListener) {
        this.listener = charsetListener;
        this.escCharsetProber = null;
        this.probers = new CharsetProber[3];
        for (int i = 0; i < this.probers.length; ++i) {
            this.probers[i] = null;
        }
        this.reset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] stringArray) throws Exception {
        int n;
        if (stringArray.length != 1) {
            System.out.println("USAGE: java UniversalDetector filename");
            return;
        }
        UniversalDetector universalDetector = new UniversalDetector(new CharsetListener(){

            @Override
            public void report(String string2) {
                System.out.println("charset = " + string2);
            }
        });
        byte[] byArray = new byte[4096];
        FileInputStream fileInputStream = new FileInputStream(stringArray[0]);
        while ((n = fileInputStream.read(byArray)) > 0 && !universalDetector.isDone()) {
            universalDetector.handleData(byArray, 0, n);
        }
        universalDetector.dataEnd();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dataEnd() {
        int n = 0;
        if (!this.gotData) {
            return;
        }
        if (this.detectedCharset != null) {
            this.done = true;
            if (this.listener == null) return;
            this.listener.report(this.detectedCharset);
            return;
        }
        if (this.inputState != InputState.HIGHBYTE) {
            if (this.inputState != InputState.ESC_ASCII) return;
            return;
        }
        float f = 0.0f;
        int n2 = n;
        while (true) {
            if (n >= this.probers.length) {
                if (!(f > 0.2f)) return;
                this.detectedCharset = this.probers[n2].getCharSetName();
                if (this.listener == null) return;
                this.listener.report(this.detectedCharset);
                return;
            }
            float f2 = this.probers[n].getConfidence();
            if (f2 > f) {
                n2 = n;
                f = f2;
            }
            ++n;
        }
    }

    public String getDetectedCharset() {
        return this.detectedCharset;
    }

    public CharsetListener getListener() {
        return this.listener;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void handleData(byte[] byArray, int n, int n2) {
        int n3 = 0;
        if (this.done) {
            return;
        }
        if (n2 > 0) {
            this.gotData = true;
        }
        if (this.start) {
            this.start = n3;
            if (n2 > 3) {
                int n4 = 0xFF & byArray[n];
                int n5 = 0xFF & byArray[n + 1];
                int n6 = 0xFF & byArray[n + 2];
                int n7 = 0xFF & byArray[n + 3];
                switch (n4) {
                    case 239: {
                        if (n5 != 187 || n6 != 191) break;
                        this.detectedCharset = Constants.CHARSET_UTF_8;
                        break;
                    }
                    case 254: {
                        if (n5 == 255 && n6 == 0 && n7 == 0) {
                            this.detectedCharset = Constants.CHARSET_X_ISO_10646_UCS_4_3412;
                            break;
                        }
                        if (n5 != 255) break;
                        this.detectedCharset = Constants.CHARSET_UTF_16BE;
                        break;
                    }
                    case 0: {
                        if (n5 == 0 && n6 == 254 && n7 == 255) {
                            this.detectedCharset = Constants.CHARSET_UTF_32BE;
                            break;
                        }
                        if (n5 != 0 || n6 != 255 || n7 != 254) break;
                        this.detectedCharset = Constants.CHARSET_X_ISO_10646_UCS_4_2143;
                        break;
                    }
                    case 255: {
                        if (n5 == 254 && n6 == 0 && n7 == 0) {
                            this.detectedCharset = Constants.CHARSET_UTF_32LE;
                            break;
                        }
                        if (n5 != 254) break;
                        this.detectedCharset = Constants.CHARSET_UTF_16LE;
                    }
                }
                if (this.detectedCharset != null) {
                    this.done = true;
                    return;
                }
            }
        }
        int n8 = n + n2;
        for (int i = n; i < n8; ++i) {
            int n9 = 0xFF & byArray[i];
            if ((n9 & 0x80) != 0 && n9 != 160) {
                if (this.inputState == InputState.HIGHBYTE) continue;
                this.inputState = InputState.HIGHBYTE;
                if (this.escCharsetProber != null) {
                    this.escCharsetProber = null;
                }
                if (this.probers[n3] == null) {
                    this.probers[n3] = new MBCSGroupProber();
                }
                if (this.probers[1] == null) {
                    this.probers[1] = new SBCSGroupProber();
                }
                if (this.probers[2] != null) continue;
                this.probers[2] = new Latin1Prober();
                continue;
            }
            if (this.inputState == InputState.PURE_ASCII && (n9 == 27 || n9 == 123 && this.lastChar == 126)) {
                this.inputState = InputState.ESC_ASCII;
            }
            this.lastChar = byArray[i];
        }
        if (this.inputState == InputState.ESC_ASCII) {
            if (this.escCharsetProber == null) {
                this.escCharsetProber = new EscCharsetProber();
            }
            if (this.escCharsetProber.handleData(byArray, n, n2) != CharsetProber.ProbingState.FOUND_IT) return;
            this.done = true;
            this.detectedCharset = this.escCharsetProber.getCharSetName();
            return;
        }
        if (this.inputState != InputState.HIGHBYTE) return;
        while (n3 < this.probers.length) {
            if (this.probers[n3].handleData(byArray, n, n2) == CharsetProber.ProbingState.FOUND_IT) {
                this.done = true;
                this.detectedCharset = this.probers[n3].getCharSetName();
                return;
            }
            ++n3;
        }
    }

    public boolean isDone() {
        return this.done;
    }

    public void reset() {
        int n;
        this.done = n = 0;
        this.start = true;
        this.detectedCharset = null;
        this.gotData = n;
        this.inputState = InputState.PURE_ASCII;
        this.lastChar = (byte)n;
        if (this.escCharsetProber != null) {
            this.escCharsetProber.reset();
        }
        while (n < this.probers.length) {
            if (this.probers[n] != null) {
                this.probers[n].reset();
            }
            ++n;
        }
    }

    public void setListener(CharsetListener charsetListener) {
        this.listener = charsetListener;
    }

    public static final class InputState
    extends Enum<InputState> {
        private static final /* synthetic */ InputState[] $VALUES;
        public static final /* enum */ InputState ESC_ASCII;
        public static final /* enum */ InputState HIGHBYTE;
        public static final /* enum */ InputState PURE_ASCII;

        static {
            PURE_ASCII = new InputState();
            ESC_ASCII = new InputState();
            HIGHBYTE = new InputState();
            InputState[] inputStateArray = new InputState[]{PURE_ASCII, ESC_ASCII, HIGHBYTE};
            $VALUES = inputStateArray;
        }

        public static InputState valueOf(String string2) {
            return Enum.valueOf(InputState.class, string2);
        }

        public static InputState[] values() {
            return (InputState[])$VALUES.clone();
        }
    }
}

