/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.nio.ByteBuffer;

public abstract class CharsetProber {
    public static final int ASCII_A = 97;
    public static final int ASCII_A_CAPITAL = 65;
    public static final int ASCII_GT = 62;
    public static final int ASCII_LT = 60;
    public static final int ASCII_SP = 32;
    public static final int ASCII_Z = 122;
    public static final int ASCII_Z_CAPITAL = 90;
    public static final float SHORTCUT_THRESHOLD = 0.95f;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAscii(byte by) {
        if ((by & 0x80) != 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAsciiSymbol(byte by) {
        int n = by & 0xFF;
        if (n < 65) return true;
        if (n > 90) {
            if (n < 97) return true;
        }
        if (n <= 122) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ByteBuffer filterWithEnglishLetters(byte[] byArray, int n, int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        int n3 = n + n2;
        int n4 = n;
        boolean bl = false;
        while (n < n3) {
            byte by = byArray[n];
            if (by == 62) {
                bl = false;
            } else if (by == 60) {
                bl = true;
            }
            if (this.isAscii(by) && this.isAsciiSymbol(by)) {
                if (n > n4 && !bl) {
                    byteBuffer.put(byArray, n4, n - n4);
                    byteBuffer.put((byte)32);
                    n4 = n + 1;
                } else {
                    n4 = n + 1;
                }
            }
            ++n;
        }
        if (!bl && n > n4) {
            byteBuffer.put(byArray, n4, n - n4);
        }
        return byteBuffer;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ByteBuffer filterWithoutEnglishLetters(byte[] byArray, int n, int n2) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        int n3 = n + n2;
        int n4 = n;
        boolean bl = false;
        while (n < n3) {
            byte by = byArray[n];
            if (!this.isAscii(by)) {
                bl = true;
            } else if (this.isAsciiSymbol(by)) {
                if (bl && n > n4) {
                    byteBuffer.put(byArray, n4, n - n4);
                    byteBuffer.put((byte)32);
                    n4 = n + 1;
                    bl = false;
                } else {
                    n4 = n + 1;
                }
            }
            ++n;
        }
        if (bl && n > n4) {
            byteBuffer.put(byArray, n4, n - n4);
        }
        return byteBuffer;
    }

    public abstract String getCharSetName();

    public abstract float getConfidence();

    public abstract ProbingState getState();

    public abstract ProbingState handleData(byte[] var1, int var2, int var3);

    public abstract void reset();

    public abstract void setOption();

    public static final class ProbingState
    extends Enum<ProbingState> {
        private static final /* synthetic */ ProbingState[] $VALUES;
        public static final /* enum */ ProbingState DETECTING = new ProbingState();
        public static final /* enum */ ProbingState FOUND_IT = new ProbingState();
        public static final /* enum */ ProbingState NOT_ME = new ProbingState();

        static {
            ProbingState[] probingStateArray = new ProbingState[]{DETECTING, FOUND_IT, NOT_ME};
            $VALUES = probingStateArray;
        }

        public static ProbingState valueOf(String string2) {
            return Enum.valueOf(ProbingState.class, string2);
        }

        public static ProbingState[] values() {
            return (ProbingState[])$VALUES.clone();
        }
    }
}

