/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.statemachine.CodingStateMachine;
import org.mozilla.universalchardet.prober.statemachine.SMModel;
import org.mozilla.universalchardet.prober.statemachine.UTF8SMModel;

public class UTF8Prober
extends CharsetProber {
    public static final float ONE_CHAR_PROB = 0.5f;
    private static final SMModel smModel = new UTF8SMModel();
    private CodingStateMachine codingSM = new CodingStateMachine(smModel);
    private int numOfMBChar = 0;
    private CharsetProber.ProbingState state;

    public UTF8Prober() {
        this.reset();
    }

    @Override
    public String getCharSetName() {
        return Constants.CHARSET_UTF_8;
    }

    @Override
    public float getConfidence() {
        float f = 0.99f;
        if (this.numOfMBChar < 6) {
            for (int i = 0; i < this.numOfMBChar; ++i) {
                f *= 0.5f;
            }
            f = 1.0f - f;
        }
        return f;
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n, int n2) {
        int n3 = n + n2;
        while (true) {
            int n4;
            block8: {
                block6: {
                    block7: {
                        if (n >= n3) break block6;
                        n4 = this.codingSM.nextState(byArray[n]);
                        if (n4 != 1) break block7;
                        this.state = CharsetProber.ProbingState.NOT_ME;
                        break block6;
                    }
                    if (n4 != 2) break block8;
                    this.state = CharsetProber.ProbingState.FOUND_IT;
                }
                if (this.state == CharsetProber.ProbingState.DETECTING && this.getConfidence() > 0.95f) {
                    this.state = CharsetProber.ProbingState.FOUND_IT;
                }
                return this.state;
            }
            if (n4 == 0 && this.codingSM.getCurrentCharLen() >= 2) {
                this.numOfMBChar = 1 + this.numOfMBChar;
            }
            ++n;
        }
    }

    @Override
    public void reset() {
        this.codingSM.reset();
        this.numOfMBChar = 0;
        this.state = CharsetProber.ProbingState.DETECTING;
    }

    @Override
    public void setOption() {
    }
}

